/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class VersionCommand
extends BukkitCommand {
    private VersionFetcher versionFetcher;
    private final ReentrantLock versionLock = new ReentrantLock();
    private boolean hasVersion = false;
    private Component versionMessage = null;
    private final Set<CommandSender> versionWaiters = new HashSet<CommandSender>();
    private boolean versionTaskStarted = false;
    private long lastCheck = 0L;

    private VersionFetcher getVersionFetcher() {
        if (this.versionFetcher == null) {
            this.versionFetcher = Bukkit.getUnsafe().getVersionFetcher();
        }
        return this.versionFetcher;
    }

    public VersionCommand(@NotNull String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/version [plugin name]";
        this.setPermission("bukkit.command.version");
        this.setAliases(Arrays.asList("ver", "about"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            this.sendVersion(sender);
        } else {
            StringBuilder name = new StringBuilder();
            for (String arg : args) {
                if (name.length() > 0) {
                    name.append(' ');
                }
                name.append(arg);
            }
            String pluginName = name.toString();
            Plugin exactPlugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (exactPlugin != null) {
                this.describeToSender(exactPlugin, sender);
                return true;
            }
            boolean found = false;
            pluginName = pluginName.toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.getName().toLowerCase(Locale.ENGLISH).contains(pluginName)) continue;
                this.describeToSender(plugin, sender);
                found = true;
            }
            if (!found) {
                sender.sendMessage("This server is not running any plugin by that name.");
                sender.sendMessage("Use /plugins to get a list of plugins.");
            }
        }
        return true;
    }

    private void describeToSender(@NotNull Plugin plugin, @NotNull CommandSender sender) {
        PluginDescriptionFile desc = plugin.getDescription();
        sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)desc.getName(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" version "))).append(((TextComponent)Component.text((String)desc.getVersion(), (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)Component.text((String)"Click to copy to clipboard", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.copyToClipboard((String)desc.getVersion()))));
        if (desc.getDescription() != null) {
            sender.sendMessage(desc.getDescription());
        }
        if (desc.getWebsite() != null) {
            sender.sendMessage("Website: " + ChatColor.GREEN + desc.getWebsite());
        }
        if (!desc.getAuthors().isEmpty()) {
            if (desc.getAuthors().size() == 1) {
                sender.sendMessage("Author: " + this.getNameList(desc.getAuthors()));
            } else {
                sender.sendMessage("Authors: " + this.getNameList(desc.getAuthors()));
            }
        }
        if (!desc.getContributors().isEmpty()) {
            sender.sendMessage("Contributors: " + this.getNameList(desc.getContributors()));
        }
    }

    @NotNull
    private String getNameList(@NotNull List<String> names) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (result.length() > 0) {
                result.append((Object)ChatColor.WHITE);
                if (i < names.size() - 1) {
                    result.append(", ");
                } else {
                    result.append(" and ");
                }
            }
            result.append((Object)ChatColor.GREEN);
            result.append(names.get(i));
        }
        return result.toString();
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String toComplete = args[0].toLowerCase(Locale.ENGLISH);
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                if (!StringUtil.startsWithIgnoreCase(plugin.getName(), toComplete)) continue;
                completions.add(plugin.getName());
            }
            return completions;
        }
        return ImmutableList.of();
    }

    private void sendVersion(@NotNull CommandSender sender) {
        if (this.hasVersion) {
            if (System.currentTimeMillis() - this.lastCheck > this.getVersionFetcher().getCacheTime()) {
                this.lastCheck = System.currentTimeMillis();
                this.hasVersion = false;
            } else {
                sender.sendMessage(this.versionMessage);
                return;
            }
        }
        this.versionLock.lock();
        try {
            if (this.hasVersion) {
                sender.sendMessage(this.versionMessage);
                return;
            }
            this.versionWaiters.add(sender);
            sender.sendMessage((Component)Component.text((String)"Checking version, please wait...", (TextColor)NamedTextColor.WHITE, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
            if (!this.versionTaskStarted) {
                this.versionTaskStarted = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VersionCommand.this.obtainVersion();
                    }
                }).start();
            }
        }
        finally {
            this.versionLock.unlock();
        }
    }

    private void obtainVersion() {
        String version = Bukkit.getVersion();
        if (version.startsWith("null")) {
            this.setVersionMessage((Component)Component.text((String)"* Unknown version, custom build?", (TextColor)NamedTextColor.RED));
            return;
        }
        this.setVersionMessage(this.getVersionFetcher().getVersionMessage(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVersionMessage(@NotNull Component msg) {
        this.lastCheck = System.currentTimeMillis();
        int distance = this.getVersionFetcher().distance();
        Component message = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), (ComponentLike[])new ComponentLike[]{ChatColor.parseMM("<grey>Current: %s%s*", distance == 0 ? "<green>" : (distance > 0 ? "<yellow>" : "<red>"), Bukkit.getVersion()), msg});
        this.versionMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(message)).hoverEvent((HoverEventSource)Component.text((String)"Click to copy to clipboard", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.copyToClipboard((String)PlainTextComponentSerializer.plainText().serialize(message)))).build();
        this.versionLock.lock();
        try {
            this.hasVersion = true;
            this.versionTaskStarted = false;
            for (CommandSender sender : this.versionWaiters) {
                sender.sendMessage(this.versionMessage);
            }
            this.versionWaiters.clear();
        }
        finally {
            this.versionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDistance(@NotNull String repo, @NotNull String hash) {
        int n;
        BufferedReader reader = Resources.asCharSource((URL)new URL("https://hub.spigotmc.org/stash/rest/api/1.0/projects/SPIGOT/repos/" + repo + "/commits?since=" + URLEncoder.encode(hash, "UTF-8") + "&withCounts=true"), (Charset)Charsets.UTF_8).openBufferedStream();
        try {
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            n = obj.get("totalCount").getAsInt();
        }
        catch (JsonSyntaxException ex) {
            int n2;
            try {
                ex.printStackTrace();
                n2 = -1;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            reader.close();
            return n2;
        }
        reader.close();
        return n;
    }
}

