/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import java.util.Collections;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class BlockShearEntityEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Entity sheared;
    private final ItemStack tool;
    private boolean cancelled;
    private List<ItemStack> drops;

    @ApiStatus.Internal
    public BlockShearEntityEvent(@NotNull Block dispenser, @NotNull Entity sheared, @NotNull ItemStack tool, @NotNull List<ItemStack> drops) {
        super(dispenser);
        this.sheared = sheared;
        this.tool = tool;
        this.drops = drops;
    }

    @NotNull
    public Entity getEntity() {
        return this.sheared;
    }

    @NotNull
    public ItemStack getTool() {
        return this.tool.clone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public @NotNull @Unmodifiable List<ItemStack> getDrops() {
        return Collections.unmodifiableList(this.drops);
    }

    public void setDrops(@NotNull List<ItemStack> drops) {
        this.drops = List.copyOf(drops);
    }
}

