/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameEvent
implements Keyed {
    private static final Map<NamespacedKey, GameEvent> GAME_EVENTS = new HashMap<NamespacedKey, GameEvent>();
    public static final GameEvent BLOCK_ATTACH = GameEvent.getEvent("block_attach");
    public static final GameEvent BLOCK_CHANGE = GameEvent.getEvent("block_change");
    public static final GameEvent BLOCK_CLOSE = GameEvent.getEvent("block_close");
    public static final GameEvent BLOCK_DESTROY = GameEvent.getEvent("block_destroy");
    public static final GameEvent BLOCK_DETACH = GameEvent.getEvent("block_detach");
    public static final GameEvent BLOCK_OPEN = GameEvent.getEvent("block_open");
    public static final GameEvent BLOCK_PLACE = GameEvent.getEvent("block_place");
    public static final GameEvent BLOCK_PRESS = GameEvent.getEvent("block_press");
    public static final GameEvent BLOCK_SWITCH = GameEvent.getEvent("block_switch");
    public static final GameEvent BLOCK_UNPRESS = GameEvent.getEvent("block_unpress");
    public static final GameEvent BLOCK_UNSWITCH = GameEvent.getEvent("block_unswitch");
    public static final GameEvent CONTAINER_CLOSE = GameEvent.getEvent("container_close");
    public static final GameEvent CONTAINER_OPEN = GameEvent.getEvent("container_open");
    public static final GameEvent DISPENSE_FAIL = GameEvent.getEvent("dispense_fail");
    public static final GameEvent DRINKING_FINISH = GameEvent.getEvent("drinking_finish");
    public static final GameEvent EAT = GameEvent.getEvent("eat");
    public static final GameEvent ELYTRA_FREE_FALL = GameEvent.getEvent("elytra_free_fall");
    public static final GameEvent ENTITY_DAMAGED = GameEvent.getEvent("entity_damaged");
    public static final GameEvent ENTITY_KILLED = GameEvent.getEvent("entity_killed");
    public static final GameEvent ENTITY_PLACE = GameEvent.getEvent("entity_place");
    public static final GameEvent EQUIP = GameEvent.getEvent("equip");
    public static final GameEvent EXPLODE = GameEvent.getEvent("explode");
    public static final GameEvent FISHING_ROD_CAST = GameEvent.getEvent("fishing_rod_cast");
    public static final GameEvent FISHING_ROD_REEL_IN = GameEvent.getEvent("fishing_rod_reel_in");
    public static final GameEvent FLAP = GameEvent.getEvent("flap");
    public static final GameEvent FLUID_PICKUP = GameEvent.getEvent("fluid_pickup");
    public static final GameEvent FLUID_PLACE = GameEvent.getEvent("fluid_place");
    public static final GameEvent HIT_GROUND = GameEvent.getEvent("hit_ground");
    public static final GameEvent LIGHTNING_STRIKE = GameEvent.getEvent("lightning_strike");
    public static final GameEvent MINECART_MOVING = GameEvent.getEvent("minecart_moving");
    public static final GameEvent MOB_INTERACT = GameEvent.getEvent("mob_interact");
    public static final GameEvent PISTON_CONTRACT = GameEvent.getEvent("piston_contract");
    public static final GameEvent PISTON_EXTEND = GameEvent.getEvent("piston_extend");
    public static final GameEvent PRIME_FUSE = GameEvent.getEvent("prime_fuse");
    public static final GameEvent PROJECTILE_LAND = GameEvent.getEvent("projectile_land");
    public static final GameEvent PROJECTILE_SHOOT = GameEvent.getEvent("projectile_shoot");
    public static final GameEvent RAVAGER_ROAR = GameEvent.getEvent("ravager_roar");
    public static final GameEvent RING_BELL = GameEvent.getEvent("ring_bell");
    public static final GameEvent SHEAR = GameEvent.getEvent("shear");
    public static final GameEvent SHULKER_CLOSE = GameEvent.getEvent("shulker_close");
    public static final GameEvent SHULKER_OPEN = GameEvent.getEvent("shulker_open");
    public static final GameEvent SPLASH = GameEvent.getEvent("splash");
    public static final GameEvent STEP = GameEvent.getEvent("step");
    public static final GameEvent SWIM = GameEvent.getEvent("swim");
    public static final GameEvent WOLF_SHAKING = GameEvent.getEvent("wolf_shaking");
    private final NamespacedKey key;

    private GameEvent(NamespacedKey key) {
        this.key = key;
        GAME_EVENTS.put(key, this);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Nullable
    public static GameEvent getByKey(@NotNull NamespacedKey namespacedKey) {
        return GAME_EVENTS.get(namespacedKey);
    }

    @NotNull
    public static Collection<GameEvent> values() {
        return Collections.unmodifiableCollection(GAME_EVENTS.values());
    }

    private static GameEvent getEvent(String vanilla) {
        return new GameEvent(NamespacedKey.minecraft(vanilla));
    }
}

