/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.destroystokyo.paper.Namespaced;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespacedKey
implements Key,
Namespaced {
    public static final String MINECRAFT = "minecraft";
    public static final String BUKKIT = "bukkit";
    private static final Pattern VALID_NAMESPACE = Pattern.compile("[a-z0-9._-]+");
    private static final Pattern VALID_KEY = Pattern.compile("[a-z0-9/._-]+");
    private final String namespace;
    private final String key;

    public NamespacedKey(@NotNull String namespace, @NotNull String key) {
        Preconditions.checkArgument((namespace != null && VALID_NAMESPACE.matcher(namespace).matches() ? 1 : 0) != 0, (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)namespace);
        Preconditions.checkArgument((key != null && VALID_KEY.matcher(key).matches() ? 1 : 0) != 0, (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)key);
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedKey must be less than 256 characters", (Object)string);
    }

    public NamespacedKey(@NotNull Plugin plugin, @NotNull String key) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)VALID_NAMESPACE.matcher(this.namespace).matches(), (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)this.namespace);
        Preconditions.checkArgument((boolean)VALID_KEY.matcher(this.key).matches(), (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)this.key);
        String string = this.toString();
        Preconditions.checkArgument((string.length() < 256 ? 1 : 0) != 0, (String)"NamespacedKey must be less than 256 characters (%s)", (Object)string);
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.namespace.hashCode();
        hash = 47 * hash + this.key.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespacedKey other = (NamespacedKey)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Deprecated
    @NotNull
    public static NamespacedKey randomKey() {
        return new NamespacedKey(BUKKIT, UUID.randomUUID().toString());
    }

    @NotNull
    public static NamespacedKey minecraft(@NotNull String key) {
        return new NamespacedKey(MINECRAFT, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String string, @Nullable Plugin defaultNamespace) {
        String key;
        Preconditions.checkArgument((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Input string must not be empty or null");
        String[] components = string.split(":", 3);
        if (components.length > 2) {
            return null;
        }
        String string2 = key = components.length == 2 ? components[1] : "";
        if (components.length == 1) {
            String value = components[0];
            if (value.isEmpty() || !VALID_KEY.matcher(value).matches()) {
                return null;
            }
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, value) : NamespacedKey.minecraft(value);
        }
        if (components.length == 2 && !VALID_KEY.matcher(key).matches()) {
            return null;
        }
        String namespace = components[0];
        if (namespace.isEmpty()) {
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, key) : NamespacedKey.minecraft(key);
        }
        if (!VALID_KEY.matcher(namespace).matches()) {
            return null;
        }
        return new NamespacedKey(namespace, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String key) {
        return NamespacedKey.fromString(key, null);
    }

    @NotNull
    public String namespace() {
        return this.getNamespace();
    }

    @NotNull
    public String value() {
        return this.getKey();
    }

    @NotNull
    public String asString() {
        return this.namespace + ":" + this.key;
    }
}

