/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.command.modules;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.activitylog.Activity;
import me.lucko.spark.paper.common.command.Arguments;
import me.lucko.spark.paper.common.command.Command;
import me.lucko.spark.paper.common.command.CommandModule;
import me.lucko.spark.paper.common.command.CommandResponseHandler;
import me.lucko.spark.paper.common.command.sender.CommandSender;
import me.lucko.spark.paper.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.paper.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.paper.common.sampler.Sampler;
import me.lucko.spark.paper.common.sampler.SamplerBuilder;
import me.lucko.spark.paper.common.sampler.SamplerMode;
import me.lucko.spark.paper.common.sampler.ThreadDumper;
import me.lucko.spark.paper.common.sampler.ThreadGrouper;
import me.lucko.spark.paper.common.sampler.async.AsyncSampler;
import me.lucko.spark.paper.common.sampler.node.MergeMode;
import me.lucko.spark.paper.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.paper.common.tick.TickHook;
import me.lucko.spark.paper.common.util.FormatUtil;
import me.lucko.spark.paper.common.util.MethodDisambiguator;
import me.lucko.spark.paper.common.ws.ViewerSocket;
import me.lucko.spark.paper.lib.bytesocks.BytesocksClient;
import me.lucko.spark.paper.proto.SparkSamplerProtos;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class SamplerModule
implements CommandModule {
    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("profiler", "sampler").allowSubCommand(true).argumentUsage("info", "", null).argumentUsage("open", "", null).argumentUsage("start", "timeout", "timeout seconds").argumentUsage("start", "thread *", null).argumentUsage("start", "thread", "thread name").argumentUsage("start", "only-ticks-over", "tick length millis").argumentUsage("start", "interval", "interval millis").argumentUsage("start", "alloc", null).argumentUsage("stop", "", null).argumentUsage("cancel", "", null).executor(this::profiler).tabCompleter((platform, sender, arguments) -> {
            List<String> opts = Collections.emptyList();
            if (arguments.size() > 0) {
                String subCommand = (String)arguments.get(0);
                if (subCommand.equals("stop") || subCommand.equals("upload")) {
                    opts = new ArrayList<String>(Arrays.asList("--comment", "--save-to-file"));
                    opts.removeAll(arguments);
                }
                if (subCommand.equals("start")) {
                    opts = new ArrayList<String>(Arrays.asList("--timeout", "--regex", "--combine-all", "--not-combined", "--interval", "--only-ticks-over", "--force-java-sampler", "--alloc", "--alloc-live-only"));
                    opts.removeAll(arguments);
                    opts.add("--thread");
                }
            }
            return TabCompleter.create().at(0, CompletionSupplier.startsWith(Arrays.asList("info", "start", "open", "stop", "cancel"))).from(1, CompletionSupplier.startsWith(opts)).complete(arguments);
        }).build());
    }

    private void profiler(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        String subCommand;
        String string = subCommand = arguments.subCommand() == null ? "" : arguments.subCommand();
        if (subCommand.equals("info") || arguments.boolFlag("info")) {
            this.profilerInfo(platform, resp);
            return;
        }
        if (subCommand.equals("open") || arguments.boolFlag("open")) {
            this.profilerOpen(platform, sender, resp, arguments);
            return;
        }
        if (subCommand.equals("trust-viewer") || arguments.boolFlag("trust-viewer")) {
            this.profilerTrustViewer(platform, sender, resp, arguments);
            return;
        }
        if (subCommand.equals("cancel") || arguments.boolFlag("cancel")) {
            this.profilerCancel(platform, resp);
            return;
        }
        if (subCommand.equals("stop") || subCommand.equals("upload") || arguments.boolFlag("stop") || arguments.boolFlag("upload")) {
            this.profilerStop(platform, sender, resp, arguments);
            return;
        }
        if (subCommand.equals("start") || arguments.boolFlag("start")) {
            this.profilerStart(platform, sender, resp, arguments);
            return;
        }
        if (arguments.raw().isEmpty()) {
            this.profilerInfo(platform, resp);
        } else {
            this.profilerStart(platform, sender, resp, arguments);
        }
    }

    private void profilerStart(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        Sampler sampler;
        int timeoutSeconds;
        Sampler previousSampler = platform.getSamplerContainer().getActiveSampler();
        if (previousSampler != null) {
            if (previousSampler.isRunningInBackground()) {
                resp.replyPrefixed((Component)Component.text((String)"Stopping the background profiler before starting... please wait"));
                previousSampler.stop(true);
                platform.getSamplerContainer().unsetActiveSampler(previousSampler);
            } else {
                this.profilerInfo(platform, resp);
                return;
            }
        }
        if ((timeoutSeconds = arguments.intFlag("timeout")) != -1 && timeoutSeconds <= 10) {
            resp.replyPrefixed((Component)Component.text((String)"The specified timeout is not long enough for accurate results to be formed. Please choose a value greater than 10.", (TextColor)NamedTextColor.RED));
            return;
        }
        if (timeoutSeconds != -1 && timeoutSeconds < 30) {
            resp.replyPrefixed((Component)Component.text((String)"The accuracy of the output will significantly improve when the profiler is able to run for longer periods. Consider setting a timeout value over 30 seconds."));
        }
        SamplerMode mode = arguments.boolFlag("alloc") ? SamplerMode.ALLOCATION : SamplerMode.EXECUTION;
        boolean allocLiveOnly = arguments.boolFlag("alloc-live-only");
        double interval = arguments.doubleFlag("interval");
        if (interval <= 0.0) {
            interval = mode.defaultInterval();
        }
        boolean ignoreSleeping = arguments.boolFlag("ignore-sleeping");
        boolean ignoreNative = arguments.boolFlag("ignore-native");
        boolean forceJavaSampler = arguments.boolFlag("force-java-sampler");
        Set<String> threads = arguments.stringFlag("thread");
        ThreadDumper threadDumper = threads.isEmpty() ? platform.getPlugin().getDefaultThreadDumper() : (threads.contains("*") ? ThreadDumper.ALL : (arguments.boolFlag("regex") ? new ThreadDumper.Regex(threads) : new ThreadDumper.Specific(threads)));
        ThreadGrouper threadGrouper = arguments.boolFlag("combine-all") ? ThreadGrouper.AS_ONE : (arguments.boolFlag("not-combined") ? ThreadGrouper.BY_NAME : ThreadGrouper.BY_POOL);
        int ticksOver = arguments.intFlag("only-ticks-over");
        TickHook tickHook = null;
        if (ticksOver != -1 && (tickHook = platform.getTickHook()) == null) {
            resp.replyPrefixed((Component)Component.text((String)"Tick counting is not supported!", (TextColor)NamedTextColor.RED));
            return;
        }
        resp.broadcastPrefixed((Component)Component.text((String)"Starting a new profiler, please wait..."));
        SamplerBuilder builder = new SamplerBuilder();
        builder.mode(mode);
        builder.threadDumper(threadDumper);
        builder.threadGrouper(threadGrouper);
        if (timeoutSeconds != -1) {
            builder.completeAfter(timeoutSeconds, TimeUnit.SECONDS);
        }
        builder.samplingInterval(interval);
        builder.ignoreSleeping(ignoreSleeping);
        builder.ignoreNative(ignoreNative);
        builder.forceJavaSampler(forceJavaSampler);
        builder.allocLiveOnly(allocLiveOnly);
        if (ticksOver != -1) {
            builder.ticksOver(ticksOver, tickHook);
        }
        try {
            sampler = builder.start(platform);
        }
        catch (UnsupportedOperationException e) {
            resp.replyPrefixed((Component)Component.text((String)e.getMessage(), (TextColor)NamedTextColor.RED));
            return;
        }
        platform.getSamplerContainer().setActiveSampler(sampler);
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)((mode == SamplerMode.ALLOCATION ? "Allocation Profiler" : "Profiler") + " is now running!"), (TextColor)NamedTextColor.GOLD))).append((Component)Component.space())).append((Component)Component.text((String)("(" + (sampler instanceof AsyncSampler ? "async" : "built-in java") + ")"), (TextColor)NamedTextColor.DARK_GRAY))).build());
        if (timeoutSeconds == -1) {
            resp.broadcastPrefixed((Component)Component.text((String)"It will run in the background until it is stopped by an admin."));
            resp.broadcastPrefixed((Component)Component.text((String)"To stop the profiler and upload the results, run:"));
            resp.broadcastPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler stop"));
            resp.broadcastPrefixed((Component)Component.text((String)"To view the profiler while it's running, run:"));
            resp.broadcastPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler open"));
        } else {
            resp.broadcastPrefixed((Component)Component.text((String)("The results will be automatically returned after the profiler has been running for " + FormatUtil.formatSeconds(timeoutSeconds) + ".")));
        }
        CompletableFuture<Sampler> future = sampler.getFuture();
        future.whenCompleteAsync((s, throwable) -> {
            if (throwable != null) {
                resp.broadcastPrefixed((Component)Component.text((String)("Profiler operation failed unexpectedly. Error: " + throwable.toString()), (TextColor)NamedTextColor.RED));
                throwable.printStackTrace();
            }
        });
        sampler.getFuture().whenCompleteAsync((s, throwable) -> platform.getSamplerContainer().unsetActiveSampler((Sampler)s));
        if (timeoutSeconds != -1) {
            Sampler.ExportProps exportProps = this.getExportProps(platform, resp, arguments);
            boolean saveToFile = arguments.boolFlag("save-to-file");
            future.thenAcceptAsync(s -> {
                resp.broadcastPrefixed((Component)Component.text((String)"The active profiler has completed! Uploading results..."));
                this.handleUpload(platform, resp, (Sampler)s, exportProps, saveToFile);
            });
        }
    }

    private void profilerInfo(SparkPlatform platform, CommandResponseHandler resp) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed((Component)Component.text((String)"The profiler isn't running!"));
            resp.replyPrefixed((Component)Component.text((String)"To start a new one, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler start"));
        } else {
            resp.replyPrefixed((Component)Component.text((String)"Profiler is already running!", (TextColor)NamedTextColor.GOLD));
            long runningTime = (System.currentTimeMillis() - sampler.getStartTime()) / 1000L;
            if (sampler.isRunningInBackground()) {
                resp.replyPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"It was started "))).append((Component)Component.text((String)"automatically", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)(" when spark enabled and has been running in the background for " + FormatUtil.formatSeconds(runningTime) + ".")))).build());
            } else {
                resp.replyPrefixed((Component)Component.text((String)("So far, it has profiled for " + FormatUtil.formatSeconds(runningTime) + ".")));
            }
            resp.replyPrefixed((Component)Component.text((String)"To view the profiler while it's running, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler open"));
            long timeout = sampler.getAutoEndTime();
            if (timeout == -1L) {
                resp.replyPrefixed((Component)Component.text((String)"To stop the profiler and upload the results, run:"));
                resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler stop"));
            } else {
                long timeoutDiff = (timeout - System.currentTimeMillis()) / 1000L;
                resp.replyPrefixed((Component)Component.text((String)("It is due to complete automatically and upload results in " + FormatUtil.formatSeconds(timeoutDiff) + ".")));
            }
            resp.replyPrefixed((Component)Component.text((String)"To cancel the profiler without uploading the results, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler cancel"));
        }
    }

    private void profilerOpen(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        BytesocksClient bytesocksClient = platform.getBytesocksClient();
        if (bytesocksClient == null) {
            resp.replyPrefixed((Component)Component.text((String)"The live viewer is not supported.", (TextColor)NamedTextColor.RED));
            return;
        }
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed((Component)Component.text((String)"The profiler isn't running!"));
            resp.replyPrefixed((Component)Component.text((String)"To start a new one, run:"));
            resp.replyPrefixed(SamplerModule.cmdPrompt("/" + platform.getPlugin().getCommandName() + " profiler start"));
            return;
        }
        Sampler.ExportProps exportProps = this.getExportProps(platform, resp, arguments);
        this.handleOpen(platform, bytesocksClient, resp, sampler, exportProps);
    }

    private void profilerTrustViewer(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        Set<String> ids = arguments.stringFlag("id");
        if (ids.isEmpty()) {
            resp.replyPrefixed((Component)Component.text((String)"Please provide a client id with '--id <client id>'."));
            return;
        }
        for (String id : ids) {
            boolean success = platform.getTrustedKeyStore().trustPendingKey(id);
            if (success) {
                Sampler sampler = platform.getSamplerContainer().getActiveSampler();
                if (sampler != null) {
                    for (ViewerSocket socket : sampler.getAttachedSockets()) {
                        socket.sendClientTrustedMessage(id);
                    }
                }
                resp.replyPrefixed((Component)Component.text((String)("Client connected to the viewer using id '" + id + "' is now trusted.")));
                continue;
            }
            resp.replyPrefixed((Component)Component.text((String)("Unable to find pending client with id '" + id + "'.")));
        }
    }

    private void profilerCancel(SparkPlatform platform, CommandResponseHandler resp) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed((Component)Component.text((String)"There isn't an active profiler running."));
        } else {
            platform.getSamplerContainer().stopActiveSampler(true);
            resp.broadcastPrefixed((Component)Component.text((String)"Profiler has been cancelled.", (TextColor)NamedTextColor.GOLD));
        }
    }

    private void profilerStop(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        Sampler sampler = platform.getSamplerContainer().getActiveSampler();
        if (sampler == null) {
            resp.replyPrefixed((Component)Component.text((String)"There isn't an active profiler running."));
        } else {
            platform.getSamplerContainer().unsetActiveSampler(sampler);
            sampler.stop(false);
            boolean saveToFile = arguments.boolFlag("save-to-file");
            if (saveToFile) {
                resp.broadcastPrefixed((Component)Component.text((String)"Stopping the profiler & saving results, please wait..."));
            } else {
                resp.broadcastPrefixed((Component)Component.text((String)"Stopping the profiler & uploading results, please wait..."));
            }
            Sampler.ExportProps exportProps = this.getExportProps(platform, resp, arguments);
            this.handleUpload(platform, resp, sampler, exportProps, saveToFile);
            if (platform.getBackgroundSamplerManager().restartBackgroundSampler()) {
                resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Restarted the background profiler. "))).append((Component)Component.text((String)("(If you don't want this to happen, run: /" + platform.getPlugin().getCommandName() + " profiler cancel)"), (TextColor)NamedTextColor.DARK_GRAY))).build());
            }
        }
    }

    private void handleUpload(SparkPlatform platform, CommandResponseHandler resp, Sampler sampler, Sampler.ExportProps exportProps, boolean saveToFileFlag) {
        SparkSamplerProtos.SamplerData output = sampler.toProto(platform, exportProps);
        boolean saveToFile = false;
        if (saveToFileFlag) {
            saveToFile = true;
        } else {
            try {
                String key = platform.getBytebinClient().postContent(output, "application/x-spark-sampler").key();
                String url = platform.getViewerUrl() + key;
                resp.broadcastPrefixed((Component)Component.text((String)"Profiler stopped & upload complete!", (TextColor)NamedTextColor.GOLD));
                resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl((String)url))).build());
                platform.getActivityLog().addToLog(Activity.urlActivity(resp.senderData(), System.currentTimeMillis(), "Profiler", url));
            }
            catch (Exception e) {
                resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst uploading the results. Attempting to save to disk instead.", (TextColor)NamedTextColor.RED));
                e.printStackTrace();
                saveToFile = true;
            }
        }
        if (saveToFile) {
            Path file = platform.resolveSaveFile("profile", "sparkprofile");
            try {
                Files.write(file, output.toByteArray(), new OpenOption[0]);
                resp.broadcastPrefixed((Component)Component.text((String)"Profiler stopped & save complete!", (TextColor)NamedTextColor.GOLD));
                resp.broadcastPrefixed((Component)Component.text((String)("Data has been written to: " + file)));
                resp.broadcastPrefixed((Component)Component.text((String)("You can view the profile file using the web app @ " + platform.getViewerUrl()), (TextColor)NamedTextColor.GRAY));
                platform.getActivityLog().addToLog(Activity.fileActivity(resp.senderData(), System.currentTimeMillis(), "Profiler", file.toString()));
            }
            catch (IOException e) {
                resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst saving the data.", (TextColor)NamedTextColor.RED));
                e.printStackTrace();
            }
        }
    }

    private void handleOpen(SparkPlatform platform, BytesocksClient bytesocksClient, CommandResponseHandler resp, Sampler sampler, Sampler.ExportProps exportProps) {
        try {
            ViewerSocket socket = new ViewerSocket(platform, bytesocksClient, exportProps);
            sampler.attachSocket(socket);
            exportProps.channelInfo(socket.getPayload());
            SparkSamplerProtos.SamplerData data = sampler.toProto(platform, exportProps);
            String key = platform.getBytebinClient().postContent(data, "application/x-spark-sampler", "live").key();
            String url = platform.getViewerUrl() + key;
            resp.broadcastPrefixed((Component)Component.text((String)"Profiler live viewer:", (TextColor)NamedTextColor.GOLD));
            resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl((String)url))).build());
            String cmd = "/" + platform.getPlugin().getCommandName() + " profiler stop";
            resp.broadcast((Component)Component.empty());
            resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"(NOTE: this link is temporary and will expire after a short period of time. If you need a link to share with other people (e.g. in a bug report), please use ", (TextColor)NamedTextColor.GRAY))).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(cmd).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)cmd))).build())).append((Component)Component.text((String)" instead.)", (TextColor)NamedTextColor.GRAY))).build());
            platform.getActivityLog().addToLog(Activity.urlActivity(resp.senderData(), System.currentTimeMillis(), "Profiler (live)", url));
        }
        catch (Exception e) {
            resp.replyPrefixed((Component)Component.text((String)"An error occurred whilst opening the live profiler.", (TextColor)NamedTextColor.RED));
            e.printStackTrace();
        }
    }

    private Sampler.ExportProps getExportProps(SparkPlatform platform, CommandResponseHandler resp, Arguments arguments) {
        return new Sampler.ExportProps().creator(resp.senderData()).comment((String)Iterables.getFirst(arguments.stringFlag("comment"), null)).mergeMode(() -> {
            MethodDisambiguator methodDisambiguator = new MethodDisambiguator(platform.createClassFinder());
            return arguments.boolFlag("separate-parent-calls") ? MergeMode.separateParentCalls(methodDisambiguator) : MergeMode.sameMethod(methodDisambiguator);
        }).classSourceLookup(() -> ClassSourceLookup.create(platform));
    }

    private static Component cmdPrompt(String cmd) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"  "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(cmd).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)cmd))).build())).build();
    }
}

