/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.command.sender;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import me.lucko.spark.paper.proto.SparkProtos;
import net.kyori.adventure.text.Component;

public interface CommandSender {
    public String getName();

    public UUID getUniqueId();

    public void sendMessage(Component var1);

    public boolean hasPermission(String var1);

    default public Data toData() {
        return new Data(this.getName(), this.getUniqueId());
    }

    public static final class Data {
        private final String name;
        private final UUID uniqueId;

        public Data(String name, UUID uniqueId) {
            this.name = name;
            this.uniqueId = uniqueId;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUniqueId() {
            return this.uniqueId;
        }

        public boolean isPlayer() {
            return this.uniqueId != null;
        }

        public JsonObject serialize() {
            JsonObject user = new JsonObject();
            user.add("type", (JsonElement)new JsonPrimitive(this.isPlayer() ? "player" : "other"));
            user.add("name", (JsonElement)new JsonPrimitive(this.name));
            if (this.uniqueId != null) {
                user.add("uniqueId", (JsonElement)new JsonPrimitive(this.uniqueId.toString()));
            }
            return user;
        }

        public SparkProtos.CommandSenderMetadata toProto() {
            SparkProtos.CommandSenderMetadata.Builder proto = SparkProtos.CommandSenderMetadata.newBuilder().setType(this.isPlayer() ? SparkProtos.CommandSenderMetadata.Type.PLAYER : SparkProtos.CommandSenderMetadata.Type.OTHER).setName(this.name);
            if (this.uniqueId != null) {
                proto.setUniqueId(this.uniqueId.toString());
            }
            return (SparkProtos.CommandSenderMetadata)proto.build();
        }

        public static Data deserialize(JsonElement element) {
            JsonObject userObject = element.getAsJsonObject();
            String user = userObject.get("name").getAsJsonPrimitive().getAsString();
            UUID uuid = userObject.has("uniqueId") ? UUID.fromString(userObject.get("uniqueId").getAsJsonPrimitive().getAsString()) : null;
            return new Data(user, uuid);
        }
    }
}

