/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.platform;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.regex.Pattern;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.monitor.cpu.CpuInfo;
import me.lucko.spark.paper.common.monitor.cpu.CpuMonitor;
import me.lucko.spark.paper.common.monitor.disk.DiskUsage;
import me.lucko.spark.paper.common.monitor.memory.GarbageCollectorStatistics;
import me.lucko.spark.paper.common.monitor.memory.MemoryInfo;
import me.lucko.spark.paper.common.monitor.net.NetworkInterfaceAverages;
import me.lucko.spark.paper.common.monitor.net.NetworkMonitor;
import me.lucko.spark.paper.common.monitor.os.OperatingSystemInfo;
import me.lucko.spark.paper.common.monitor.ping.PingStatistics;
import me.lucko.spark.paper.common.monitor.tick.TickStatistics;
import me.lucko.spark.paper.common.platform.PlatformInfo;
import me.lucko.spark.paper.common.platform.world.AsyncWorldInfoProvider;
import me.lucko.spark.paper.common.platform.world.WorldStatisticsProvider;
import me.lucko.spark.paper.proto.SparkProtos;

public class PlatformStatisticsProvider {
    private final SparkPlatform platform;

    public PlatformStatisticsProvider(SparkPlatform platform) {
        this.platform = platform;
    }

    public SparkProtos.SystemStatistics getSystemStatistics() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        OperatingSystemInfo osInfo = OperatingSystemInfo.poll();
        String vmArgs = String.join((CharSequence)" ", runtimeBean.getInputArguments());
        SparkProtos.SystemStatistics.Builder builder = SparkProtos.SystemStatistics.newBuilder().setCpu((SparkProtos.SystemStatistics.Cpu)SparkProtos.SystemStatistics.Cpu.newBuilder().setThreads(Runtime.getRuntime().availableProcessors()).setProcessUsage((SparkProtos.SystemStatistics.Cpu.Usage)SparkProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.processLoad1MinAvg()).setLast15M(CpuMonitor.processLoad15MinAvg()).build()).setSystemUsage((SparkProtos.SystemStatistics.Cpu.Usage)SparkProtos.SystemStatistics.Cpu.Usage.newBuilder().setLast1M(CpuMonitor.systemLoad1MinAvg()).setLast15M(CpuMonitor.systemLoad15MinAvg()).build()).setModelName(CpuInfo.queryCpuModel()).build()).setMemory((SparkProtos.SystemStatistics.Memory)SparkProtos.SystemStatistics.Memory.newBuilder().setPhysical((SparkProtos.SystemStatistics.Memory.MemoryPool)SparkProtos.SystemStatistics.Memory.MemoryPool.newBuilder().setUsed(MemoryInfo.getUsedPhysicalMemory()).setTotal(MemoryInfo.getTotalPhysicalMemory()).build()).setSwap((SparkProtos.SystemStatistics.Memory.MemoryPool)SparkProtos.SystemStatistics.Memory.MemoryPool.newBuilder().setUsed(MemoryInfo.getUsedSwap()).setTotal(MemoryInfo.getTotalSwap()).build()).build()).setDisk((SparkProtos.SystemStatistics.Disk)SparkProtos.SystemStatistics.Disk.newBuilder().setTotal(DiskUsage.getTotal()).setUsed(DiskUsage.getUsed()).build()).setOs((SparkProtos.SystemStatistics.Os)SparkProtos.SystemStatistics.Os.newBuilder().setArch(osInfo.arch()).setName(osInfo.name()).setVersion(osInfo.version()).build()).setJava((SparkProtos.SystemStatistics.Java)SparkProtos.SystemStatistics.Java.newBuilder().setVendor(System.getProperty("java.vendor", "unknown")).setVersion(System.getProperty("java.version", "unknown")).setVendorVersion(System.getProperty("java.vendor.version", "unknown")).setVmArgs(VmArgRedactor.replace(vmArgs)).build()).setJvm((SparkProtos.SystemStatistics.Jvm)SparkProtos.SystemStatistics.Jvm.newBuilder().setName(System.getProperty("java.vm.name", "unknown")).setVendor(System.getProperty("java.vm.vendor", "unknown")).setVersion(System.getProperty("java.vm.version", "unknown")).build());
        long uptime = runtimeBean.getUptime();
        builder.setUptime(uptime);
        Map<String, GarbageCollectorStatistics> gcStats = GarbageCollectorStatistics.pollStats();
        gcStats.forEach((name, statistics) -> builder.putGc((String)name, (SparkProtos.SystemStatistics.Gc)SparkProtos.SystemStatistics.Gc.newBuilder().setTotal(statistics.getCollectionCount()).setAvgTime(statistics.getAverageCollectionTime()).setAvgFrequency(statistics.getAverageCollectionFrequency(uptime)).build()));
        Map<String, NetworkInterfaceAverages> networkInterfaceStats = NetworkMonitor.systemAverages();
        networkInterfaceStats.forEach((name, statistics) -> builder.putNet((String)name, (SparkProtos.SystemStatistics.NetInterface)SparkProtos.SystemStatistics.NetInterface.newBuilder().setRxBytesPerSecond(PlatformStatisticsProvider.rollingAvgProto(statistics.rxBytesPerSecond())).setRxPacketsPerSecond(PlatformStatisticsProvider.rollingAvgProto(statistics.rxPacketsPerSecond())).setTxBytesPerSecond(PlatformStatisticsProvider.rollingAvgProto(statistics.txBytesPerSecond())).setTxPacketsPerSecond(PlatformStatisticsProvider.rollingAvgProto(statistics.txPacketsPerSecond())).build()));
        return (SparkProtos.SystemStatistics)builder.build();
    }

    public SparkProtos.PlatformStatistics getPlatformStatistics(Map<String, GarbageCollectorStatistics> startingGcStatistics, boolean includeWorld) {
        PlatformInfo.Type platformType;
        PingStatistics pingStatistics;
        TickStatistics tickStatistics;
        SparkProtos.PlatformStatistics.Builder builder = SparkProtos.PlatformStatistics.newBuilder();
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        builder.setMemory((SparkProtos.PlatformStatistics.Memory)SparkProtos.PlatformStatistics.Memory.newBuilder().setHeap((SparkProtos.PlatformStatistics.Memory.MemoryPool)SparkProtos.PlatformStatistics.Memory.MemoryPool.newBuilder().setUsed(memoryUsage.getUsed()).setTotal(memoryUsage.getCommitted()).build()).build());
        long uptime = System.currentTimeMillis() - this.platform.getServerNormalOperationStartTime();
        builder.setUptime(uptime);
        if (startingGcStatistics != null) {
            Map<String, GarbageCollectorStatistics> gcStats = GarbageCollectorStatistics.pollStatsSubtractInitial(startingGcStatistics);
            gcStats.forEach((name, statistics) -> builder.putGc((String)name, (SparkProtos.PlatformStatistics.Gc)SparkProtos.PlatformStatistics.Gc.newBuilder().setTotal(statistics.getCollectionCount()).setAvgTime(statistics.getAverageCollectionTime()).setAvgFrequency(statistics.getAverageCollectionFrequency(uptime)).build()));
        }
        if ((tickStatistics = this.platform.getTickStatistics()) != null) {
            builder.setTps((SparkProtos.PlatformStatistics.Tps)SparkProtos.PlatformStatistics.Tps.newBuilder().setLast1M(tickStatistics.tps1Min()).setLast5M(tickStatistics.tps5Min()).setLast15M(tickStatistics.tps15Min()).build());
            if (tickStatistics.isDurationSupported()) {
                builder.setMspt((SparkProtos.PlatformStatistics.Mspt)SparkProtos.PlatformStatistics.Mspt.newBuilder().setLast1M(PlatformStatisticsProvider.rollingAvgProto(tickStatistics.duration1Min())).setLast5M(PlatformStatisticsProvider.rollingAvgProto(tickStatistics.duration5Min())).build());
            }
        }
        if ((pingStatistics = this.platform.getPingStatistics()) != null && pingStatistics.getPingAverage().getSamples() != 0) {
            builder.setPing((SparkProtos.PlatformStatistics.Ping)SparkProtos.PlatformStatistics.Ping.newBuilder().setLast15M(PlatformStatisticsProvider.rollingAvgProto(pingStatistics.getPingAverage())).build());
        }
        if ((platformType = this.platform.getPlugin().getPlatformInfo().getType()) != PlatformInfo.Type.CLIENT) {
            long playerCount = this.platform.getPlugin().getCommandSenders().count() - 1L;
            builder.setPlayerCount(playerCount);
        }
        if (includeWorld) {
            try {
                WorldStatisticsProvider worldStatisticsProvider = new WorldStatisticsProvider(new AsyncWorldInfoProvider(this.platform, this.platform.getPlugin().createWorldInfoProvider()));
                SparkProtos.WorldStatistics worldStatistics = worldStatisticsProvider.getWorldStatistics();
                if (worldStatistics != null) {
                    builder.setWorld(worldStatistics);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (SparkProtos.PlatformStatistics)builder.build();
    }

    public static SparkProtos.RollingAverageValues rollingAvgProto(DoubleAverageInfo info) {
        return (SparkProtos.RollingAverageValues)SparkProtos.RollingAverageValues.newBuilder().setMean(info.mean()).setMax(info.max()).setMin(info.min()).setMedian(info.median()).setPercentile95(info.percentile95th()).build();
    }

    static final class VmArgRedactor {
        private static final Pattern WINDOWS_USERNAME = Pattern.compile("C:\\\\Users\\\\\\w+");
        private static final Pattern MACOS_USERNAME = Pattern.compile("/Users/\\w+");
        private static final Pattern LINUX_USERNAME = Pattern.compile("/home/\\w+");

        VmArgRedactor() {
        }

        static String replace(String input) {
            input = WINDOWS_USERNAME.matcher(input).replaceAll("C:\\\\Users\\\\<redacted>");
            input = MACOS_USERNAME.matcher(input).replaceAll("/Users/<redacted>");
            input = LINUX_USERNAME.matcher(input).replaceAll("/home/<redacted>");
            return input;
        }
    }
}

