/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntPredicate;
import me.lucko.spark.paper.common.sampler.node.MergeMode;
import me.lucko.spark.paper.common.sampler.node.StackTraceNode;
import me.lucko.spark.paper.common.sampler.window.ProtoTimeEncoder;

public abstract class AbstractNode {
    protected static final int MAX_STACK_DEPTH = Integer.getInteger("spark.maxStackDepth", 300);
    private final Map<StackTraceNode.Description, StackTraceNode> children = new ConcurrentHashMap<StackTraceNode.Description, StackTraceNode>();
    private final Map<Integer, LongAdder> times = new ConcurrentHashMap<Integer, LongAdder>();

    protected LongAdder getTimeAccumulator(int window) {
        LongAdder adder = this.times.get(window);
        if (adder == null) {
            adder = new LongAdder();
            this.times.put(window, adder);
        }
        return adder;
    }

    public Set<Integer> getTimeWindows() {
        return this.times.keySet();
    }

    public boolean removeTimeWindows(IntPredicate predicate) {
        return this.times.keySet().removeIf(predicate::test);
    }

    protected double[] encodeTimesForProto(ProtoTimeEncoder encoder) {
        return encoder.encode(this.times);
    }

    public Collection<StackTraceNode> getChildren() {
        return this.children.values();
    }

    protected StackTraceNode resolveChild(StackTraceNode.Description description) {
        StackTraceNode result = this.children.get(description);
        if (result != null) {
            return result;
        }
        return this.children.computeIfAbsent(description, StackTraceNode::new);
    }

    protected void merge(AbstractNode other) {
        other.times.forEach((key, value) -> this.getTimeAccumulator((int)key).add(value.longValue()));
        for (Map.Entry<StackTraceNode.Description, StackTraceNode> child : other.children.entrySet()) {
            this.resolveChild(child.getKey()).merge(child.getValue());
        }
    }

    protected List<StackTraceNode> exportChildren(MergeMode mergeMode) {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.size());
        block0: for (StackTraceNode child : this.children.values()) {
            for (StackTraceNode other : list) {
                if (!mergeMode.shouldMerge(other, child)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(child);
        }
        return list;
    }
}

