/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.sampler.node.StackTraceNode;
import me.lucko.spark.paper.common.sampler.node.ThreadNode;
import me.lucko.spark.paper.common.util.classfinder.ClassFinder;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ClassSourceLookup {
    public static final ClassSourceLookup NO_OP = new ClassSourceLookup(){

        @Override
        public @Nullable String identify(Class<?> clazz) {
            return null;
        }
    };

    public @Nullable String identify(Class<?> var1) throws Exception;

    default public @Nullable String identify(MethodCall methodCall) throws Exception {
        return null;
    }

    default public @Nullable String identify(MethodCallByLine methodCall) throws Exception {
        return null;
    }

    public static ClassSourceLookup create(SparkPlatform platform) {
        try {
            return platform.createClassSourceLookup();
        }
        catch (Exception e) {
            e.printStackTrace();
            return NO_OP;
        }
    }

    public static Visitor createVisitor(ClassSourceLookup lookup, Supplier<ClassFinder> classFinderSupplier) {
        if (lookup == NO_OP) {
            return NoOpVisitor.INSTANCE;
        }
        return new VisitorImpl(lookup, classFinderSupplier.get());
    }

    public static enum NoOpVisitor implements Visitor
    {
        INSTANCE;


        @Override
        public void visit(ThreadNode node) {
        }

        @Override
        public boolean hasClassSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getClassSourceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public boolean hasMethodSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getMethodSourceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public boolean hasLineSourceMappings() {
            return false;
        }

        @Override
        public Map<String, String> getLineSourceMapping() {
            return Collections.emptyMap();
        }
    }

    public static class VisitorImpl
    implements Visitor {
        private final ClassSourceLookup lookup;
        private final ClassFinder classFinder;
        private final SourcesMap<String> classSources = new SourcesMap(Function.identity());
        private final SourcesMap<MethodCall> methodSources = new SourcesMap(MethodCall::toString);
        private final SourcesMap<MethodCallByLine> lineSources = new SourcesMap(MethodCallByLine::toString);

        VisitorImpl(ClassSourceLookup lookup, ClassFinder classFinder) {
            this.lookup = lookup;
            this.classFinder = classFinder;
        }

        @Override
        public void visit(ThreadNode node) {
            ArrayDeque<StackTraceNode> queue = new ArrayDeque<StackTraceNode>(node.getChildren());
            StackTraceNode n = (StackTraceNode)queue.poll();
            while (n != null) {
                this.visitStackNode(n);
                queue.addAll(n.getChildren());
                n = (StackTraceNode)queue.poll();
            }
        }

        private void visitStackNode(StackTraceNode node) {
            this.classSources.computeIfAbsent(node.getClassName(), className -> {
                Class<?> clazz = this.classFinder.findClass((String)className);
                if (clazz == null) {
                    return null;
                }
                return this.lookup.identify(clazz);
            });
            if (node.getMethodDescription() != null) {
                MethodCall methodCall = new MethodCall(node.getClassName(), node.getMethodName(), node.getMethodDescription());
                this.methodSources.computeIfAbsent(methodCall, this.lookup::identify);
            } else {
                MethodCallByLine methodCall = new MethodCallByLine(node.getClassName(), node.getMethodName(), node.getLineNumber());
                this.lineSources.computeIfAbsent(methodCall, this.lookup::identify);
            }
        }

        @Override
        public boolean hasClassSourceMappings() {
            return this.classSources.hasMappings();
        }

        @Override
        public Map<String, String> getClassSourceMapping() {
            return this.classSources.export();
        }

        @Override
        public boolean hasMethodSourceMappings() {
            return this.methodSources.hasMappings();
        }

        @Override
        public Map<String, String> getMethodSourceMapping() {
            return this.methodSources.export();
        }

        @Override
        public boolean hasLineSourceMappings() {
            return this.lineSources.hasMappings();
        }

        @Override
        public Map<String, String> getLineSourceMapping() {
            return this.lineSources.export();
        }
    }

    public static final class MethodCallByLine {
        private final String className;
        private final String methodName;
        private final int lineNumber;

        public MethodCallByLine(String className, String methodName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String toString() {
            return this.className + ";" + this.lineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCallByLine)) {
                return false;
            }
            MethodCallByLine that = (MethodCallByLine)o;
            return this.lineNumber == that.lineNumber && this.className.equals(that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.lineNumber);
        }
    }

    public static final class MethodCall {
        private final String className;
        private final String methodName;
        private final String methodDescriptor;

        public MethodCall(String className, String methodName, String methodDescriptor) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDescriptor() {
            return this.methodDescriptor;
        }

        public String toString() {
            return this.className + ";" + this.methodName + ";" + this.methodDescriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCall)) {
                return false;
            }
            MethodCall that = (MethodCall)o;
            return this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.methodDescriptor.equals(that.methodDescriptor);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.methodName, this.methodDescriptor);
        }
    }

    public static final class SourcesMap<T> {
        private final Map<T, String> map = new HashMap<T, String>();
        private final Function<? super T, String> keyToStringFunction;

        private SourcesMap(Function<? super T, String> keyToStringFunction) {
            this.keyToStringFunction = keyToStringFunction;
        }

        public void computeIfAbsent(T key, ComputeSourceFunction<T> function) {
            if (!this.map.containsKey(key)) {
                try {
                    this.map.put(key, function.compute(key));
                }
                catch (Throwable e) {
                    this.map.put(key, null);
                }
            }
        }

        public boolean hasMappings() {
            this.map.values().removeIf(Objects::isNull);
            return !this.map.isEmpty();
        }

        public Map<String, String> export() {
            this.map.values().removeIf(Objects::isNull);
            if (this.keyToStringFunction.equals(Function.identity())) {
                return this.map;
            }
            return this.map.entrySet().stream().collect(Collectors.toMap(e -> this.keyToStringFunction.apply(e.getKey()), Map.Entry::getValue));
        }

        private static interface ComputeSourceFunction<T> {
            public String compute(T var1) throws Exception;
        }
    }

    public static interface Visitor {
        public void visit(ThreadNode var1);

        public boolean hasClassSourceMappings();

        public Map<String, String> getClassSourceMapping();

        public boolean hasMethodSourceMappings();

        public Map<String, String> getMethodSourceMapping();

        public boolean hasLineSourceMappings();

        public Map<String, String> getLineSourceMapping();
    }

    public static class ByCodeSource
    implements ClassSourceLookup,
    ByUrl {
        @Override
        public @Nullable String identify(Class<?> clazz) throws URISyntaxException, MalformedURLException {
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL url = codeSource.getLocation();
            return url == null ? null : this.identifyUrl(url);
        }
    }

    public static class ByFirstUrlSource
    extends ByClassLoader
    implements ByUrl {
        @Override
        public @Nullable String identify(ClassLoader loader) throws IOException, URISyntaxException {
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                URL[] urls = urlClassLoader.getURLs();
                if (urls.length == 0) {
                    return null;
                }
                return this.identifyUrl(urls[0]);
            }
            return null;
        }
    }

    public static interface ByUrl
    extends ClassSourceLookup {
        default public String identifyUrl(URL url) throws URISyntaxException, MalformedURLException {
            Path path = null;
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                path = Paths.get(url.toURI());
            } else if (protocol.equals("jar")) {
                URL innerUrl = new URL(url.getPath());
                path = Paths.get(innerUrl.getPath().split("!")[0], new String[0]);
            }
            if (path != null) {
                return this.identifyFile(path.toAbsolutePath().normalize());
            }
            return null;
        }

        default public String identifyFile(Path path) {
            return this.identifyFileName(path.getFileName().toString());
        }

        default public String identifyFileName(String fileName) {
            return fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : null;
        }
    }

    public static abstract class ByClassLoader
    implements ClassSourceLookup {
        public abstract @Nullable String identify(ClassLoader var1) throws Exception;

        @Override
        public final @Nullable String identify(Class<?> clazz) throws Exception {
            for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
                String source = this.identify(loader);
                if (source == null) continue;
                return source;
            }
            return null;
        }
    }
}

