/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.util;

import java.util.Arrays;
import java.util.stream.Stream;

public final class ThreadFinder {
    private static final ThreadGroup ROOT_THREAD_GROUP;
    private int approxActiveCount = ROOT_THREAD_GROUP.activeCount();

    public Stream<Thread> getThreads() {
        int len;
        Thread[] threads = new Thread[this.approxActiveCount + 10];
        while ((len = ROOT_THREAD_GROUP.enumerate(threads, true)) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        this.approxActiveCount = len;
        return Arrays.stream(threads, 0, len);
    }

    static {
        ThreadGroup parentGroup;
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while ((parentGroup = rootGroup.getParent()) != null) {
            rootGroup = parentGroup;
        }
        ROOT_THREAD_GROUP = rootGroup;
    }
}

