/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.LevelHelper;
import alternate.current.wire.Node;
import alternate.current.wire.WireConnectionManager;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class WireNode
extends Node {
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean root;
    boolean discovered;
    boolean searched;
    WireNode next_wire;

    WireNode(WorldServer level, BlockPosition pos, IBlockData state) {
        super(level);
        this.pos = pos.j();
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.state.c(BlockRedstoneWire.f).intValue();
        this.priority = this.priority();
    }

    @Override
    Node set(BlockPosition pos, IBlockData state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    int priority() {
        return MathHelper.a(this.virtualPower, 0, 15);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = this.level.a_(this.pos);
        if (!this.state.a(Blocks.cE)) {
            return false;
        }
        if (this.shouldBreak) {
            Block.c(this.state, this.level, this.pos);
            this.level.a(this.pos, Blocks.a.m(), 2);
            return true;
        }
        this.currentPower = LevelHelper.doRedstoneEvent(this.level, this.pos, this.currentPower, MathHelper.a(this.virtualPower, 0, 15));
        this.state = (IBlockData)this.state.b(BlockRedstoneWire.f, this.currentPower);
        return LevelHelper.setWireState(this.level, this.pos, this.state, this.added);
    }
}

