/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.map;

import ca.spottedleaf.concurrentutil.function.BiLong1Function;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.HashUtil;
import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.concurrentutil.util.ThrowUtil;
import ca.spottedleaf.concurrentutil.util.Validate;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.Predicate;

public class ConcurrentLong2ReferenceChainedHashTable<V>
implements Iterable<TableEntry<V>> {
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected final LongAdder size = new LongAdder();
    protected final float loadFactor;
    protected volatile TableEntry<V>[] table;
    protected static final int THRESHOLD_NO_RESIZE = -1;
    protected static final int THRESHOLD_RESIZING = -2;
    protected volatile int threshold;
    protected static final VarHandle THRESHOLD_HANDLE = ConcurrentUtil.getVarHandle(ConcurrentLong2ReferenceChainedHashTable.class, "threshold", Integer.TYPE);

    protected final int getThresholdAcquire() {
        return THRESHOLD_HANDLE.getAcquire(this);
    }

    protected final int getThresholdVolatile() {
        return THRESHOLD_HANDLE.getVolatile(this);
    }

    protected final void setThresholdPlain(int threshold) {
        THRESHOLD_HANDLE.set(this, threshold);
    }

    protected final void setThresholdRelease(int threshold) {
        THRESHOLD_HANDLE.setRelease(this, threshold);
    }

    protected final void setThresholdVolatile(int threshold) {
        THRESHOLD_HANDLE.setVolatile(this, threshold);
    }

    protected final int compareExchangeThresholdVolatile(int expect, int update) {
        return THRESHOLD_HANDLE.compareAndExchange(this, expect, update);
    }

    public ConcurrentLong2ReferenceChainedHashTable() {
        this(16, 0.75f);
    }

    protected static int getTargetThreshold(int capacity, float loadFactor) {
        double ret = (double)capacity * (double)loadFactor;
        if (Double.isInfinite(ret) || ret >= 2.147483647E9) {
            return -1;
        }
        return (int)Math.ceil(ret);
    }

    protected static int getCapacityFor(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        if (capacity >= 0x40000000) {
            return 0x40000000;
        }
        return IntegerUtil.roundCeilLog2(capacity);
    }

    protected ConcurrentLong2ReferenceChainedHashTable(int capacity, float loadFactor) {
        int tableSize = ConcurrentLong2ReferenceChainedHashTable.getCapacityFor(capacity);
        if ((double)loadFactor <= 0.0 || !Float.isFinite(loadFactor)) {
            throw new IllegalArgumentException("Invalid load factor: " + loadFactor);
        }
        if (tableSize == 0x40000000) {
            this.setThresholdPlain(-1);
        } else {
            this.setThresholdPlain(ConcurrentLong2ReferenceChainedHashTable.getTargetThreshold(tableSize, loadFactor));
        }
        this.loadFactor = loadFactor;
        this.table = new TableEntry[tableSize];
    }

    public static <V> ConcurrentLong2ReferenceChainedHashTable<V> createWithCapacity(int capacity) {
        return ConcurrentLong2ReferenceChainedHashTable.createWithCapacity(capacity, 0.75f);
    }

    public static <V> ConcurrentLong2ReferenceChainedHashTable<V> createWithCapacity(int capacity, float loadFactor) {
        return new ConcurrentLong2ReferenceChainedHashTable<V>(capacity, loadFactor);
    }

    public static <V> ConcurrentLong2ReferenceChainedHashTable<V> createWithExpected(int expected) {
        return ConcurrentLong2ReferenceChainedHashTable.createWithExpected(expected, 0.75f);
    }

    public static <V> ConcurrentLong2ReferenceChainedHashTable<V> createWithExpected(int expected, float loadFactor) {
        int capacity = (int)Math.ceil((double)expected / (double)loadFactor);
        return ConcurrentLong2ReferenceChainedHashTable.createWithCapacity(capacity, loadFactor);
    }

    protected static int getHash(long key) {
        return (int)HashUtil.mix(key);
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    protected static <V> TableEntry<V> getAtIndexVolatile(TableEntry<V>[] table, int index) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.getVolatile(table, index);
    }

    protected static <V> void setAtIndexRelease(TableEntry<V>[] table, int index, TableEntry<V> value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setRelease(table, index, value);
    }

    protected static <V> void setAtIndexVolatile(TableEntry<V>[] table, int index, TableEntry<V> value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setVolatile(table, index, value);
    }

    protected static <V> TableEntry<V> compareAndExchangeAtIndexVolatile(TableEntry<V>[] table, int index, TableEntry<V> expect, TableEntry<V> update) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.compareAndExchange(table, index, expect, update);
    }

    protected final TableEntry<V> getNode(long key) {
        TableEntry<V> node;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        while (true) {
            if ((node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, hash & table.length - 1)) == null) {
                return node;
            }
            if (!node.resize) break;
            table = (TableEntry[])node.getValuePlain();
        }
        while (node != null) {
            if (node.key == key) {
                return node;
            }
            node = node.getNextVolatile();
        }
        return node;
    }

    public V get(long key) {
        TableEntry<V> node = this.getNode(key);
        return node == null ? null : (V)node.getValueVolatile();
    }

    public V getOrDefault(long key, V defaultValue) {
        TableEntry<V> node = this.getNode(key);
        if (node == null) {
            return defaultValue;
        }
        V ret = node.getValueVolatile();
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public boolean containsValue(V value) {
        TableEntry<V> node;
        Validate.notNull(value, "Value cannot be null");
        NodeIterator<V> iterator = new NodeIterator<V>(this.table);
        while ((node = iterator.findNext()) != null) {
            if (node.getValueAcquire() != value) continue;
            return true;
        }
        return false;
    }

    public int size() {
        long ret = this.size.sum();
        if (ret < 0L) {
            return 0;
        }
        if (ret > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)ret;
    }

    public boolean isEmpty() {
        return this.size.sum() <= 0L;
    }

    protected final void addSize(long count) {
        this.size.add(count);
        int threshold = this.getThresholdAcquire();
        if ((long)threshold < 0L) {
            return;
        }
        long sum = this.size.sum();
        if (sum < (long)threshold) {
            return;
        }
        if (threshold != this.compareExchangeThresholdVolatile(threshold, -2)) {
            return;
        }
        this.resize(sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(long sum) {
        int capacity;
        double targetD = (double)sum / (double)this.loadFactor + 1.0;
        if (targetD >= 1.073741824E9) {
            capacity = 0x40000000;
        } else {
            capacity = (int)Math.ceil(targetD);
            if ((capacity = IntegerUtil.roundCeilLog2(capacity)) > 0x40000000) {
                capacity = 0x40000000;
            }
        }
        TableEntry[] newTable = new TableEntry[capacity];
        TableEntry<TableEntry[]> resizeNode = new TableEntry<TableEntry[]>(0L, newTable, true);
        TableEntry<V>[] oldTable = this.table;
        int capOldShift = IntegerUtil.floorLog2(oldTable.length);
        int capDiffShift = IntegerUtil.floorLog2(capacity) - capOldShift;
        if (capDiffShift == 0) {
            throw new IllegalStateException("Resizing to same size");
        }
        Object[] work = new TableEntry[1 << capDiffShift];
        int len = oldTable.length;
        block3: for (int i2 = 0; i2 < len; ++i2) {
            TableEntry<Object> binNode = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(oldTable, i2);
            while (binNode != null || null != (binNode = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(oldTable, i2, null, resizeNode))) {
                TableEntry<V> tableEntry = binNode;
                synchronized (tableEntry) {
                    TableEntry<V> tableEntry2 = binNode;
                    binNode = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(oldTable, i2);
                    if (tableEntry2 != binNode) {
                        continue;
                    }
                    TableEntry<Object> next = binNode.getNextPlain();
                    if (next == null) {
                        newTable[ConcurrentLong2ReferenceChainedHashTable.getHash((long)binNode.key) & capacity - 1] = binNode;
                    } else {
                        Arrays.fill(work, null);
                        for (TableEntry<Object> curr = binNode; curr != null; curr = curr.getNextPlain()) {
                            int newTableIdx = ConcurrentLong2ReferenceChainedHashTable.getHash(curr.key) & capacity - 1;
                            int workIdx = newTableIdx >>> capOldShift;
                            TableEntry<Object> replace = new TableEntry<Object>(curr.key, curr.getValuePlain());
                            Object workNode = work[workIdx];
                            work[workIdx] = replace;
                            if (workNode == null) {
                                newTable[newTableIdx] = replace;
                                continue;
                            }
                            ((TableEntry)workNode).setNextPlain(replace);
                        }
                    }
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(oldTable, i2, resizeNode);
                    continue block3;
                }
            }
        }
        int newThreshold = capacity == 0x40000000 ? -1 : ConcurrentLong2ReferenceChainedHashTable.getTargetThreshold(capacity, this.loadFactor);
        this.table = newTable;
        this.setThresholdVolatile(newThreshold);
    }

    protected final void subSize(long count) {
        this.size.add(-count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V put(long key, V value) {
        TableEntry<V> node;
        Validate.notNull(value, "Value may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null && null == (node = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry<V>(key, value)))) {
                    this.addSize(1L);
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                TableEntry<V> tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry<V> tableEntry2 = node;
                    node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            TableEntry<V> prev = null;
            while (true) {
                if (node == null) {
                    prev.setNextRelease(new TableEntry<V>(key, value));
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var8_7
                    this.addSize(1L);
                    return null;
                }
                if (node.key == key) {
                    V ret = node.getValuePlain();
                    node.setValueVolatile(value);
                    return ret;
                }
                prev = node;
                node = node.getNextPlain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V putIfAbsent(long key, V value) {
        TableEntry<V> node;
        Validate.notNull(value, "Value may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                V ret;
                if (node == null && null == (node = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry<V>(key, value)))) {
                    this.addSize(1L);
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                if (node.key == key && (ret = node.getValueVolatile()) != null) {
                    return ret;
                }
                TableEntry<V> tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry<V> tableEntry2 = node;
                    node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            TableEntry<V> prev = null;
            while (true) {
                if (node == null) {
                    prev.setNextRelease(new TableEntry<V>(key, value));
                    // MONITOREXIT @DISABLED, blocks:[1, 4, 6] lbl28 : MonitorExitStatement: MONITOREXIT : var8_7
                    this.addSize(1L);
                    return null;
                }
                if (node.key == key) {
                    return node.getValuePlain();
                }
                prev = node;
                node = node.getNextPlain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V replace(long key, V value) {
        TableEntry<V> node;
        Validate.notNull(value, "Value may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                TableEntry<V> tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry<V> tableEntry2 = node;
                    node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            while (node != null) {
                if (node.key == key) {
                    V ret = node.getValuePlain();
                    node.setValueVolatile(value);
                    return ret;
                }
                node = node.getNextPlain();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V replace(long key, V expect, V update) {
        TableEntry<V> node;
        Validate.notNull(expect, "Expect may not be null");
        Validate.notNull(update, "Update may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                TableEntry<V> tableEntry = node;
                synchronized (tableEntry) {
                    TableEntry<V> tableEntry2 = node;
                    node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
                    if (tableEntry2 == node) break block2;
                }
            }
            break;
        }
        {
            while (node != null) {
                if (node.key == key) {
                    V ret = node.getValuePlain();
                    if (ret != expect) {
                        return ret;
                    }
                    node.setValueVolatile(update);
                    return ret;
                }
                node = node.getNextPlain();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V remove(long key) {
        V ret;
        boolean removed;
        TableEntry<V> node;
        int index;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                removed = false;
                ret = null;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<V> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                removed = true;
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V remove(long key, V expect) {
        V ret;
        boolean removed;
        TableEntry<V> node;
        int index;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                removed = false;
                ret = null;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<V> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                if (ret != expect) break;
                removed = true;
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return ret;
        this.subSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V removeIf(long key, Predicate<? super V> predicate) {
        Object ret;
        boolean removed;
        TableEntry<V> node;
        int index;
        Validate.notNull(predicate, "Predicate may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                removed = false;
                ret = null;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<V> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                if (!predicate.test(ret)) break;
                removed = true;
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                    break;
                }
                prev.setNextRelease(node.getNextPlain());
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return (V)ret;
        this.subSize(1L);
        return (V)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V compute(long key, BiLong1Function<? super V, ? extends V> function) {
        V computed;
        boolean removed;
        boolean added;
        V ret;
        TableEntry<Object> node;
        int index;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block6: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                TableEntry<Object> tableEntry;
                ret = null;
                if (node == null) {
                    TableEntry<Object> insert = new TableEntry<Object>(key, null);
                    added = false;
                    tableEntry = insert;
                    // MONITORENTER : tableEntry
                    node = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, insert);
                    if (null == node) {
                        try {
                            ret = function.apply(key, null);
                        }
                        catch (Throwable throwable) {
                            ConcurrentLong2ReferenceChainedHashTable.setAtIndexVolatile(table, index, null);
                            ThrowUtil.throwUnchecked(throwable);
                            // MONITOREXIT : tableEntry
                            return null;
                        }
                        if (ret == null) {
                            ConcurrentLong2ReferenceChainedHashTable.setAtIndexVolatile(table, index, null);
                            // MONITOREXIT : tableEntry
                            return ret;
                        }
                        insert.setValueRelease(ret);
                        added = true;
                    }
                    // MONITOREXIT : tableEntry
                    if (added) {
                        this.addSize(1L);
                        return ret;
                    }
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block6;
                }
                removed = false;
                added = false;
                tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block6;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<Object> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                Object old = node.getValuePlain();
                V computed2 = function.apply(key, old);
                if (computed2 != null) {
                    node.setValueVolatile(computed2);
                    // MONITOREXIT : tableEntry
                    return computed2;
                }
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                } else {
                    prev.setNextRelease(node.getNextPlain());
                }
                removed = true;
                break;
            }
            prev = node;
        }
        if (!removed && (computed = function.apply(key, null)) != null) {
            prev.setNextRelease(new TableEntry<V>(key, computed));
            ret = computed;
            added = true;
        }
        // MONITOREXIT : tableEntry
        if (removed) {
            this.subSize(1L);
        }
        if (!added) return ret;
        this.addSize(1L);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V computeIfAbsent(long key, LongFunction<? extends V> function) {
        boolean added;
        Object ret;
        TableEntry<Object> node;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block6: while (true) {
            int index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                ret = null;
                if (node == null) {
                    TableEntry<Object> insert = new TableEntry<Object>(key, null);
                    boolean added2 = false;
                    TableEntry<Object> tableEntry = insert;
                    // MONITORENTER : tableEntry
                    node = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, insert);
                    if (null == node) {
                        try {
                            ret = function.apply(key);
                        }
                        catch (Throwable throwable) {
                            ConcurrentLong2ReferenceChainedHashTable.setAtIndexVolatile(table, index, null);
                            ThrowUtil.throwUnchecked(throwable);
                            // MONITOREXIT : tableEntry
                            return null;
                        }
                        if (ret == null) {
                            ConcurrentLong2ReferenceChainedHashTable.setAtIndexVolatile(table, index, null);
                            // MONITOREXIT : tableEntry
                            return null;
                        }
                        insert.setValueRelease(ret);
                        added2 = true;
                    }
                    // MONITOREXIT : tableEntry
                    if (added2) {
                        this.addSize(1L);
                        return (V)ret;
                    }
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block6;
                }
                if (node.key == key && (ret = (Object)node.getValueVolatile()) != null) {
                    return (V)ret;
                }
                added = false;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block6;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<Object> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                ret = node.getValuePlain();
                // MONITOREXIT : tableEntry
                return (V)ret;
            }
            prev = node;
        }
        V computed = function.apply(key);
        if (computed != null) {
            prev.setNextRelease(new TableEntry<V>(key, computed));
            ret = computed;
            added = true;
        }
        // MONITOREXIT : tableEntry
        if (!added) return (V)ret;
        this.addSize(1L);
        return (V)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V computeIfPresent(long key, BiLong1Function<? super V, ? extends V> function) {
        boolean removed;
        TableEntry<V> node;
        int index;
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null) {
                    return null;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                removed = false;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<V> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                V old = node.getValuePlain();
                V computed = function.apply(key, old);
                if (computed != null) {
                    node.setValueVolatile(computed);
                    // MONITOREXIT : tableEntry
                    return computed;
                }
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                } else {
                    prev.setNextRelease(node.getNextPlain());
                }
                removed = true;
                break;
            }
            prev = node;
        }
        // MONITOREXIT : tableEntry
        if (!removed) return null;
        this.subSize(1L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public V merge(long key, V def, BiFunction<? super V, ? super V, ? extends V> function) {
        V ret;
        boolean added;
        boolean removed;
        TableEntry<V> node;
        int index;
        Validate.notNull(def, "Default value may not be null");
        int hash = ConcurrentLong2ReferenceChainedHashTable.getHash(key);
        TableEntry<V>[] table = this.table;
        block2: while (true) {
            index = hash & table.length - 1;
            node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index);
            while (true) {
                if (node == null && null == (node = ConcurrentLong2ReferenceChainedHashTable.compareAndExchangeAtIndexVolatile(table, index, null, new TableEntry<V>(key, def)))) {
                    this.addSize(1L);
                    return def;
                }
                if (node.resize) {
                    table = (TableEntry[])node.getValuePlain();
                    continue block2;
                }
                removed = false;
                added = false;
                ret = null;
                TableEntry<V> tableEntry = node;
                // MONITORENTER : tableEntry
                TableEntry<V> tableEntry2 = node;
                if (tableEntry2 == node) break block2;
                // MONITOREXIT : tableEntry
            }
            break;
        }
        TableEntry<V> prev = null;
        for (node = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, index); node != null; node = node.getNextPlain()) {
            if (node.key == key) {
                V old = node.getValuePlain();
                V computed = function.apply(old, def);
                if (computed != null) {
                    node.setValueVolatile(computed);
                    // MONITOREXIT : tableEntry
                    return computed;
                }
                if (prev == null) {
                    ConcurrentLong2ReferenceChainedHashTable.setAtIndexRelease(table, index, node.getNextPlain());
                } else {
                    prev.setNextRelease(node.getNextPlain());
                }
                removed = true;
                break;
            }
            prev = node;
        }
        if (!removed) {
            prev.setNextRelease(new TableEntry<V>(key, def));
            ret = def;
            added = true;
        }
        // MONITOREXIT : tableEntry
        if (removed) {
            this.subSize(1L);
        }
        if (!added) return ret;
        this.addSize(1L);
        return ret;
    }

    public void clear() {
        TableEntry<V> node;
        NodeIterator<V> nodeIterator = new NodeIterator<V>(this.table);
        while ((node = nodeIterator.findNext()) != null) {
            this.remove(node.key);
        }
    }

    public Iterator<TableEntry<V>> entryIterator() {
        return new EntryIterator(this);
    }

    @Override
    public final Iterator<TableEntry<V>> iterator() {
        return this.entryIterator();
    }

    public PrimitiveIterator.OfLong keyIterator() {
        return new KeyIterator(this);
    }

    public Iterator<V> valueIterator() {
        return new ValueIterator(this);
    }

    public static final class TableEntry<V> {
        private static final VarHandle TABLE_ENTRY_ARRAY_HANDLE = ConcurrentUtil.getArrayHandle(TableEntry[].class);
        private final boolean resize;
        private final long key;
        private volatile V value;
        private static final VarHandle VALUE_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "value", Object.class);
        private volatile TableEntry<V> next;
        private static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "next", TableEntry.class);

        private V getValuePlain() {
            return (V)VALUE_HANDLE.get(this);
        }

        private V getValueAcquire() {
            return (V)VALUE_HANDLE.getAcquire(this);
        }

        private V getValueVolatile() {
            return (V)VALUE_HANDLE.getVolatile(this);
        }

        private void setValuePlain(V value) {
            VALUE_HANDLE.set(this, value);
        }

        private void setValueRelease(V value) {
            VALUE_HANDLE.setRelease(this, value);
        }

        private void setValueVolatile(V value) {
            VALUE_HANDLE.setVolatile(this, value);
        }

        private TableEntry<V> getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        private TableEntry<V> getNextVolatile() {
            return NEXT_HANDLE.getVolatile(this);
        }

        private void setNextPlain(TableEntry<V> next) {
            NEXT_HANDLE.set(this, next);
        }

        private void setNextRelease(TableEntry<V> next) {
            NEXT_HANDLE.setRelease(this, next);
        }

        private void setNextVolatile(TableEntry<V> next) {
            NEXT_HANDLE.setVolatile(this, next);
        }

        public TableEntry(long key, V value) {
            this.resize = false;
            this.key = key;
            this.setValuePlain(value);
        }

        public TableEntry(long key, V value, boolean resize) {
            this.resize = resize;
            this.key = key;
            this.setValuePlain(value);
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.getValueVolatile();
        }
    }

    protected static class NodeIterator<V> {
        protected TableEntry<V>[] currentTable;
        protected ResizeChain<V> resizeChain;
        protected TableEntry<V> last;
        protected int nextBin;
        protected int increment;

        protected NodeIterator(TableEntry<V>[] baseTable) {
            this.currentTable = baseTable;
            this.increment = 1;
        }

        private TableEntry<V>[] pullResizeChain(int index) {
            ResizeChain<V> resizeChain = this.resizeChain;
            if (resizeChain == null) {
                this.currentTable = null;
                return null;
            }
            ResizeChain prevChain = resizeChain.prev;
            this.resizeChain = prevChain;
            if (prevChain == null) {
                this.currentTable = null;
                return null;
            }
            TableEntry<V>[] newTable = prevChain.table;
            int newIdx = index & newTable.length - 1;
            ResizeChain nextPrevChain = prevChain.prev;
            int increment = nextPrevChain == null ? 1 : nextPrevChain.table.length;
            this.increment = increment;
            this.nextBin = newIdx += increment;
            this.currentTable = newTable;
            return newTable;
        }

        private TableEntry<V>[] pushResizeChain(TableEntry<V>[] table, TableEntry<V> entry) {
            ResizeChain<V> chain = this.resizeChain;
            if (chain == null) {
                TableEntry[] nextTable = (TableEntry[])entry.getValuePlain();
                ResizeChain<V> oldChain = new ResizeChain<V>(table, null, null);
                ResizeChain<V> currChain = new ResizeChain<V>(nextTable, oldChain, null);
                oldChain.next = currChain;
                this.increment = table.length;
                this.resizeChain = currChain;
                this.currentTable = nextTable;
                return nextTable;
            }
            ResizeChain currChain = chain.next;
            if (currChain == null) {
                TableEntry[] ret = (TableEntry[])entry.getValuePlain();
                chain.next = currChain = new ResizeChain<V>(ret, chain, null);
                this.increment = table.length;
                this.resizeChain = currChain;
                this.currentTable = ret;
                return ret;
            }
            this.increment = table.length;
            this.resizeChain = currChain;
            this.currentTable = currChain.table;
            return currChain.table;
        }

        protected final TableEntry<V> findNext() {
            TableEntry<V> entry;
            while (true) {
                TableEntry<V> next;
                TableEntry<V> last;
                if ((last = this.last) != null && (next = last.getNextVolatile()) != null) {
                    this.last = next;
                    if (next.getValuePlain() == null) continue;
                    return next;
                }
                TableEntry<V>[] table = this.currentTable;
                if (table == null) {
                    return null;
                }
                int idx = this.nextBin;
                int increment = this.increment;
                while (true) {
                    if (idx >= table.length) {
                        table = this.pullResizeChain(idx);
                        idx = this.nextBin;
                        increment = this.increment;
                        if (table != null) continue;
                        this.last = null;
                        return null;
                    }
                    entry = ConcurrentLong2ReferenceChainedHashTable.getAtIndexVolatile(table, idx);
                    if (entry == null) {
                        idx += increment;
                        continue;
                    }
                    if (!entry.resize) break;
                    table = this.pushResizeChain(table, entry);
                    increment = this.increment;
                }
                this.last = entry;
                this.nextBin = idx + increment;
                if (entry.getValuePlain() != null) break;
            }
            return entry;
        }

        protected static final class ResizeChain<V> {
            public final TableEntry<V>[] table;
            public final ResizeChain<V> prev;
            public ResizeChain<V> next;

            public ResizeChain(TableEntry<V>[] table, ResizeChain<V> prev, ResizeChain<V> next) {
                this.table = table;
                this.prev = prev;
                this.next = next;
            }
        }
    }

    protected static final class EntryIterator<V>
    extends BaseIteratorImpl<V, TableEntry<V>> {
        public EntryIterator(ConcurrentLong2ReferenceChainedHashTable<V> map) {
            super(map);
        }

        @Override
        public TableEntry<V> next() throws NoSuchElementException {
            return this.nextNode();
        }

        @Override
        public void forEachRemaining(Consumer<? super TableEntry<V>> action) {
            Validate.notNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept((TableEntry<V>)this.next());
            }
        }
    }

    protected static final class KeyIterator<V>
    extends BaseIteratorImpl<V, Long>
    implements PrimitiveIterator.OfLong {
        public KeyIterator(ConcurrentLong2ReferenceChainedHashTable<V> map) {
            super(map);
        }

        @Override
        public Long next() throws NoSuchElementException {
            return this.nextNode().key;
        }

        @Override
        public long nextLong() {
            return this.nextNode().key;
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            Validate.notNull(action, "Action may not be null");
            if (action instanceof LongConsumer) {
                LongConsumer longConsumer = (LongConsumer)((Object)action);
                this.forEachRemaining(longConsumer);
                return;
            }
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            Validate.notNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept(this.nextLong());
            }
        }
    }

    protected static final class ValueIterator<V>
    extends BaseIteratorImpl<V, V> {
        public ValueIterator(ConcurrentLong2ReferenceChainedHashTable<V> map) {
            super(map);
        }

        @Override
        public V next() throws NoSuchElementException {
            return this.nextNode().getValueVolatile();
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            Validate.notNull(action, "Action may not be null");
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
    }

    protected static abstract class BaseIteratorImpl<V, T>
    extends NodeIterator<V>
    implements Iterator<T> {
        protected final ConcurrentLong2ReferenceChainedHashTable<V> map;
        protected TableEntry<V> lastReturned;
        protected TableEntry<V> nextToReturn;

        protected BaseIteratorImpl(ConcurrentLong2ReferenceChainedHashTable<V> map) {
            super(map.table);
            this.map = map;
        }

        @Override
        public final boolean hasNext() {
            if (this.nextToReturn != null) {
                return true;
            }
            this.nextToReturn = this.findNext();
            return this.nextToReturn != null;
        }

        protected final TableEntry<V> nextNode() throws NoSuchElementException {
            TableEntry<V> ret = this.nextToReturn;
            if (ret != null) {
                this.lastReturned = ret;
                this.nextToReturn = null;
                return ret;
            }
            ret = this.findNext();
            if (ret != null) {
                this.lastReturned = ret;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            TableEntry<V> lastReturned = this.lastReturned;
            if (lastReturned == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = null;
            this.map.remove(lastReturned.key);
        }

        @Override
        public abstract T next() throws NoSuchElementException;

        @Override
        public abstract void forEachRemaining(Consumer<? super T> var1);
    }
}

