/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.concurrentutil.util;

public final class IntegerUtil {
    public static final int HIGH_BIT_U32 = Integer.MIN_VALUE;
    public static final long HIGH_BIT_U64 = Long.MIN_VALUE;

    public static int ceilLog2(int value) {
        return 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static long ceilLog2(long value) {
        return 64 - Long.numberOfLeadingZeros(value - 1L);
    }

    public static int floorLog2(int value) {
        return 0x1F ^ Integer.numberOfLeadingZeros(value);
    }

    public static int floorLog2(long value) {
        return 0x3F ^ Long.numberOfLeadingZeros(value);
    }

    public static int roundCeilLog2(int value) {
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(value - 1) - 1;
    }

    public static long roundCeilLog2(long value) {
        return Long.MIN_VALUE >>> Long.numberOfLeadingZeros(value - 1L) - 1;
    }

    public static int roundFloorLog2(int value) {
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(value);
    }

    public static long roundFloorLog2(long value) {
        return Long.MIN_VALUE >>> Long.numberOfLeadingZeros(value);
    }

    public static boolean isPowerOfTwo(int n2) {
        return IntegerUtil.getTrailingBit(n2) == n2;
    }

    public static boolean isPowerOfTwo(long n2) {
        return IntegerUtil.getTrailingBit(n2) == n2;
    }

    public static int getTrailingBit(int n2) {
        return -n2 & n2;
    }

    public static long getTrailingBit(long n2) {
        return -n2 & n2;
    }

    public static int trailingZeros(int n2) {
        return Integer.numberOfTrailingZeros(n2);
    }

    public static int trailingZeros(long n2) {
        return Long.numberOfTrailingZeros(n2);
    }

    public static int getDivisorMultiple(long numbers) {
        return (int)(numbers >>> 32);
    }

    public static int getDivisorShift(long numbers) {
        return (int)numbers;
    }

    public static long getDivisorNumbers(int d2) {
        int delta;
        int ad = IntegerUtil.branchlessAbs(d2);
        if (ad < 2) {
            throw new IllegalArgumentException("|number| must be in [2, 2^31 -1], not: " + d2);
        }
        int two31 = Integer.MIN_VALUE;
        long mask = 0xFFFFFFFFL;
        int p2 = 31;
        int t2 = Integer.MIN_VALUE + (d2 >>> 31);
        int anc = t2 - 1 - (int)(((long)t2 & 0xFFFFFFFFL) % (long)ad);
        int q1 = (int)(0x80000000L / ((long)anc & 0xFFFFFFFFL));
        int r1 = Integer.MIN_VALUE - q1 * anc;
        int q2 = (int)(0x80000000L / ((long)ad & 0xFFFFFFFFL));
        int r2 = Integer.MIN_VALUE - q2 * ad;
        do {
            ++p2;
            q1 = 2 * q1;
            if (((long)(r1 = 2 * r1) & 0xFFFFFFFFL) >= ((long)anc & 0xFFFFFFFFL)) {
                ++q1;
                r1 -= anc;
            }
            q2 = 2 * q2;
            if (((long)(r2 = 2 * r2) & 0xFFFFFFFFL) < ((long)ad & 0xFFFFFFFFL)) continue;
            ++q2;
            r2 -= ad;
        } while (((long)q1 & 0xFFFFFFFFL) < ((long)(delta = ad - r2) & 0xFFFFFFFFL) || q1 == delta && r1 == 0);
        int magicNum = q2 + 1;
        if (d2 < 0) {
            magicNum = -magicNum;
        }
        int shift = p2;
        return (long)magicNum << 32 | (long)shift;
    }

    public static int branchlessAbs(int val) {
        int mask = val >> 31;
        return (mask ^ val) - mask;
    }

    public static long branchlessAbs(long val) {
        long mask = val >> 63;
        return (mask ^ val) - mask;
    }

    public static long getUnsignedDivisorMagic(long divisor, int bits) {
        return ((1L << bits) - 1L) / divisor + 1L;
    }

    private IntegerUtil() {
        throw new RuntimeException();
    }
}

