/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.entity;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.function.IntFunction;

public final class ConverterEntityToVariant
extends DataConverter<MapType<String>, MapType<String>> {
    public final String path;
    public final IntFunction<String> conversion;

    public ConverterEntityToVariant(int toVersion, String path, IntFunction<String> conversion) {
        super(toVersion);
        this.path = path;
        this.conversion = conversion;
    }

    public ConverterEntityToVariant(int toVersion, int versionStep, String path, IntFunction<String> conversion) {
        super(toVersion, versionStep);
        this.path = path;
        this.conversion = conversion;
    }

    @Override
    public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
        Number value = data.getNumber(this.path);
        if (value == null) {
            return null;
        }
        String converted = this.conversion.apply(value.intValue());
        if (converted == null) {
            throw new NullPointerException("Conversion " + String.valueOf(this.conversion) + " cannot return null value!");
        }
        data.setString("variant", converted);
        return null;
    }
}

