/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;

public interface PlatformHooks {
    public static PlatformHooks get() {
        return Holder.INSTANCE;
    }

    public String getBrand();

    public int getLightEmission(IBlockData var1, IBlockAccess var2, BlockPosition var3);

    public Predicate<IBlockData> maybeHasLightEmission();

    public boolean hasCurrentlyLoadingChunk();

    public Chunk getCurrentlyLoadingChunk(GenerationChunkHolder var1);

    public void setCurrentlyLoading(GenerationChunkHolder var1, Chunk var2);

    public void chunkFullStatusComplete(Chunk var1, ProtoChunk var2);

    public boolean allowAsyncTicketUpdates();

    public void onChunkHolderTicketChange(WorldServer var1, PlayerChunk var2, int var3, int var4);

    public void chunkUnloadFromWorld(Chunk var1);

    public void chunkSyncSave(WorldServer var1, IChunkAccess var2, SerializableChunkData var3);

    public void onChunkWatch(WorldServer var1, Chunk var2, EntityPlayer var3);

    public void onChunkUnWatch(WorldServer var1, ChunkCoordIntPair var2, EntityPlayer var3);

    public void addToGetEntities(World var1, Entity var2, AxisAlignedBB var3, Predicate<? super Entity> var4, List<Entity> var5);

    public <T extends Entity> void addToGetEntities(World var1, EntityTypeTest<Entity, T> var2, AxisAlignedBB var3, Predicate<? super T> var4, List<? super T> var5, int var6);

    public void entityMove(Entity var1, long var2, long var4);

    public boolean screenEntity(WorldServer var1, Entity var2, boolean var3, boolean var4);

    public boolean configFixMC224294();

    public boolean configAutoConfigSendDistance();

    public double configPlayerMaxLoadRate();

    public double configPlayerMaxGenRate();

    public double configPlayerMaxSendRate();

    public int configPlayerMaxConcurrentLoads();

    public int configPlayerMaxConcurrentGens();

    public long configAutoSaveInterval(WorldServer var1);

    public int configMaxAutoSavePerTick(WorldServer var1);

    public boolean configFixMC159283();

    public boolean forceNoSave(IChunkAccess var1);

    public NBTTagCompound convertNBT(DSL.TypeReference var1, DataFixer var2, NBTTagCompound var3, int var4, int var5);

    public boolean hasMainChunkLoadHook();

    public void mainChunkLoad(IChunkAccess var1, SerializableChunkData var2);

    public List<Entity> modifySavedEntities(WorldServer var1, int var2, int var3, List<Entity> var4);

    public void unloadEntity(Entity var1);

    public void postLoadProtoChunk(WorldServer var1, ProtoChunk var2);

    public int modifyEntityTrackingRange(Entity var1, int var2);

    public static final class Holder {
        private static final PlatformHooks INSTANCE = ServiceLoader.load(PlatformHooks.class, PlatformHooks.class.getClassLoader()).findFirst().orElseThrow(() -> new RuntimeException("Failed to locate PlatformHooks"));

        private Holder() {
        }
    }
}

