/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class IteratorSafeOrderedReferenceSet<E> {
    public static final int ITERATOR_FLAG_SEE_ADDITIONS = 1;
    private final Reference2IntLinkedOpenHashMap<E> indexMap;
    private int firstInvalidIndex = -1;
    private E[] listElements;
    private int listSize;
    private final double maxFragFactor;
    private int iteratorCount;

    public IteratorSafeOrderedReferenceSet() {
        this(16, 0.75f, 16, 0.2);
    }

    public IteratorSafeOrderedReferenceSet(int setCapacity, float setLoadFactor, int arrayCapacity, double maxFragFactor) {
        this.indexMap = new Reference2IntLinkedOpenHashMap(setCapacity, setLoadFactor);
        this.indexMap.defaultReturnValue(-1);
        this.maxFragFactor = maxFragFactor;
        this.listElements = new Object[arrayCapacity];
    }

    private double getFragFactor() {
        return 1.0 - (double)this.indexMap.size() / (double)this.listSize;
    }

    public int createRawIterator() {
        ++this.iteratorCount;
        if (this.indexMap.isEmpty()) {
            return -1;
        }
        return this.firstInvalidIndex == 0 ? this.indexMap.getInt(this.indexMap.firstKey()) : 0;
    }

    public int advanceRawIterator(int index) {
        E[] elements = this.listElements;
        int len = this.listSize;
        for (int ret = index + 1; ret < len; ++ret) {
            if (elements[ret] == null) continue;
            return ret;
        }
        return -1;
    }

    public void finishRawIterator() {
        if (--this.iteratorCount == 0 && this.getFragFactor() >= this.maxFragFactor) {
            this.defrag();
        }
    }

    public boolean remove(E element) {
        int index = this.indexMap.removeInt(element);
        if (index >= 0) {
            if (this.firstInvalidIndex < 0 || index < this.firstInvalidIndex) {
                this.firstInvalidIndex = index;
            }
            if (this.listElements[index] != element) {
                throw new IllegalStateException();
            }
            this.listElements[index] = null;
            if (this.iteratorCount == 0 && this.getFragFactor() >= this.maxFragFactor) {
                this.defrag();
            }
            return true;
        }
        return false;
    }

    public boolean contains(E element) {
        return this.indexMap.containsKey(element);
    }

    public boolean add(E element) {
        int listSize = this.listSize;
        int previous = this.indexMap.putIfAbsent(element, listSize);
        if (previous != -1) {
            return false;
        }
        if (listSize >= this.listElements.length) {
            this.listElements = Arrays.copyOf(this.listElements, listSize * 2);
        }
        this.listElements[listSize] = element;
        this.listSize = listSize + 1;
        return true;
    }

    private void defrag() {
        int lastValidIndex;
        ObjectBidirectionalIterator iterator;
        if (this.firstInvalidIndex < 0) {
            return;
        }
        if (this.indexMap.isEmpty()) {
            Arrays.fill(this.listElements, 0, this.listSize, null);
            this.listSize = 0;
            this.firstInvalidIndex = -1;
            return;
        }
        Object[] backingArray = this.listElements;
        if (this.firstInvalidIndex == 0) {
            iterator = this.indexMap.reference2IntEntrySet().fastIterator();
            lastValidIndex = 0;
        } else {
            lastValidIndex = this.firstInvalidIndex;
            final E key = backingArray[lastValidIndex - 1];
            iterator = this.indexMap.reference2IntEntrySet().fastIterator(new Reference2IntMap.Entry<E>(){

                public int getIntValue() {
                    throw new UnsupportedOperationException();
                }

                public int setValue(int i2) {
                    throw new UnsupportedOperationException();
                }

                public E getKey() {
                    return key;
                }
            });
        }
        while (iterator.hasNext()) {
            Reference2IntMap.Entry entry = (Reference2IntMap.Entry)iterator.next();
            int newIndex = lastValidIndex++;
            backingArray[newIndex] = entry.getKey();
            entry.setValue(newIndex);
        }
        Arrays.fill(backingArray, lastValidIndex, this.listSize, null);
        this.listSize = lastValidIndex;
        this.firstInvalidIndex = -1;
    }

    public E rawGet(int index) {
        return this.listElements[index];
    }

    public int size() {
        return this.indexMap.size();
    }

    public Iterator<E> iterator() {
        return this.iterator(0);
    }

    public Iterator<E> iterator(int flags) {
        ++this.iteratorCount;
        return new BaseIterator(this, true, (flags & 1) != 0 ? Integer.MAX_VALUE : this.listSize);
    }

    public java.util.Iterator<E> unsafeIterator() {
        return this.unsafeIterator(0);
    }

    public java.util.Iterator<E> unsafeIterator(int flags) {
        return new BaseIterator(this, false, (flags & 1) != 0 ? Integer.MAX_VALUE : this.listSize);
    }

    public static interface Iterator<E>
    extends java.util.Iterator<E> {
        public void finishedIterating();
    }

    private static final class BaseIterator<E>
    implements Iterator<E> {
        private final IteratorSafeOrderedReferenceSet<E> set;
        private final boolean canFinish;
        private final int maxIndex;
        private int nextIndex;
        private E pendingValue;
        private boolean finished;
        private E lastReturned;

        private BaseIterator(IteratorSafeOrderedReferenceSet<E> set, boolean canFinish, int maxIndex) {
            this.set = set;
            this.canFinish = canFinish;
            this.maxIndex = maxIndex;
        }

        @Override
        public boolean hasNext() {
            int index;
            if (this.finished) {
                return false;
            }
            if (this.pendingValue != null) {
                return true;
            }
            E[] elements = this.set.listElements;
            int len = Math.min(this.maxIndex, this.set.listSize);
            for (index = this.nextIndex; index < len; ++index) {
                Object element = elements[index];
                if (element == null) continue;
                this.pendingValue = element;
                this.nextIndex = index + 1;
                return true;
            }
            this.nextIndex = index;
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E ret = this.pendingValue;
            this.pendingValue = null;
            this.lastReturned = ret;
            return ret;
        }

        @Override
        public void remove() {
            E lastReturned = this.lastReturned;
            if (lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.set.remove(lastReturned);
        }

        @Override
        public void finishedIterating() {
            if (this.finished || !this.canFinish) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.finished = true;
            this.set.finishRawIterator();
        }
    }
}

