/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, Priority.NORMAL);
    }

    public static void scheduleChunkTask(WorldServer level, int chunkX, int chunkZ, Runnable run, Priority priority) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(WorldServer level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<IChunkAccess> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(WorldServer level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, Priority priority, Consumer<Chunk> onComplete) {
        level.moonrise$getChunkTaskScheduler().scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<PlayerChunk> getVisibleChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static List<PlayerChunk> getUpdatingChunkHolders(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(WorldServer level) {
        return level.moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(WorldServer level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static boolean screenEntity(WorldServer level, Entity entity, boolean fromDisk, boolean event) {
        return PlatformHooks.get().screenEntity(level, entity, fromDisk, event);
    }

    public static void onChunkHolderCreate(WorldServer level, PlayerChunk holder) {
    }

    public static void onChunkHolderDelete(WorldServer level, PlayerChunk holder) {
        WorldLoadListener progressListener = level.m().a.E;
        if (progressListener != null) {
            ChunkSystem.scheduleChunkTask(level, holder.r().h, holder.r().i, () -> progressListener.a(holder.r(), null));
        }
    }

    public static void onChunkPreBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).m().moonrise$setFullChunk(chunk.f().h, chunk.f().i, chunk);
    }

    public static void onChunkBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getLoadedChunks().add(chunk.moonrise$getChunkAndHolder());
        chunk.loadCallback();
    }

    public static void onChunkNotBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getLoadedChunks().remove(chunk.moonrise$getChunkAndHolder());
        chunk.unloadCallback();
    }

    public static void onChunkPostNotBorder(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).m().moonrise$setFullChunk(chunk.f().h, chunk.f().i, null);
    }

    public static void onChunkTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getTickingChunks().add(chunk.moonrise$getChunkAndHolder());
        if (!chunk.moonrise$isPostProcessingDone()) {
            chunk.a((WorldServer)chunk.H());
        }
        ((WorldServer)chunk.H()).b(chunk);
        ((WorldServer)chunk.H()).m().a.H.incrementAndGet();
        ((WorldServer)chunk.H()).moonrise$markChunkForPlayerTicking(chunk);
    }

    public static void onChunkNotTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
        ((WorldServer)chunk.H()).moonrise$removeChunkForPlayerTicking(chunk);
    }

    public static void onChunkEntityTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getEntityTickingChunks().add(chunk.moonrise$getChunkAndHolder());
    }

    public static void onChunkNotEntityTicking(Chunk chunk, PlayerChunk holder) {
        ((WorldServer)chunk.H()).moonrise$getEntityTickingChunks().remove(chunk.moonrise$getChunkAndHolder());
    }

    public static PlayerChunk getUnloadingChunkHolder(WorldServer level, int chunkX, int chunkZ) {
        return null;
    }

    public static int getSendViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(player);
    }

    public static int getTickViewDistance(EntityPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    public static void addPlayerToDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().addPlayer(player);
    }

    public static void removePlayerFromDistanceMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().removePlayer(player);
    }

    public static void updateMaps(WorldServer world, EntityPlayer player) {
        world.moonrise$getPlayerChunkLoader().updatePlayer(player);
    }

    private ChunkSystem() {
    }
}

