/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public final class SimpleThreadUnsafeRandom
implements BitRandomSource {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final int BITS = 48;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long value;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public SimpleThreadUnsafeRandom(long seed) {
        this.b(seed);
    }

    @Override
    public void b(long seed) {
        this.value = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.gaussianSource.a();
    }

    private long advanceSeed() {
        this.value = this.value * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return this.value;
    }

    @Override
    public int c(int bits) {
        return (int)(this.advanceSeed() >>> 48 - bits);
    }

    @Override
    public int f() {
        long seed = this.advanceSeed();
        return (int)(seed >>> 16);
    }

    @Override
    public int a(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        long value = this.advanceSeed() >>> 16;
        return (int)(value * (long)bound >>> 32);
    }

    @Override
    public double k() {
        return this.gaussianSource.b();
    }

    @Override
    public RandomSource d() {
        return new SimpleThreadUnsafeRandom(this.g());
    }

    @Override
    public PositionalRandomFactory e() {
        return new SimpleRandomPositionalFactory(this.g());
    }

    public static final class SimpleRandomPositionalFactory
    implements PositionalRandomFactory {
        private final long seed;

        public SimpleRandomPositionalFactory(long seed) {
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }

        @Override
        public RandomSource a(String string) {
            return new SimpleThreadUnsafeRandom((long)string.hashCode() ^ this.seed);
        }

        @Override
        public RandomSource a(long seed) {
            return new SimpleThreadUnsafeRandom(seed);
        }

        @Override
        public RandomSource a(int x2, int y2, int z2) {
            return new SimpleThreadUnsafeRandom(MathHelper.b(x2, y2, z2) ^ this.seed);
        }

        @Override
        public void a(StringBuilder stringBuilder) {
            stringBuilder.append("SimpleRandomPositionalFactory{").append(this.seed).append('}');
        }
    }
}

