/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.io;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.completable.CallbackCompletable;
import ca.spottedleaf.concurrentutil.completable.Completable;
import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.queue.PrioritisedTaskQueue;
import ca.spottedleaf.concurrentutil.function.BiLong1Function;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoonriseRegionFileIO {
    private static final int REGION_FILE_SHIFT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoonriseRegionFileIO.class);
    private static final RegionFileType[] CACHED_REGIONFILE_TYPES = RegionFileType.values();

    public static RegionDataController getControllerFor(WorldServer world, RegionFileType type) {
        switch (type.ordinal()) {
            case 0: {
                return world.moonrise$getChunkDataController();
            }
            case 1: {
                return world.moonrise$getPoiChunkDataController();
            }
            case 2: {
                return world.moonrise$getEntityChunkDataController();
            }
        }
        throw new IllegalStateException("Unknown controller type " + String.valueOf((Object)type));
    }

    public static void flushRegionStorages(WorldServer world) throws IOException {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            MoonriseRegionFileIO.flushRegionStorages(world, type);
        }
    }

    public static void flushRegionStorages(WorldServer world, RegionFileType type) throws IOException {
        MoonriseRegionFileIO.getControllerFor(world, type).getCache().a();
    }

    public static void flush(MinecraftServer server) {
        for (WorldServer world : server.L()) {
            MoonriseRegionFileIO.flush(world);
        }
    }

    public static void flush(WorldServer world) {
        for (RegionFileType regionFileType : CACHED_REGIONFILE_TYPES) {
            MoonriseRegionFileIO.flush(world, regionFileType);
        }
    }

    public static void flush(WorldServer world, RegionFileType type) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        long failures = 1L;
        while (taskController.hasTasks()) {
            Thread.yield();
            failures = ConcurrentUtil.linearLongBackoff(failures, 125000L, 5000000L);
        }
    }

    public static void partialFlush(WorldServer world, int tasksRemaining) {
        long failures = 1L;
        while (true) {
            long totalTasks = 0L;
            for (RegionFileType regionFileType : CACHED_REGIONFILE_TYPES) {
                totalTasks += MoonriseRegionFileIO.getControllerFor(world, regionFileType).getTotalWorkingTasks();
            }
            if (totalTasks <= (long)tasksRemaining) break;
            Thread.yield();
            failures = ConcurrentUtil.linearLongBackoff(failures, 125000L, 5000000L);
        }
    }

    public static Priority getIOBlockingPriorityForCurrentThread() {
        if (TickThread.isTickThread()) {
            return Priority.BLOCKING;
        }
        return Priority.HIGHEST;
    }

    public static Priority getPriority(WorldServer world, int chunkX, int chunkZ, RegionFileType type) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        ChunkIOTask task = taskController.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task == null) {
            return Priority.COMPLETING;
        }
        return task.getPriority();
    }

    public static void setPriority(WorldServer world, int chunkX, int chunkZ, Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            MoonriseRegionFileIO.setPriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void setPriority(WorldServer world, int chunkX, int chunkZ, RegionFileType type, Priority priority) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        ChunkIOTask task = taskController.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.setPriority(priority);
        }
    }

    public static void raisePriority(WorldServer world, int chunkX, int chunkZ, Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            MoonriseRegionFileIO.raisePriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void raisePriority(WorldServer world, int chunkX, int chunkZ, RegionFileType type, Priority priority) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        ChunkIOTask task = taskController.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.raisePriority(priority);
        }
    }

    public static void lowerPriority(WorldServer world, int chunkX, int chunkZ, Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            MoonriseRegionFileIO.lowerPriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void lowerPriority(WorldServer world, int chunkX, int chunkZ, RegionFileType type, Priority priority) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        ChunkIOTask task = taskController.chunkTasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.lowerPriority(priority);
        }
    }

    public static void scheduleSave(WorldServer world, int chunkX, int chunkZ, NBTTagCompound data, RegionFileType type) {
        MoonriseRegionFileIO.scheduleSave(world, chunkX, chunkZ, data, type, Priority.NORMAL);
    }

    public static void scheduleSave(WorldServer world, int chunkX, int chunkZ, NBTTagCompound data, RegionFileType type, Priority priority) {
        MoonriseRegionFileIO.scheduleSave(world, chunkX, chunkZ, (BiConsumer<NBTTagCompound, Throwable> consumer) -> consumer.accept(data, null), null, type, priority);
    }

    public static void scheduleSave(WorldServer world, int chunkX, int chunkZ, CallbackCompletable<NBTTagCompound> completable, PrioritisedExecutor.PrioritisedTask writeTask, RegionFileType type, Priority priority) {
        MoonriseRegionFileIO.scheduleSave(world, chunkX, chunkZ, completable::addWaiter, writeTask, type, priority);
    }

    public static void scheduleSave(WorldServer world, int chunkX, int chunkZ, Completable<NBTTagCompound> completable, PrioritisedExecutor.PrioritisedTask writeTask, RegionFileType type, Priority priority) {
        MoonriseRegionFileIO.scheduleSave(world, chunkX, chunkZ, completable::whenComplete, writeTask, type, priority);
    }

    private static void scheduleSave(WorldServer world, int chunkX, int chunkZ, Consumer<BiConsumer<NBTTagCompound, Throwable>> scheduler, PrioritisedExecutor.PrioritisedTask writeTask, RegionFileType type, Priority priority) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        boolean[] created = new boolean[1];
        ChunkIOTask.InProgressWrite write = new ChunkIOTask.InProgressWrite(writeTask);
        ChunkIOTask task = taskController.chunkTasks.compute(CoordinateUtils.getChunkKey(chunkX, chunkZ), (keyInMap, taskRunning) -> {
            if (taskRunning == null || taskRunning.failedWrite) {
                ChunkIOTask newTask = new ChunkIOTask(world, taskController, chunkX, chunkZ, priority, new ChunkIOTask.InProgressRead());
                newTask.pushPendingWrite(write);
                created[0] = true;
                return newTask;
            }
            taskRunning.pushPendingWrite(write);
            return taskRunning;
        });
        write.schedule(task, scheduler);
        if (created[0]) {
            taskController.startTask(task);
            task.scheduleWriteCompress();
        } else {
            task.raisePriority(priority);
        }
    }

    public static Cancellable loadAllChunkData(WorldServer world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock) {
        return MoonriseRegionFileIO.loadAllChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, Priority.NORMAL);
    }

    public static Cancellable loadAllChunkData(WorldServer world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, Priority priority) {
        return MoonriseRegionFileIO.loadChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, priority, CACHED_REGIONFILE_TYPES);
    }

    public static Cancellable loadChunkData(WorldServer world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, RegionFileType ... types) {
        return MoonriseRegionFileIO.loadChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, Priority.NORMAL, types);
    }

    public static Cancellable loadChunkData(WorldServer world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, Priority priority, RegionFileType ... types) {
        if (types == null) {
            throw new NullPointerException("Types cannot be null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Types cannot be empty");
        }
        RegionFileData ret = new RegionFileData();
        Cancellable[] reads = new CancellableRead[types.length];
        AtomicInteger completions = new AtomicInteger();
        int expectedCompletions = types.length;
        for (int i2 = 0; i2 < expectedCompletions; ++i2) {
            RegionFileType type = types[i2];
            reads[i2] = MoonriseRegionFileIO.loadDataAsync(world, chunkX, chunkZ, type, (data, throwable) -> {
                if (throwable != null) {
                    ret.setThrowable(type, (Throwable)throwable);
                } else {
                    ret.setData(type, (NBTTagCompound)data);
                }
                if (completions.incrementAndGet() == expectedCompletions) {
                    onComplete.accept(ret);
                }
            }, intendingToBlock, priority);
        }
        return new CancellableReads(reads);
    }

    public static Cancellable loadDataAsync(WorldServer world, int chunkX, int chunkZ, RegionFileType type, BiConsumer<NBTTagCompound, Throwable> onComplete, boolean intendingToBlock) {
        return MoonriseRegionFileIO.loadDataAsync(world, chunkX, chunkZ, type, onComplete, intendingToBlock, Priority.NORMAL);
    }

    public static Cancellable loadDataAsync(WorldServer world, int chunkX, int chunkZ, RegionFileType type, BiConsumer<NBTTagCompound, Throwable> onComplete, boolean intendingToBlock, Priority priority) {
        RegionDataController taskController = MoonriseRegionFileIO.getControllerFor(world, type);
        ImmediateCallbackCompletion callbackInfo = new ImmediateCallbackCompletion();
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        BiLong1Function<ChunkIOTask, ChunkIOTask> compute = (keyInMap, running) -> {
            if (running == null) {
                ChunkIOTask newTask = new ChunkIOTask(world, taskController, chunkX, chunkZ, priority, new ChunkIOTask.InProgressRead());
                newTask.inProgressRead.addToAsyncWaiters(onComplete);
                callbackInfo.tasksNeedReadScheduling = true;
                return newTask;
            }
            ChunkIOTask.InProgressWrite pendingWrite = running.inProgressWrite;
            if (pendingWrite == null) {
                if (!running.inProgressRead.addToAsyncWaiters(onComplete)) {
                    callbackInfo.data = running.inProgressRead.value;
                    callbackInfo.throwable = running.inProgressRead.throwable;
                    callbackInfo.completeNow = true;
                    return running;
                }
                callbackInfo.read = running.inProgressRead;
                return running;
            }
            if (!pendingWrite.addToAsyncWaiters(onComplete)) {
                callbackInfo.data = pendingWrite.value;
                callbackInfo.throwable = pendingWrite.throwable;
                callbackInfo.completeNow = true;
                return running;
            }
            callbackInfo.write = pendingWrite;
            return running;
        };
        ChunkIOTask ret = taskController.chunkTasks.compute(key, compute);
        if (callbackInfo.tasksNeedReadScheduling) {
            taskController.startTask(ret);
            ret.scheduleReadIO();
        } else if (callbackInfo.completeNow) {
            try {
                onComplete.accept(callbackInfo.data == null ? null : callbackInfo.data.i(), callbackInfo.throwable);
            }
            catch (Throwable thr) {
                LOGGER.error("Callback " + ConcurrentUtil.genericToString(onComplete) + " synchronously failed to handle chunk data for task " + ret.toString(), thr);
            }
        } else {
            ret.raisePriority(priority);
        }
        return new CancellableRead(onComplete, callbackInfo.read, callbackInfo.write);
    }

    public static NBTTagCompound loadData(WorldServer world, int chunkX, int chunkZ, RegionFileType type, Priority priority) throws IOException {
        CompletableFuture ret = new CompletableFuture();
        MoonriseRegionFileIO.loadDataAsync(world, chunkX, chunkZ, type, (compound, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(compound);
            }
        }, true, priority);
        try {
            return (NBTTagCompound)ret.join();
        }
        catch (CompletionException ex) {
            throw new IOException(ex);
        }
    }

    public static enum RegionFileType {
        CHUNK_DATA,
        POI_DATA,
        ENTITY_DATA;

    }

    public static abstract class RegionDataController {
        public final RegionFileType type;
        private final PrioritisedExecutor compressionExecutor;
        private final IOScheduler ioScheduler;
        private final ConcurrentLong2ReferenceChainedHashTable<ChunkIOTask> chunkTasks = new ConcurrentLong2ReferenceChainedHashTable();
        private final AtomicLong inProgressTasks = new AtomicLong();

        public RegionDataController(RegionFileType type, PrioritisedExecutor ioExecutor, PrioritisedExecutor compressionExecutor) {
            this.type = type;
            this.compressionExecutor = compressionExecutor;
            this.ioScheduler = new IOScheduler(ioExecutor);
        }

        final void startTask(ChunkIOTask task) {
            this.inProgressTasks.getAndIncrement();
        }

        final void endTask(ChunkIOTask task) {
            this.inProgressTasks.getAndDecrement();
        }

        public boolean hasTasks() {
            return this.inProgressTasks.get() != 0L;
        }

        public long getTotalWorkingTasks() {
            return this.inProgressTasks.get();
        }

        public abstract RegionFileCache getCache();

        public abstract WriteData startWrite(int var1, int var2, NBTTagCompound var3) throws IOException;

        public abstract void finishWrite(int var1, int var2, WriteData var3) throws IOException;

        public abstract ReadData readData(int var1, int var2) throws IOException;

        public abstract NBTTagCompound finishRead(int var1, int var2, ReadData var3) throws IOException;

        public static interface IORunnable {
            public void run(RegionFile var1) throws IOException;
        }

        public record ReadData(ReadResult result, DataInputStream input, NBTTagCompound syncRead) {

            public static enum ReadResult {
                NO_DATA,
                HAS_DATA,
                SYNC_READ;

            }
        }

        public record WriteData(NBTTagCompound input, WriteResult result, DataOutputStream output, IORunnable write) {

            public static enum WriteResult {
                WRITE,
                DELETE;

            }
        }
    }

    private static final class ChunkIOTask {
        private final WorldServer world;
        private final RegionDataController regionDataController;
        private final int chunkX;
        private final int chunkZ;
        private Priority priority;
        private PrioritisedExecutor.PrioritisedTask currentTask;
        private final InProgressRead inProgressRead;
        private volatile InProgressWrite inProgressWrite;
        private final ReferenceOpenHashSet<InProgressWrite> allPendingWrites = new ReferenceOpenHashSet();
        private RegionDataController.ReadData readData;
        private RegionDataController.WriteData writeData;
        private boolean failedWrite;

        public ChunkIOTask(WorldServer world, RegionDataController regionDataController, int chunkX, int chunkZ, Priority priority, InProgressRead inProgressRead) {
            this.world = world;
            this.regionDataController = regionDataController;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.priority = priority;
            this.inProgressRead = inProgressRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Priority getPriority() {
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                return this.priority;
            }
        }

        private void updatePriority(Priority priority) {
            this.priority = priority;
            if (this.currentTask != null) {
                this.currentTask.setPriority(priority);
            }
            for (InProgressWrite write : this.allPendingWrites) {
                if (write.writeTask == null) continue;
                write.writeTask.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setPriority(Priority priority) {
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                if (this.priority == priority) {
                    return false;
                }
                this.updatePriority(priority);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean raisePriority(Priority priority) {
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                if (this.priority.isHigherOrEqualPriority(priority)) {
                    return false;
                }
                this.updatePriority(priority);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lowerPriority(Priority priority) {
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                if (this.priority.isLowerOrEqualPriority(priority)) {
                    return false;
                }
                this.updatePriority(priority);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pushPendingWrite(InProgressWrite write) {
            this.inProgressWrite = write;
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.allPendingWrites.add((Object)write);
                if (write.writeTask != null) {
                    write.writeTask.setPriority(this.priority);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pendingWriteComplete(InProgressWrite write) {
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.allPendingWrites.remove((Object)write);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleReadIO() {
            PrioritisedExecutor.PrioritisedTask task;
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.currentTask = task = this.regionDataController.ioScheduler.createTask(this.chunkX, this.chunkZ, this::performReadIO, this.priority);
            }
            task.queue();
        }

        private void performReadIO() {
            ChunkIOTask inMap;
            InProgressRead read = this.inProgressRead;
            long chunkKey = CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ);
            boolean[] canRead = new boolean[]{true};
            if (read.hasNoWaiters() && (inMap = this.regionDataController.chunkTasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                }
                if (valueInMap != this) {
                    throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                }
                if (!read.hasNoWaiters()) {
                    return valueInMap;
                }
                canRead[0] = false;
                if (valueInMap.inProgressWrite != null) {
                    return valueInMap;
                }
                return null;
            })) == null) {
                this.regionDataController.endTask(this);
                return;
            }
            if (canRead[0]) {
                RegionDataController.ReadData readData = null;
                Throwable throwable = null;
                try {
                    readData = this.regionDataController.readData(this.chunkX, this.chunkZ);
                }
                catch (Throwable thr) {
                    throwable = thr;
                    LOGGER.error("Failed to read chunk data for task: " + this.toString(), thr);
                }
                if (throwable != null) {
                    this.finishRead(null, throwable);
                } else {
                    switch (readData.result().ordinal()) {
                        case 0: 
                        case 2: {
                            this.finishRead(readData.syncRead(), null);
                            break;
                        }
                        case 1: {
                            this.readData = readData;
                            this.scheduleReadDecompress();
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + String.valueOf((Object)readData.result()));
                        }
                    }
                }
            }
            if (!this.tryAbortWrite()) {
                this.scheduleWriteCompress();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleReadDecompress() {
            PrioritisedExecutor.PrioritisedTask task;
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.currentTask = task = this.regionDataController.compressionExecutor.createTask(this::performReadDecompress, this.priority);
            }
            task.queue();
        }

        private void performReadDecompress() {
            RegionDataController.ReadData readData = this.readData;
            this.readData = null;
            NBTTagCompound compoundTag = null;
            Throwable throwable = null;
            try {
                compoundTag = this.regionDataController.finishRead(this.chunkX, this.chunkZ, readData);
            }
            catch (Throwable thr) {
                throwable = thr;
                LOGGER.error("Failed to decompress chunk data for task: " + this.toString(), thr);
            }
            if (compoundTag == null) {
                this.scheduleReadIO();
                return;
            }
            this.finishRead(compoundTag, throwable);
            if (!this.tryAbortWrite()) {
                this.scheduleWriteCompress();
            }
        }

        private void finishRead(NBTTagCompound compoundTag, Throwable throwable) {
            this.inProgressRead.complete(this, compoundTag, throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleWriteCompress() {
            PrioritisedExecutor.PrioritisedTask task;
            InProgressWrite inProgressWrite = this.inProgressWrite;
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.currentTask = task = this.regionDataController.compressionExecutor.createTask(() -> this.performWriteCompress(inProgressWrite), this.priority);
            }
            inProgressWrite.addToWaiters(this, (data, throwable) -> task.queue());
        }

        private boolean tryAbortWrite() {
            ChunkIOTask inMap;
            long chunkKey = CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ);
            if (this.inProgressWrite == null && (inMap = this.regionDataController.chunkTasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                }
                if (valueInMap != this) {
                    throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                }
                if (valueInMap.inProgressWrite != null) {
                    return valueInMap;
                }
                return null;
            })) == null) {
                this.regionDataController.endTask(this);
                return true;
            }
            return false;
        }

        private void performWriteCompress(InProgressWrite inProgressWrite) {
            NBTTagCompound write = inProgressWrite.value;
            if (!inProgressWrite.isComplete()) {
                throw new IllegalStateException("Should be writable");
            }
            RegionDataController.WriteData writeData = null;
            boolean failedWrite = false;
            try {
                writeData = this.regionDataController.startWrite(this.chunkX, this.chunkZ, write);
            }
            catch (Throwable thr) {
                failedWrite = thr instanceof IOException;
                LOGGER.error("Failed to write chunk data for task: " + this.toString(), thr);
            }
            if (writeData == null) {
                if (this.tryCompleteWrite(inProgressWrite, failedWrite)) {
                    return;
                }
                this.scheduleWriteCompress();
                return;
            }
            this.writeData = writeData;
            this.scheduleWriteIO(inProgressWrite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleWriteIO(InProgressWrite inProgressWrite) {
            PrioritisedExecutor.PrioritisedTask task;
            ChunkIOTask chunkIOTask = this;
            synchronized (chunkIOTask) {
                this.currentTask = task = this.regionDataController.ioScheduler.createTask(this.chunkX, this.chunkZ, () -> this.runWriteIO(inProgressWrite), this.priority);
            }
            task.queue();
        }

        private void runWriteIO(InProgressWrite inProgressWrite) {
            RegionDataController.WriteData writeData = this.writeData;
            this.writeData = null;
            boolean failedWrite = false;
            try {
                this.regionDataController.finishWrite(this.chunkX, this.chunkZ, writeData);
            }
            catch (Throwable thr) {
                failedWrite = thr instanceof IOException;
                LOGGER.error("Failed to write chunk data for task: " + this.toString(), thr);
            }
            if (!this.tryCompleteWrite(inProgressWrite, failedWrite)) {
                this.scheduleWriteCompress();
            }
        }

        private boolean tryCompleteWrite(InProgressWrite written, boolean failedWrite) {
            long chunkKey = CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ);
            boolean[] done = new boolean[]{false};
            this.regionDataController.chunkTasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                }
                if (valueInMap != this) {
                    throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                }
                if (valueInMap.inProgressWrite == written) {
                    valueInMap.failedWrite = failedWrite;
                    done[0] = true;
                    return failedWrite ? valueInMap : null;
                }
                return valueInMap;
            });
            if (done[0]) {
                this.regionDataController.endTask(this);
                return true;
            }
            return false;
        }

        public String toString() {
            return "Task for world: '" + WorldUtil.getWorldName(this.world) + "' at (" + this.chunkX + "," + this.chunkZ + ") type: " + this.regionDataController.type.name() + ", hash: " + this.hashCode();
        }

        private static final class InProgressRead {
            private static final Logger LOGGER = LoggerFactory.getLogger(InProgressRead.class);
            private NBTTagCompound value;
            private Throwable throwable;
            private final MultiThreadedQueue<BiConsumer<NBTTagCompound, Throwable>> callbacks = new MultiThreadedQueue();

            private InProgressRead() {
            }

            public boolean hasNoWaiters() {
                return this.callbacks.isEmpty();
            }

            public boolean addToAsyncWaiters(BiConsumer<NBTTagCompound, Throwable> callback) {
                return this.callbacks.add(callback);
            }

            public boolean cancel(BiConsumer<NBTTagCompound, Throwable> callback) {
                return this.callbacks.remove(callback);
            }

            public void complete(ChunkIOTask task, NBTTagCompound value, Throwable throwable) {
                BiConsumer<NBTTagCompound, Throwable> consumer;
                this.value = value;
                this.throwable = throwable;
                while ((consumer = this.callbacks.pollOrBlockAdds()) != null) {
                    try {
                        consumer.accept(value == null ? null : value.i(), throwable);
                    }
                    catch (Throwable thr) {
                        LOGGER.error("Callback " + ConcurrentUtil.genericToString(consumer) + " failed to handle chunk data (read) for task " + task.toString(), thr);
                    }
                }
            }
        }

        private static final class InProgressWrite {
            private static final Logger LOGGER = LoggerFactory.getLogger(InProgressWrite.class);
            private NBTTagCompound value;
            private Throwable throwable;
            private volatile boolean complete;
            private final MultiThreadedQueue<BiConsumer<NBTTagCompound, Throwable>> callbacks = new MultiThreadedQueue();
            private final PrioritisedExecutor.PrioritisedTask writeTask;

            public InProgressWrite(PrioritisedExecutor.PrioritisedTask writeTask) {
                this.writeTask = writeTask;
            }

            public boolean isComplete() {
                return this.complete;
            }

            public void schedule(ChunkIOTask task, Consumer<BiConsumer<NBTTagCompound, Throwable>> scheduler) {
                scheduler.accept((data, throwable) -> this.complete(task, (NBTTagCompound)data, (Throwable)throwable));
            }

            public boolean addToAsyncWaiters(BiConsumer<NBTTagCompound, Throwable> callback) {
                return this.callbacks.add(callback);
            }

            public void addToWaiters(ChunkIOTask task, BiConsumer<NBTTagCompound, Throwable> consumer) {
                if (!this.callbacks.add(consumer)) {
                    this.syncAccept(task, consumer, this.value, this.throwable);
                }
            }

            private void syncAccept(ChunkIOTask task, BiConsumer<NBTTagCompound, Throwable> consumer, NBTTagCompound value, Throwable throwable) {
                try {
                    consumer.accept(value == null ? null : value.i(), throwable);
                }
                catch (Throwable thr) {
                    LOGGER.error("Callback " + ConcurrentUtil.genericToString(consumer) + " failed to handle chunk data (write) for task " + task.toString(), thr);
                }
            }

            public void complete(ChunkIOTask task, NBTTagCompound value, Throwable throwable) {
                BiConsumer<NBTTagCompound, Throwable> consumer;
                this.value = value;
                this.throwable = throwable;
                this.complete = true;
                task.pendingWriteComplete(this);
                while ((consumer = this.callbacks.pollOrBlockAdds()) != null) {
                    this.syncAccept(task, consumer, value, throwable);
                }
            }

            public boolean cancel(BiConsumer<NBTTagCompound, Throwable> callback) {
                return this.callbacks.remove(callback);
            }
        }
    }

    public static final class RegionFileData {
        private final boolean[] hasResult = new boolean[CACHED_REGIONFILE_TYPES.length];
        private final NBTTagCompound[] data = new NBTTagCompound[CACHED_REGIONFILE_TYPES.length];
        private final Throwable[] throwables = new Throwable[CACHED_REGIONFILE_TYPES.length];

        public void setData(RegionFileType type, NBTTagCompound data) {
            int index = type.ordinal();
            if (this.hasResult[index]) {
                throw new IllegalArgumentException("Result already exists for type " + String.valueOf((Object)type));
            }
            this.hasResult[index] = true;
            this.data[index] = data;
        }

        public void setThrowable(RegionFileType type, Throwable throwable) {
            int index = type.ordinal();
            if (this.hasResult[index]) {
                throw new IllegalArgumentException("Result already exists for type " + String.valueOf((Object)type));
            }
            this.hasResult[index] = true;
            this.throwables[index] = throwable;
        }

        public boolean hasResult(RegionFileType type) {
            return this.hasResult[type.ordinal()];
        }

        public NBTTagCompound getData(RegionFileType type) {
            int index = type.ordinal();
            if (!this.hasResult[index]) {
                throw new IllegalArgumentException("Result does not exist for type " + String.valueOf((Object)type));
            }
            return this.data[index];
        }

        public Throwable getThrowable(RegionFileType type) {
            int index = type.ordinal();
            if (!this.hasResult[index]) {
                throw new IllegalArgumentException("Result does not exist for type " + String.valueOf((Object)type));
            }
            return this.throwables[index];
        }
    }

    private static final class CancellableRead
    implements Cancellable {
        private BiConsumer<NBTTagCompound, Throwable> callback;
        private ChunkIOTask.InProgressRead read;
        private ChunkIOTask.InProgressWrite write;

        private CancellableRead(BiConsumer<NBTTagCompound, Throwable> callback, ChunkIOTask.InProgressRead read, ChunkIOTask.InProgressWrite write) {
            this.callback = callback;
            this.read = read;
            this.write = write;
        }

        @Override
        public boolean cancel() {
            BiConsumer<NBTTagCompound, Throwable> callback = this.callback;
            ChunkIOTask.InProgressRead read = this.read;
            ChunkIOTask.InProgressWrite write = this.write;
            if (callback == null || read == null && write == null) {
                return false;
            }
            this.callback = null;
            this.read = null;
            this.write = null;
            if (read != null) {
                return read.cancel(callback);
            }
            if (write != null) {
                return write.cancel(callback);
            }
            throw new InternalError();
        }
    }

    private static final class CancellableReads
    implements Cancellable {
        private Cancellable[] reads;
        private static final VarHandle READS_HANDLE = ConcurrentUtil.getVarHandle(CancellableReads.class, "reads", Cancellable[].class);

        private CancellableReads(Cancellable[] reads) {
            this.reads = reads;
        }

        @Override
        public boolean cancel() {
            Cancellable[] reads = READS_HANDLE.getAndSet(this, null);
            if (reads == null) {
                return false;
            }
            boolean ret = false;
            for (Cancellable read : reads) {
                ret |= read.cancel();
            }
            return ret;
        }
    }

    private static final class ImmediateCallbackCompletion {
        private NBTTagCompound data;
        private Throwable throwable;
        private boolean completeNow;
        private boolean tasksNeedReadScheduling;
        private ChunkIOTask.InProgressRead read;
        private ChunkIOTask.InProgressWrite write;

        private ImmediateCallbackCompletion() {
        }
    }

    private static final class RegionIOTasks
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(RegionIOTasks.class);
        private final PrioritisedTaskQueue queue = new PrioritisedTaskQueue();
        private final long regionKey;
        private final IOScheduler ioScheduler;
        private long createdTasks;
        private long executedTasks;
        private PrioritisedExecutor.PrioritisedTask task;

        public RegionIOTasks(long regionKey, IOScheduler ioScheduler) {
            this.regionKey = regionKey;
            this.ioScheduler = ioScheduler;
        }

        public PrioritisedExecutor.PrioritisedTask createTask(Runnable run, Priority priority, long subOrder) {
            ++this.createdTasks;
            return new WrappedTask(this.queue.createTask(run, priority, subOrder));
        }

        private void adjustTaskPriority() {
            PrioritisedTaskQueue.PrioritySubOrderPair priority = this.queue.getHighestPrioritySubOrder();
            if (this.task == null) {
                if (priority == null) {
                    return;
                }
                this.task = this.ioScheduler.executor.createTask(this, priority.priority(), priority.subOrder());
                this.task.queue();
            } else {
                if (priority == null) {
                    throw new IllegalStateException();
                }
                this.task.setPriorityAndSubOrder(priority.priority(), priority.subOrder());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable run;
            RegionIOTasks regionIOTasks = this;
            synchronized (regionIOTasks) {
                run = this.queue.pollTask();
            }
            try {
                run.run();
            }
            finally {
                regionIOTasks = this;
                synchronized (regionIOTasks) {
                    this.task = null;
                    this.adjustTaskPriority();
                }
                this.ioScheduler.regionTasks.compute(this.regionKey, (keyInMap, tasks) -> {
                    if (tasks != this) {
                        throw new IllegalStateException("Region task mismatch");
                    }
                    ++tasks.executedTasks;
                    if (tasks.createdTasks != tasks.executedTasks) {
                        return tasks;
                    }
                    if (tasks.task != null) {
                        throw new IllegalStateException("Task may not be null when created==executed");
                    }
                    return null;
                });
            }
        }

        private final class WrappedTask
        implements PrioritisedExecutor.PrioritisedTask {
            private final PrioritisedExecutor.PrioritisedTask wrapped;

            public WrappedTask(PrioritisedExecutor.PrioritisedTask wrap) {
                this.wrapped = wrap;
            }

            @Override
            public PrioritisedExecutor getExecutor() {
                return RegionIOTasks.this.ioScheduler.executor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean queue() {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.queue()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public boolean isQueued() {
                return this.wrapped.isQueued();
            }

            @Override
            public boolean cancel() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean execute() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Priority getPriority() {
                return this.wrapped.getPriority();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPriority(Priority priority) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.setPriority(priority) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean raisePriority(Priority priority) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.raisePriority(priority) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean lowerPriority(Priority priority) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.lowerPriority(priority) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public long getSubOrder() {
                return this.wrapped.getSubOrder();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSubOrder(long subOrder) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.setSubOrder(subOrder) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean raiseSubOrder(long subOrder) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.raiseSubOrder(subOrder) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean lowerSubOrder(long subOrder) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.lowerSubOrder(subOrder) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setPriorityAndSubOrder(Priority priority, long subOrder) {
                RegionIOTasks regionIOTasks = RegionIOTasks.this;
                synchronized (regionIOTasks) {
                    if (this.wrapped.setPriorityAndSubOrder(priority, subOrder) && this.wrapped.isQueued()) {
                        RegionIOTasks.this.adjustTaskPriority();
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    private static final class IOScheduler {
        private final ConcurrentLong2ReferenceChainedHashTable<RegionIOTasks> regionTasks = new ConcurrentLong2ReferenceChainedHashTable();
        private final PrioritisedExecutor executor;

        public IOScheduler(PrioritisedExecutor executor) {
            this.executor = executor;
        }

        public PrioritisedExecutor.PrioritisedTask createTask(int chunkX, int chunkZ, Runnable run, Priority priority) {
            PrioritisedExecutor.PrioritisedTask[] ret = new PrioritisedExecutor.PrioritisedTask[1];
            long subOrder = this.executor.generateNextSubOrder();
            this.regionTasks.compute(CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5), (regionKey, existing) -> {
                RegionIOTasks res = existing != null ? existing : new RegionIOTasks(regionKey, this);
                ret[0] = res.createTask(run, priority, subOrder);
                return res;
            });
            return ret[0];
        }
    }
}

