/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.command.PaperSubcommand;
import io.papermc.paper.util.MCUtil;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class FixLightCommand
implements PaperSubcommand {
    private static final ThreadLocal<DecimalFormat> ONE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.0"));

    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.doFixLight(sender, args);
        return true;
    }

    private void doFixLight(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text((String)"Only players can use this command", (TextColor)NamedTextColor.RED));
            return;
        }
        @Nullable Runnable post = null;
        int radius = 2;
        if (args.length > 0) {
            try {
                int parsed = Integer.parseInt(args[0]);
                if (parsed < 0) {
                    sender.sendMessage((Component)Component.text((String)"Radius cannot be negative!", (TextColor)NamedTextColor.RED));
                    return;
                }
                int maxRadius = 32;
                radius = Math.min(32, parsed);
                if (radius != parsed) {
                    post = () -> sender.sendMessage((Component)Component.text((String)("Radius '" + parsed + "' was not in the required range [0, 32], it was lowered to the maximum (32 chunks)."), (TextColor)NamedTextColor.RED));
                }
            }
            catch (Exception e2) {
                sender.sendMessage((Component)Component.text((String)("'" + args[0] + "' is not a valid number."), (TextColor)NamedTextColor.RED));
                return;
            }
        }
        CraftPlayer player = (CraftPlayer)sender;
        EntityPlayer handle = player.getHandle();
        WorldServer world = (WorldServer)handle.dW();
        LightEngineThreaded lightengine = world.m().a();
        this.starlightFixLight(handle, world, lightengine, radius, post);
    }

    private void starlightFixLight(EntityPlayer sender, WorldServer world, LightEngineThreaded lightengine, int radius, @Nullable Runnable done) {
        long start = System.nanoTime();
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(MCUtil.getSpiralOutChunks(sender.dw(), radius));
        int[] pending = new int[1];
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkPos2 = (ChunkCoordIntPair)iterator.next();
            @Nullable IChunkAccess chunk = (IChunkAccess)world.m().c(chunkPos2.h, chunkPos2.i);
            if (chunk == null || !chunk.x() || !chunk.n().a(ChunkStatus.l)) {
                iterator.remove();
                continue;
            }
            pending[0] = pending[0] + 1;
        }
        int[] relitChunks = new int[1];
        lightengine.starlight$serverRelightChunks(chunks, chunkPos -> {
            relitChunks[0] = relitChunks[0] + 1;
            sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Relit chunk ", (TextColor)NamedTextColor.BLUE), Component.text((String)chunkPos.toString()), Component.text((String)", progress: ", (TextColor)NamedTextColor.BLUE), Component.text((String)(ONE_DECIMAL_PLACES.get().format(100.0 * (double)relitChunks[0] / (double)pending[0]) + "%"))}));
        }, totalRelit -> {
            long end = System.nanoTime();
            sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(new Component[]{Component.text((String)"Relit ", (TextColor)NamedTextColor.BLUE), Component.text((int)totalRelit), Component.text((String)" chunks. Took ", (TextColor)NamedTextColor.BLUE), Component.text((String)(ONE_DECIMAL_PLACES.get().format(1.0E-6 * (double)(end - start)) + "ms"))}));
            if (done != null) {
                done.run();
            }
        });
        sender.getBukkitEntity().sendMessage((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.BLUE)).append(new Component[]{Component.text((String)"Relighting "), Component.text((int)pending[0], (TextColor)NamedTextColor.DARK_AQUA), Component.text((String)" chunks")}));
    }
}

