/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class Duration {
    private static final Pattern SPACE = Pattern.compile(" ");
    private static final Pattern NOT_NUMERIC = Pattern.compile("[^-\\d.]");
    public static final ScalarSerializer<Duration> SERIALIZER = new Serializer();
    private final long seconds;
    private final String value;

    private Duration(String value) {
        this.value = value;
        this.seconds = Duration.getSeconds(value);
    }

    public long seconds() {
        return this.seconds;
    }

    public long ticks() {
        return this.seconds * 20L;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Duration duration = (Duration)o2;
        return this.seconds == duration.seconds && this.value.equals(duration.value);
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.value);
    }

    public String toString() {
        return "Duration{seconds=" + this.seconds + ", value='" + this.value + "'}";
    }

    public static Duration of(String time) {
        return new Duration(time);
    }

    private static int getSeconds(String str) {
        double num;
        str = SPACE.matcher(str).replaceAll("");
        char unit = str.charAt(str.length() - 1);
        str = NOT_NUMERIC.matcher(str).replaceAll("");
        try {
            num = Double.parseDouble(str);
        }
        catch (Exception e2) {
            num = 0.0;
        }
        switch (unit) {
            case 'd': {
                num *= 86400.0;
                break;
            }
            case 'h': {
                num *= 3600.0;
                break;
            }
            case 'm': {
                num *= 60.0;
                break;
            }
        }
        return (int)num;
    }

    static final class Serializer
    extends ScalarSerializer<Duration> {
        private Serializer() {
            super(Duration.class);
        }

        public Duration deserialize(Type type, Object obj) throws SerializationException {
            return new Duration(obj.toString());
        }

        protected Object serialize(Duration item, Predicate<Class<?>> typeSupported) {
            return item.value();
        }
    }
}

