/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentAdapter;
import io.papermc.paper.datacomponent.item.PaperBannerPatternLayers;
import io.papermc.paper.datacomponent.item.PaperBlockItemDataProperties;
import io.papermc.paper.datacomponent.item.PaperBundleContents;
import io.papermc.paper.datacomponent.item.PaperChargedProjectiles;
import io.papermc.paper.datacomponent.item.PaperConsumable;
import io.papermc.paper.datacomponent.item.PaperCustomModelData;
import io.papermc.paper.datacomponent.item.PaperDamageResistant;
import io.papermc.paper.datacomponent.item.PaperDeathProtection;
import io.papermc.paper.datacomponent.item.PaperDyedItemColor;
import io.papermc.paper.datacomponent.item.PaperEnchantable;
import io.papermc.paper.datacomponent.item.PaperEquippable;
import io.papermc.paper.datacomponent.item.PaperFireworks;
import io.papermc.paper.datacomponent.item.PaperFoodProperties;
import io.papermc.paper.datacomponent.item.PaperItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.PaperItemArmorTrim;
import io.papermc.paper.datacomponent.item.PaperItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.PaperItemContainerContents;
import io.papermc.paper.datacomponent.item.PaperItemEnchantments;
import io.papermc.paper.datacomponent.item.PaperItemLore;
import io.papermc.paper.datacomponent.item.PaperItemTool;
import io.papermc.paper.datacomponent.item.PaperJukeboxPlayable;
import io.papermc.paper.datacomponent.item.PaperLodestoneTracker;
import io.papermc.paper.datacomponent.item.PaperMapDecorations;
import io.papermc.paper.datacomponent.item.PaperMapId;
import io.papermc.paper.datacomponent.item.PaperMapItemColor;
import io.papermc.paper.datacomponent.item.PaperOminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PaperPotDecorations;
import io.papermc.paper.datacomponent.item.PaperPotionContents;
import io.papermc.paper.datacomponent.item.PaperRepairable;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.PaperSeededContainerLoot;
import io.papermc.paper.datacomponent.item.PaperSuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.PaperUnbreakable;
import io.papermc.paper.datacomponent.item.PaperUseCooldown;
import io.papermc.paper.datacomponent.item.PaperUseRemainder;
import io.papermc.paper.datacomponent.item.PaperWritableBookContent;
import io.papermc.paper.datacomponent.item.PaperWrittenBookContent;
import io.papermc.paper.item.MapPostProcessing;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R2.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.bukkit.inventory.ItemRarity;

public final class DataComponentAdapters {
    static final Function<Unit, Void> UNIT_TO_API_CONVERTER = $ -> {
        throw new UnsupportedOperationException("Cannot convert the Unit type to an API value");
    };
    static final Map<ResourceKey<DataComponentType<?>>, DataComponentAdapter<?, ?>> ADAPTERS = new HashMap();

    public static void bootstrap() {
        DataComponentAdapters.registerIdentity(DataComponents.c);
        DataComponentAdapters.registerIdentity(DataComponents.d);
        DataComponentAdapters.registerIdentity(DataComponents.e);
        DataComponentAdapters.register(DataComponents.f, PaperUnbreakable::new);
        DataComponentAdapters.register(DataComponents.g, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.h, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.i, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.j, PaperItemLore::new);
        DataComponentAdapters.register(DataComponents.k, nms -> ItemRarity.valueOf((String)nms.name()), api -> EnumItemRarity.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.l, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.m, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.n, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.o, PaperItemAttributeModifiers::new);
        DataComponentAdapters.register(DataComponents.p, PaperCustomModelData::new);
        DataComponentAdapters.registerUntyped(DataComponents.q);
        DataComponentAdapters.registerUntyped(DataComponents.r);
        DataComponentAdapters.registerIdentity(DataComponents.s);
        DataComponentAdapters.registerIdentity(DataComponents.u);
        DataComponentAdapters.registerUntyped(DataComponents.v);
        DataComponentAdapters.register(DataComponents.w, PaperFoodProperties::new);
        DataComponentAdapters.register(DataComponents.x, PaperConsumable::new);
        DataComponentAdapters.register(DataComponents.y, PaperUseRemainder::new);
        DataComponentAdapters.register(DataComponents.z, PaperUseCooldown::new);
        DataComponentAdapters.register(DataComponents.A, PaperDamageResistant::new);
        DataComponentAdapters.register(DataComponents.B, PaperItemTool::new);
        DataComponentAdapters.register(DataComponents.C, PaperEnchantable::new);
        DataComponentAdapters.register(DataComponents.D, PaperEquippable::new);
        DataComponentAdapters.register(DataComponents.E, PaperRepairable::new);
        DataComponentAdapters.registerUntyped(DataComponents.F);
        DataComponentAdapters.register(DataComponents.G, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.H, PaperDeathProtection::new);
        DataComponentAdapters.register(DataComponents.I, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.J, PaperDyedItemColor::new);
        DataComponentAdapters.register(DataComponents.K, PaperMapItemColor::new);
        DataComponentAdapters.register(DataComponents.L, PaperMapId::new);
        DataComponentAdapters.register(DataComponents.M, PaperMapDecorations::new);
        DataComponentAdapters.register(DataComponents.N, nms -> MapPostProcessing.valueOf((String)nms.name()), api -> net.minecraft.world.item.component.MapPostProcessing.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.O, PaperChargedProjectiles::new);
        DataComponentAdapters.register(DataComponents.P, PaperBundleContents::new);
        DataComponentAdapters.register(DataComponents.Q, PaperPotionContents::new);
        DataComponentAdapters.register(DataComponents.R, PaperSuspiciousStewEffects::new);
        DataComponentAdapters.register(DataComponents.T, PaperWrittenBookContent::new);
        DataComponentAdapters.register(DataComponents.S, PaperWritableBookContent::new);
        DataComponentAdapters.register(DataComponents.U, PaperItemArmorTrim::new);
        DataComponentAdapters.register(DataComponents.Z, CraftMusicInstrument::minecraftHolderToBukkit, CraftMusicInstrument::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aa, PaperOminousBottleAmplifier::new);
        DataComponentAdapters.register(DataComponents.ab, PaperJukeboxPlayable::new);
        DataComponentAdapters.register(DataComponents.ac, nms -> MCUtil.transformUnmodifiable(nms, PaperAdventure::asAdventureKey), api -> MCUtil.transformUnmodifiable(api, key -> PaperAdventure.asVanilla(Registries.bk, key)));
        DataComponentAdapters.register(DataComponents.ad, PaperLodestoneTracker::new);
        DataComponentAdapters.register(DataComponents.ae, CraftMetaFirework::getEffect, CraftMetaFirework::getExplosion);
        DataComponentAdapters.register(DataComponents.af, PaperFireworks::new);
        DataComponentAdapters.register(DataComponents.ag, PaperResolvableProfile::new);
        DataComponentAdapters.register(DataComponents.ah, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.ai, PaperBannerPatternLayers::new);
        DataComponentAdapters.register(DataComponents.aj, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.ak, PaperPotDecorations::new);
        DataComponentAdapters.register(DataComponents.al, PaperItemContainerContents::new);
        DataComponentAdapters.register(DataComponents.am, PaperBlockItemDataProperties::new);
        DataComponentAdapters.register(DataComponents.ap, PaperSeededContainerLoot::new);
        for (Map.Entry<ResourceKey<DataComponentType<?>>, DataComponentType<?>> componentType : BuiltInRegistries.ao.k()) {
            if (ADAPTERS.containsKey(componentType.getKey())) continue;
            DataComponentAdapters.registerUntyped(componentType.getValue());
        }
    }

    public static void registerUntyped(DataComponentType<Unit> type) {
        DataComponentAdapters.registerInternal(type, UNIT_TO_API_CONVERTER, DataComponentAdapter.API_TO_UNIT_CONVERTER, false);
    }

    private static <COMMON> void registerIdentity(DataComponentType<COMMON> type) {
        DataComponentAdapters.registerInternal(type, Function.identity(), Function.identity(), true);
    }

    private static <NMS, API extends Handleable<NMS>> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi) {
        DataComponentAdapters.registerInternal(type, vanillaToApi, Handleable::getHandle, false);
    }

    private static <NMS, API> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla) {
        DataComponentAdapters.registerInternal(type, vanillaToApi, apiToVanilla, false);
    }

    private static <NMS, API> void registerInternal(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla, boolean codecValidation) {
        ResourceKey<DataComponentType<NMS>> key = BuiltInRegistries.ao.d(type).orElseThrow();
        if (ADAPTERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate adapter registration for " + String.valueOf(key));
        }
        ADAPTERS.put(key, new DataComponentAdapter<NMS, API>(type, apiToVanilla, vanillaToApi, codecValidation && !type.d()));
    }
}

