/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.MCUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperBannerPatternLayers(net.minecraft.world.level.block.entity.BannerPatternLayers impl) implements BannerPatternLayers,
Handleable<net.minecraft.world.level.block.entity.BannerPatternLayers>
{
    private static List<Pattern> convert(net.minecraft.world.level.block.entity.BannerPatternLayers nmsPatterns) {
        return MCUtil.transformUnmodifiable(nmsPatterns.b(), input -> {
            Optional type = CraftRegistry.unwrapAndConvertHolder(RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN), input.b());
            return new Pattern(Objects.requireNonNull(DyeColor.getByWoolData((byte)((byte)input.c().a()))), (PatternType)type.orElseThrow(() -> new IllegalStateException("Inlined banner patterns are not supported yet in the API!")));
        });
    }

    @Override
    public net.minecraft.world.level.block.entity.BannerPatternLayers getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<Pattern> patterns() {
        return PaperBannerPatternLayers.convert(this.impl);
    }

    static final class BuilderImpl
    implements BannerPatternLayers.Builder {
        private final BannerPatternLayers.a builder = new BannerPatternLayers.a();

        BuilderImpl() {
        }

        public BannerPatternLayers.Builder add(Pattern pattern) {
            this.builder.a(CraftPatternType.bukkitToMinecraftHolder(pattern.getPattern()), EnumColor.a(pattern.getColor().getWoolData()));
            return this;
        }

        public BannerPatternLayers.Builder addAll(List<Pattern> patterns) {
            patterns.forEach(this::add);
            return this;
        }

        public BannerPatternLayers build() {
            return new PaperBannerPatternLayers(this.builder.a());
        }
    }
}

