/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemContainerContents;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.Handleable;
import org.bukkit.inventory.ItemStack;

public record PaperItemContainerContents(net.minecraft.world.item.component.ItemContainerContents impl) implements ItemContainerContents,
Handleable<net.minecraft.world.item.component.ItemContainerContents>
{
    @Override
    public net.minecraft.world.item.component.ItemContainerContents getHandle() {
        return this.impl;
    }

    public List<ItemStack> contents() {
        return MCUtil.transformUnmodifiable(this.impl.f, CraftItemStack::asBukkitCopy);
    }

    static final class BuilderImpl
    implements ItemContainerContents.Builder {
        private final List<net.minecraft.world.item.ItemStack> items = new ObjectArrayList();

        BuilderImpl() {
        }

        public ItemContainerContents.Builder add(ItemStack stack) {
            Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"Item cannot be null");
            Preconditions.checkArgument((this.items.size() + 1 <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s items, had %s", (int)256, (int)(this.items.size() + 1));
            this.items.add(CraftItemStack.asNMSCopy(stack));
            return this;
        }

        public ItemContainerContents.Builder addAll(List<ItemStack> stacks) {
            Preconditions.checkArgument((this.items.size() + stacks.size() <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s items, had %s", (int)256, (int)(this.items.size() + stacks.size()));
            MCUtil.addAndConvert(this.items, stacks, stack -> {
                Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"Cannot pass null itemstacks!");
                return CraftItemStack.asNMSCopy(stack);
            });
            return this;
        }

        public ItemContainerContents build() {
            if (this.items.isEmpty()) {
                return new PaperItemContainerContents(net.minecraft.world.item.component.ItemContainerContents.a);
            }
            return new PaperItemContainerContents(net.minecraft.world.item.component.ItemContainerContents.a(this.items));
        }
    }
}

