/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.DatapackSource;
import io.papermc.paper.datapack.DatapackSourceImpl;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import org.bukkit.FeatureFlag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperDatapack
implements Datapack {
    private static final Map<PackSource, DatapackSource> PACK_SOURCES = new ConcurrentHashMap<PackSource, DatapackSource>();
    private final ResourcePackLoader pack;
    private final boolean enabled;

    PaperDatapack(ResourcePackLoader pack, boolean enabled) {
        this.pack = pack;
        this.enabled = enabled;
    }

    public String getName() {
        return this.pack.g();
    }

    public Component getTitle() {
        return PaperAdventure.asAdventure(this.pack.b());
    }

    public Component getDescription() {
        return PaperAdventure.asAdventure(this.pack.c());
    }

    public boolean isRequired() {
        return this.pack.i();
    }

    public Datapack.Compatibility getCompatibility() {
        return Datapack.Compatibility.valueOf((String)this.pack.d().name());
    }

    public Set<FeatureFlag> getRequiredFeatures() {
        return PaperFeatureFlagProviderImpl.fromNms(this.pack.e());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        MinecraftServer server = MinecraftServer.getServer();
        ArrayList<ResourcePackLoader> enabledPacks = new ArrayList<ResourcePackLoader>(server.aF().g());
        @Nullable ResourcePackLoader packToChange = server.aF().c(this.getName());
        if (packToChange == null) {
            throw new IllegalStateException("Cannot toggle state of pack that doesn't exist: " + this.getName());
        }
        if (enabled == enabledPacks.contains(packToChange)) {
            return;
        }
        if (enabled) {
            packToChange.k().a(enabledPacks, packToChange, ResourcePackLoader::h, false);
        } else {
            enabledPacks.remove(packToChange);
        }
        server.reloadResources(enabledPacks.stream().map(ResourcePackLoader::g).toList(), ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public DatapackSource getSource() {
        return PACK_SOURCES.computeIfAbsent(this.pack.a().c(), source -> new DatapackSourceImpl(source.toString()));
    }

    public Component computeDisplayName() {
        return PaperAdventure.asAdventure(this.pack.a(this.enabled));
    }

    static {
        PACK_SOURCES.put(PackSource.b, DatapackSource.DEFAULT);
        PACK_SOURCES.put(PackSource.c, DatapackSource.BUILT_IN);
        PACK_SOURCES.put(PackSource.d, DatapackSource.FEATURE);
        PACK_SOURCES.put(PackSource.e, DatapackSource.WORLD);
        PACK_SOURCES.put(PackSource.f, DatapackSource.SERVER);
    }
}

