/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.type.spigot;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.configuration.LoadOrderConfiguration;
import io.papermc.paper.plugin.provider.type.spigot.SpigotPluginProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class SpigotLoadOrderConfiguration
implements LoadOrderConfiguration {
    private final PluginDescriptionFile meta;
    private final List<String> loadBefore;
    private final List<String> loadAfter;

    public SpigotLoadOrderConfiguration(SpigotPluginProvider spigotPluginProvider, Map<String, PluginProvider<?>> toLoad) {
        this.meta = spigotPluginProvider.getMeta();
        this.loadBefore = this.meta.getLoadBeforePlugins();
        this.loadAfter = new ArrayList<String>();
        this.loadAfter.addAll(this.meta.getDepend());
        this.loadAfter.addAll(this.meta.getSoftDepend());
        for (String loadBefore : this.loadBefore) {
            this.loadAfter.remove(loadBefore);
        }
        Iterator<String> iterators = this.loadAfter.iterator();
        while (iterators.hasNext()) {
            String loadAfter = iterators.next();
            PluginProvider<?> provider = toLoad.get(loadAfter);
            if (provider == null) continue;
            PluginMeta configuration = provider.getMeta();
            HashSet dependencies = new HashSet();
            dependencies.addAll(configuration.getPluginDependencies());
            dependencies.addAll(configuration.getPluginSoftDependencies());
            if (!configuration.getName().equals(this.meta.getName()) && !dependencies.contains(this.meta.getName())) continue;
            iterators.remove();
        }
    }

    @Override
    @NotNull
    public List<String> getLoadBefore() {
        return this.loadBefore;
    }

    @Override
    @NotNull
    public List<String> getLoadAfter() {
        return this.loadAfter;
    }

    @Override
    @NotNull
    public PluginMeta getMeta() {
        return this.meta;
    }
}

