/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryBuilder;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.WritableCraftRegistry;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryInfo;
import io.papermc.paper.registry.event.RegistryEntryAddEventImpl;
import io.papermc.paper.registry.event.RegistryEventMap;
import io.papermc.paper.registry.event.RegistryEventProvider;
import io.papermc.paper.registry.event.RegistryFreezeEvent;
import io.papermc.paper.registry.event.RegistryFreezeEventImpl;
import io.papermc.paper.registry.event.type.RegistryEntryAddEventType;
import io.papermc.paper.registry.event.type.RegistryEntryAddEventTypeImpl;
import io.papermc.paper.registry.event.type.RegistryLifecycleEventType;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.jspecify.annotations.Nullable;

public class PaperRegistryListenerManager {
    public static final PaperRegistryListenerManager INSTANCE = new PaperRegistryListenerManager();
    public final RegistryEventMap valueAddEventTypes = new RegistryEventMap("value add");
    public final RegistryEventMap freezeEventTypes = new RegistryEventMap("freeze");

    private PaperRegistryListenerManager() {
    }

    public <M> M registerWithListeners(IRegistry<M> registry, String id, M nms) {
        return this.registerWithListeners(registry, MinecraftKey.b(id), nms);
    }

    public <M> M registerWithListeners(IRegistry<M> registry, MinecraftKey loc, M nms) {
        return this.registerWithListeners(registry, ResourceKey.a(registry.g(), loc), nms);
    }

    public <M> M registerWithListeners(IRegistry<M> registry, ResourceKey<M> key, M nms) {
        return (M)this.registerWithListeners(registry, key, nms, RegistrationInfo.a, PaperRegistryListenerManager::registerWithInstance, BuiltInRegistries.BUILT_IN_CONVERSIONS);
    }

    public <M> Holder.c<M> registerForHolderWithListeners(IRegistry<M> registry, MinecraftKey loc, M nms) {
        return this.registerForHolderWithListeners(registry, ResourceKey.a(registry.g(), loc), nms);
    }

    public <M> Holder.c<M> registerForHolderWithListeners(IRegistry<M> registry, ResourceKey<M> key, M nms) {
        return this.registerWithListeners(registry, key, nms, RegistrationInfo.a, IRegistryWritable::a, BuiltInRegistries.BUILT_IN_CONVERSIONS);
    }

    public <M> void registerWithListeners(IRegistry<M> registry, ResourceKey<M> key, M nms, RegistrationInfo registrationInfo, Conversions conversions) {
        this.registerWithListeners(registry, key, nms, registrationInfo, IRegistryWritable::a, conversions);
    }

    public <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>, R> R registerWithListeners(IRegistry<M> registry, ResourceKey<M> key, M nms, RegistrationInfo registrationInfo, RegisterMethod<M, R> registerMethod, Conversions conversions) {
        Preconditions.checkState((boolean)LaunchEntryPointHandler.INSTANCE.hasEntered(Entrypoint.BOOTSTRAPPER), (Object)(String.valueOf(registry.g()) + " tried to run modification listeners before bootstrappers have been called"));
        RegistryEntry entry = PaperRegistries.getEntry(registry.g());
        if (!RegistryEntry.Modifiable.isModifiable(entry) || !this.valueAddEventTypes.hasHandlers(entry.apiKey())) {
            return registerMethod.register((IRegistryWritable)registry, key, nms, registrationInfo);
        }
        RegistryEntry.Modifiable modifiableEntry = RegistryEntry.Modifiable.asModifiable(entry);
        TypedKey typedKey = TypedKey.create(entry.apiKey(), (Key)Key.key((String)key.a().b(), (String)key.a().a()));
        Object builder = modifiableEntry.fillBuilder(conversions, typedKey, nms);
        return this.registerWithListeners(registry, modifiableEntry, key, nms, builder, registrationInfo, registerMethod, conversions);
    }

    <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> void registerWithListeners(IRegistryWritable<M> registry, RegistryEntryInfo<M, T> entry, ResourceKey<M> key, B builder, RegistrationInfo registrationInfo, Conversions conversions) {
        if (!RegistryEntry.Modifiable.isModifiable(entry) || !this.valueAddEventTypes.hasHandlers(entry.apiKey())) {
            registry.a(key, builder.build(), registrationInfo);
            return;
        }
        this.registerWithListeners(registry, RegistryEntry.Modifiable.asModifiable(entry), key, null, builder, registrationInfo, IRegistryWritable::a, conversions);
    }

    public <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>, R> R registerWithListeners(IRegistry<M> registry, RegistryEntry.Modifiable<M, T, B> entry, ResourceKey<M> key, @Nullable M oldNms, B builder, RegistrationInfo registrationInfo, RegisterMethod<M, R> registerMethod, Conversions conversions) {
        MinecraftKey beingAdded = key.a();
        TypedKey typedKey = TypedKey.create(entry.apiKey(), (Key)Key.key((String)beingAdded.b(), (String)beingAdded.a()));
        RegistryEntryAddEventImpl<T, B> event = entry.createEntryAddEvent(typedKey, builder, conversions);
        LifecycleEventRunner.INSTANCE.callEvent(this.valueAddEventTypes.getEventType(entry.apiKey()), event);
        if (oldNms != null) {
            ((RegistryMaterials)registry).clearIntrusiveHolder(oldNms);
        }
        Object newNms = ((PaperRegistryBuilder)event.builder()).build();
        if (oldNms != null && !newNms.equals(oldNms)) {
            registrationInfo = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
        }
        return registerMethod.register((IRegistryWritable)registry, key, newNms, registrationInfo);
    }

    private static <M> M registerWithInstance(IRegistryWritable<M> writableRegistry, ResourceKey<M> key, M value, RegistrationInfo registrationInfo) {
        writableRegistry.a(key, value, registrationInfo);
        return value;
    }

    public <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> void runFreezeListeners(ResourceKey<? extends IRegistry<M>> resourceKey, Conversions conversions) {
        RegistryEntry entry = PaperRegistries.getEntry(resourceKey);
        if (!RegistryEntry.Addable.isAddable(entry) || !this.freezeEventTypes.hasHandlers(entry.apiKey())) {
            return;
        }
        RegistryEntry.Addable writableEntry = RegistryEntry.Addable.asAddable(entry);
        WritableCraftRegistry writableRegistry = PaperRegistryAccess.instance().getWritableRegistry(entry.apiKey());
        RegistryFreezeEventImpl event = writableEntry.createFreezeEvent(writableRegistry, conversions);
        LifecycleEventRunner.INSTANCE.callEvent(this.freezeEventTypes.getEventType(entry.apiKey()), event);
    }

    public <T, B extends RegistryBuilder<T>> RegistryEntryAddEventType<T, B> getRegistryValueAddEventType(RegistryEventProvider<T, B> type) {
        if (!RegistryEntry.Modifiable.isModifiable(PaperRegistries.getEntry(type.registryKey()))) {
            throw new IllegalArgumentException(String.valueOf(type.registryKey()) + " does not support RegistryEntryAddEvent");
        }
        return this.valueAddEventTypes.getOrCreate(type.registryKey(), RegistryEntryAddEventTypeImpl::new);
    }

    public <T, B extends RegistryBuilder<T>> LifecycleEventType.Prioritizable<BootstrapContext, RegistryFreezeEvent<T, B>> getRegistryFreezeEventType(RegistryEventProvider<T, B> type) {
        if (!RegistryEntry.Addable.isAddable(PaperRegistries.getEntry(type.registryKey()))) {
            throw new IllegalArgumentException(String.valueOf(type.registryKey()) + " does not support RegistryFreezeEvent");
        }
        return this.freezeEventTypes.getOrCreate(type.registryKey(), RegistryLifecycleEventType::new);
    }

    @FunctionalInterface
    public static interface RegisterMethod<M, R> {
        public R register(IRegistryWritable<M> var1, ResourceKey<M> var2, M var3, RegistrationInfo var4);
    }
}

