/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.GameEventRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.OptionalInt;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public class PaperGameEventRegistryEntry
implements GameEventRegistryEntry {
    protected OptionalInt range = OptionalInt.empty();

    public PaperGameEventRegistryEntry(Conversions ignoredConversions, TypedKey<org.bukkit.GameEvent> ignoredKey, @Nullable GameEvent internal) {
        if (internal == null) {
            return;
        }
        this.range = OptionalInt.of(internal.a());
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int range() {
        return Checks.asConfigured(this.range, "range");
    }

    public static final class PaperBuilder
    extends PaperGameEventRegistryEntry
    implements GameEventRegistryEntry.Builder,
    PaperRegistryBuilder<GameEvent, org.bukkit.GameEvent> {
        public PaperBuilder(Conversions conversions, TypedKey<org.bukkit.GameEvent> key, @Nullable GameEvent internal) {
            super(conversions, key, internal);
        }

        public GameEventRegistryEntry.Builder range(@Range(from=0L, to=0x7FFFFFFFL) int range) {
            this.range = OptionalInt.of(Checks.asArgumentMin(range, "range", 0));
            return this;
        }

        @Override
        public GameEvent build() {
            return new GameEvent(this.range());
        }
    }
}

