/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.legacy;

import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DelayedRegistry<T extends Keyed, R extends Registry<T>>
implements Registry<T> {
    private @Nullable Supplier<? extends R> delegate;

    public void load(Supplier<? extends R> registry) {
        if (this.delegate != null) {
            throw new IllegalStateException("Registry already loaded!");
        }
        this.delegate = registry;
    }

    public Registry<T> delegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("You are trying to access this registry too early!");
        }
        return (Registry)this.delegate.get();
    }

    public @Nullable T get(NamespacedKey key) {
        return (T)this.delegate().get(key);
    }

    public T getOrThrow(NamespacedKey key) {
        return (T)this.delegate().getOrThrow(key);
    }

    public Iterator<T> iterator() {
        return this.delegate().iterator();
    }

    public Stream<T> stream() {
        return this.delegate().stream();
    }

    public @Nullable NamespacedKey getKey(T value) {
        return this.delegate().getKey(value);
    }

    public boolean hasTag(TagKey<T> key) {
        return this.delegate().hasTag(key);
    }

    public @NonNull Tag<T> getTag(TagKey<T> key) {
        return this.delegate().getTag(key);
    }
}

