/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.util.ServerWorkerThread;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.TracingExecutor;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.slf4j.Logger;

public class SystemUtils {
    static final Logger g = LogUtils.getLogger();
    private static final int h = 255;
    private static final int i = 10;
    private static final String j = "max.bg.threads";
    private static final TracingExecutor k = SystemUtils.makeExecutor("Main", -1);
    private static final TracingExecutor l = SystemUtils.a("IO-Worker-", false);
    public static final TracingExecutor DIMENSION_DATA_IO_POOL = SystemUtils.makeExtraIoExecutor("Dimension-Data-IO-Worker-");
    private static final TracingExecutor m = SystemUtils.a("Download-", true);
    public static final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable run) {
            Thread ret = new Thread(run);
            ret.setName("Profile Lookup Executor #" + this.count.getAndIncrement());
            ret.setUncaughtExceptionHandler((thread, throwable) -> g.error("Uncaught exception in thread " + thread.getName(), throwable));
            return ret;
        }
    });
    private static final DateTimeFormatter n = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int a = 8;
    private static final Set<String> o = Set.of("http", "https");
    public static final long b = 1000000L;
    public static TimeSource.a c = System::nanoTime;
    public static final Ticker d = new BooleanSupplier(){
        final /* synthetic */ Path val$path;
        {
            this.val$path = path;
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Files.deleteIfExists(this.val$path);
                return true;
            }
            catch (IOException var2) {
                g.warn("Failed to delete", (Throwable)var2);
                return false;
            }
        }

        public String toString() {
            return "delete old " + String.valueOf(this.val$path);
        }
    };
    public static final UUID e = new UUID(0L, 0L);
    public static final FileSystemProvider f = FileSystemProvider.installedProviders().stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    public static final double COLLISION_EPSILON = 1.0E-7;
    private static Consumer<String> p = message -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> b() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String a(IBlockState<T> property, Object value) {
        return property.b((Comparable)value);
    }

    public static String a(String type, @Nullable MinecraftKey id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.b() + "." + id.a().replace('/', '.');
    }

    public static long c() {
        return SystemUtils.d() / 1000000L;
    }

    public static long d() {
        return System.nanoTime();
    }

    public static long e() {
        return Instant.now().toEpochMilli();
    }

    public static String f() {
        return n.format(ZonedDateTime.now());
    }

    private static TracingExecutor makeExecutor(String s2, int priorityModifier) {
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        int i2 = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : (cpus <= 8 ? Math.max(3, cpus - 2) : cpus * 2 / 3);
        i2 = Math.min(8, i2);
        i2 = Integer.getInteger("Paper.WorkerThreadCount", i2);
        Object executorService = i2 <= 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(i2, target -> new ServerWorkerThread(target, s2, priorityModifier));
        return new TracingExecutor((ExecutorService)executorService);
    }

    private static int p() {
        String string = System.getProperty(j);
        if (string != null) {
            try {
                int i2 = Integer.parseInt(string);
                if (i2 >= 1 && i2 <= 255) {
                    return i2;
                }
                g.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{j, string, 255});
            }
            catch (NumberFormatException var2) {
                g.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{j, string, 255});
            }
        }
        return 255;
    }

    public static TracingExecutor g() {
        return k;
    }

    public static TracingExecutor h() {
        return l;
    }

    public static TracingExecutor i() {
        return m;
    }

    public static void j() {
        k.a(3L, TimeUnit.SECONDS);
        l.a(3L, TimeUnit.SECONDS);
    }

    private static TracingExecutor a(String namePrefix, boolean daemon) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(daemon);
            thread.setUncaughtExceptionHandler(SystemUtils::a);
            return thread;
        }));
    }

    private static TracingExecutor makeExtraIoExecutor(String namePrefix) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(false);
            thread.setUncaughtExceptionHandler(SystemUtils::a);
            return thread;
        }));
    }

    public static void a(Throwable t2) {
        throw t2 instanceof RuntimeException ? (RuntimeException)t2 : new RuntimeException(t2);
    }

    public static void a(Thread thread, Throwable t2) {
        SystemUtils.b(t2);
        if (t2 instanceof CompletionException) {
            t2 = t2.getCause();
        }
        if (t2 instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)t2;
            DispenserRegistry.a(reportedException.a().a(ReportType.a));
            System.exit(-1);
        }
        g.error(String.format(Locale.ROOT, "Caught exception in thread %s", thread), t2);
    }

    @Nullable
    public static Type<?> a(DSL.TypeReference typeReference, String id) {
        return !SharedConstants.aT ? null : SystemUtils.b(typeReference, id);
    }

    @Nullable
    private static Type<?> b(DSL.TypeReference typeReference, String id) {
        Type type;
        block2: {
            type = null;
            try {
                type = DataConverterRegistry.a().getSchema(DataFixUtils.makeKey((int)SharedConstants.b().d().c())).getChoiceType(typeReference, id);
            }
            catch (IllegalArgumentException var4) {
                g.error("No data fixer registered for {}", (Object)id);
                if (!SharedConstants.aU) break block2;
                throw var4;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(Runnable runnable, String name) {
        block16: {
            if (SharedConstants.aU) {
                Thread thread = Thread.currentThread();
                String string = thread.getName();
                thread.setName(name);
                try (Zone zone = TracyClient.beginZone((String)name, (boolean)SharedConstants.aU);){
                    runnable.run();
                    break block16;
                }
                finally {
                    thread.setName(string);
                }
            }
            try (Zone zone2 = TracyClient.beginZone((String)name, (boolean)SharedConstants.aU);){
                runnable.run();
            }
        }
    }

    public static <T> String a(IRegistry<T> registry, T value) {
        MinecraftKey resourceLocation = registry.b(value);
        return resourceLocation == null ? "[unregistered]" : resourceLocation.toString();
    }

    public static <T> Predicate<T> k() {
        return o2 -> true;
    }

    public static <T> Predicate<T> a(Predicate<? super T> a2) {
        return a2;
    }

    public static <T> Predicate<T> a(Predicate<? super T> a2, Predicate<? super T> b2) {
        return o2 -> a2.test(o2) && b2.test(o2);
    }

    public static <T> Predicate<T> a(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2) {
        return o2 -> a2.test(o2) && b2.test(o2) && c2.test(o2);
    }

    public static <T> Predicate<T> a(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2, Predicate<? super T> d2) {
        return o2 -> a2.test(o2) && b2.test(o2) && c2.test(o2) && d2.test(o2);
    }

    public static <T> Predicate<T> a(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2, Predicate<? super T> d2, Predicate<? super T> e2) {
        return o2 -> a2.test(o2) && b2.test(o2) && c2.test(o2) && d2.test(o2) && e2.test(o2);
    }

    @SafeVarargs
    public static <T> Predicate<T> a(Predicate<? super T> ... predicates) {
        return o2 -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(o2)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> a(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> SystemUtils.k();
            case 1 -> SystemUtils.a(predicates.get(0));
            case 2 -> SystemUtils.a(predicates.get(0), predicates.get(1));
            case 3 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates2 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield SystemUtils.a(predicates2);
            }
        };
    }

    public static <T> Predicate<T> l() {
        return o2 -> false;
    }

    public static <T> Predicate<T> b(Predicate<? super T> a2) {
        return a2;
    }

    public static <T> Predicate<T> b(Predicate<? super T> a2, Predicate<? super T> b2) {
        return o2 -> a2.test(o2) || b2.test(o2);
    }

    public static <T> Predicate<T> b(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2) {
        return o2 -> a2.test(o2) || b2.test(o2) || c2.test(o2);
    }

    public static <T> Predicate<T> b(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2, Predicate<? super T> d2) {
        return o2 -> a2.test(o2) || b2.test(o2) || c2.test(o2) || d2.test(o2);
    }

    public static <T> Predicate<T> b(Predicate<? super T> a2, Predicate<? super T> b2, Predicate<? super T> c2, Predicate<? super T> d2, Predicate<? super T> e2) {
        return o2 -> a2.test(o2) || b2.test(o2) || c2.test(o2) || d2.test(o2) || e2.test(o2);
    }

    @SafeVarargs
    public static <T> Predicate<T> b(Predicate<? super T> ... predicates) {
        return o2 -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(o2)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> b(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> SystemUtils.l();
            case 1 -> SystemUtils.b(predicates.get(0));
            case 2 -> SystemUtils.b(predicates.get(0), predicates.get(1));
            case 3 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates2 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield SystemUtils.b(predicates2);
            }
        };
    }

    public static <T> boolean a(int width, int height, List<T> list) {
        if (width == 1) {
            return true;
        }
        int i2 = width / 2;
        for (int j2 = 0; j2 < height; ++j2) {
            for (int k2 = 0; k2 < i2; ++k2) {
                T object2;
                int l2 = width - 1 - k2;
                T object = list.get(k2 + j2 * width);
                if (object.equals(object2 = list.get(l2 + j2 * width))) continue;
                return false;
            }
        }
        return true;
    }

    public static OS m() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.c;
        }
        if (string.contains("mac")) {
            return OS.d;
        }
        if (string.contains("solaris")) {
            return OS.b;
        }
        if (string.contains("sunos")) {
            return OS.b;
        }
        if (string.contains("linux")) {
            return OS.a;
        }
        return string.contains("unix") ? OS.a : OS.e;
    }

    public static URI a(String uri) throws URISyntaxException {
        URI uRI = new URI(uri);
        String string = uRI.getScheme();
        if (string == null) {
            throw new URISyntaxException(uri, "Missing protocol in URI: " + uri);
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        if (!o.contains(string2)) {
            throw new URISyntaxException(uri, "Unsupported protocol in URI: " + uri);
        }
        return uRI;
    }

    public static Stream<String> n() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(runtimeArg -> runtimeArg.startsWith("-X"));
    }

    public static <T> T c(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T a(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = iterator.next();
        if (object != null) {
            T object3 = object2;
            while (object3 != object) {
                if (!iterator.hasNext()) continue;
                object3 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return object2;
    }

    public static <T> T b(Iterable<T> iterable, @Nullable T object) {
        Iterator<T> iterator = iterable.iterator();
        T object2 = null;
        while (iterator.hasNext()) {
            T object3 = iterator.next();
            if (object3 == object) {
                if (object2 != null) break;
                object2 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : object);
                break;
            }
            object2 = object3;
        }
        return object2;
    }

    public static <T> T a(Supplier<T> factory) {
        return factory.get();
    }

    public static <T> T a(T object, Consumer<? super T> initializer) {
        initializer.accept(object);
        return object;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> a(Class<K> enumClass, Function<K, V> mapper) {
        EnumMap<Enum, V> enumMap = new EnumMap<Enum, V>(enumClass);
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            enumMap.put(enum_, mapper.apply(enum_));
        }
        return enumMap;
    }

    public static <V> CompletableFuture<List<V>> d(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(void_ -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> e(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(futures, completableFuture::completeExceptionally).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    public static <V> CompletableFuture<List<V>> f(List<? extends CompletableFuture<? extends V>> futures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(futures, (Throwable throwable) -> {
            if (completableFuture.completeExceptionally((Throwable)throwable)) {
                for (CompletableFuture completableFuture2 : futures) {
                    completableFuture2.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)completableFuture, Function.identity());
    }

    private static <V> CompletableFuture<List<V>> a(List<? extends CompletableFuture<? extends V>> futures, Consumer<Throwable> exceptionHandler) {
        ArrayList list = Lists.newArrayListWithCapacity((int)futures.size());
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        futures.forEach(future -> {
            int i2 = list.size();
            list.add(null);
            completableFutures[i2] = future.whenComplete((value, throwable) -> {
                if (throwable != null) {
                    exceptionHandler.accept((Throwable)throwable);
                } else {
                    list.set(i2, value);
                }
            });
        });
        return CompletableFuture.allOf(completableFutures).thenApply(void_ -> list);
    }

    public static <T> Optional<T> a(Optional<T> optional, Consumer<T> presentAction, Runnable elseAction) {
        if (optional.isPresent()) {
            presentAction.accept(optional.get());
        } else {
            elseAction.run();
        }
        return optional;
    }

    public static <T> Supplier<T> a(Supplier<T> supplier, Supplier<String> messageSupplier) {
        return supplier;
    }

    public static Runnable a(Runnable runnable, Supplier<String> messageSupplier) {
        return runnable;
    }

    public static void b(String message) {
        g.error(message);
        if (SharedConstants.aU) {
            SystemUtils.d(message);
        }
    }

    public static void a(String message, Throwable throwable) {
        g.error(message, throwable);
        if (SharedConstants.aU) {
            SystemUtils.d(message);
        }
    }

    public static <T extends Throwable> T b(T t2) {
        if (SharedConstants.aU) {
            g.error("Trying to throw a fatal exception, pausing in IDE", t2);
            SystemUtils.d(t2.getMessage());
        }
        return t2;
    }

    public static void a(Consumer<String> missingBreakpointHandler) {
        p = missingBreakpointHandler;
    }

    private static void d(String message) {
        boolean bl;
        Instant instant = Instant.now();
        g.warn("Did you remember to set a breakpoint here?");
        boolean bl2 = bl = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!bl) {
            p.accept(message);
        }
    }

    public static String c(Throwable t2) {
        if (t2.getCause() != null) {
            return SystemUtils.c(t2.getCause());
        }
        return t2.getMessage() != null ? t2.getMessage() : t2.toString();
    }

    public static <T> T a(T[] array, RandomSource random) {
        return array[random.a(array.length)];
    }

    public static int a(int[] array, RandomSource random) {
        return array[random.a(array.length)];
    }

    public static <T> T a(List<T> list, RandomSource random) {
        return list.get(random.a(list.size()));
    }

    public static <T> Optional<T> b(List<T> list, RandomSource random) {
        return list.isEmpty() ? Optional.empty() : Optional.of(SystemUtils.a(list, random));
    }

    private static BooleanSupplier a(final Path src, final Path dest) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(src, dest, new CopyOption[0]);
                    return true;
                }
                catch (IOException var2) {
                    g.error("Failed to rename", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "rename " + String.valueOf(src) + " to " + String.valueOf(dest);
            }
        };
    }

    private static BooleanSupplier a(Path path) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static BooleanSupplier b(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(path) + " is deleted";
            }
        };
    }

    private static BooleanSupplier c(final Path path) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(path, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(path) + " is present";
            }
        };
    }

    private static boolean a(BooleanSupplier ... tasks) {
        for (BooleanSupplier booleanSupplier : tasks) {
            if (booleanSupplier.getAsBoolean()) continue;
            g.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean a(int retries, String taskName, BooleanSupplier ... tasks) {
        for (int i2 = 0; i2 < retries; ++i2) {
            if (SystemUtils.a(tasks)) {
                return true;
            }
            g.error("Failed to {}, retrying {}/{}", new Object[]{taskName, i2, retries});
        }
        g.error("Failed to {}, aborting, progress might be lost", (Object)taskName);
        return false;
    }

    public static void a(Path current, Path newPath, Path backup) {
        SystemUtils.a(current, newPath, backup, false);
    }

    public static boolean a(Path current, Path newPath, Path backup, boolean noRestoreOnFail) {
        if (Files.exists(current, new LinkOption[0]) && !SystemUtils.a(10, "create backup " + String.valueOf(backup), SystemUtils.a(backup), SystemUtils.a(current, backup), SystemUtils.c(backup))) {
            return false;
        }
        if (!SystemUtils.a(10, "remove old " + String.valueOf(current), SystemUtils.a(current), SystemUtils.b(current))) {
            return false;
        }
        if (!SystemUtils.a(10, "replace " + String.valueOf(current) + " with " + String.valueOf(newPath), SystemUtils.a(newPath, current), SystemUtils.c(current)) && !noRestoreOnFail) {
            SystemUtils.a(10, "restore " + String.valueOf(current) + " from " + String.valueOf(backup), SystemUtils.a(backup, current), SystemUtils.c(current));
            return false;
        }
        return true;
    }

    public static int a(String string, int cursor, int delta) {
        int i2 = string.length();
        if (delta >= 0) {
            for (int j2 = 0; cursor < i2 && j2 < delta; ++j2) {
                if (!Character.isHighSurrogate(string.charAt(cursor++)) || cursor >= i2 || !Character.isLowSurrogate(string.charAt(cursor))) continue;
                ++cursor;
            }
        } else {
            for (int k2 = delta; cursor > 0 && k2 < 0; ++k2) {
                if (!Character.isLowSurrogate(string.charAt(--cursor)) || cursor <= 0 || !Character.isHighSurrogate(string.charAt(cursor - 1))) continue;
                --cursor;
            }
        }
        return cursor;
    }

    public static Consumer<String> a(String prefix, Consumer<String> consumer) {
        return string -> consumer.accept(prefix + string);
    }

    public static DataResult<int[]> a(IntStream stream, int length) {
        int[] is = stream.limit(length + 1).toArray();
        if (is.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " ints";
            return is.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(is, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)is);
    }

    public static DataResult<long[]> a(LongStream stream, int length) {
        long[] ls = stream.limit(length + 1).toArray();
        if (ls.length != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " longs";
            return ls.length >= length ? DataResult.error(supplier, (Object)Arrays.copyOf(ls, length)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)ls);
    }

    public static <T> DataResult<List<T>> a(List<T> list, int length) {
        if (list.size() != length) {
            Supplier<String> supplier = () -> "Input is not a list of " + length + " elements";
            return list.size() >= length ? DataResult.error(supplier, list.subList(0, length)) : DataResult.error(supplier);
        }
        return DataResult.success(list);
    }

    public static void o() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var2) {
                    g.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(g));
        thread.start();
    }

    public static void b(Path src, Path dest, Path toCopy) throws IOException {
        Path path = src.relativize(toCopy);
        Path path2 = dest.resolve(path);
        Files.copy(toCopy, path2, new CopyOption[0]);
    }

    public static String a(String string, CharPredicate predicate) {
        return string.toLowerCase(Locale.ROOT).chars().mapToObj(charCode -> predicate.test((char)charCode) ? Character.toString((char)charCode) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> a(Function<K, V> mapper) {
        return new SingleKeyCache<K, V>(mapper);
    }

    public static <T, R> Function<T, R> b(final Function<T, R> function) {
        return new Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object) {
                return this.cache.computeIfAbsent(object, function);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(function) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> a(final BiFunction<T, U, R> biFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T object, U object2) {
                return this.cache.computeIfAbsent(Pair.of(object, object2), pair -> biFunction.apply(pair.getFirst(), pair.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(biFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> a(Stream<T> stream, RandomSource random) {
        ObjectArrayList objectArrayList = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        SystemUtils.c(objectArrayList, random);
        return objectArrayList;
    }

    public static IntArrayList a(IntStream stream, RandomSource random) {
        int i2;
        IntArrayList intArrayList = IntArrayList.wrap((int[])stream.toArray());
        for (int j2 = i2 = intArrayList.size(); j2 > 1; --j2) {
            int k2 = random.a(j2);
            intArrayList.set(j2 - 1, intArrayList.set(k2, intArrayList.getInt(j2 - 1)));
        }
        return intArrayList;
    }

    public static <T> List<T> b(T[] array, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList((Object[])array);
        SystemUtils.c(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> List<T> a(ObjectArrayList<T> list, RandomSource random) {
        ObjectArrayList objectArrayList = new ObjectArrayList(list);
        SystemUtils.c(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> void c(List<T> list, RandomSource random) {
        int i2;
        for (int j2 = i2 = list.size(); j2 > 1; --j2) {
            int k2 = random.a(j2);
            list.set(j2 - 1, list.set(k2, list.get(j2 - 1)));
        }
    }

    public static <T> CompletableFuture<T> c(Function<Executor, CompletableFuture<T>> resultFactory) {
        return SystemUtils.a(resultFactory, CompletableFuture::isDone);
    }

    public static <T> T a(Function<Executor, T> resultFactory, Predicate<T> donePredicate) {
        int i2;
        LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        T object = resultFactory.apply(blockingQueue::add);
        while (!donePredicate.test(object)) {
            try {
                Runnable runnable = (Runnable)blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException var5) {
                g.warn("Interrupted wait");
                break;
            }
        }
        if ((i2 = blockingQueue.size()) > 0) {
            g.warn("Tasks left in queue: {}", (Object)i2);
        }
        return object;
    }

    public static <T> ToIntFunction<T> g(List<T> values) {
        int i2 = values.size();
        if (i2 < 8) {
            return values::indexOf;
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap(i2);
        object2IntMap.defaultReturnValue(-1);
        for (int j2 = 0; j2 < i2; ++j2) {
            object2IntMap.put(values.get(j2), j2);
        }
        return object2IntMap;
    }

    public static <T> ToIntFunction<T> h(List<T> values) {
        int i2 = values.size();
        if (i2 < 8) {
            ReferenceImmutableList referenceList = new ReferenceImmutableList(values);
            return arg_0 -> ((ReferenceList)referenceList).indexOf(arg_0);
        }
        Reference2IntOpenHashMap reference2IntMap = new Reference2IntOpenHashMap(i2);
        reference2IntMap.defaultReturnValue(-1);
        for (int j2 = 0; j2 < i2; ++j2) {
            reference2IntMap.put(values.get(j2), j2);
        }
        return reference2IntMap;
    }

    public static <A, B> Typed<B> a(Typed<A> typed, Type<B> type, UnaryOperator<Dynamic<?>> modifier) {
        Dynamic dynamic = (Dynamic)((Object)typed.write().getOrThrow());
        return SystemUtils.a(type, (Dynamic)((Object)modifier.apply(dynamic)), true);
    }

    public static <T> Typed<T> a(Type<T> type, Dynamic<?> value) {
        return SystemUtils.a(type, value, false);
    }

    public static <T> Typed<T> a(Type<T> type, Dynamic<?> value, boolean allowPartial) {
        DataResult dataResult = type.readTyped(value).map(Pair::getFirst);
        try {
            return allowPartial ? (Typed)dataResult.getPartialOrThrow(IllegalStateException::new) : (Typed)dataResult.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException var7) {
            CrashReport crashReport = CrashReport.a(var7, "Reading type");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Info");
            crashReportCategory.a("Data", value);
            crashReportCategory.a("Type", type);
            throw new ReportedException(crashReport);
        }
    }

    public static <T> List<T> a(List<T> list, T valueToAppend) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).addAll(list).add(valueToAppend).build();
    }

    public static <T> List<T> a(T valueToPrepend, List<T> list) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).add(valueToPrepend).addAll(list).build();
    }

    public static <K, V> Map<K, V> a(Map<K, V> map, K keyToAppend, V valueToAppend) {
        return ImmutableMap.builderWithExpectedSize((int)(map.size() + 1)).putAll(map).put(keyToAppend, valueToAppend).buildKeepingLast();
    }

    public static sealed class OS
    extends Enum<OS> {
        public static final /* enum */ OS a = new OS("linux");
        public static final /* enum */ OS b = new OS("solaris");
        public static final /* enum */ OS c = new OS("windows"){

            @Override
            protected String[] b(URI uri) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
            }
        };
        public static final /* enum */ OS d = new OS("mac"){

            @Override
            protected String[] b(URI uri) {
                return new String[]{"open", uri.toString()};
            }
        };
        public static final /* enum */ OS e = new OS("unknown");
        private final String f;
        private static final /* synthetic */ OS[] g;

        public static OS[] values() {
            return (OS[])g.clone();
        }

        public static OS valueOf(String name) {
            return Enum.valueOf(OS.class, name);
        }

        private OS(String name) {
            this.f = name;
        }

        public void a(URI uri) {
            throw new IllegalStateException("This method is not useful on dedicated servers.");
        }

        public void a(File file) {
            this.a(file.toURI());
        }

        public void a(Path path) {
            this.a(path.toUri());
        }

        protected String[] b(URI uri) {
            String string = uri.toString();
            if ("file".equals(uri.getScheme())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void a(String uri) {
            try {
                this.a(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException var3) {
                g.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public String a() {
            return this.f;
        }

        private static /* synthetic */ OS[] b() {
            return new OS[]{a, b, c, d, e};
        }

        static {
            g = OS.b();
        }
    }
}

