/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public class ArgumentParticle
implements ArgumentType<ParticleParam> {
    private static final Collection<String> c = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("particle.notFound", id));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(error -> IChatBaseComponent.b("particle.invalidOptions", error));
    private final HolderLookup.a d;

    public ArgumentParticle(CommandBuildContext registryAccess) {
        this.d = registryAccess;
    }

    public static ArgumentParticle a(CommandBuildContext registryAccess) {
        return new ArgumentParticle(registryAccess);
    }

    public static ParticleParam a(CommandContext<CommandListenerWrapper> context, String name) {
        return (ParticleParam)context.getArgument(name, ParticleParam.class);
    }

    public ParticleParam a(StringReader stringReader) throws CommandSyntaxException {
        return ArgumentParticle.a(stringReader, this.d);
    }

    public Collection<String> getExamples() {
        return c;
    }

    public static ParticleParam a(StringReader reader, HolderLookup.a registries) throws CommandSyntaxException {
        Particle<?> particleType = ArgumentParticle.a(reader, registries.d(Registries.Y));
        return ArgumentParticle.a(reader, particleType, registries);
    }

    private static Particle<?> a(StringReader reader, HolderLookup<Particle<?>> registryWrapper) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(reader);
        ResourceKey<Particle<?>> resourceKey = ResourceKey.a(Registries.Y, resourceLocation);
        return registryWrapper.a(resourceKey).orElseThrow(() -> a.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation)).a();
    }

    private static <T extends ParticleParam> T a(StringReader reader, Particle<T> type, HolderLookup.a registries) throws CommandSyntaxException {
        NBTTagCompound compoundTag2;
        if (reader.canRead() && reader.peek() == '{') {
            NBTTagCompound compoundTag = new MojangsonParser(reader).f();
        } else {
            compoundTag2 = new NBTTagCompound();
        }
        return (T)((ParticleParam)type.c().codec().parse(registries.a(DynamicOpsNBT.a), (Object)compoundTag2).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)b).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        HolderLookup.b<Particle<?>> registryLookup = this.d.d(Registries.Y);
        return ICompletionProvider.a(registryLookup.c_().map(ResourceKey::a), suggestionsBuilder);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }
}

