/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;

public class ArgumentScoreholder
implements ArgumentType<b> {
    public static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(stringReader, ArgumentParserSelector.a((CommandListenerWrapper)context.getSource()));
        try {
            entitySelectorParser.t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entitySelectorParser.a(builder, builderx -> ICompletionProvider.b(((CommandListenerWrapper)context.getSource()).q(), builderx));
    };
    private static final Collection<String> b = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.scoreHolder.empty"));
    final boolean d;

    public ArgumentScoreholder(boolean multiple) {
        this.d = multiple;
    }

    public static ScoreHolder a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.b(context, name).iterator().next();
    }

    public static Collection<ScoreHolder> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.a(context, name, Collections::emptyList);
    }

    public static Collection<ScoreHolder> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.a(context, name, ((CommandListenerWrapper)context.getSource()).l().aJ()::e);
    }

    public static Collection<ScoreHolder> a(CommandContext<CommandListenerWrapper> context, String name, Supplier<Collection<ScoreHolder>> players) throws CommandSyntaxException {
        Collection<ScoreHolder> collection = ((b)context.getArgument(name, b.class)).getNames((CommandListenerWrapper)context.getSource(), players);
        if (collection.isEmpty()) {
            throw ArgumentEntity.d.create();
        }
        return collection;
    }

    public static ArgumentScoreholder a() {
        return new ArgumentScoreholder(false);
    }

    public static ArgumentScoreholder b() {
        return new ArgumentScoreholder(true);
    }

    public b a(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader, true);
    }

    public <S> b a(StringReader stringReader, S object) throws CommandSyntaxException {
        return this.a(stringReader, ArgumentParserSelector.a(object));
    }

    private b a(StringReader reader, boolean allowAtSelectors) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(reader, allowAtSelectors);
            EntitySelector entitySelector = entitySelectorParser.t();
            if (!this.d && entitySelector.a() > 1) {
                throw ArgumentEntity.a.createWithContext((ImmutableStringReader)reader);
            }
            return new c(entitySelector);
        }
        int i2 = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String string = reader.getString().substring(i2, reader.getCursor());
        if (string.equals("*")) {
            return (source, players) -> {
                Collection collection = (Collection)players.get();
                if (collection.isEmpty()) {
                    throw c.create();
                }
                return collection;
            };
        }
        List<ScoreHolder> list = List.of(ScoreHolder.c(string));
        if (string.startsWith("#")) {
            return (source, players) -> list;
        }
        try {
            UUID uUID = UUID.fromString(string);
            return (source, holders) -> {
                MinecraftServer minecraftServer = source.l();
                Entity scoreHolder = null;
                ArrayList<Entity> list2 = null;
                for (WorldServer serverLevel : minecraftServer.L()) {
                    Entity entity = serverLevel.a(uUID);
                    if (entity == null) continue;
                    if (scoreHolder == null) {
                        scoreHolder = entity;
                        continue;
                    }
                    if (list2 == null) {
                        list2 = new ArrayList<Entity>();
                        list2.add(scoreHolder);
                    }
                    list2.add(entity);
                }
                if (list2 != null) {
                    return list2;
                }
                if (scoreHolder != null) {
                    return List.of(scoreHolder);
                }
                return list;
            };
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (source, holders) -> {
                MinecraftServer minecraftServer = source.l();
                EntityPlayer serverPlayer = minecraftServer.ag().a(string);
                if (serverPlayer != null) {
                    return List.of(serverPlayer);
                }
                return list;
            };
        }
    }

    public Collection<String> getExamples() {
        return b;
    }

    public /* synthetic */ Object parse(StringReader stringReader, Object object) throws CommandSyntaxException {
        return this.a(stringReader, object);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    @FunctionalInterface
    public static interface b {
        public Collection<ScoreHolder> getNames(CommandListenerWrapper var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException;
    }

    public static class c
    implements b {
        private final EntitySelector a;

        public c(EntitySelector selector) {
            this.a = selector;
        }

        @Override
        @Override
        public Collection<ScoreHolder> getNames(CommandListenerWrapper source, Supplier<Collection<ScoreHolder>> holders) throws CommandSyntaxException {
            List<? extends Entity> list = this.a.b(source);
            if (list.isEmpty()) {
                throw ArgumentEntity.d.create();
            }
            return List.copyOf(list);
        }
    }

    public static class net.minecraft.commands.arguments.ArgumentScoreholder$a
    implements ArgumentTypeInfo<ArgumentScoreholder, a> {
        private static final byte a = 1;

        @Override
        @Override
        public void a(a properties, PacketDataSerializer buf) {
            int i2 = 0;
            if (properties.b) {
                i2 |= 1;
            }
            buf.l(i2);
        }

        @Override
        @Override
        public a a(PacketDataSerializer friendlyByteBuf) {
            byte b2 = friendlyByteBuf.readByte();
            boolean bl = (b2 & 1) != 0;
            return new a(bl);
        }

        @Override
        @Override
        public void a(a properties, JsonObject json) {
            json.addProperty("amount", properties.b ? "multiple" : "single");
        }

        @Override
        @Override
        public a a(ArgumentScoreholder argumentType) {
            return new a(argumentType.d);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer buf) {
            return this.a(buf);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentScoreholder> {
            final boolean b;

            a(boolean multiple) {
                this.b = multiple;
            }

            @Override
            public ArgumentScoreholder a(CommandBuildContext commandBuildContext) {
                return new ArgumentScoreholder(this.b);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ArgumentScoreholder, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandRegistryAccess) {
                return this.a(commandRegistryAccess);
            }
        }
    }
}

