/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> b = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(argument -> IChatBaseComponent.b("argument.resource_or_id.failed_to_parse", argument));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.resource_or_id.invalid"));
    private final HolderLookup.a d;
    private final boolean e;
    private final Codec<Holder<T>> f;

    protected ResourceOrIdArgument(CommandBuildContext registryAccess, ResourceKey<IRegistry<T>> registry, Codec<Holder<T>> entryCodec) {
        this.d = registryAccess;
        this.e = registryAccess.a(registry).isPresent();
        this.f = entryCodec;
    }

    public static c a(CommandBuildContext registryAccess) {
        return new c(registryAccess);
    }

    public static Holder<LootTable> a(CommandContext<CommandListenerWrapper> context, String argument) throws CommandSyntaxException {
        return ResourceOrIdArgument.d(context, argument);
    }

    public static a b(CommandBuildContext registryAccess) {
        return new a(registryAccess);
    }

    public static Holder<LootItemFunction> b(CommandContext<CommandListenerWrapper> context, String argument) {
        return ResourceOrIdArgument.d(context, argument);
    }

    public static b c(CommandBuildContext registryAccess) {
        return new b(registryAccess);
    }

    public static Holder<LootItemCondition> c(CommandContext<CommandListenerWrapper> context, String argument) {
        return ResourceOrIdArgument.d(context, argument);
    }

    private static <T> Holder<T> d(CommandContext<CommandListenerWrapper> context, String argument) {
        return (Holder)context.getArgument(argument, Holder.class);
    }

    @Nullable
    public Holder<T> a(StringReader stringReader) throws CommandSyntaxException {
        NBTBase tag = ResourceOrIdArgument.b(stringReader);
        if (!this.e) {
            return null;
        }
        RegistryOps<NBTBase> registryOps = this.d.a(DynamicOpsNBT.a);
        return (Holder)this.f.parse(registryOps, (Object)tag).getOrThrow(argument -> a.createWithContext((ImmutableStringReader)stringReader, argument));
    }

    @VisibleForTesting
    static NBTBase b(StringReader stringReader) throws CommandSyntaxException {
        int i2 = stringReader.getCursor();
        NBTBase tag = new MojangsonParser(stringReader).d();
        if (ResourceOrIdArgument.c(stringReader)) {
            return tag;
        }
        stringReader.setCursor(i2);
        MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
        if (ResourceOrIdArgument.c(stringReader)) {
            return NBTTagString.a(resourceLocation.toString());
        }
        stringReader.setCursor(i2);
        throw c.createWithContext((ImmutableStringReader)stringReader);
    }

    private static boolean c(StringReader stringReader) {
        return !stringReader.canRead() || stringReader.peek() == ' ';
    }

    public Collection<String> getExamples() {
        return b;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class c
    extends ResourceOrIdArgument<LootTable> {
        protected c(CommandBuildContext registryAccess) {
            super(registryAccess, Registries.bg, LootTable.e);
        }

        @Override
        @Nullable
        @Override
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.a(stringReader);
        }
    }

    public static class a
    extends ResourceOrIdArgument<LootItemFunction> {
        protected a(CommandBuildContext registryAccess) {
            super(registryAccess, Registries.bh, LootItemFunctions.d);
        }

        @Override
        @Nullable
        @Override
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.a(stringReader);
        }
    }

    public static class b
    extends ResourceOrIdArgument<LootItemCondition> {
        protected b(CommandBuildContext registryAccess) {
            super(registryAccess, Registries.bi, LootItemCondition.f);
        }

        @Override
        @Nullable
        @Override
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.a(stringReader);
        }
    }
}

