/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class ArgumentParserItemStack {
    static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("argument.item.id.invalid", id));
    static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("arguments.item.component.unknown", id));
    static final Dynamic2CommandExceptionType h = new Dynamic2CommandExceptionType((type, error) -> IChatBaseComponent.b("arguments.item.component.malformed", type, error));
    static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.item.component.expected"));
    static final DynamicCommandExceptionType j = new DynamicCommandExceptionType(type -> IChatBaseComponent.b("arguments.item.component.repeated", type));
    private static final DynamicCommandExceptionType k = new DynamicCommandExceptionType(error -> IChatBaseComponent.b("arguments.item.malformed", error));
    public static final char a = '[';
    public static final char b = ']';
    public static final char c = ',';
    public static final char d = '=';
    public static final char e = '!';
    static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> l = SuggestionsBuilder::buildFuture;
    final HolderLookup.b<Item> m;
    final DynamicOps<NBTBase> n;

    public ArgumentParserItemStack(HolderLookup.a registries) {
        this.m = registries.d(Registries.K);
        this.n = registries.a(DynamicOpsNBT.a);
    }

    public a a(StringReader reader) throws CommandSyntaxException {
        final MutableObject mutableObject = new MutableObject();
        final DataComponentPatch.a builder = DataComponentPatch.a();
        this.a(reader, new d(){

            @Override
            @Override
            public void a(Holder<Item> item) {
                mutableObject.setValue(item);
            }

            @Override
            @Override
            public <T> void a(DataComponentType<T> type, T value) {
                builder.a(type, value);
            }

            @Override
            @Override
            public <T> void a(DataComponentType<T> type) {
                builder.a(type);
            }
        });
        Holder holder = Objects.requireNonNull((Holder)mutableObject.getValue(), "Parser gave no item");
        DataComponentPatch dataComponentPatch = builder.a();
        ArgumentParserItemStack.a(reader, holder, dataComponentPatch);
        return new a(holder, dataComponentPatch);
    }

    private static void a(StringReader reader, Holder<Item> item, DataComponentPatch components) throws CommandSyntaxException {
        PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.a(item.a().g(), components);
        DataResult<Unit> dataResult = ItemStack.a(dataComponentMap);
        dataResult.getOrThrow(error -> k.createWithContext((ImmutableStringReader)reader, error));
    }

    public void a(StringReader reader, d callbacks) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        try {
            new b(reader, callbacks).a();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            reader.setCursor(i2);
            throw commandSyntaxException;
        }
    }

    public CompletableFuture<Suggestions> a(SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        c suggestionsVisitor = new c();
        b state = new b(stringReader, suggestionsVisitor);
        try {
            state.a();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return suggestionsVisitor.a(builder, stringReader);
    }

    public static interface d {
        default public void a(Holder<Item> item) {
        }

        default public <T> void a(DataComponentType<T> type, T value) {
        }

        default public <T> void a(DataComponentType<T> type) {
        }

        default public void a(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestor) {
        }
    }

    public record a(Holder<Item> a, DataComponentPatch b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "item;components", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "item;components", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "item;components", "a", "b"}, this, object);
        }
    }

    class b {
        private final StringReader b;
        private final d c;

        b(StringReader reader, d callbacks) {
            this.b = reader;
            this.c = callbacks;
        }

        public void a() throws CommandSyntaxException {
            this.c.a(this::d);
            this.b();
            this.c.a(this::a);
            if (this.b.canRead() && this.b.peek() == '[') {
                this.c.a(l);
                this.c();
            }
        }

        private void b() throws CommandSyntaxException {
            int i2 = this.b.getCursor();
            MinecraftKey resourceLocation = MinecraftKey.a(this.b);
            this.c.a((Holder<Item>)ArgumentParserItemStack.this.m.a(ResourceKey.a(Registries.K, resourceLocation)).orElseThrow(() -> {
                this.b.setCursor(i2);
                return f.createWithContext((ImmutableStringReader)this.b, (Object)resourceLocation);
            }));
        }

        private void c() throws CommandSyntaxException {
            this.b.expect('[');
            this.c.a(this::e);
            ReferenceArraySet set = new ReferenceArraySet();
            while (this.b.canRead() && this.b.peek() != ']') {
                this.b.skipWhitespace();
                if (this.b.canRead() && this.b.peek() == '!') {
                    this.b.skip();
                    this.c.a(this::f);
                    DataComponentType<?> dataComponentType = net.minecraft.commands.arguments.item.ArgumentParserItemStack$b.a(this.b);
                    if (!set.add(dataComponentType)) {
                        throw j.create(dataComponentType);
                    }
                    this.c.a(dataComponentType);
                    this.c.a(l);
                    this.b.skipWhitespace();
                } else {
                    DataComponentType<?> dataComponentType2 = net.minecraft.commands.arguments.item.ArgumentParserItemStack$b.a(this.b);
                    if (!set.add(dataComponentType2)) {
                        throw j.create(dataComponentType2);
                    }
                    this.c.a(this::c);
                    this.b.skipWhitespace();
                    this.b.expect('=');
                    this.c.a(l);
                    this.b.skipWhitespace();
                    this.a(dataComponentType2);
                    this.b.skipWhitespace();
                }
                this.c.a(this::b);
                if (!this.b.canRead() || this.b.peek() != ',') break;
                this.b.skip();
                this.b.skipWhitespace();
                this.c.a(this::e);
                if (this.b.canRead()) continue;
                throw i.createWithContext((ImmutableStringReader)this.b);
            }
            this.b.expect(']');
            this.c.a(l);
        }

        public static DataComponentType<?> a(StringReader reader) throws CommandSyntaxException {
            if (!reader.canRead()) {
                throw i.createWithContext((ImmutableStringReader)reader);
            }
            int i2 = reader.getCursor();
            MinecraftKey resourceLocation = MinecraftKey.a(reader);
            DataComponentType<?> dataComponentType = BuiltInRegistries.ao.a(resourceLocation);
            if (dataComponentType == null || dataComponentType.d()) {
                reader.setCursor(i2);
                throw g.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation);
            }
            return dataComponentType;
        }

        private <T> void a(DataComponentType<T> type) throws CommandSyntaxException {
            int i2 = this.b.getCursor();
            NBTBase tag = new MojangsonParser(this.b).d();
            DataResult dataResult = type.c().parse(ArgumentParserItemStack.this.n, (Object)tag);
            this.c.a(type, dataResult.getOrThrow(error -> {
                this.b.setCursor(i2);
                return h.createWithContext((ImmutableStringReader)this.b, (Object)type.toString(), error);
            }));
        }

        private CompletableFuture<Suggestions> a(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> b(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf(','));
                builder.suggest(String.valueOf(']'));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> c(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('='));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> d(SuggestionsBuilder builder) {
            return ICompletionProvider.a(ArgumentParserItemStack.this.m.c_().map(ResourceKey::a), builder);
        }

        private CompletableFuture<Suggestions> e(SuggestionsBuilder builder) {
            builder.suggest(String.valueOf('!'));
            return this.a(builder, String.valueOf('='));
        }

        private CompletableFuture<Suggestions> f(SuggestionsBuilder builder) {
            return this.a(builder, "");
        }

        private CompletableFuture<Suggestions> a(SuggestionsBuilder builder, String suffix) {
            String string = builder.getRemaining().toLowerCase(Locale.ROOT);
            ICompletionProvider.a(BuiltInRegistries.ao.k(), string, entry -> ((ResourceKey)entry.getKey()).a(), entry -> {
                DataComponentType dataComponentType = (DataComponentType)entry.getValue();
                if (dataComponentType.b() != null) {
                    MinecraftKey resourceLocation = ((ResourceKey)entry.getKey()).a();
                    builder.suggest(String.valueOf(resourceLocation) + suffix);
                }
            });
            return builder.buildFuture();
        }
    }

    static class c
    implements d {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> a = l;

        c() {
        }

        @Override
        @Override
        public void a(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestor) {
            this.a = suggestor;
        }

        public CompletableFuture<Suggestions> a(SuggestionsBuilder builder, StringReader reader) {
            return this.a.apply(builder.createOffset(reader.getCursor()));
        }
    }
}

