/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat a = SystemUtils.a(new DecimalFormat("#"), (? super T format) -> {
        format.setMaximumFractionDigits(15);
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    });
    private static final int b = 8;
    private final List<String> c;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> d = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final MinecraftKey e;
    private final List<a<T>> f;

    public MacroFunction(MinecraftKey id, List<a<T>> lines, List<String> varNames) {
        this.e = id;
        this.f = lines;
        this.c = varNames;
    }

    @Override
    @Override
    public MinecraftKey a() {
        return this.e;
    }

    @Override
    @Override
    public InstantiatedFunction<T> a(@Nullable NBTTagCompound arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        if (arguments == null) {
            throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_arguments", IChatBaseComponent.a(this.a())));
        }
        ArrayList<String> list = new ArrayList<String>(this.c.size());
        for (String string : this.c) {
            NBTBase tag = arguments.c(string);
            if (tag == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_argument", IChatBaseComponent.a(this.a()), string));
            }
            list.add(MacroFunction.a(tag));
        }
        InstantiatedFunction instantiatedFunction = (InstantiatedFunction)this.d.getAndMoveToLast(list);
        if (instantiatedFunction != null) {
            return instantiatedFunction;
        }
        if (this.d.size() >= 8) {
            this.d.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction2 = this.a(this.c, list, dispatcher);
        this.d.put(list, instantiatedFunction2);
        return instantiatedFunction2;
    }

    private static String a(NBTBase nbt) {
        if (nbt instanceof NBTTagFloat) {
            NBTTagFloat floatTag = (NBTTagFloat)nbt;
            return a.format(floatTag.k());
        }
        if (nbt instanceof NBTTagDouble) {
            NBTTagDouble doubleTag = (NBTTagDouble)nbt;
            return a.format(doubleTag.j());
        }
        if (nbt instanceof NBTTagByte) {
            NBTTagByte byteTag = (NBTTagByte)nbt;
            return String.valueOf(byteTag.i());
        }
        if (nbt instanceof NBTTagShort) {
            NBTTagShort shortTag = (NBTTagShort)nbt;
            return String.valueOf(shortTag.h());
        }
        if (nbt instanceof NBTTagLong) {
            NBTTagLong longTag = (NBTTagLong)nbt;
            return String.valueOf(longTag.f());
        }
        return nbt.u_();
    }

    private static void a(List<String> arguments, IntList indices, List<String> out) {
        out.clear();
        indices.forEach(index -> out.add((String)arguments.get(index)));
    }

    private InstantiatedFunction<T> a(List<String> varNames, List<String> arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        ArrayList list = new ArrayList(this.f.size());
        ArrayList<String> list2 = new ArrayList<String>(arguments.size());
        for (a<T> entry : this.f) {
            MacroFunction.a(arguments, entry.a(), list2);
            list.add(entry.a(list2, dispatcher, this.e));
        }
        return new PlainTextFunction(this.a().a(path -> path + "/" + varNames.hashCode()), list);
    }

    static interface a<T> {
        public IntList a();

        public UnboundEntryAction<T> a(List<String> var1, CommandDispatcher<T> var2, MinecraftKey var3) throws FunctionInstantiationException;
    }

    static class b<T extends ExecutionCommandSource<T>>
    implements a<T> {
        private final StringTemplate a;
        private final IntList b;
        private final T c;

        public b(StringTemplate invocation, IntList variableIndices, T source) {
            this.a = invocation;
            this.b = variableIndices;
            this.c = source;
        }

        @Override
        @Override
        public IntList a() {
            return this.b;
        }

        @Override
        @Override
        public UnboundEntryAction<T> a(List<String> args, CommandDispatcher<T> dispatcher, MinecraftKey id) throws FunctionInstantiationException {
            String string = this.a.a(args);
            try {
                return CommandFunction.a(dispatcher, this.c, new StringReader(string));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.parse", IChatBaseComponent.a(id), string, commandSyntaxException.getMessage()));
            }
        }
    }

    static class c<T>
    implements a<T> {
        private final UnboundEntryAction<T> a;

        public c(UnboundEntryAction<T> action) {
            this.a = action;
        }

        @Override
        @Override
        public IntList a() {
            return IntLists.emptyList();
        }

        @Override
        @Override
        public UnboundEntryAction<T> a(List<String> args, CommandDispatcher<T> dispatcher, MinecraftKey id) {
            return this.a;
        }
    }
}

