/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.VisibleForTesting;

public interface HolderSet<T>
extends Iterable<Holder<T>> {
    public Stream<Holder<T>> a();

    public int b();

    public boolean c();

    public Either<TagKey<T>, List<Holder<T>>> d();

    public Optional<Holder<T>> a(RandomSource var1);

    public Holder<T> a(int var1);

    public boolean a(Holder<T> var1);

    public boolean a(HolderOwner<T> var1);

    public Optional<TagKey<T>> e();

    @Deprecated
    @VisibleForTesting
    public static <T> Named<T> a(HolderOwner<T> owner, TagKey<T> tagKey) {
        return new Named<T>((HolderOwner)owner, (TagKey)tagKey){

            @Override
            @Override
            protected List<Holder<T>> g() {
                throw new UnsupportedOperationException("Tag " + String.valueOf(this.h()) + " can't be dereferenced during construction");
            }
        };
    }

    public static <T> HolderSet<T> f() {
        return a.a;
    }

    @SafeVarargs
    public static <T> a<T> a(Holder<T> ... entries) {
        return new a<T>(List.of(entries));
    }

    public static <T> a<T> a(List<? extends Holder<T>> entries) {
        return new a(List.copyOf(entries));
    }

    @SafeVarargs
    public static <E, T> a<T> a(Function<E, Holder<T>> mapper, E ... values) {
        return HolderSet.a(Stream.of(values).map(mapper).toList());
    }

    public static <E, T> a<T> a(Function<E, Holder<T>> mapper, Collection<E> values) {
        return HolderSet.a(values.stream().map(mapper).toList());
    }

    public static final class a<T>
    extends b<T> {
        static final a<?> a = new a(List.of());
        private final List<Holder<T>> b;
        @Nullable
        private Set<Holder<T>> c;

        a(List<Holder<T>> entries) {
            this.b = entries;
        }

        @Override
        @Override
        protected List<Holder<T>> g() {
            return this.b;
        }

        @Override
        @Override
        public boolean c() {
            return true;
        }

        @Override
        @Override
        public Either<TagKey<T>, List<Holder<T>>> d() {
            return Either.right(this.b);
        }

        @Override
        @Override
        public Optional<TagKey<T>> e() {
            return Optional.empty();
        }

        @Override
        @Override
        public boolean a(Holder<T> entry) {
            if (this.c == null) {
                this.c = Set.copyOf(this.b);
            }
            return this.c.contains(entry);
        }

        @Override
        public String toString() {
            return "DirectSet[" + String.valueOf(this.b) + "]";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof a)) return false;
            a direct = (a)object;
            if (!this.b.equals(direct.b)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.b.hashCode();
        }
    }

    public static class Named<T>
    extends b<T> {
        private final HolderOwner<T> a;
        private final TagKey<T> b;
        @Nullable
        private List<Holder<T>> c;

        Named(HolderOwner<T> owner, TagKey<T> tag) {
            this.a = owner;
            this.b = tag;
        }

        void b(List<Holder<T>> entries) {
            this.c = List.copyOf(entries);
        }

        public TagKey<T> h() {
            return this.b;
        }

        @Override
        @Override
        protected List<Holder<T>> g() {
            if (this.c == null) {
                throw new IllegalStateException("Trying to access unbound tag '" + String.valueOf(this.b) + "' from registry " + String.valueOf(this.a));
            }
            return this.c;
        }

        @Override
        @Override
        public boolean c() {
            return this.c != null;
        }

        @Override
        @Override
        public Either<TagKey<T>, List<Holder<T>>> d() {
            return Either.left(this.b);
        }

        @Override
        @Override
        public Optional<TagKey<T>> e() {
            return Optional.of(this.b);
        }

        @Override
        @Override
        public boolean a(Holder<T> entry) {
            return entry.a(this.b);
        }

        @Override
        public String toString() {
            return "NamedSet(" + String.valueOf(this.b) + ")[" + String.valueOf(this.c) + "]";
        }

        @Override
        @Override
        public boolean a(HolderOwner<T> owner) {
            return this.a.a(owner);
        }
    }

    public static abstract class b<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> g();

        @Override
        @Override
        public int b() {
            return this.g().size();
        }

        @Override
        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.g().spliterator();
        }

        @Override
        @Override
        public Iterator<Holder<T>> iterator() {
            return this.g().iterator();
        }

        @Override
        @Override
        public Stream<Holder<T>> a() {
            return this.g().stream();
        }

        @Override
        @Override
        public Optional<Holder<T>> a(RandomSource random) {
            return SystemUtils.b(this.g(), random);
        }

        @Override
        @Override
        public Holder<T> a(int index) {
            return this.g().get(index);
        }

        @Override
        @Override
        public boolean a(HolderOwner<T> owner) {
            return true;
        }
    }
}

