/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface IRegistry<T>
extends Keyable,
HolderLookup.b<T>,
Registry<T> {
    @Override
    @Override
    public ResourceKey<? extends IRegistry<T>> g();

    default public Codec<T> q() {
        return this.b().flatComapMap(Holder.c::a, value -> this.a(this.e(value)));
    }

    default public Codec<Holder<T>> r() {
        return this.b().flatComapMap(entry -> entry, this::a);
    }

    private Codec<Holder.c<T>> b() {
        Codec codec = MinecraftKey.a.comapFlatMap(id -> this.c((MinecraftKey)id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.g()) + ": " + String.valueOf(id))), entry -> entry.h().a());
        return ExtraCodecs.a(codec, (E entry) -> this.d(entry.h()).map(RegistrationInfo::b).orElse(Lifecycle.experimental()));
    }

    @Override
    private DataResult<Holder.c<T>> a(Holder<T> entry) {
        DataResult dataResult;
        if (entry instanceof Holder.c) {
            Holder.c reference = (Holder.c)entry;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.g()) + ": " + String.valueOf(entry));
        }
        return dataResult;
    }

    default public <U> Stream<U> keys(DynamicOps<U> dynamicOps) {
        return this.i().stream().map(id -> dynamicOps.createString(id.toString()));
    }

    @Nullable
    public MinecraftKey b(T var1);

    public Optional<ResourceKey<T>> d(T var1);

    @Override
    @Override
    public int a(@Nullable T var1);

    @Nullable
    public T c(@Nullable ResourceKey<T> var1);

    @Nullable
    public T a(@Nullable MinecraftKey var1);

    public Optional<RegistrationInfo> d(ResourceKey<T> var1);

    default public Optional<T> b(@Nullable MinecraftKey id) {
        return Optional.ofNullable(this.a(id));
    }

    default public Optional<T> f(@Nullable ResourceKey<T> key) {
        return Optional.ofNullable(this.c(key));
    }

    public Optional<Holder.c<T>> a();

    default public T g(ResourceKey<T> key) {
        T object = this.c(key);
        if (object == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.g()) + ": " + String.valueOf(key));
        }
        return object;
    }

    public Set<MinecraftKey> i();

    public Set<Map.Entry<ResourceKey<T>, T>> k();

    public Set<ResourceKey<T>> j();

    public Optional<Holder.c<T>> a(RandomSource var1);

    default public Stream<T> s() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean d(MinecraftKey var1);

    public boolean e(ResourceKey<T> var1);

    public static <T> T a(IRegistry<? super T> registry, String id, T entry) {
        return IRegistry.a(registry, MinecraftKey.a(id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey id, T entry) {
        return IRegistry.a(registry, ResourceKey.a(registry.g(), id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T entry) {
        ((IRegistryWritable)registry).a(key, entry, RegistrationInfo.a);
        return entry;
    }

    public static <T> Holder.c<T> b(IRegistry<T> registry, ResourceKey<T> key, T entry) {
        return ((IRegistryWritable)registry).a(key, entry, RegistrationInfo.a);
    }

    public static <T> Holder.c<T> b(IRegistry<T> registry, MinecraftKey id, T entry) {
        return IRegistry.b(registry, ResourceKey.a(registry.g(), id), entry);
    }

    public IRegistry<T> n();

    public Holder.c<T> f(T var1);

    public Optional<Holder.c<T>> c(int var1);

    public Optional<Holder.c<T>> c(MinecraftKey var1);

    public Holder<T> e(T var1);

    default public Iterable<Holder<T>> c(TagKey<T> tag) {
        return (Iterable)DataFixUtils.orElse((Optional)this.a(tag), List.of());
    }

    default public Optional<Holder<T>> a(TagKey<T> tag, RandomSource random) {
        return this.a(tag).flatMap(entryList -> entryList.a(random));
    }

    public Stream<HolderSet.Named<T>> l();

    default public Registry<Holder<T>> t() {
        return new Registry<Holder<T>>(){

            @Override
            @Override
            public int a(Holder<T> value) {
                return IRegistry.this.a(value.a());
            }

            @Nullable
            @Override
            public Holder<T> c(int i2) {
                return IRegistry.this.c(i2).orElse(null);
            }

            @Override
            @Override
            public int d() {
                return IRegistry.this.d();
            }

            @Override
            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.c().map(entry -> entry).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object a(int index) {
                return this.c(index);
            }
        };
    }

    @Override
    public a<T> a(TagDataPack.c<T> var1);

    public static interface a<T> {
        public ResourceKey<? extends IRegistry<? extends T>> a();

        public HolderLookup.b<T> c();

        public void d();

        public int b();
    }
}

