/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import ca.spottedleaf.moonrise.patches.fluid.FluidFluidState;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private final ResourceKey<? extends IRegistry<T>> b;
    private final ObjectList<Holder.c<T>> c = new ObjectArrayList(256);
    private final Reference2IntMap<T> d = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(2048), (? super T map) -> map.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> e = new HashMap<MinecraftKey, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, Holder.c<T>> f = new HashMap<ResourceKey<T>, Holder.c<T>>(2048);
    private final Map<T, Holder.c<T>> g = new IdentityHashMap<T, Holder.c<T>>(2048);
    private final Map<ResourceKey<T>, RegistrationInfo> h = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>(2048);
    private Lifecycle i;
    private final Map<TagKey<T>, HolderSet.Named<T>> j = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    a<T> k = a.a();
    private boolean l;
    @Nullable
    private Map<T, Holder.c<T>> m;

    @Override
    public Stream<HolderSet.Named<T>> e() {
        return this.l();
    }

    private void injectFluidRegister(ResourceKey<?> resourceKey, T object) {
        if (resourceKey.c() == Registries.D) {
            for (Fluid possibleState : ((FluidType)object).f().a()) {
                ((FluidFluidState)possibleState).moonrise$initCaches();
            }
        }
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle) {
        this(key, lifecycle, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, boolean intrusive) {
        this.b = key;
        this.i = lifecycle;
        if (intrusive) {
            this.m = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> g() {
        return this.b;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.b) + " (" + String.valueOf(this.i) + ")]";
    }

    private void b() {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    public void h(ResourceKey<T> key) {
        if (this.l) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(key) + ")");
        }
    }

    @Override
    public Holder.c<T> a(ResourceKey<T> key, T value, RegistrationInfo info) {
        Holder.c reference;
        this.h(key);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.e.containsKey(key.a())) {
            throw SystemUtils.b(new IllegalStateException("Adding duplicate key '" + String.valueOf(key) + "' to registry"));
        }
        if (this.g.containsKey(value)) {
            throw SystemUtils.b(new IllegalStateException("Adding duplicate value '" + String.valueOf(value) + "' to registry"));
        }
        if (this.m != null) {
            reference = this.m.remove(value);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(key) + ":" + String.valueOf(value)));
            }
            reference.b(key);
        } else {
            reference = this.f.computeIfAbsent(key, k2 -> Holder.c.a(this, k2));
        }
        this.f.put(key, reference);
        this.e.put(key.a(), reference);
        this.g.put(value, reference);
        int i2 = this.c.size();
        this.c.add((Object)reference);
        this.d.put(value, i2);
        this.h.put(key, info);
        this.i = this.i.add(info.b());
        this.injectFluidRegister(key, value);
        return reference;
    }

    @Override
    @Nullable
    public MinecraftKey b(T value) {
        Holder.c<T> reference = this.g.get(value);
        return reference != null ? reference.h().a() : null;
    }

    @Override
    public Optional<ResourceKey<T>> d(T entry) {
        return Optional.ofNullable(this.g.get(entry)).map(Holder.c::h);
    }

    @Override
    public int a(@Nullable T value) {
        return this.d.getInt(value);
    }

    @Override
    @Nullable
    public T c(@Nullable ResourceKey<T> key) {
        return RegistryMaterials.a(this.f.get(key));
    }

    @Override
    @Nullable
    public T a(int index) {
        return index >= 0 && index < this.c.size() ? (T)((Holder.c)this.c.get(index)).a() : null;
    }

    @Override
    public Optional<Holder.c<T>> c(int rawId) {
        return rawId >= 0 && rawId < this.c.size() ? Optional.ofNullable((Holder.c)this.c.get(rawId)) : Optional.empty();
    }

    @Override
    public Optional<Holder.c<T>> c(MinecraftKey id) {
        return Optional.ofNullable(this.e.get(id));
    }

    @Override
    public Optional<Holder.c<T>> a(ResourceKey<T> key) {
        return Optional.ofNullable(this.f.get(key));
    }

    @Override
    public Optional<Holder.c<T>> a() {
        return this.c.isEmpty() ? Optional.empty() : Optional.of((Holder.c)this.c.getFirst());
    }

    @Override
    public Holder<T> e(T value) {
        Holder.c<T> reference = this.g.get(value);
        return reference != null ? reference : Holder.a(value);
    }

    Holder.c<T> i(ResourceKey<T> key) {
        return this.f.computeIfAbsent(key, key2 -> {
            if (this.m != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.h((ResourceKey<T>)key2);
            return Holder.c.a(this, key2);
        });
    }

    @Override
    public int d() {
        return this.f.size();
    }

    @Override
    public Optional<RegistrationInfo> d(ResourceKey<T> key) {
        return Optional.ofNullable(this.h.get(key));
    }

    @Override
    public Lifecycle h() {
        return this.i;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.c.iterator(), Holder::a);
    }

    @Override
    @Nullable
    public T a(@Nullable MinecraftKey id) {
        Holder.c<T> reference = this.e.get(id);
        return RegistryMaterials.a(reference);
    }

    @Nullable
    private static <T> T a(@Nullable Holder.c<T> entry) {
        return entry != null ? (T)entry.a() : null;
    }

    @Override
    public Set<MinecraftKey> i() {
        return Collections.unmodifiableSet(this.e.keySet());
    }

    @Override
    public Set<ResourceKey<T>> j() {
        return Collections.unmodifiableSet(this.f.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> k() {
        return Collections.unmodifiableSet(Maps.transformValues(this.f, Holder::a).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> c() {
        return this.c.stream();
    }

    @Override
    public Stream<HolderSet.Named<T>> l() {
        return this.k.c();
    }

    HolderSet.Named<T> d(TagKey<T> key) {
        return this.j.computeIfAbsent(key, this::e);
    }

    @Override
    private HolderSet.Named<T> e(TagKey<T> tag) {
        return new HolderSet.Named<T>(this, tag);
    }

    @Override
    public boolean m() {
        return this.f.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> a(RandomSource random) {
        return SystemUtils.b(this.c, random);
    }

    @Override
    public boolean d(MinecraftKey id) {
        return this.e.containsKey(id);
    }

    @Override
    public boolean e(ResourceKey<T> key) {
        return this.f.containsKey(key);
    }

    @Override
    public IRegistry<T> n() {
        if (this.l) {
            return this;
        }
        this.l = true;
        this.g.forEach((? super K value, ? super V entry) -> entry.b(value));
        List<MinecraftKey> list = this.f.entrySet().stream().filter(entry -> !((Holder.c)entry.getValue()).b()).map(entry -> ((ResourceKey)entry.getKey()).a()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.g()) + ": " + String.valueOf(list));
        }
        if (this.m != null) {
            if (!this.m.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.m.values()));
            }
            this.m = null;
        }
        if (this.k.b()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<MinecraftKey> list2 = this.j.entrySet().stream().filter(entry -> !((HolderSet.Named)entry.getValue()).c()).map(entry -> ((TagKey)entry.getKey()).b()).sorted().toList();
        if (!list2.isEmpty()) {
            throw new IllegalStateException("Unbound tags in registry " + String.valueOf(this.g()) + ": " + String.valueOf(list2));
        }
        this.k = a.a(this.j);
        this.u();
        return this;
    }

    @Override
    public Holder.c<T> f(T value) {
        if (this.m == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.b();
        return this.m.computeIfAbsent(value, valuex -> Holder.c.a(this, valuex));
    }

    @Override
    public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
        return this.k.a(tag);
    }

    private Holder.c<T> a(TagKey<T> key, Holder<T> entry) {
        if (!entry.a(this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(key) + " containing value " + String.valueOf(entry) + " from outside registry " + String.valueOf(this));
        }
        if (entry instanceof Holder.c) {
            return (Holder.c)entry;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(entry) + " value in tag " + String.valueOf(key));
    }

    @Override
    public void a(TagKey<T> tag, List<Holder<T>> entries) {
        this.b();
        this.d(tag).b(entries);
    }

    void u() {
        IdentityHashMap<Holder.c, List> map = new IdentityHashMap<Holder.c, List>();
        this.f.values().forEach(key -> map.put((Holder.c)key, new ArrayList()));
        this.k.a((? super TagKey<T> key, ? super HolderSet.Named<T> value) -> {
            for (Holder holder : value) {
                Holder.c reference = this.a((TagKey<T>)key, holder);
                ((List)map.get(reference)).add(key);
            }
        });
        map.forEach(Holder.c::a);
    }

    public void o() {
        this.b();
        this.j.values().forEach(tag -> tag.b(List.of()));
    }

    @Override
    public HolderGetter<T> p() {
        this.b();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return Optional.of(this.b(key));
            }

            @Override
            public Holder.c<T> b(ResourceKey<T> key) {
                return RegistryMaterials.this.i(key);
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.of(this.b(tag));
            }

            @Override
            public HolderSet.Named<T> b(TagKey<T> tag) {
                return RegistryMaterials.this.d(tag);
            }
        };
    }

    @Override
    public IRegistry.a<T> a(TagDataPack.c<T> tags) {
        if (!this.l) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashMap map = new HashMap();
        tags.b().forEach((? super K key, ? super V values) -> {
            HolderSet.Named<T> named = this.j.get(key);
            if (named == null) {
                named = this.e((TagKey<T>)key);
            }
            builder.put(key, named);
            map.put(key, List.copyOf(values));
        });
        final ImmutableMap immutableMap = builder.build();
        final HolderLookup.b.a registryLookup = new HolderLookup.b.a<T>(){

            @Override
            public HolderLookup.b<T> a() {
                return RegistryMaterials.this;
            }

            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.ofNullable((HolderSet.Named)immutableMap.get(tag));
            }

            @Override
            public Stream<HolderSet.Named<T>> e() {
                return immutableMap.values().stream();
            }
        };
        return new IRegistry.a<T>(){

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> a() {
                return RegistryMaterials.this.g();
            }

            @Override
            public int b() {
                return map.size();
            }

            @Override
            public HolderLookup.b<T> c() {
                return registryLookup;
            }

            @Override
            public void d() {
                immutableMap.forEach((tagKey, named) -> {
                    List list = map.getOrDefault(tagKey, List.of());
                    named.b(list);
                });
                RegistryMaterials.this.k = a.a(immutableMap);
                RegistryMaterials.this.u();
            }
        };
    }

    public void clearIntrusiveHolder(T instance) {
        if (this.m != null) {
            this.m.remove(instance);
        }
    }

    static interface a<T> {
        public static <T> a<T> a() {
            return new a<T>(){

                @Override
                public boolean b() {
                    return false;
                }

                @Override
                public Optional<HolderSet.Named<T>> a(TagKey<T> key) {
                    throw new IllegalStateException("Tags not bound, trying to access " + String.valueOf(key));
                }

                @Override
                public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> consumer) {
                    throw new IllegalStateException("Tags not bound");
                }

                @Override
                public Stream<HolderSet.Named<T>> c() {
                    throw new IllegalStateException("Tags not bound");
                }
            };
        }

        public static <T> a<T> a(final Map<TagKey<T>, HolderSet.Named<T>> map) {
            return new a<T>(){

                @Override
                public boolean b() {
                    return true;
                }

                @Override
                public Optional<HolderSet.Named<T>> a(TagKey<T> key) {
                    return Optional.ofNullable((HolderSet.Named)map.get(key));
                }

                @Override
                public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> consumer) {
                    map.forEach(consumer);
                }

                @Override
                public Stream<HolderSet.Named<T>> c() {
                    return map.values().stream();
                }
            };
        }

        public boolean b();

        public Optional<HolderSet.Named<T>> a(TagKey<T> var1);

        public void a(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var1);

        public Stream<HolderSet.Named<T>> c();
    }
}

