/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<k<?>> a = new ArrayList();

    static <T> HolderGetter<T> a(final HolderLookup.b<T> wrapper) {
        return new c<T>(wrapper){

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return wrapper.a(key);
            }
        };
    }

    static <T> HolderLookup.b<T> a(final ResourceKey<? extends IRegistry<? extends T>> registryRef, final Lifecycle lifecycle, HolderOwner<T> owner, final Map<ResourceKey<T>, Holder.c<T>> entries) {
        return new e<T>(owner){

            @Override
            @Override
            public ResourceKey<? extends IRegistry<? extends T>> g() {
                return registryRef;
            }

            @Override
            @Override
            public Lifecycle h() {
                return lifecycle;
            }

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return Optional.ofNullable((Holder.c)entries.get(key));
            }

            @Override
            @Override
            public Stream<Holder.c<T>> c() {
                return entries.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, i<T> bootstrapFunction) {
        this.a.add(new k<T>(registryRef, lifecycle, bootstrapFunction));
        return this;
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, i<T> bootstrapFunction) {
        return this.a(registryRef, Lifecycle.stable(), bootstrapFunction);
    }

    private b b(IRegistryCustom registryManager) {
        b buildState = b.a(registryManager, this.a.stream().map(k::a));
        this.a.forEach(registry -> registry.b(buildState));
        return buildState;
    }

    private static HolderLookup.a a(m entryOwner, IRegistryCustom registryManager, Stream<HolderLookup.b<?>> wrappers) {
        record A<T>(HolderLookup.b<T> a, RegistryOps.b<T> b) {
            public static <T> A<T> a(HolderLookup.b<T> wrapper) {
                return new A<T>(new d<T>(wrapper, wrapper), RegistryOps.b.a(wrapper));
            }

            public static <T> A<T> a(m owner, HolderLookup.b<T> wrapper) {
                return new A(new d(owner.a(), wrapper), new RegistryOps.b(owner.a(), wrapper, wrapper.h()));
            }

            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "lookup;opsInfo", "a", "b"}, this, object);
            }
        }
        final HashMap map = new HashMap();
        registryManager.a().forEach(registry -> map.put(registry.a(), A.a(registry.b())));
        wrappers.forEach(wrapper -> map.put(wrapper.g(), A.a(entryOwner, wrapper)));
        return new HolderLookup.a(){

            @Override
            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                return map.keySet().stream();
            }

            <T> Optional<A<T>> e(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return Optional.ofNullable((A)map.get(registryRef));
            }

            @Override
            public <T> Optional<HolderLookup.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return this.e(registryRef).map(A::a);
            }

            @Override
            @Override
            public <V> RegistryOps<V> a(DynamicOps<V> delegate) {
                return RegistryOps.a(delegate, new RegistryOps.c(){

                    @Override
                    @Override
                    public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                        return this.e(registryRef).map(A::b);
                    }
                });
            }
        };
    }

    public HolderLookup.a a(IRegistryCustom registryManager) {
        b buildState = this.b(registryManager);
        Stream<HolderLookup.b<?>> stream = this.a.stream().map(info -> info.a(buildState).a(buildState.a));
        HolderLookup.a provider = RegistrySetBuilder.a(buildState.a, registryManager, stream);
        buildState.c();
        buildState.b();
        buildState.d();
        return provider;
    }

    private HolderLookup.a a(IRegistryCustom registryManager, HolderLookup.a base, Cloner.a cloneableRegistries, Map<ResourceKey<? extends IRegistry<?>>, j<?>> initializedRegistries, HolderLookup.a patches) {
        m universalOwner = new m();
        MutableObject mutableObject = new MutableObject();
        List list = initializedRegistries.keySet().stream().map(registryRef -> this.a((HolderOwner)universalOwner, cloneableRegistries, (ResourceKey)registryRef, patches, base, (MutableObject<HolderLookup.a>)mutableObject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.a provider = RegistrySetBuilder.a(universalOwner, registryManager, list.stream());
        mutableObject.setValue((Object)provider);
        return provider;
    }

    private <T> HolderLookup.b<T> a(HolderOwner<T> owner, Cloner.a cloneableRegistries, ResourceKey<? extends IRegistry<? extends T>> registryRef, HolderLookup.a patches, HolderLookup.a base, MutableObject<HolderLookup.a> lazyWrapper) {
        Cloner cloner = cloneableRegistries.a(registryRef);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(registryRef.a()));
        }
        HashMap map = new HashMap();
        HolderLookup.b registryLookup = patches.d(registryRef);
        registryLookup.c().forEach(entry -> {
            ResourceKey resourceKey = entry.h();
            f lazyHolder = new f(owner, resourceKey);
            lazyHolder.a = () -> cloner.a(entry.a(), patches, (HolderLookup.a)lazyWrapper.getValue());
            map.put(resourceKey, lazyHolder);
        });
        HolderLookup.b registryLookup2 = base.d(registryRef);
        registryLookup2.c().forEach(entry -> {
            ResourceKey resourceKey = entry.h();
            map.computeIfAbsent(resourceKey, key -> {
                f lazyHolder = new f(owner, resourceKey);
                lazyHolder.a = () -> cloner.a(entry.a(), base, (HolderLookup.a)lazyWrapper.getValue());
                return lazyHolder;
            });
        });
        Lifecycle lifecycle = registryLookup.h().add(registryLookup2.h());
        return RegistrySetBuilder.a(registryRef, lifecycle, owner, map);
    }

    public g a(IRegistryCustom baseRegistryManager, HolderLookup.a registries, Cloner.a cloneableRegistries) {
        b buildState = this.b(baseRegistryManager);
        HashMap map = new HashMap();
        this.a.stream().map(info -> info.a(buildState)).forEach(registry -> map.put((ResourceKey<IRegistry<?>>)registry.a, (j<?>)registry));
        Set set = baseRegistryManager.b().collect(Collectors.toUnmodifiableSet());
        registries.b().filter(key -> !set.contains(key)).forEach(key -> map.putIfAbsent((ResourceKey<IRegistry<?>>)key, new j(key, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.b<?>> stream = map.values().stream().map(registry -> registry.a(buildState.a));
        HolderLookup.a provider = RegistrySetBuilder.a(buildState.a, baseRegistryManager, stream);
        buildState.b();
        buildState.d();
        HolderLookup.a provider2 = this.a(baseRegistryManager, registries, cloneableRegistries, map, provider);
        return new g(provider2, provider);
    }

    record k<T>(ResourceKey<? extends IRegistry<T>> a, Lifecycle b, i<T> c) {
        void b(b registries) {
            this.c.run(registries.a());
        }

        public j<T> a(b registries) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, h<?>>> iterator = registries.d.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, h<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.c(this.a)) continue;
                ResourceKey<?> resourceKey2 = resourceKey;
                h<?> registeredValue = entry.getValue();
                Holder.c<Object> reference = registries.b.a.remove(resourceKey);
                map.put(resourceKey2, new n(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new j(this.a, this.b, map);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface i<T> {
        public void run(BootstrapContext<T> var1);
    }

    record b(m a, l b, Map<MinecraftKey, HolderGetter<?>> c, Map<ResourceKey<?>, h<?>> d, List<RuntimeException> e) {
        private final m a;
        private final l b;
        private final Map<MinecraftKey, HolderGetter<?>> c;
        private final Map<ResourceKey<?>, h<?>> d;
        private final List<RuntimeException> e;

        public static b a(IRegistryCustom dynamicRegistryManager, Stream<ResourceKey<? extends IRegistry<?>>> registryRefs) {
            m universalOwner = new m();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            l universalLookup = new l(universalOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            dynamicRegistryManager.a().forEach(entry -> builder.put((Object)entry.a().a(), RegistrySetBuilder.a(entry.b())));
            registryRefs.forEach(registryRef -> builder.put((Object)registryRef.a(), (Object)universalLookup));
            return new b(universalOwner, universalLookup, (Map<MinecraftKey, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> a() {
            return new BootstrapContext<T>(){

                @Override
                @Override
                public Holder.c<T> a(ResourceKey<T> key, T value, Lifecycle lifecycle) {
                    h registeredValue = d.put(key, new h(value, lifecycle));
                    if (registeredValue != null) {
                        e.add(new IllegalStateException("Duplicate registration for " + String.valueOf(key) + ", new=" + String.valueOf(value) + ", old=" + String.valueOf(registeredValue.a)));
                    }
                    return b.c(key);
                }

                @Override
                @Override
                public <S> HolderGetter<S> a(ResourceKey<? extends IRegistry<? extends S>> registryRef) {
                    return c.getOrDefault(registryRef.a(), b);
                }
            };
        }

        public void b() {
            this.d.forEach((key, value) -> this.e.add(new IllegalStateException("Orpaned value " + String.valueOf(value.a) + " for key " + String.valueOf(key))));
        }

        public void c() {
            for (ResourceKey<Object> resourceKey : this.b.a.keySet()) {
                this.e.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourceKey)));
            }
        }

        public void d() {
            if (!this.e.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.e) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this, object);
        }

        public m e() {
            return this.a;
        }

        public l f() {
            return this.b;
        }

        public Map<MinecraftKey, HolderGetter<?>> g() {
            return this.c;
        }

        public Map<ResourceKey<?>, h<?>> h() {
            return this.d;
        }

        public List<RuntimeException> i() {
            return this.e;
        }
    }

    static class m
    implements HolderOwner<Object> {
        m() {
        }

        public <T> HolderOwner<T> a() {
            return this;
        }
    }

    public record g(HolderLookup.a a, HolderLookup.a b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "full;patches", "a", "b"}, this, object);
        }
    }

    record j<T>(ResourceKey<? extends IRegistry<? extends T>> a, Lifecycle b, Map<ResourceKey<T>, n<T>> c) {
        public HolderLookup.b<T> a(m anyOwner) {
            Map map = this.c.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                n valueAndHolder = (n)entry.getValue();
                Holder.c reference = valueAndHolder.b().orElseGet(() -> Holder.c.a(anyOwner.a(), (ResourceKey)entry.getKey()));
                reference.b(valueAndHolder.a().a());
                return reference;
            }));
            return RegistrySetBuilder.a(this.a, this.b, anyOwner.a(), map);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "key;lifecycle;values", "a", "b", "c"}, this, object);
        }
    }

    static class f<T>
    extends Holder.c<T> {
        @Nullable
        Supplier<T> a;

        protected f(HolderOwner<T> owner, @Nullable ResourceKey<T> key) {
            super(Holder.c.a.a, owner, key, null);
        }

        @Override
        @Override
        protected void b(T value) {
            super.b(value);
            this.a = null;
        }

        @Override
        @Override
        public T a() {
            if (this.a != null) {
                this.b(this.a.get());
            }
            return super.a();
        }
    }

    record n<T>(h<T> a, Optional<Holder.c<T>> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{n.class, "value;holder", "a", "b"}, this, object);
        }
    }

    record h<T>(T a, Lifecycle b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "value;lifecycle", "a", "b"}, this, object);
        }
    }

    static class l
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> a = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public l(HolderOwner<Object> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Optional<Holder.c<Object>> a(ResourceKey<Object> key) {
            return Optional.of(this.c(key));
        }

        <T> Holder.c<T> c(ResourceKey<T> key) {
            return this.a.computeIfAbsent(key, key2 -> Holder.c.a(this.d, key2));
        }
    }

    static class d<T>
    extends e<T>
    implements HolderLookup.b.a<T> {
        private final HolderLookup.b<T> a;

        d(HolderOwner<T> entryOwner, HolderLookup.b<T> base) {
            super(entryOwner);
            this.a = base;
        }

        @Override
        @Override
        public HolderLookup.b<T> a() {
            return this.a;
        }
    }

    static abstract class e<T>
    extends c<T>
    implements HolderLookup.b<T> {
        protected e(HolderOwner<T> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Stream<HolderSet.Named<T>> e() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> d;

        protected c(HolderOwner<T> entryOwner) {
            this.d = entryOwner;
        }

        @Override
        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return Optional.of(HolderSet.a(this.d, tag));
        }
    }
}

