/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.util.UndashedUuid;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;

public final class UUIDUtil {
    public static final Codec<UUID> a = Codec.INT_STREAM.comapFlatMap(uuidStream -> SystemUtils.a(uuidStream, 4).map(UUIDUtil::a), uuid -> Arrays.stream(UUIDUtil.a(uuid)));
    public static final Codec<Set<UUID>> b = Codec.list(a).xmap(Sets::newHashSet, Lists::newArrayList);
    public static final Codec<Set<UUID>> c = Codec.list(a).xmap(Sets::newLinkedHashSet, Lists::newArrayList);
    public static final Codec<UUID> d = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Invalid UUID " + string + ": " + illegalArgumentException.getMessage());
        }
    }, UUID::toString);
    public static final Codec<UUID> e = Codec.withAlternative((Codec)Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UndashedUuid.fromStringLenient((String)string), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Invalid UUID " + string + ": " + illegalArgumentException.getMessage());
        }
    }, UndashedUuid::toString), a);
    public static final Codec<UUID> f = Codec.withAlternative(a, d);
    public static final StreamCodec<ByteBuf, UUID> g = new StreamCodec<ByteBuf, UUID>(){

        @Override
        public UUID a(ByteBuf byteBuf) {
            return PacketDataSerializer.g(byteBuf);
        }

        @Override
        public void a(ByteBuf byteBuf, UUID uUID) {
            PacketDataSerializer.a(byteBuf, uUID);
        }

        @Override
        public /* synthetic */ void encode(Object buf, Object value) {
            this.a((ByteBuf)buf, (UUID)value);
        }

        @Override
        public /* synthetic */ Object decode(Object buf) {
            return this.a((ByteBuf)buf);
        }
    };
    public static final int h = 16;
    private static final String i = "OfflinePlayer:";

    private UUIDUtil() {
    }

    public static UUID a(int[] array) {
        return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
    }

    public static int[] a(UUID uuid) {
        long l2 = uuid.getMostSignificantBits();
        long m2 = uuid.getLeastSignificantBits();
        return UUIDUtil.a(l2, m2);
    }

    private static int[] a(long uuidMost, long uuidLeast) {
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    public static byte[] b(UUID uuid) {
        byte[] bs = new byte[16];
        ByteBuffer.wrap(bs).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return bs;
    }

    public static UUID a(Dynamic<?> dynamic) {
        int[] is = dynamic.asIntStream().toArray();
        if (is.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + is.length + ".");
        }
        return UUIDUtil.a(is);
    }

    public static UUID a(String nickname) {
        return UUID.nameUUIDFromBytes((i + nickname).getBytes(StandardCharsets.UTF_8));
    }

    public static GameProfile b(String nickname) {
        UUID uUID = UUIDUtil.a(nickname);
        return new GameProfile(uUID, nickname);
    }
}

