/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.cauldron;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;

public interface CauldronInteraction {
    public static final Map<String, a> a = new Object2ObjectArrayMap();
    public static final Codec<a> b = Codec.stringResolver(a::a, a::get);
    public static final a c = CauldronInteraction.a("empty");
    public static final a d = CauldronInteraction.a("water");
    public static final a e = CauldronInteraction.a("lava");
    public static final a f = CauldronInteraction.a("powder_snow");

    public static a a(String name) {
        Object2ObjectOpenHashMap object2objectopenhashmap = new Object2ObjectOpenHashMap();
        object2objectopenhashmap.defaultReturnValue((iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> EnumInteractionResult.f);
        a cauldroninteraction_a = new a(name, (Map<Item, CauldronInteraction>)object2objectopenhashmap);
        a.put(name, cauldroninteraction_a);
        return cauldroninteraction_a;
    }

    public EnumInteractionResult interact(IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, ItemStack var6, EnumDirection var7);

    public static void a() {
        Map<Item, CauldronInteraction> map = c.b();
        CauldronInteraction.a(map);
        map.put(Items.sZ, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> {
            PotionContents potioncontents = itemstack.a(DataComponents.Q);
            if (potioncontents != null && potioncontents.a(Potions.a)) {
                if (!world.C) {
                    if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, Blocks.fI.m(), entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY, false)) {
                        return EnumInteractionResult.a;
                    }
                    Item item = itemstack.h();
                    entityhuman.a(enumhand, ItemLiquidUtil.a(itemstack, entityhuman, new ItemStack(Items.sY)));
                    entityhuman.a(StatisticList.W);
                    entityhuman.b(StatisticList.c.b(item));
                    world.a((EntityHuman)null, blockposition, SoundEffects.cB, SoundCategory.e, 1.0f, 1.0f);
                    world.a((Entity)null, GameEvent.z, blockposition);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        });
        Map<Item, CauldronInteraction> map1 = d.b();
        CauldronInteraction.a(map1);
        map1.put(Items.qW, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.qX), iblockdata1 -> iblockdata1.c(LayeredCauldronBlock.g) == 3, SoundEffects.dj, hitDirection));
        map1.put(Items.sY, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> {
            if (!world.C) {
                if (!LayeredCauldronBlock.lowerFillLevel(iblockdata, world, blockposition, entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL)) {
                    return EnumInteractionResult.a;
                }
                Item item = itemstack.h();
                entityhuman.a(enumhand, ItemLiquidUtil.a(itemstack, entityhuman, PotionContents.a(Items.sZ, Potions.a)));
                entityhuman.a(StatisticList.W);
                entityhuman.b(StatisticList.c.b(item));
                world.a((EntityHuman)null, blockposition, SoundEffects.cC, SoundCategory.e, 1.0f, 1.0f);
                world.a((Entity)null, GameEvent.y, blockposition);
            }
            return EnumInteractionResult.a;
        });
        map1.put(Items.sZ, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> {
            if (iblockdata.c(LayeredCauldronBlock.g) == 3) {
                return EnumInteractionResult.f;
            }
            PotionContents potioncontents = itemstack.a(DataComponents.Q);
            if (potioncontents != null && potioncontents.a(Potions.a)) {
                if (!world.C) {
                    if (!LayeredCauldronBlock.changeLevel(iblockdata, world, blockposition, (IBlockData)iblockdata.a(LayeredCauldronBlock.g), entityhuman, CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY, false)) {
                        return EnumInteractionResult.a;
                    }
                    entityhuman.a(enumhand, ItemLiquidUtil.a(itemstack, entityhuman, new ItemStack(Items.sY)));
                    entityhuman.a(StatisticList.W);
                    entityhuman.b(StatisticList.c.b(itemstack.h()));
                    world.a((EntityHuman)null, blockposition, SoundEffects.cB, SoundCategory.e, 1.0f, 1.0f);
                    world.a((Entity)null, GameEvent.z, blockposition);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        });
        map1.put(Items.pX, CauldronInteraction::dyedItemIteration);
        map1.put(Items.pW, CauldronInteraction::dyedItemIteration);
        map1.put(Items.pV, CauldronInteraction::dyedItemIteration);
        map1.put(Items.pU, CauldronInteraction::dyedItemIteration);
        map1.put(Items.vz, CauldronInteraction::dyedItemIteration);
        map1.put(Items.oN, CauldronInteraction::dyedItemIteration);
        map1.put(Items.vF, CauldronInteraction::bannerInteraction);
        map1.put(Items.vM, CauldronInteraction::bannerInteraction);
        map1.put(Items.vU, CauldronInteraction::bannerInteraction);
        map1.put(Items.vQ, CauldronInteraction::bannerInteraction);
        map1.put(Items.vR, CauldronInteraction::bannerInteraction);
        map1.put(Items.vO, CauldronInteraction::bannerInteraction);
        map1.put(Items.vS, CauldronInteraction::bannerInteraction);
        map1.put(Items.vI, CauldronInteraction::bannerInteraction);
        map1.put(Items.vN, CauldronInteraction::bannerInteraction);
        map1.put(Items.vK, CauldronInteraction::bannerInteraction);
        map1.put(Items.vH, CauldronInteraction::bannerInteraction);
        map1.put(Items.vG, CauldronInteraction::bannerInteraction);
        map1.put(Items.vL, CauldronInteraction::bannerInteraction);
        map1.put(Items.vP, CauldronInteraction::bannerInteraction);
        map1.put(Items.vT, CauldronInteraction::bannerInteraction);
        map1.put(Items.vJ, CauldronInteraction::bannerInteraction);
        map1.put(Items.jr, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jy, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jG, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jC, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jD, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jA, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jE, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.ju, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jz, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jw, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jt, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.js, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jx, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jB, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jF, CauldronInteraction::shulkerBoxInteraction);
        map1.put(Items.jv, CauldronInteraction::shulkerBoxInteraction);
        Map<Item, CauldronInteraction> map2 = e.b();
        map2.put(Items.qW, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.qY), iblockdata1 -> true, SoundEffects.dm, hitDirection));
        CauldronInteraction.a(map2);
        Map<Item, CauldronInteraction> map3 = f.b();
        map3.put(Items.qW, (iblockdata, world, blockposition, entityhuman, enumhand, itemstack, hitDirection) -> CauldronInteraction.fillBucket(iblockdata, world, blockposition, entityhuman, enumhand, itemstack, new ItemStack(Items.qZ), iblockdata1 -> iblockdata1.c(LayeredCauldronBlock.g) == 3, SoundEffects.dn, hitDirection));
        CauldronInteraction.a(map3);
    }

    public static void a(Map<Item, CauldronInteraction> behavior) {
        behavior.put(Items.qY, CauldronInteraction::fillLavaInteraction);
        behavior.put(Items.qX, CauldronInteraction::fillWaterInteraction);
        behavior.put(Items.qZ, CauldronInteraction::fillPowderSnowInteraction);
    }

    public static EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, ItemStack output, Predicate<IBlockData> fullPredicate, SoundEffect soundEvent) {
        return CauldronInteraction.fillBucket(state, world, pos, player, hand, stack, output, fullPredicate, soundEvent, null);
    }

    public static EnumInteractionResult fillBucket(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, ItemStack output, Predicate<IBlockData> fullPredicate, SoundEffect soundEvent, @Nullable EnumDirection hitDirection) {
        if (!fullPredicate.test(state)) {
            return EnumInteractionResult.f;
        }
        if (!world.C) {
            if (hitDirection != null) {
                PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)world, player, pos, pos, hitDirection, stack, output.h(), hand);
                if (event.isCancelled()) {
                    return EnumInteractionResult.e;
                }
                ItemStack itemStack = output = event.getItemStack() != null ? CraftItemStack.asNMSCopy(event.getItemStack()) : ItemStack.j;
            }
            if (!LayeredCauldronBlock.changeLevel(state, world, pos, Blocks.fH.m(), player, CauldronLevelChangeEvent.ChangeReason.BUCKET_FILL, false)) {
                return EnumInteractionResult.a;
            }
            Item item = stack.h();
            player.a(hand, ItemLiquidUtil.a(stack, player, output));
            player.a(StatisticList.W);
            player.b(StatisticList.c.b(item));
            world.a((EntityHuman)null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
            world.a((Entity)null, GameEvent.y, pos);
        }
        return EnumInteractionResult.a;
    }

    public static EnumInteractionResult a(World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, IBlockData state, SoundEffect soundEvent) {
        return CauldronInteraction.emptyBucket(world, pos, player, hand, stack, state, soundEvent, null);
    }

    public static EnumInteractionResult emptyBucket(World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, IBlockData state, SoundEffect soundEvent, @Nullable EnumDirection hitDirection) {
        if (!world.C) {
            ItemStack output = new ItemStack(Items.qW);
            if (hitDirection != null) {
                PlayerBucketEmptyEvent event = CraftEventFactory.callPlayerBucketEmptyEvent((WorldServer)world, player, pos, pos, hitDirection, stack, hand);
                if (event.isCancelled()) {
                    return EnumInteractionResult.e;
                }
                ItemStack itemStack = output = event.getItemStack() != null ? CraftItemStack.asNMSCopy(event.getItemStack()) : ItemStack.j;
            }
            if (!LayeredCauldronBlock.changeLevel(state, world, pos, state, player, CauldronLevelChangeEvent.ChangeReason.BUCKET_EMPTY, false)) {
                return EnumInteractionResult.a;
            }
            Item item = stack.h();
            player.a(hand, ItemLiquidUtil.a(stack, player, output));
            player.a(StatisticList.V);
            player.b(StatisticList.c.b(item));
            world.a((EntityHuman)null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
            world.a((Entity)null, GameEvent.z, pos);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult fillWaterInteraction(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        return CauldronInteraction.emptyBucket(world, pos, player, hand, stack, (IBlockData)Blocks.fI.m().b(LayeredCauldronBlock.g, 3), SoundEffects.dd, hitDirection);
    }

    private static EnumInteractionResult fillLavaInteraction(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        return CauldronInteraction.a(world, pos) ? EnumInteractionResult.c : CauldronInteraction.emptyBucket(world, pos, player, hand, stack, Blocks.fJ.m(), SoundEffects.dg, hitDirection);
    }

    private static EnumInteractionResult fillPowderSnowInteraction(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        return CauldronInteraction.a(world, pos) ? EnumInteractionResult.c : CauldronInteraction.emptyBucket(world, pos, player, hand, stack, (IBlockData)Blocks.fK.m().b(LayeredCauldronBlock.g, 3), SoundEffects.dh, hitDirection);
    }

    private static EnumInteractionResult shulkerBoxInteraction(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        Block block = Block.a(stack.h());
        if (!(block instanceof BlockShulkerBox)) {
            return EnumInteractionResult.f;
        }
        if (!world.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, world, pos, player, CauldronLevelChangeEvent.ChangeReason.SHULKER_WASH)) {
                return EnumInteractionResult.a;
            }
            ItemStack itemstack1 = stack.a(Blocks.lk, 1);
            player.a(hand, ItemLiquidUtil.a(stack, player, itemstack1, false));
            player.a(StatisticList.Z);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult bannerInteraction(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        BannerPatternLayers bannerpatternlayers = stack.a(DataComponents.ai, BannerPatternLayers.a);
        if (bannerpatternlayers.b().isEmpty()) {
            return EnumInteractionResult.f;
        }
        if (!world.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, world, pos, player, CauldronLevelChangeEvent.ChangeReason.BANNER_WASH)) {
                return EnumInteractionResult.a;
            }
            ItemStack itemstack1 = stack.c(1);
            itemstack1.b(DataComponents.ai, bannerpatternlayers.a());
            player.a(hand, ItemLiquidUtil.a(stack, player, itemstack1, false));
            player.a(StatisticList.Y);
        }
        return EnumInteractionResult.a;
    }

    private static EnumInteractionResult dyedItemIteration(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, ItemStack stack, EnumDirection hitDirection) {
        if (!stack.a(TagsItem.bR)) {
            return EnumInteractionResult.f;
        }
        if (!stack.b(DataComponents.J)) {
            return EnumInteractionResult.f;
        }
        if (!world.C) {
            if (!LayeredCauldronBlock.lowerFillLevel(state, world, pos, player, CauldronLevelChangeEvent.ChangeReason.ARMOR_WASH)) {
                return EnumInteractionResult.a;
            }
            stack.c(DataComponents.J);
            player.a(StatisticList.X);
        }
        return EnumInteractionResult.a;
    }

    private static boolean a(World world, BlockPosition pos) {
        Fluid fluid = world.b_(pos.d());
        return fluid.a(TagsFluid.a);
    }

    public record a(String a, Map<Item, CauldronInteraction> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;map", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;map", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;map", "a", "b"}, this, o2);
        }
    }
}

