/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch a = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> b = Codec.dispatchedMap(net.minecraft.core.component.DataComponentPatch$b.a, b::a).xmap(map -> {
        if (map.isEmpty()) {
            return a;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            b datacomponentpatch_b = (b)entry.getKey();
            if (datacomponentpatch_b.c()) {
                reference2objectmap.put(datacomponentpatch_b.b(), Optional.empty());
                continue;
            }
            reference2objectmap.put(datacomponentpatch_b.b(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }, datacomponentpatch -> {
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(datacomponentpatch.d.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.d)) {
            DataComponentType datacomponenttype = (DataComponentType)entry.getKey();
            if (datacomponenttype.d()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                reference2objectmap.put((Object)new b(datacomponenttype, false), optional.get());
                continue;
            }
            reference2objectmap.put((Object)new b(datacomponenttype, true), (Object)Unit.a);
        }
        return reference2objectmap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> c = new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

        public DataComponentPatch a(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            DataComponentType datacomponenttype;
            int l2;
            int i2 = registryfriendlybytebuf.l();
            int j2 = registryfriendlybytebuf.l();
            if (i2 == 0 && j2 == 0) {
                return a;
            }
            int k2 = i2 + j2;
            Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(k2, 65536));
            for (l2 = 0; l2 < i2; ++l2) {
                datacomponenttype = (DataComponentType)DataComponentType.b.decode(registryfriendlybytebuf);
                Object object = datacomponenttype.e().decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.of(object));
            }
            for (l2 = 0; l2 < j2; ++l2) {
                datacomponenttype = (DataComponentType)DataComponentType.b.decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.empty());
            }
            return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
        }

        public void a(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentPatch datacomponentpatch) {
            if (datacomponentpatch.d()) {
                registryfriendlybytebuf.c(0);
                registryfriendlybytebuf.c(0);
            } else {
                int i2 = 0;
                int j2 = 0;
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.d)) {
                    if (((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isPresent()) {
                        ++i2;
                        continue;
                    }
                    ++j2;
                }
                registryfriendlybytebuf.c(i2);
                registryfriendlybytebuf.c(j2);
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.d)) {
                    Optional optional = (Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue();
                    if (!optional.isPresent()) continue;
                    DataComponentType datacomponenttype = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.b.encode(registryfriendlybytebuf, datacomponenttype);
                    1.a(registryfriendlybytebuf, datacomponenttype, optional.get());
                }
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.d)) {
                    if (!((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isEmpty()) continue;
                    DataComponentType datacomponenttype1 = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.b.encode(registryfriendlybytebuf, datacomponenttype1);
                }
            }
        }

        private static <T> void a(RegistryFriendlyByteBuf buf, DataComponentType<T> type, Object value) {
            try {
                type.e().encode(buf, value);
            }
            catch (Exception e2) {
                throw new RuntimeException("Error encoding component " + String.valueOf(type), e2);
            }
        }
    };
    private static final String e = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> d;

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents) {
        this.d = changedComponents;
    }

    public static a a() {
        return new a();
    }

    @Nullable
    public <T> Optional<? extends T> a(DataComponentType<? extends T> type) {
        return (Optional)this.d.get(type);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> b() {
        return this.d.entrySet();
    }

    public int c() {
        return this.d.size();
    }

    public DataComponentPatch a(Predicate<DataComponentType<?>> removedTypePredicate) {
        if (this.d()) {
            return a;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(this.d);
        reference2objectmap.keySet().removeIf(removedTypePredicate);
        return reference2objectmap.isEmpty() ? a : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }

    public boolean d() {
        return this.d.isEmpty();
    }

    public c e() {
        if (this.d()) {
            return net.minecraft.core.component.DataComponentPatch$c.a;
        }
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        Set set = Sets.newIdentityHashSet();
        this.d.forEach((datacomponenttype, optional) -> {
            if (optional.isPresent()) {
                datacomponentmap_a.b(datacomponenttype, optional.get());
            } else {
                set.add(datacomponenttype);
            }
        });
        return new c(datacomponentmap_a.a(), set);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DataComponentPatch) {
            DataComponentPatch datacomponentpatch = (DataComponentPatch)object;
            if (this.d.equals(datacomponentpatch.d)) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public String toString() {
        return DataComponentPatch.a(this.d);
    }

    static String a(Reference2ObjectMap<DataComponentType<?>, Optional<?>> changes) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changes)) {
            if (flag) {
                flag = false;
            } else {
                stringbuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringbuilder.append(entry.getKey());
                stringbuilder.append("=>");
                stringbuilder.append(optional.get());
                continue;
            }
            stringbuilder.append(e);
            stringbuilder.append(entry.getKey());
        }
        stringbuilder.append('}');
        return stringbuilder.toString();
    }

    public static class a {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> a = new Reference2ObjectArrayMap();

        a() {
        }

        public void copy(DataComponentPatch orig) {
            this.a.putAll(orig.d);
        }

        public void clear(DataComponentType<?> type) {
            this.a.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.a.containsKey(type);
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a patch = (a)object;
                return this.a.equals(patch.a);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public <T> a a(DataComponentType<T> type, T value) {
            this.a.put(type, Optional.of(value));
            return this;
        }

        public <T> a a(DataComponentType<T> type) {
            this.a.put(type, Optional.empty());
            return this;
        }

        public <T> a a(TypedDataComponent<T> component) {
            return this.a(component.a(), component.b());
        }

        public DataComponentPatch a() {
            return this.a.isEmpty() ? a : new DataComponentPatch(this.a);
        }
    }

    public static final class c
    extends Record {
        private final DataComponentMap b;
        private final Set<DataComponentType<?>> c;
        public static final c a = new c(DataComponentMap.a, Set.of());

        public c(DataComponentMap added, Set<DataComponentType<?>> removed) {
            this.b = added;
            this.c = removed;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this, o2);
        }

        public DataComponentMap a() {
            return this.b;
        }

        public Set<DataComponentType<?>> b() {
            return this.c;
        }
    }

    private record b(DataComponentType<?> b, boolean c) {
        public static final Codec<b> a = Codec.STRING.flatXmap(s2 -> {
            MinecraftKey minecraftkey;
            DataComponentType<?> datacomponenttype;
            boolean flag = s2.startsWith(DataComponentPatch.e);
            if (flag) {
                s2 = s2.substring(DataComponentPatch.e.length());
            }
            return (datacomponenttype = BuiltInRegistries.ao.a(minecraftkey = MinecraftKey.c(s2))) == null ? DataResult.error(() -> "No component with type: '" + String.valueOf(minecraftkey) + "'") : (datacomponenttype.d() ? DataResult.error(() -> "'" + String.valueOf(minecraftkey) + "' is not a persistent component") : DataResult.success((Object)new b(datacomponenttype, flag)));
        }, datacomponentpatch_b -> {
            DataComponentType<?> datacomponenttype = datacomponentpatch_b.b();
            MinecraftKey minecraftkey = BuiltInRegistries.ao.b(datacomponenttype);
            return minecraftkey == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(datacomponenttype)) : DataResult.success((Object)(datacomponentpatch_b.c() ? DataComponentPatch.e + String.valueOf(minecraftkey) : minecraftkey.toString()));
        });

        public Codec<?> a() {
            return this.c ? Codec.EMPTY.codec() : this.b.c();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this, o2);
        }
    }
}

