/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public final class PatchedDataComponentMap
implements DataComponentMap {
    private final DataComponentMap c;
    private Reference2ObjectMap<DataComponentType<?>, Optional<?>> d;
    private boolean e;

    public PatchedDataComponentMap(DataComponentMap baseComponents) {
        this(baseComponents, Reference2ObjectMaps.emptyMap(), true);
    }

    private PatchedDataComponentMap(DataComponentMap baseComponents, Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents, boolean copyOnWrite) {
        this.c = baseComponents;
        this.d = changedComponents;
        this.e = copyOnWrite;
    }

    public static PatchedDataComponentMap a(DataComponentMap baseComponents, DataComponentPatch changes) {
        if (PatchedDataComponentMap.a(baseComponents, changes.d)) {
            return new PatchedDataComponentMap(baseComponents, changes.d, true);
        }
        PatchedDataComponentMap patchedDataComponentMap = new PatchedDataComponentMap(baseComponents);
        patchedDataComponentMap.a(changes);
        return patchedDataComponentMap;
    }

    private static boolean a(DataComponentMap baseComponents, Reference2ObjectMap<DataComponentType<?>, Optional<?>> changedComponents) {
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changedComponents)) {
            Object object = baseComponents.a((DataComponentType)entry.getKey());
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent() && optional.get().equals(object)) {
                return false;
            }
            if (!optional.isEmpty() || object != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    @Override
    public <T> T a(DataComponentType<? extends T> type) {
        Optional optional = (Optional)this.d.get(type);
        if (optional != null) {
            return optional.orElse(null);
        }
        return this.c.a(type);
    }

    @Nullable
    public <T> T b(DataComponentType<? super T> type, @Nullable T value) {
        Optional optional2;
        this.i();
        T object = this.c.a(type);
        if (Objects.equals(value, object)) {
            Optional optional = (Optional)this.d.remove(type);
        } else {
            optional2 = (Optional)this.d.put(type, Optional.ofNullable(value));
        }
        if (optional2 != null) {
            return optional2.orElse(object);
        }
        return object;
    }

    @Nullable
    public <T> T d(DataComponentType<? extends T> type) {
        Optional optional2;
        this.i();
        T object = this.c.a(type);
        if (object != null) {
            Optional optional = (Optional)this.d.put(type, Optional.empty());
        } else {
            optional2 = (Optional)this.d.remove(type);
        }
        if (optional2 != null) {
            return optional2.orElse(null);
        }
        return object;
    }

    public void a(DataComponentPatch changes) {
        this.i();
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(changes.d)) {
            this.a((DataComponentType)entry.getKey(), (Optional)entry.getValue());
        }
    }

    private void a(DataComponentType<?> type, Optional<?> optional) {
        Object object = this.c.a(type);
        if (optional.isPresent()) {
            if (optional.get().equals(object)) {
                this.d.remove(type);
            } else {
                this.d.put(type, optional);
            }
        } else if (object != null) {
            this.d.put(type, Optional.empty());
        } else {
            this.d.remove(type);
        }
    }

    public void b(DataComponentPatch changes) {
        this.i();
        this.d.clear();
        this.d.putAll(changes.d);
    }

    public void f() {
        this.i();
        this.d.clear();
    }

    public void a(DataComponentMap components) {
        for (TypedDataComponent<?> typedDataComponent : components) {
            typedDataComponent.a(this);
        }
    }

    private void i() {
        if (this.e) {
            this.d = new Reference2ObjectArrayMap(this.d);
            this.e = false;
        }
    }

    @Override
    @Override
    public Set<DataComponentType<?>> b() {
        if (this.d.isEmpty()) {
            return this.c.b();
        }
        ReferenceArraySet set = new ReferenceArraySet(this.c.b());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                set.add((DataComponentType)entry.getKey());
                continue;
            }
            set.remove(entry.getKey());
        }
        return set;
    }

    @Override
    @Override
    public Iterator<TypedDataComponent<?>> iterator() {
        if (this.d.isEmpty()) {
            return this.c.iterator();
        }
        ArrayList<TypedDataComponent> list = new ArrayList<TypedDataComponent>(this.d.size() + this.c.d());
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            if (!((Optional)entry.getValue()).isPresent()) continue;
            list.add(TypedDataComponent.a((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get()));
        }
        for (TypedDataComponent typedDataComponent : this.c) {
            if (this.d.containsKey(typedDataComponent.a())) continue;
            list.add(typedDataComponent);
        }
        return list.iterator();
    }

    @Override
    @Override
    public int d() {
        int i2 = this.c.d();
        for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(this.d)) {
            boolean bl2;
            boolean bl = ((Optional)entry.getValue()).isPresent();
            if (bl == (bl2 = this.c.b((DataComponentType)entry.getKey()))) continue;
            i2 += bl ? 1 : -1;
        }
        return i2;
    }

    public DataComponentPatch g() {
        if (this.d.isEmpty()) {
            return DataComponentPatch.a;
        }
        this.e = true;
        return new DataComponentPatch(this.d);
    }

    public PatchedDataComponentMap h() {
        this.e = true;
        return new PatchedDataComponentMap(this.c, this.d, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PatchedDataComponentMap)) return false;
        PatchedDataComponentMap patchedDataComponentMap = (PatchedDataComponentMap)object;
        if (!this.c.equals(patchedDataComponentMap.c)) return false;
        if (!this.d.equals(patchedDataComponentMap.d)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.c.hashCode() + this.d.hashCode() * 31;
    }

    @Override
    public String toString() {
        return "{" + this.c().map(TypedDataComponent::toString).collect(Collectors.joining(", ")) + "}";
    }
}

