/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MinecartDispenseItemBehavior
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem c = new DispenseBehaviorItem();
    private final EntityTypes<? extends EntityMinecartAbstract> d;

    public MinecartDispenseItemBehavior(EntityTypes<? extends EntityMinecartAbstract> minecartEntityType) {
        this.d = minecartEntityType;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
        double d3;
        EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
        WorldServer worldserver = pointer.b();
        Vec3D vec3d = pointer.a();
        double d0 = vec3d.a() + (double)enumdirection.j() * 1.125;
        double d1 = Math.floor(vec3d.b()) + (double)enumdirection.k();
        double d2 = vec3d.c() + (double)enumdirection.l() * 1.125;
        BlockPosition blockposition = pointer.c().a(enumdirection);
        IBlockData iblockdata = worldserver.a_(blockposition);
        if (iblockdata.a(TagsBlock.P)) {
            d3 = MinecartDispenseItemBehavior.a(iblockdata).b() ? 0.6 : 0.1;
        } else {
            if (!iblockdata.l()) {
                return this.c.dispense(pointer, stack);
            }
            IBlockData iblockdata1 = worldserver.a_(blockposition.e());
            if (!iblockdata1.a(TagsBlock.P)) {
                return this.c.dispense(pointer, stack);
            }
            d3 = enumdirection != EnumDirection.a && MinecartDispenseItemBehavior.a(iblockdata1).b() ? -0.4 : -0.9;
        }
        Vec3D vec3d1 = new Vec3D(d0, d1 + d3, d2);
        net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
        CraftBlock block2 = CraftBlock.at(worldserver, pointer.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block2, (ItemStack)craftItem.clone(), new Vector(vec3d1.d, vec3d1.e, vec3d1.f));
        if (!BlockDispenser.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return stack;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.getDispenseBehavior(pointer, eventStack);
            if (idispensebehavior != IDispenseBehavior.b && idispensebehavior != this) {
                idispensebehavior.dispense(pointer, eventStack);
                return stack;
            }
        }
        itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
        EntityMinecartAbstract entityminecartabstract = EntityMinecartAbstract.a(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.d, EntitySpawnReason.o, itemstack1, null);
        if (entityminecartabstract != null && worldserver.b(entityminecartabstract) && shrink) {
            stack.h(1);
        }
        return stack;
    }

    private static BlockPropertyTrackPosition a(IBlockData state) {
        BlockPropertyTrackPosition blockpropertytrackposition;
        Block block = state.b();
        if (block instanceof BlockMinecartTrackAbstract) {
            BlockMinecartTrackAbstract blockminecarttrackabstract = (BlockMinecartTrackAbstract)block;
            blockpropertytrackposition = state.c(blockminecarttrackabstract.c());
        } else {
            blockpropertytrackposition = BlockPropertyTrackPosition.a;
        }
        return blockpropertytrackposition;
    }

    @Override
    protected void a(SourceBlock pointer) {
        pointer.b().c(1000, pointer.c(), 0);
    }
}

