/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public interface DebugReportProvider {
    public static final ToIntFunction<String> a = (ToIntFunction)SystemUtils.a(new Object2IntOpenHashMap(), map -> {
        map.put((Object)"type", 0);
        map.put((Object)"parent", 1);
        map.defaultReturnValue(2);
    });
    public static final Comparator<String> b = Comparator.comparingInt(a).thenComparing(key -> key);
    public static final Logger c = LogUtils.getLogger();

    public CompletableFuture<?> a(CachedOutput var1);

    public String a();

    public static <T> CompletableFuture<?> a(CachedOutput writer, Codec<T> codec, PackOutput.a pathResolver, Map<MinecraftKey, T> idsToValues) {
        return CompletableFuture.allOf((CompletableFuture[])idsToValues.entrySet().stream().map(entry -> DebugReportProvider.a(writer, codec, entry.getValue(), pathResolver.a((MinecraftKey)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static <T> CompletableFuture<?> a(CachedOutput writer, HolderLookup.a registries, Codec<T> codec, T value, Path path) {
        RegistryOps<JsonElement> registryOps = registries.a(JsonOps.INSTANCE);
        return DebugReportProvider.a(writer, registryOps, codec, value, path);
    }

    public static <T> CompletableFuture<?> a(CachedOutput writer, Codec<T> codec, T value, Path path) {
        return DebugReportProvider.a(writer, (DynamicOps<JsonElement>)JsonOps.INSTANCE, codec, value, path);
    }

    private static <T> CompletableFuture<?> a(CachedOutput writer, DynamicOps<JsonElement> ops, Codec<T> codec, T value, Path path) {
        JsonElement jsonElement = (JsonElement)codec.encodeStart(ops, value).getOrThrow();
        return DebugReportProvider.a(writer, jsonElement, path);
    }

    public static CompletableFuture<?> a(CachedOutput writer, JsonElement json, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("  ");
                    ChatDeserializer.a(jsonWriter, json, b);
                }
                writer.writeIfNeeded(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException iOException) {
                c.error("Failed to save file to {}", (Object)path, (Object)iOException);
            }
        }, SystemUtils.g().a("saveStable"));
    }

    @FunctionalInterface
    public static interface a<T extends DebugReportProvider> {
        public T create(PackOutput var1);
    }
}

