/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.WorldVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.advancements.packs.WinterDropAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.DatapackStructureReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.loot.packs.WinterDropLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.EquipmentModelProvider;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.recipes.packs.WinterDropRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.registries.WinterDropRegistries;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WinterDropBiomeTagsProvider;
import net.minecraft.data.tags.WinterDropBlockTagsProvider;
import net.minecraft.data.tags.WinterDropEntityTypeTagsProvider;
import net.minecraft.data.tags.WinterDropItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @DontObfuscate
    public static void main(String[] args) throws IOException {
        SharedConstants.a();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec2 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder optionSpec3 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder optionSpec4 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionSpec5 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder optionSpec6 = optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionSpec7 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec8 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionSpec9 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(args);
        if (optionSet.has((OptionSpec)optionSpec) || !optionSet.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path path = Paths.get((String)optionSpec8.value(optionSet), new String[0]);
        boolean bl = optionSet.has((OptionSpec)optionSpec7);
        boolean bl2 = bl || optionSet.has((OptionSpec)optionSpec3);
        boolean bl3 = bl || optionSet.has((OptionSpec)optionSpec2);
        boolean bl4 = bl || optionSet.has((OptionSpec)optionSpec4);
        boolean bl5 = bl || optionSet.has((OptionSpec)optionSpec5);
        boolean bl6 = bl || optionSet.has((OptionSpec)optionSpec6);
        DataGenerator dataGenerator = Main.a(path, optionSet.valuesOf((OptionSpec)optionSpec9).stream().map(input -> Paths.get(input, new String[0])).collect(Collectors.toList()), bl2, bl3, bl4, bl5, bl6, SharedConstants.b(), true);
        dataGenerator.a();
    }

    private static <T extends DebugReportProvider> DebugReportProvider.a<T> a(BiFunction<PackOutput, CompletableFuture<HolderLookup.a>, T> baseFactory, CompletableFuture<HolderLookup.a> registriesFuture) {
        return output -> (DebugReportProvider)baseFactory.apply(output, registriesFuture);
    }

    public static DataGenerator a(Path output2, Collection<Path> inputs, boolean includeClient, boolean includeServer, boolean includeDev, boolean includeReports, boolean validate, WorldVersion gameVersion, boolean ignoreCache) {
        DataGenerator dataGenerator = new DataGenerator(output2, gameVersion, ignoreCache);
        DataGenerator.a packGenerator = dataGenerator.a(includeClient || includeServer);
        packGenerator.a(outputx -> new SnbtToNbt(outputx, inputs).a(new StructureUpdater()));
        CompletableFuture<HolderLookup.a> completableFuture = CompletableFuture.supplyAsync(VanillaRegistries::a, SystemUtils.g());
        DataGenerator.a packGenerator2 = dataGenerator.a(includeClient);
        packGenerator2.a(ModelProvider::new);
        packGenerator2.a(EquipmentModelProvider::new);
        DataGenerator.a packGenerator3 = dataGenerator.a(includeServer);
        packGenerator3.a(Main.a(RegistriesDatapackGenerator::new, completableFuture));
        packGenerator3.a(Main.a(VanillaAdvancementProvider::a, completableFuture));
        packGenerator3.a(Main.a(VanillaLootTableProvider::a, completableFuture));
        packGenerator3.a(Main.a(VanillaRecipeProvider.a::new, completableFuture));
        TagsProvider tagsProvider = packGenerator3.a(Main.a(VanillaBlockTagsProvider::new, completableFuture));
        TagsProvider tagsProvider2 = packGenerator3.a(outputx -> new VanillaItemTagsProvider(outputx, completableFuture, tagsProvider.c()));
        TagsProvider tagsProvider3 = packGenerator3.a(Main.a(BiomeTagsProvider::new, completableFuture));
        TagsProvider tagsProvider4 = packGenerator3.a(Main.a(BannerPatternTagsProvider::new, completableFuture));
        TagsProvider tagsProvider5 = packGenerator3.a(Main.a(StructureTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(CatVariantTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(DamageTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(EntityTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(FlatLevelGeneratorPresetTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(FluidTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(GameEventTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(InstrumentTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(PaintingVariantTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(PoiTypeTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(WorldPresetTagsProvider::new, completableFuture));
        packGenerator3.a(Main.a(VanillaEnchantmentTagsProvider::new, completableFuture));
        DataGenerator.a packGenerator4 = dataGenerator.a(includeDev);
        packGenerator4.a(outputx -> new DebugReportNBT(outputx, inputs));
        DataGenerator.a packGenerator5 = dataGenerator.a(includeReports);
        packGenerator5.a(Main.a(BiomeParametersDumpReport::new, completableFuture));
        packGenerator5.a(Main.a(ItemListReport::new, completableFuture));
        packGenerator5.a(Main.a(BlockListReport::new, completableFuture));
        packGenerator5.a(Main.a(CommandsReport::new, completableFuture));
        packGenerator5.a(RegistryDumpReport::new);
        packGenerator5.a(PacketReport::new);
        packGenerator5.a(DatapackStructureReport::new);
        CompletableFuture<RegistrySetBuilder.g> completableFuture2 = TradeRebalanceRegistries.a(completableFuture);
        CompletionStage completableFuture3 = completableFuture2.thenApply(RegistrySetBuilder.g::b);
        DataGenerator.a packGenerator6 = dataGenerator.a(includeServer, "trade_rebalance");
        packGenerator6.a(Main.a(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.a>)completableFuture3));
        packGenerator6.a(outputx -> PackMetadataGenerator.a(outputx, IChatBaseComponent.c("dataPack.trade_rebalance.description"), FeatureFlagSet.a(FeatureFlags.c)));
        packGenerator6.a(Main.a(TradeRebalanceLootTableProvider::a, completableFuture));
        packGenerator6.a(Main.a(TradeRebalanceStructureTagsProvider::new, completableFuture));
        packGenerator6.a(Main.a(TradeRebalanceEnchantmentTagsProvider::new, completableFuture));
        DataGenerator.a packGenerator7 = dataGenerator.a(includeServer, "redstone_experiments");
        packGenerator7.a(outputx -> PackMetadataGenerator.a(outputx, IChatBaseComponent.c("dataPack.redstone_experiments.description"), FeatureFlagSet.a(FeatureFlags.d)));
        DataGenerator.a packGenerator8 = dataGenerator.a(includeServer, "minecart_improvements");
        packGenerator8.a(outputx -> PackMetadataGenerator.a(outputx, IChatBaseComponent.c("dataPack.minecart_improvements.description"), FeatureFlagSet.a(FeatureFlags.e)));
        CompletableFuture<RegistrySetBuilder.g> completableFuture4 = WinterDropRegistries.a(completableFuture);
        CompletionStage completableFuture5 = completableFuture4.thenApply(RegistrySetBuilder.g::a);
        DataGenerator.a packGenerator9 = dataGenerator.a(includeServer, "winter_drop");
        packGenerator9.a(Main.a(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.a>)completableFuture4.thenApply(RegistrySetBuilder.g::b)));
        packGenerator9.a(Main.a(WinterDropRecipeProvider.a::new, (CompletableFuture<HolderLookup.a>)completableFuture5));
        TagsProvider tagsProvider6 = packGenerator9.a(arg_0 -> Main.b((CompletableFuture)completableFuture5, tagsProvider, arg_0));
        packGenerator9.a(arg_0 -> Main.a((CompletableFuture)completableFuture5, tagsProvider2, tagsProvider6, arg_0));
        packGenerator9.a(arg_0 -> Main.a((CompletableFuture)completableFuture5, tagsProvider3, arg_0));
        packGenerator9.a(Main.a(WinterDropLootTableProvider::a, (CompletableFuture<HolderLookup.a>)completableFuture5));
        packGenerator9.a(output -> PackMetadataGenerator.a(output, IChatBaseComponent.c("dataPack.winter_drop.description"), FeatureFlagSet.a(FeatureFlags.b)));
        packGenerator9.a(Main.a(WinterDropEntityTypeTagsProvider::new, (CompletableFuture<HolderLookup.a>)completableFuture5));
        packGenerator9.a(Main.a(WinterDropAdvancementProvider::a, (CompletableFuture<HolderLookup.a>)completableFuture5));
        return dataGenerator;
    }

    private static /* synthetic */ WinterDropBiomeTagsProvider a(CompletableFuture completableFuture, TagsProvider tagsProvider, PackOutput output) {
        return new WinterDropBiomeTagsProvider(output, completableFuture, tagsProvider.c());
    }

    private static /* synthetic */ WinterDropItemTagsProvider a(CompletableFuture completableFuture, TagsProvider tagsProvider, TagsProvider tagsProvider2, PackOutput output) {
        return new WinterDropItemTagsProvider(output, completableFuture, tagsProvider.c(), tagsProvider2.c());
    }

    private static /* synthetic */ WinterDropBlockTagsProvider b(CompletableFuture completableFuture, TagsProvider tagsProvider, PackOutput outout) {
        return new WinterDropBlockTagsProvider(outout, completableFuture, tagsProvider.c());
    }
}

