/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.INamable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFlowerPot;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.a a;
    protected final Set<Item> b;
    protected final FeatureFlagSet c;
    protected final Map<ResourceKey<LootTable>, LootTable.a> d;
    protected static final float[] e = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] f = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    protected LootItemCondition.a a() {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(ItemSubPredicates.b, ItemEnchantmentsPredicate.a(List.of(new CriterionConditionEnchantments(registryLookup.b(Enchantments.v), CriterionConditionValue.IntegerRange.b(1))))));
    }

    protected LootItemCondition.a b() {
        return this.a().invert();
    }

    protected LootItemCondition.a c() {
        return LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(this.a.d(Registries.K), Items.sJ));
    }

    private LootItemCondition.a f() {
        return this.c().or(this.a());
    }

    private LootItemCondition.a g() {
        return this.f().invert();
    }

    protected BlockLootSubProvider(Set<Item> explosionImmuneItems, FeatureFlagSet requiredFeatures, HolderLookup.a registries) {
        this(explosionImmuneItems, requiredFeatures, new HashMap<ResourceKey<LootTable>, LootTable.a>(), registries);
    }

    protected BlockLootSubProvider(Set<Item> explosionImmuneItems, FeatureFlagSet requiredFeatures, Map<ResourceKey<LootTable>, LootTable.a> lootTables, HolderLookup.a registries) {
        this.b = explosionImmuneItems;
        this.c = requiredFeatures;
        this.d = lootTables;
        this.a = registries;
    }

    protected <T extends LootItemFunctionUser<T>> T a(IMaterial drop, LootItemFunctionUser<T> builder) {
        if (!this.b.contains(drop.j())) {
            return builder.b(LootItemFunctionExplosionDecay.c());
        }
        return builder.c();
    }

    protected <T extends LootItemConditionUser<T>> T a(IMaterial drop, LootItemConditionUser<T> builder) {
        if (!this.b.contains(drop.j())) {
            return builder.b(LootItemConditionSurvivesExplosion.c());
        }
        return builder.d();
    }

    public LootTable.a a(IMaterial drop) {
        return LootTable.b().a(this.a(drop, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(drop))));
    }

    private static LootTable.a a(Block drop, LootItemCondition.a conditionBuilder, LootEntryAbstract.a<?> child) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootSelectorEntry.a)LootItem.a(drop).a(conditionBuilder)).a(child)));
    }

    protected LootTable.a a(Block block, LootEntryAbstract.a<?> loot) {
        return BlockLootSubProvider.a(block, this.a(), loot);
    }

    protected LootTable.a b(Block block, LootEntryAbstract.a<?> loot) {
        return BlockLootSubProvider.a(block, this.c(), loot);
    }

    protected LootTable.a c(Block block, LootEntryAbstract.a<?> loot) {
        return BlockLootSubProvider.a(block, this.f(), loot);
    }

    protected LootTable.a a(Block withSilkTouch, IMaterial withoutSilkTouch) {
        return this.a(withSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)withSilkTouch, LootItem.a(withoutSilkTouch)));
    }

    protected LootTable.a a(IMaterial drop, NumberProvider count) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a(drop, (LootItemFunctionUser)LootItem.a(drop).a(LootItemFunctionSetCount.a(count)))));
    }

    protected LootTable.a a(Block block, IMaterial drop, NumberProvider count) {
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(drop).a(LootItemFunctionSetCount.a(count))));
    }

    private LootTable.a d(IMaterial drop) {
        return LootTable.b().a(LootSelector.a().a(this.a()).a(ConstantValue.a(1.0f)).a(LootItem.a(drop)));
    }

    private LootTable.a e(IMaterial drop) {
        return LootTable.b().a(this.a((IMaterial)Blocks.gf, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(Blocks.gf)))).a(this.a(drop, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(drop))));
    }

    protected LootTable.a a(Block drop) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)LootItem.a(drop).a((LootItemFunction.a)LootItemFunctionSetCount.a(ConstantValue.a(2.0f)).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(BlockStepAbstract.b, BlockPropertySlabType.c)))))));
    }

    protected <T extends Comparable<T> & INamable> LootTable.a a(Block drop, IBlockState<T> property, T value) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(property, value))))));
    }

    protected LootTable.a b(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(CopyComponentsFunction.a(CopyComponentsFunction.b.a).a(DataComponents.g)))));
    }

    protected LootTable.a c(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(CopyComponentsFunction.a(CopyComponentsFunction.b.a).a(DataComponents.g).a(DataComponents.al).a(DataComponents.ao).a(DataComponents.ap)))));
    }

    protected LootTable.a d(Block drop) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.pc).a(LootItemFunctionSetCount.a(UniformGenerator.a(2.0f, 5.0f)))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a e(Block drop) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.oX).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 9.0f)))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a f(Block drop) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a(drop, (LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.lV).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 5.0f)))).a(LootItemFunctionApplyBonus.b(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a g(Block drop) {
        return LootTable.b().a(this.a((IMaterial)drop, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(CopyComponentsFunction.a(CopyComponentsFunction.b.a).a(DataComponents.g).a(DataComponents.h).a(DataComponents.q).a(DataComponents.ai).a(DataComponents.k)))));
    }

    protected LootTable.a h(Block drop) {
        return LootTable.b().a(LootSelector.a().a(this.a()).a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)LootItem.a(drop).a(CopyComponentsFunction.a(CopyComponentsFunction.b.a).a(DataComponents.an))).a(LootItemFunctionCopyState.a(drop).a(BlockBeehive.c))));
    }

    protected LootTable.a i(Block drop) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootEntryAbstract.a)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(drop).a(this.a())).a(CopyComponentsFunction.a(CopyComponentsFunction.b.a).a(DataComponents.an))).a(LootItemFunctionCopyState.a(drop).a(BlockBeehive.c))).a(LootItem.a(drop))));
    }

    protected LootTable.a j(Block drop) {
        return LootTable.b().a(LootSelector.a().a(LootItem.a(Items.xm)).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(CaveVines.t_, true))));
    }

    protected LootTable.a a(Block withSilkTouch, Item withoutSilkTouch) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a(withSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)withSilkTouch, (LootItemFunctionUser)LootItem.a(withoutSilkTouch).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a b(Block withSilkTouch, IMaterial withoutSilkTouch) {
        return this.a(withSilkTouch, (LootEntryAbstract.a)this.a((IMaterial)withSilkTouch, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(withoutSilkTouch).a(LootItemFunctionSetCount.a(UniformGenerator.a(-6.0f, 2.0f)))).a(LootItemFunctionLimitCount.a(IntRange.b(0)))));
    }

    protected LootTable.a k(Block withShears) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.b(withShears, (LootEntryAbstract.a)this.a((IMaterial)withShears, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.pR).a(LootItemConditionRandomChance.a(0.125f))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x), 2))));
    }

    public LootTable.a b(Block stem, Item drop) {
        return LootTable.b().a(this.a((IMaterial)stem, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)LootItem.a(drop).a(BlockStem.c.a(), (E age) -> LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, (float)(age + 1) / 15.0f)).a(LootItemConditionBlockStateProperty.a(stem).a(CriterionTriggerProperties.a.a().a(BlockStem.c, age.intValue())))))));
    }

    public LootTable.a c(Block stem, Item drop) {
        return LootTable.b().a(this.a((IMaterial)stem, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(drop).a(LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, 0.53333336f))))));
    }

    protected LootTable.a b(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.c()).a(LootItem.a(item)));
    }

    protected LootTable.a c(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.f()).a(LootItem.a(item)));
    }

    protected LootTable.a a(Block drop, LootItemCondition.a condition) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)drop, (LootItemFunctionUser)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(drop).a(condition)).a(EnumDirection.values(), (E direction) -> LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(1.0f), true).a(LootItemConditionBlockStateProperty.a(drop).a(CriterionTriggerProperties.a.a().a(MultifaceBlock.b(direction), true))))).a(LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(-1.0f), true)))));
    }

    protected LootTable.a l(Block block) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(block).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(MossyCarpetBlock.b, true))))));
    }

    protected LootTable.a a(Block leaves, Block sapling, float ... saplingChance) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.c(leaves, (LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leaves, LootItem.a(sapling))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), saplingChance))).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.g()).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leaves, (LootItemFunctionUser)LootItem.a(Items.pM).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), f))));
    }

    protected LootTable.a b(Block leaves, Block sapling, float ... saplingChance) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a(leaves, sapling, saplingChance).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.g()).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leaves, LootItem.a(Items.oQ))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), 0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f))));
    }

    protected LootTable.a m(Block leaves) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.c(leaves, (LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)Blocks.aS, (LootItemFunctionUser)LootItem.a(Items.pM).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), f)));
    }

    protected LootTable.a a(Block crop, Item product, Item seeds, LootItemCondition.a condition) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return this.a((IMaterial)crop, LootTable.b().a(LootSelector.a().a(((LootSelectorEntry.a)LootItem.a(product).a(condition)).a(LootItem.a(seeds)))).a(LootSelector.a().a(condition).a((LootEntryAbstract.a<?>)LootItem.a(seeds).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x), 0.5714286f, 3)))));
    }

    protected LootTable.a n(Block seagrass) {
        return LootTable.b().a(LootSelector.a().a(this.c()).a((LootEntryAbstract.a<?>)LootItem.a(seagrass).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))));
    }

    protected LootTable.a a(Block tallPlant, Block shortPlant) {
        HolderLookup.b<Block> registryLookup = this.a.d(Registries.f);
        LootEntryAlternatives.a builder = ((LootSelectorEntry.a)((LootEntryAbstract.a)LootItem.a(shortPlant).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))).a(this.c())).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)tallPlant, LootItem.a(Items.pR))).a(LootItemConditionRandomChance.a(0.125f)));
        return LootTable.b().a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(tallPlant).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.b))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(registryLookup, tallPlant).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a))), new BlockPosition(0, 1, 0)))).a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(tallPlant).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(registryLookup, tallPlant).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.b))), new BlockPosition(0, -1, 0))));
    }

    protected LootTable.a o(Block candle) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)candle, (LootItemFunctionUser)LootItem.a(candle).a(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), (E candles) -> LootItemFunctionSetCount.a(ConstantValue.a(candles.intValue())).a(LootItemConditionBlockStateProperty.a(candle).a(CriterionTriggerProperties.a.a().a(CandleBlock.f, candles.intValue())))))));
    }

    protected LootTable.a p(Block flowerbed) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)flowerbed, (LootItemFunctionUser)LootItem.a(flowerbed).a(IntStream.rangeClosed(1, 4).boxed().toList(), (E flowerAmount) -> LootItemFunctionSetCount.a(ConstantValue.a(flowerAmount.intValue())).a(LootItemConditionBlockStateProperty.a(flowerbed).a(CriterionTriggerProperties.a.a().a(PinkPetalsBlock.e, flowerAmount.intValue())))))));
    }

    protected static LootTable.a q(Block candleCake) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(candleCake)));
    }

    public static LootTable.a d() {
        return LootTable.b();
    }

    protected abstract void e();

    @Override
    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.a> lootTableBiConsumer) {
        this.e();
        HashSet set = new HashSet();
        for (Block block : BuiltInRegistries.e) {
            if (!block.a(this.c)) continue;
            block.u().ifPresent(lootTableKey -> {
                if (set.add(lootTableKey)) {
                    LootTable.a builder = this.d.remove(lootTableKey);
                    if (builder == null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", lootTableKey.a(), BuiltInRegistries.e.b(block)));
                    }
                    lootTableBiConsumer.accept((ResourceKey<LootTable>)lootTableKey, builder);
                }
            });
        }
        if (!this.d.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.d.keySet()));
        }
    }

    protected void b(Block vine, Block vinePlant) {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        LootTable.a builder = this.c(vine, (LootEntryAbstract.a<?>)LootItem.a(vine).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), 0.33f, 0.55f, 0.77f, 1.0f)));
        this.a(vine, builder);
        this.a(vinePlant, builder);
    }

    protected LootTable.a r(Block block) {
        return this.a(block, BlockDoor.f, BlockPropertyDoubleBlockHalf.b);
    }

    protected void s(Block block) {
        this.a(block, (Block flowerPot) -> this.e((IMaterial)((BlockFlowerPot)flowerPot).b()));
    }

    protected void c(Block block, Block drop) {
        this.a(block, this.d((IMaterial)drop));
    }

    protected void c(Block block, IMaterial drop) {
        this.a(block, this.a(drop));
    }

    protected void t(Block block) {
        this.c(block, block);
    }

    protected void u(Block block) {
        this.c(block, (IMaterial)block);
    }

    protected void a(Block block, Function<Block, LootTable.a> lootTableFunction) {
        this.a(block, lootTableFunction.apply(block));
    }

    protected void a(Block block, LootTable.a lootTable) {
        this.d.put(block.u().orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(block) + " does not have loot table")), lootTable);
    }
}

