/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.CriterionConditionDamageSource;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionEntityEquipment;
import net.minecraft.advancements.critereon.CriterionConditionEntityFlags;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;

public abstract class EntityLootSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.a a;
    private final FeatureFlagSet b;
    private final FeatureFlagSet c;
    private final Map<EntityTypes<?>, Map<ResourceKey<LootTable>, LootTable.a>> d = Maps.newHashMap();

    protected final AnyOfCondition.a a() {
        HolderLookup.b<Enchantment> registryLookup = this.a.d(Registries.aO);
        return AnyOfCondition.a(LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, CriterionConditionEntity.a.a().a(CriterionConditionEntityFlags.a.a().b(true))), LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.c, CriterionConditionEntity.a.a().a(CriterionConditionEntityEquipment.a.a().f(CriterionConditionItem.a.a().a(ItemSubPredicates.b, ItemEnchantmentsPredicate.a(List.of(new CriterionConditionEnchantments(registryLookup.b(EnchantmentTags.p), CriterionConditionValue.IntegerRange.c))))))));
    }

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures, HolderLookup.a registries) {
        this(requiredFeatures, requiredFeatures, registries);
    }

    protected EntityLootSubProvider(FeatureFlagSet requiredFeatures, FeatureFlagSet featureSet, HolderLookup.a registries) {
        this.b = requiredFeatures;
        this.c = featureSet;
        this.a = registries;
    }

    public static LootSelector.a a(Map<EnumColor, ResourceKey<LootTable>> colorLootTables) {
        LootEntryAlternatives.a builder = LootEntryAlternatives.a(new LootEntryAbstract.a[0]);
        for (Map.Entry<EnumColor, ResourceKey<LootTable>> entry : colorLootTables.entrySet()) {
            builder = builder.a((LootEntryAbstract.a<?>)NestedLootTable.a(entry.getValue()).a(LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, CriterionConditionEntity.a.a().a(SheepPredicate.a(entry.getKey())))));
        }
        return LootSelector.a().a(builder);
    }

    public abstract void b();

    @Override
    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.a> lootTableBiConsumer) {
        this.b();
        HashSet set = new HashSet();
        BuiltInRegistries.f.c().forEach(entityType -> {
            EntityTypes entityType2 = (EntityTypes)entityType.a();
            if (!entityType2.a(this.b)) {
                return;
            }
            Optional<ResourceKey<LootTable>> optional = entityType2.k();
            if (optional.isPresent()) {
                Map<ResourceKey<LootTable>, LootTable.a> map = this.d.remove(entityType2);
                if (entityType2.a(this.c) && (map == null || !map.containsKey(optional.get()))) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", optional.get(), entityType.h().a()));
                }
                if (map != null) {
                    map.forEach((tableKey, lootTableBuilder) -> {
                        if (!set.add(tableKey)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", tableKey, entityType.h().a()));
                        }
                        lootTableBiConsumer.accept((ResourceKey<LootTable>)tableKey, (LootTable.a)lootTableBuilder);
                    });
                }
            } else {
                Map<ResourceKey<LootTable>, LootTable.a> map2 = this.d.remove(entityType2);
                if (map2 != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map2.keySet().stream().map(resourceKey -> resourceKey.a().toString()).collect(Collectors.joining(",")), entityType.h().a()));
                }
            }
        });
        if (!this.d.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.d.keySet()));
        }
    }

    protected LootItemCondition.a a(HolderGetter<EntityTypes<?>> registryLookup) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(registryLookup, EntityTypes.ac)));
    }

    protected LootItemCondition.a a(HolderGetter<EntityTypes<?>> registryLookup, ResourceKey<FrogVariant> frogVariant) {
        return LootItemConditionDamageSourceProperties.a(CriterionConditionDamageSource.a.a().b(CriterionConditionEntity.a.a().a(registryLookup, EntityTypes.ac).a(EntitySubPredicates.b(BuiltInRegistries.aj.b(frogVariant)))));
    }

    protected void a(EntityTypes<?> entityType, LootTable.a lootTable) {
        this.a(entityType, entityType.k().orElseThrow(() -> new IllegalStateException("Entity " + String.valueOf(entityType) + " has no loot table")), lootTable);
    }

    protected void a(EntityTypes<?> entityType, ResourceKey<LootTable> tableKey, LootTable.a lootTable) {
        this.d.computeIfAbsent(entityType, type -> new HashMap()).put(tableKey, lootTable);
    }
}

