/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.SnifferEggBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.Tilt;

public class BlockModelGenerators {
    final Consumer<BlockStateGenerator> b;
    final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;
    private final Consumer<Item> d;
    final List<Block> e = ImmutableList.of((Object)Blocks.eL, (Object)Blocks.eR, (Object)Blocks.ip);
    final Map<Block, c> f = ImmutableMap.builder().put((Object)Blocks.b, BlockModelGenerators::a).put((Object)Blocks.te, BlockModelGenerators::c).put((Object)Blocks.fa, BlockModelGenerators::b).build();
    final Map<Block, TexturedModel> g = ImmutableMap.builder().put((Object)Blocks.bc, (Object)TexturedModel.z.get(Blocks.bc)).put((Object)Blocks.jG, (Object)TexturedModel.z.get(Blocks.jG)).put((Object)Blocks.kk, (Object)TexturedModel.a(TextureMapping.a(Blocks.bc, "_top"))).put((Object)Blocks.km, (Object)TexturedModel.a(TextureMapping.a(Blocks.jG, "_top"))).put((Object)Blocks.be, (Object)TexturedModel.d.get(Blocks.bc).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.H(Blocks.be)))).put((Object)Blocks.jI, (Object)TexturedModel.d.get(Blocks.jG).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.H(Blocks.jI)))).put((Object)Blocks.ht, (Object)TexturedModel.d.get(Blocks.ht)).put((Object)Blocks.kl, (Object)TexturedModel.a(TextureMapping.a(Blocks.ht, "_bottom"))).put((Object)Blocks.pM, (Object)TexturedModel.A.get(Blocks.pM)).put((Object)Blocks.te, (Object)TexturedModel.A.get(Blocks.te)).put((Object)Blocks.hu, (Object)TexturedModel.d.get(Blocks.hu).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.H(Blocks.hu)))).put((Object)Blocks.bd, (Object)TexturedModel.d.get(Blocks.bd).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.bc, "_top"));
        textures.a(TextureSlot.i, TextureMapping.H(Blocks.bd));
    })).put((Object)Blocks.jH, (Object)TexturedModel.d.get(Blocks.jH).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.jG, "_top"));
        textures.a(TextureSlot.i, TextureMapping.H(Blocks.jH));
    })).put((Object)Blocks.rh, (Object)TexturedModel.A.get(Blocks.rh)).put((Object)Blocks.rc, (Object)TexturedModel.A.get(Blocks.rc)).build();
    static final Map<BlockFamily.b, BiConsumer<b, Block>> h = ImmutableMap.builder().put((Object)BlockFamily.b.a, b::a).put((Object)BlockFamily.b.e, b::l).put((Object)BlockFamily.b.b, b::k).put((Object)BlockFamily.b.c, b::k).put((Object)BlockFamily.b.f, b::c).put((Object)BlockFamily.b.g, b::d).put((Object)BlockFamily.b.h, b::e).put((Object)BlockFamily.b.i, b::f).put((Object)BlockFamily.b.k, b::h).put((Object)BlockFamily.b.l, b::i).put((Object)BlockFamily.b.m, b::j).put((Object)BlockFamily.b.n, b::g).put((Object)BlockFamily.b.p, b::m).put((Object)BlockFamily.b.q, b::b).build();
    public static final List<Pair<EnumDirection, Function<MinecraftKey, Variant>>> a = List.of(Pair.of((Object)EnumDirection.c, model -> Variant.a().a(VariantProperties.c, model)), Pair.of((Object)EnumDirection.f, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)), Pair.of((Object)EnumDirection.d, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)), Pair.of((Object)EnumDirection.e, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)EnumDirection.b, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)EnumDirection.a, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    private static final Map<d, MinecraftKey> i = new HashMap<d, MinecraftKey>();

    private static BlockStateGenerator a(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.e.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation);
    }

    private static BlockStateGenerator b(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.f.a(block, textures, modelCollector);
        return BlockModelGenerators.c(block, resourceLocation);
    }

    private static BlockStateGenerator c(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.l.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation).a(BlockModelGenerators.f());
    }

    public BlockModelGenerators(Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector, Consumer<Item> simpleItemModelExemptionCollector) {
        this.b = blockStateCollector;
        this.c = modelCollector;
        this.d = simpleItemModelExemptionCollector;
    }

    void c(Block block) {
        this.d.accept(block.j());
    }

    void a(Block block, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(block.j()), new DelegatedModel(parentModelId));
    }

    private void a(Item item, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(item), new DelegatedModel(parentModelId));
    }

    void a(Item item) {
        ModelTemplates.bC.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void d(Block block) {
        Item item = block.j();
        if (item != Items.a) {
            ModelTemplates.bC.a(ModelLocationUtils.a(item), TextureMapping.G(block), this.c);
        }
    }

    private void a(Block block, String textureSuffix) {
        Item item = block.j();
        ModelTemplates.bC.a(ModelLocationUtils.a(item), TextureMapping.k(TextureMapping.a(block, textureSuffix)), this.c);
    }

    private static PropertyDispatch b() {
        return PropertyDispatch.a(BlockProperties.S).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a());
    }

    private static PropertyDispatch c() {
        return PropertyDispatch.a(BlockProperties.S).a(EnumDirection.d, Variant.a()).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch d() {
        return PropertyDispatch.a(BlockProperties.S).a(EnumDirection.f, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch e() {
        return PropertyDispatch.a(BlockProperties.Q).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.b, Variant.a().a(VariantProperties.a, VariantProperties.a.d)).a(EnumDirection.c, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b));
    }

    private static MultiVariantGenerator b(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, BlockModelGenerators.a(modelId));
    }

    private static Variant[] a(MinecraftKey modelId) {
        return new Variant[]{Variant.a().a(VariantProperties.c, modelId), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.d)};
    }

    private static MultiVariantGenerator a(Block block, MinecraftKey firstModelId, MinecraftKey secondModelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, firstModelId), Variant.a().a(VariantProperties.c, secondModelId), Variant.a().a(VariantProperties.c, firstModelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, secondModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static PropertyDispatch a(BlockStateBoolean property, MinecraftKey trueModel, MinecraftKey falseModel) {
        return PropertyDispatch.a(property).a((Boolean)true, Variant.a().a(VariantProperties.c, trueModel)).a((Boolean)false, Variant.a().a(VariantProperties.c, falseModel));
    }

    private void e(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.c.create(block, this.c);
        this.b.accept(BlockModelGenerators.a(block, resourceLocation, resourceLocation2));
    }

    private void f(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        this.b.accept(BlockModelGenerators.b(block, resourceLocation));
    }

    private void g(Block block) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.bw).a((T1 dusted) -> {
            String string = "_" + dusted;
            MinecraftKey resourceLocation = TextureMapping.a(block, string);
            return Variant.a().a(VariantProperties.c, ModelTemplates.c.a(block, string, new TextureMapping().a(TextureSlot.a, resourceLocation), this.c));
        })));
        this.a(block, TextureMapping.a(block, "_0"));
    }

    static BlockStateGenerator b(Block buttonBlock, MinecraftKey regularModelId, MinecraftKey pressedModelId) {
        return MultiVariantGenerator.a(buttonBlock).a(PropertyDispatch.a(BlockProperties.x).a((Boolean)false, Variant.a().a(VariantProperties.c, regularModelId)).a((Boolean)true, Variant.a().a(VariantProperties.c, pressedModelId))).a(PropertyDispatch.a(BlockProperties.V, BlockProperties.S).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c)));
    }

    private static PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> a(PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> variantMap, BlockPropertyDoubleBlockHalf targetHalf, MinecraftKey leftHingeClosedModelId, MinecraftKey leftHingeOpenModelId, MinecraftKey rightHingeClosedModelId, MinecraftKey rightHingeOpenModelId) {
        return variantMap.a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static BlockStateGenerator a(Block doorBlock, MinecraftKey bottomLeftHingeClosedModelId, MinecraftKey bottomLeftHingeOpenModelId, MinecraftKey bottomRightHingeClosedModelId, MinecraftKey bottomRightHingeOpenModelId, MinecraftKey topLeftHingeClosedModelId, MinecraftKey topLeftHingeOpenModelId, MinecraftKey topRightHingeClosedModelId, MinecraftKey topRightHingeOpenModelId) {
        return MultiVariantGenerator.a(doorBlock).a(BlockModelGenerators.a(BlockModelGenerators.a(PropertyDispatch.a(BlockProperties.S, BlockProperties.af, BlockProperties.bf, BlockProperties.v), BlockPropertyDoubleBlockHalf.b, bottomLeftHingeClosedModelId, bottomLeftHingeOpenModelId, bottomRightHingeClosedModelId, bottomRightHingeOpenModelId), BlockPropertyDoubleBlockHalf.a, topLeftHingeClosedModelId, topLeftHingeOpenModelId, topRightHingeClosedModelId, topRightHingeOpenModelId));
    }

    static BlockStateGenerator a(Block customFenceBlock, MinecraftKey postModelId, MinecraftKey northModelId, MinecraftKey eastModelId, MinecraftKey southModelId, MinecraftKey westModelId) {
        return MultiPartGenerator.a(customFenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, northModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, eastModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, southModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, westModelId).a(VariantProperties.d, false));
    }

    static BlockStateGenerator c(Block fenceBlock, MinecraftKey postModelId, MinecraftKey sideModelId) {
        return MultiPartGenerator.a(fenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block wallBlock, MinecraftKey postModelId, MinecraftKey lowSideModelId, MinecraftKey tallSideModelId) {
        return MultiPartGenerator.a(wallBlock).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.aa, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.aa, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block fenceGateBlock, MinecraftKey openModelId, MinecraftKey closedModelId, MinecraftKey openWallModelId, MinecraftKey closedWallModelId, boolean uvlock) {
        return MultiVariantGenerator.a(fenceGateBlock, Variant.a().a(VariantProperties.d, uvlock)).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.q, BlockProperties.v).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, closedModelId)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, closedWallModelId)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, openWallModelId)));
    }

    static BlockStateGenerator b(Block stairsBlock, MinecraftKey innerModelId, MinecraftKey regularModelId, MinecraftKey outerModelId) {
        return MultiVariantGenerator.a(stairsBlock).a(PropertyDispatch.a(BlockProperties.S, BlockProperties.ag, BlockProperties.bj).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)));
    }

    private static BlockStateGenerator c(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.S, BlockProperties.ag, BlockProperties.v).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.a)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private static BlockStateGenerator d(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.S, BlockProperties.ag, BlockProperties.v).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)));
    }

    static MultiVariantGenerator c(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId));
    }

    private static PropertyDispatch f() {
        return PropertyDispatch.a(BlockProperties.J).a(EnumDirection.EnumAxis.b, Variant.a()).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    static BlockStateGenerator a(Block block, TextureMapping textureMap, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.g.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation2 = ModelTemplates.h.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation3 = ModelTemplates.i.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation4 = ModelTemplates.j.a(block, textureMap, modelCollector);
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation4)).a(PropertyDispatch.a(BlockProperties.J).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, resourceLocation3)));
    }

    static BlockStateGenerator d(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId)).a(BlockModelGenerators.f());
    }

    private void e(Block block, MinecraftKey modelId) {
        this.b.accept(BlockModelGenerators.d(block, modelId));
    }

    public void a(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation));
    }

    private void c(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    static BlockStateGenerator d(Block block, MinecraftKey verticalModelId, MinecraftKey horizontalModelId) {
        return MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.J).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, verticalModelId)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private void a(Block block, TexturedModel.a verticalModelFactory, TexturedModel.a horizontalModelFactory) {
        MinecraftKey resourceLocation = verticalModelFactory.create(block, this.c);
        MinecraftKey resourceLocation2 = horizontalModelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation, resourceLocation2));
    }

    private void h(Block block) {
        Function<TexturedModel.a, MinecraftKey> function = factory -> factory.updateTexture(textureMap -> textureMap.a(TextureSlot.i, TextureMapping.a(block, "_active"))).updateTexture(textureMap -> textureMap.a(TextureSlot.d, TextureMapping.a(block, "_top_active"))).createWithSuffix(block, "_active", this.c);
        MinecraftKey resourceLocation = TexturedModel.x.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.y.create(block, this.c);
        MinecraftKey resourceLocation3 = function.apply(TexturedModel.x);
        MinecraftKey resourceLocation4 = function.apply(TexturedModel.y);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.J, CreakingHeartBlock.c).a(EnumDirection.EnumAxis.b, CreakingHeartBlock.a.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.EnumAxis.c, CreakingHeartBlock.a.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, CreakingHeartBlock.a.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.EnumAxis.b, CreakingHeartBlock.a.b, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.EnumAxis.c, CreakingHeartBlock.a.b, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, CreakingHeartBlock.a.b, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.EnumAxis.b, CreakingHeartBlock.a.c, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.EnumAxis.c, CreakingHeartBlock.a.c, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, CreakingHeartBlock.a.c, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b))));
    }

    private MinecraftKey a(Block block, String suffix, ModelTemplate model, Function<MinecraftKey, TextureMapping> texturesFactory) {
        return model.a(block, suffix, texturesFactory.apply(TextureMapping.a(block, suffix)), this.c);
    }

    static BlockStateGenerator e(Block pressurePlateBlock, MinecraftKey upModelId, MinecraftKey downModelId) {
        return MultiVariantGenerator.a(pressurePlateBlock).a(BlockModelGenerators.a(BlockProperties.x, downModelId, upModelId));
    }

    static BlockStateGenerator e(Block slabBlock, MinecraftKey bottomModelId, MinecraftKey topModelId, MinecraftKey fullModelId) {
        return MultiVariantGenerator.a(slabBlock).a(PropertyDispatch.a(BlockProperties.bi).a(BlockPropertySlabType.b, Variant.a().a(VariantProperties.c, bottomModelId)).a(BlockPropertySlabType.a, Variant.a().a(VariantProperties.c, topModelId)).a(BlockPropertySlabType.c, Variant.a().a(VariantProperties.c, fullModelId)));
    }

    public void a(Block block) {
        this.b(block, TexturedModel.a);
    }

    public void b(Block block, TexturedModel.a modelFactory) {
        this.b.accept(BlockModelGenerators.c(block, modelFactory.create(block, this.c)));
    }

    private void a(Block block, TextureMapping textures, ModelTemplate model) {
        MinecraftKey resourceLocation = model.a(block, textures, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private b i(Block block) {
        TexturedModel texturedModel = this.g.getOrDefault(block, TexturedModel.a.get(block));
        return new b(texturedModel.b()).a(block, texturedModel.a());
    }

    public void a(Block strippedLog, Block hangingSign, Block wallHangingSign) {
        TextureMapping textureMapping = TextureMapping.v(strippedLog);
        MinecraftKey resourceLocation = ModelTemplates.aa.a(hangingSign, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(hangingSign, resourceLocation));
        this.b.accept(BlockModelGenerators.c(wallHangingSign, resourceLocation));
        this.a(hangingSign.j());
        this.c(wallHangingSign);
    }

    void j(Block doorBlock) {
        TextureMapping textureMapping = TextureMapping.u(doorBlock);
        MinecraftKey resourceLocation = ModelTemplates.v.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.w.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.x.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.y.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.z.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.A.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.B.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.C.a(doorBlock, textureMapping, this.c);
        this.a(doorBlock.j());
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8));
    }

    private void a(Block parent, Block doorBlock) {
        MinecraftKey resourceLocation = ModelTemplates.v.a(parent);
        MinecraftKey resourceLocation2 = ModelTemplates.w.a(parent);
        MinecraftKey resourceLocation3 = ModelTemplates.x.a(parent);
        MinecraftKey resourceLocation4 = ModelTemplates.y.a(parent);
        MinecraftKey resourceLocation5 = ModelTemplates.z.a(parent);
        MinecraftKey resourceLocation6 = ModelTemplates.A.a(parent);
        MinecraftKey resourceLocation7 = ModelTemplates.B.a(parent);
        MinecraftKey resourceLocation8 = ModelTemplates.C.a(parent);
        this.a(doorBlock, ModelLocationUtils.a(parent.j()));
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8));
    }

    void k(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.ak.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.al.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.am.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    void l(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.ah.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ai.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aj.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    private void b(Block parent, Block trapdoorBlock) {
        MinecraftKey resourceLocation = ModelTemplates.ah.a(parent);
        MinecraftKey resourceLocation2 = ModelTemplates.ai.a(parent);
        MinecraftKey resourceLocation3 = ModelTemplates.aj.a(parent);
        this.a(trapdoorBlock, ModelLocationUtils.a(parent.j()));
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
    }

    private void g() {
        this.c(Blocks.sY);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.sY);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.sY, "_partial_tilt");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.sY, "_full_tilt");
        this.b.accept(MultiVariantGenerator.a(Blocks.sY).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.bm).a(Tilt.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.b, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(Tilt.d, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private f m(Block logBlock) {
        return new f(TextureMapping.o(logBlock));
    }

    private void n(Block block) {
        this.c(block, block);
    }

    private void c(Block block, Block modelReference) {
        this.b.accept(BlockModelGenerators.c(block, ModelLocationUtils.a(modelReference)));
    }

    private void a(Block block, e tintType) {
        this.d(block);
        this.b(block, tintType);
    }

    private void a(Block block, e tintType, TextureMapping texture) {
        this.d(block);
        this.b(block, tintType, texture);
    }

    private void b(Block block, e tintType) {
        TextureMapping textureMapping = TextureMapping.c(block);
        this.b(block, tintType, textureMapping);
    }

    private void b(Block block, e tintType, TextureMapping crossTexture) {
        MinecraftKey resourceLocation = tintType.a().a(block, crossTexture, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void a(Block block, e tintType, IBlockState<Integer> stageProperty, int ... stages) {
        if (stageProperty.a().size() != stages.length) {
            throw new IllegalArgumentException("missing values for property: " + String.valueOf(stageProperty));
        }
        PropertyDispatch propertyDispatch = PropertyDispatch.a(stageProperty).a((T1 stage) -> {
            String string = "_stage" + stages[stage];
            TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(block, string));
            MinecraftKey resourceLocation = tintType.a().a(block, string, textureMapping, this.c);
            return Variant.a().a(VariantProperties.c, resourceLocation);
        });
        this.a(block.j());
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void a(Block plantBlock, Block flowerPotBlock, e tintType) {
        this.a(plantBlock, tintType);
        TextureMapping textureMapping = TextureMapping.e(plantBlock);
        MinecraftKey resourceLocation = tintType.b().a(flowerPotBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(flowerPotBlock, resourceLocation));
    }

    private void d(Block coralFanBlock, Block coralWallFanBlock) {
        TexturedModel texturedModel = TexturedModel.q.get(coralFanBlock);
        MinecraftKey resourceLocation = texturedModel.a(coralFanBlock, this.c);
        this.b.accept(BlockModelGenerators.c(coralFanBlock, resourceLocation));
        MinecraftKey resourceLocation2 = ModelTemplates.aD.a(coralWallFanBlock, texturedModel.b(), this.c);
        this.b.accept(MultiVariantGenerator.a(coralWallFanBlock, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockModelGenerators.b()));
        this.d(coralFanBlock);
    }

    private void e(Block stemBlock, Block attachedStemBlock) {
        this.a(stemBlock.j());
        TextureMapping textureMapping = TextureMapping.i(stemBlock);
        TextureMapping textureMapping2 = TextureMapping.a(stemBlock, attachedStemBlock);
        MinecraftKey resourceLocation = ModelTemplates.aV.a(attachedStemBlock, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(attachedStemBlock, Variant.a().a(VariantProperties.c, resourceLocation)).a(PropertyDispatch.a(BlockProperties.S).a(EnumDirection.e, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.c))));
        this.b.accept(MultiVariantGenerator.a(stemBlock).a(PropertyDispatch.a(BlockProperties.aw).a((T1 age) -> Variant.a().a(VariantProperties.c, ModelTemplates.aU[age].a(stemBlock, textureMapping, this.c)))));
    }

    private void h() {
        Block block = Blocks.kX;
        this.a(block.j());
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block, "_bottom");
        this.f(block, resourceLocation, resourceLocation2);
    }

    private void i() {
        Block block = Blocks.kW;
        this.a(block.j());
        PropertyDispatch propertyDispatch = PropertyDispatch.a(PitcherCropBlock.d, BlockProperties.af).a((T1 age, T2 half) -> switch (half) {
            default -> throw new MatchException(null, null);
            case BlockPropertyDoubleBlockHalf.a -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block, "_top_stage_" + age));
            case BlockPropertyDoubleBlockHalf.b -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block, "_bottom_stage_" + age));
        });
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void a(Block coral, Block deadCoral, Block coralBlock, Block deadCoralBlock, Block coralFan, Block deadCoralFan, Block coralWallFan, Block deadCoralWallFan) {
        this.a(coral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(deadCoral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(coralBlock);
        this.a(deadCoralBlock);
        this.d(coralFan, coralWallFan);
        this.d(deadCoralFan, deadCoralWallFan);
    }

    private void c(Block doubleBlock, e tintType) {
        this.a(doubleBlock, "_top");
        MinecraftKey resourceLocation = this.a(doubleBlock, "_top", tintType.a(), TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(doubleBlock, "_bottom", tintType.a(), TextureMapping::c);
        this.f(doubleBlock, resourceLocation, resourceLocation2);
    }

    private void j() {
        this.a(Blocks.iU, "_front");
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.iU, "_top");
        MinecraftKey resourceLocation2 = this.a(Blocks.iU, "_bottom", net.minecraft.data.models.BlockModelGenerators$e.b.a(), TextureMapping::c);
        this.f(Blocks.iU, resourceLocation, resourceLocation2);
    }

    private void k() {
        MinecraftKey resourceLocation = this.a(Blocks.bE, "_top", ModelTemplates.bp, TextureMapping::a);
        MinecraftKey resourceLocation2 = this.a(Blocks.bE, "_bottom", ModelTemplates.bp, TextureMapping::a);
        this.f(Blocks.bE, resourceLocation, resourceLocation2);
    }

    private void l() {
        this.c(Blocks.ta);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.ta, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.ta, "_bottom");
        this.b.accept(MultiVariantGenerator.a(Blocks.ta).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.af).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, resourceLocation))));
    }

    private void f(Block block, MinecraftKey upperHalfModelId, MinecraftKey lowerHalfModelId) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.af).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, lowerHalfModelId)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, upperHalfModelId))));
    }

    private void o(Block rail) {
        TextureMapping textureMapping = TextureMapping.f(rail);
        TextureMapping textureMapping2 = TextureMapping.e(TextureMapping.a(rail, "_corner"));
        MinecraftKey resourceLocation = ModelTemplates.as.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.at.a(rail, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.au.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.av.a(rail, textureMapping, this.c);
        this.d(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(PropertyDispatch.a(BlockProperties.ah).a(BlockPropertyTrackPosition.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockPropertyTrackPosition.b, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.e, Variant.a().a(VariantProperties.c, resourceLocation3)).a(BlockPropertyTrackPosition.f, Variant.a().a(VariantProperties.c, resourceLocation4)).a(BlockPropertyTrackPosition.g, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyTrackPosition.h, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.i, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyTrackPosition.j, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void p(Block rail) {
        MinecraftKey resourceLocation = this.a(rail, "", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation2 = this.a(rail, "", ModelTemplates.au, TextureMapping::e);
        MinecraftKey resourceLocation3 = this.a(rail, "", ModelTemplates.av, TextureMapping::e);
        MinecraftKey resourceLocation4 = this.a(rail, "_on", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation5 = this.a(rail, "_on", ModelTemplates.au, TextureMapping::e);
        MinecraftKey resourceLocation6 = this.a(rail, "_on", ModelTemplates.av, TextureMapping::e);
        PropertyDispatch propertyDispatch = PropertyDispatch.a(BlockProperties.x, BlockProperties.ai).a((T1 on, T2 shape) -> {
            switch (shape) {
                case a: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation);
                }
                case b: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation).a(VariantProperties.b, VariantProperties.a.b);
                }
                case c: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2).a(VariantProperties.b, VariantProperties.a.b);
                }
                case d: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3).a(VariantProperties.b, VariantProperties.a.b);
                }
                case e: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2);
                }
                case f: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3);
                }
            }
            throw new UnsupportedOperationException("Fix you generator!");
        });
        this.d(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(propertyDispatch));
    }

    private a a(MinecraftKey modelId, Block particleBlock) {
        return new a(modelId, particleBlock);
    }

    private a f(Block block, Block particleBlock) {
        return new a(ModelLocationUtils.a(block), particleBlock);
    }

    private void a(Block block, Item particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.aa.a(block, TextureMapping.a(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void f(Block block, MinecraftKey particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.aa.a(block, TextureMapping.h(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void g(Block wool, Block carpet) {
        this.a(wool);
        MinecraftKey resourceLocation = TexturedModel.j.get(wool).a(carpet, this.c);
        this.b.accept(BlockModelGenerators.c(carpet, resourceLocation));
    }

    private void q(Block flowerbed) {
        this.a(flowerbed.j());
        MinecraftKey resourceLocation = TexturedModel.l.create(flowerbed, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.m.create(flowerbed, this.c);
        MinecraftKey resourceLocation3 = TexturedModel.n.create(flowerbed, this.c);
        MinecraftKey resourceLocation4 = TexturedModel.o.create(flowerbed, this.c);
        this.b.accept(MultiPartGenerator.a(flowerbed).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.S, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.S, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.S, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.S, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.S, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.S, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.S, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.S, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.S, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.S, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.S, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.T, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.S, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.T, 4).a(BlockProperties.S, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.T, 4).a(BlockProperties.S, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.T, 4).a(BlockProperties.S, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.T, 4).a(BlockProperties.S, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void a(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(BlockModelGenerators.b(block, resourceLocation));
        }
    }

    private void b(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void h(Block glass, Block glassPane) {
        this.a(glass);
        TextureMapping textureMapping = TextureMapping.b(glass, glassPane);
        MinecraftKey resourceLocation = ModelTemplates.aJ.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aK.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aL.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aH.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.aI.a(glassPane, textureMapping, this.c);
        Item item = glassPane.j();
        ModelTemplates.bC.a(ModelLocationUtils.a(item), TextureMapping.G(glass), this.c);
        this.b.accept(MultiPartGenerator.a(glassPane).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void r(Block commandBlock) {
        TextureMapping textureMapping = TextureMapping.A(commandBlock);
        MinecraftKey resourceLocation = ModelTemplates.aM.a(commandBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(commandBlock, "_conditional", ModelTemplates.aM, (MinecraftKey id) -> textureMapping.c(TextureSlot.i, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(commandBlock).a(BlockModelGenerators.a(BlockProperties.c, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void s(Block anvil) {
        MinecraftKey resourceLocation = TexturedModel.s.create(anvil, this.c);
        this.b.accept(BlockModelGenerators.c(anvil, resourceLocation).a(BlockModelGenerators.c()));
    }

    private List<Variant> a(int age) {
        String string = "_age" + age;
        return IntStream.range(1, 5).mapToObj(i2 -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nu, i2 + string))).collect(Collectors.toList());
    }

    private void m() {
        this.c(Blocks.nu);
        this.b.accept(MultiPartGenerator.a(Blocks.nu).a((Condition)Condition.a().a(BlockProperties.ar, 0), this.a(0)).a((Condition)Condition.a().a(BlockProperties.ar, 1), this.a(1)).a((Condition)Condition.a().a(BlockProperties.bl, BlockPropertyBambooSize.b), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nu, "_small_leaves"))).a((Condition)Condition.a().a(BlockProperties.bl, BlockPropertyBambooSize.c), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nu, "_large_leaves"))));
    }

    private PropertyDispatch n() {
        return PropertyDispatch.a(BlockProperties.Q).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a()).a(EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    private void o() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.op, "_top_open");
        this.b.accept(MultiVariantGenerator.a(Blocks.op).a(this.n()).a(PropertyDispatch.a(BlockProperties.v).a((Boolean)false, Variant.a().a(VariantProperties.c, TexturedModel.f.create(Blocks.op, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, TexturedModel.f.get(Blocks.op).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.f, resourceLocation)).a(Blocks.op, "_open", this.c)))));
    }

    private static <T extends Comparable<T>> PropertyDispatch a(IBlockState<T> property, T fence, MinecraftKey higherOrEqualModelId, MinecraftKey lowerModelId) {
        Variant variant = Variant.a().a(VariantProperties.c, higherOrEqualModelId);
        Variant variant2 = Variant.a().a(VariantProperties.c, lowerModelId);
        return PropertyDispatch.a(property).a((T1 comparable2) -> {
            boolean bl = comparable2.compareTo(fence) >= 0;
            return bl ? variant : variant2;
        });
    }

    private void a(Block beehive, Function<Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(beehive).b(TextureSlot.i, TextureSlot.c);
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.g, TextureMapping.a(beehive, "_front_honey"));
        MinecraftKey resourceLocation = ModelTemplates.q.a(beehive, "_empty", textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.q.a(beehive, "_honey", textureMapping2, this.c);
        this.c(beehive);
        ModelTemplates.q.a(ModelLocationUtils.a(beehive.j(), "_empty"), textureMapping, this.c);
        ModelTemplates.q.a(ModelLocationUtils.a(beehive.j(), "_honey"), textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(beehive).a(BlockModelGenerators.b()).a(BlockModelGenerators.a(BlockProperties.aO, 5, resourceLocation2, resourceLocation)));
    }

    private void a(Block crop, IBlockState<Integer> ageProperty, int ... ageTextureIndices) {
        if (ageProperty.a().size() != ageTextureIndices.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        PropertyDispatch propertyDispatch = PropertyDispatch.a(ageProperty).a(arg_0 -> this.a(ageTextureIndices, (Int2ObjectMap)int2ObjectMap, crop, arg_0));
        this.a(crop.j());
        this.b.accept(MultiVariantGenerator.a(crop).a(propertyDispatch));
    }

    private void p() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.oy, "_floor");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.oy, "_ceiling");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.oy, "_wall");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.oy, "_between_walls");
        this.a(Items.xi);
        this.b.accept(MultiVariantGenerator.a(Blocks.oy).a(PropertyDispatch.a(BlockProperties.S, BlockProperties.W).a(EnumDirection.c, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.d, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.d, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.e, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4)).a(EnumDirection.e, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c))));
    }

    private void q() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ou, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ou))).a(PropertyDispatch.a(BlockProperties.V, BlockProperties.S).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void d(Block cooker, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(cooker, this.c);
        MinecraftKey resourceLocation2 = TextureMapping.a(cooker, "_front_on");
        MinecraftKey resourceLocation3 = modelFactory.get(cooker).a((TextureMapping textures) -> textures.a(TextureSlot.g, resourceLocation2)).a(cooker, "_on", this.c);
        this.b.accept(MultiVariantGenerator.a(cooker).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void a(Block ... blocks) {
        MinecraftKey resourceLocation = ModelLocationUtils.a("campfire_off");
        for (Block block : blocks) {
            MinecraftKey resourceLocation2 = ModelTemplates.bd.a(block, TextureMapping.F(block), this.c);
            this.a(block.j());
            this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void t(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.by.a(block, TextureMapping.m(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void u(Block block) {
        MinecraftKey resourceLocation2;
        if (block == Blocks.tE) {
            MinecraftKey resourceLocation = ModelTemplates.bA.a(block, TextureMapping.n(block), this.c);
        } else {
            resourceLocation2 = ModelTemplates.bz.a(block, TextureMapping.n(block), this.c);
        }
        this.b.accept(BlockModelGenerators.c(block, resourceLocation2));
    }

    private void r() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.H(Blocks.cs), TextureMapping.H(Blocks.n));
        MinecraftKey resourceLocation = ModelTemplates.j.a(Blocks.cs, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(Blocks.cs, resourceLocation));
    }

    private void s() {
        this.a(Items.lV);
        this.b.accept(MultiPartGenerator.a(Blocks.cE).a(Condition.b(Condition.a().a(BlockProperties.ac, BlockPropertyRedstoneSide.c).a(BlockProperties.ab, BlockPropertyRedstoneSide.c).a(BlockProperties.ad, BlockPropertyRedstoneSide.c).a(BlockProperties.ae, BlockPropertyRedstoneSide.c), Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ae, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ae, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a})), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_dot"))).a((Condition)Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side0"))).a((Condition)Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt0"))).a((Condition)Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ae, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ac, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up"))).a((Condition)Condition.a().a(BlockProperties.ab, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.ad, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.ae, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void t() {
        this.a(Items.lZ);
        this.b.accept(MultiVariantGenerator.a(Blocks.ho).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.be, BlockProperties.x).a(BlockPropertyComparatorMode.a, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ho))).a(BlockPropertyComparatorMode.a, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ho, "_on"))).a(BlockPropertyComparatorMode.b, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ho, "_subtract"))).a(BlockPropertyComparatorMode.b, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ho, "_on_subtract")))));
    }

    private void u() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.kj);
        TextureMapping textureMapping2 = TextureMapping.a(TextureMapping.a(Blocks.jW, "_side"), textureMapping.a(TextureSlot.f));
        MinecraftKey resourceLocation = ModelTemplates.ab.a(Blocks.jW, textureMapping2, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ac.a(Blocks.jW, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.j.b(Blocks.jW, "_double", textureMapping2, this.c);
        this.b.accept(BlockModelGenerators.e(Blocks.jW, resourceLocation, resourceLocation2, resourceLocation3));
        this.b.accept(BlockModelGenerators.c(Blocks.kj, ModelTemplates.c.a(Blocks.kj, textureMapping, this.c)));
    }

    private void v() {
        this.a(Items.te);
        this.b.accept(MultiPartGenerator.a(Blocks.fG).a(Variant.a().a(VariantProperties.c, TextureMapping.H(Blocks.fG))).a((Condition)Condition.a().a(BlockProperties.k, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_bottle0"))).a((Condition)Condition.a().a(BlockProperties.l, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_bottle1"))).a((Condition)Condition.a().a(BlockProperties.m, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_bottle2"))).a((Condition)Condition.a().a(BlockProperties.k, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_empty0"))).a((Condition)Condition.a().a(BlockProperties.l, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_empty1"))).a((Condition)Condition.a().a(BlockProperties.m, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, "_empty2"))));
    }

    private void v(Block mushroomBlock) {
        MinecraftKey resourceLocation = ModelTemplates.bu.a(mushroomBlock, TextureMapping.b(mushroomBlock), this.c);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a("mushroom_block_inside");
        this.b.accept(MultiPartGenerator.a(mushroomBlock).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, false)));
        this.a(mushroomBlock, TexturedModel.a.createWithSuffix(mushroomBlock, "_inventory", this.c));
    }

    private void w() {
        this.a(Items.sp);
        this.b.accept(MultiVariantGenerator.a(Blocks.et).a(PropertyDispatch.a(BlockProperties.az).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice2"))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice3"))).a((Integer)4, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice4"))).a((Integer)5, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice5"))).a((Integer)6, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.et, "_slice6")))));
    }

    private void x() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.os, "_side3")).a(TextureSlot.o, TextureMapping.H(Blocks.t)).a(TextureSlot.n, TextureMapping.a(Blocks.os, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.os, "_side3")).a(TextureSlot.l, TextureMapping.a(Blocks.os, "_side3")).a(TextureSlot.k, TextureMapping.a(Blocks.os, "_side1")).a(TextureSlot.m, TextureMapping.a(Blocks.os, "_side2"));
        this.b.accept(BlockModelGenerators.c(Blocks.os, ModelTemplates.a.a(Blocks.os, textureMapping, this.c)));
    }

    private void y() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.ow, "_front")).a(TextureSlot.o, TextureMapping.a(Blocks.ow, "_bottom")).a(TextureSlot.n, TextureMapping.a(Blocks.ow, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.ow, "_front")).a(TextureSlot.k, TextureMapping.a(Blocks.ow, "_front")).a(TextureSlot.l, TextureMapping.a(Blocks.ow, "_side")).a(TextureSlot.m, TextureMapping.a(Blocks.ow, "_side"));
        this.b.accept(BlockModelGenerators.c(Blocks.ow, ModelTemplates.a.a(Blocks.ow, textureMapping, this.c)));
    }

    private void a(Block block, Block otherTextureSource, BiFunction<Block, Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(block, otherTextureSource);
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    public void b(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(block, "_particle")).a(TextureSlot.o, TextureMapping.a(block, "_down")).a(TextureSlot.n, TextureMapping.a(block, "_up")).a(TextureSlot.j, TextureMapping.a(block, "_north")).a(TextureSlot.k, TextureMapping.a(block, "_south")).a(TextureSlot.l, TextureMapping.a(block, "_east")).a(TextureSlot.m, TextureMapping.a(block, "_west"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    private void z() {
        TextureMapping textureMapping = TextureMapping.l(Blocks.fn);
        this.b.accept(BlockModelGenerators.c(Blocks.fn, ModelLocationUtils.a(Blocks.fn)));
        this.a(Blocks.er, textureMapping);
        this.a(Blocks.es, textureMapping);
    }

    private void a(Block block, TextureMapping texture) {
        MinecraftKey resourceLocation = ModelTemplates.p.a(block, texture.c(TextureSlot.g, TextureMapping.H(block)), this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void A() {
        this.a(Items.tf);
        this.n(Blocks.fH);
        this.b.accept(BlockModelGenerators.c(Blocks.fJ, ModelTemplates.bx.a(Blocks.fJ, TextureMapping.j(TextureMapping.a(Blocks.K, "_still")), this.c)));
        this.b.accept(MultiVariantGenerator.a(Blocks.fI).a(PropertyDispatch.a(LayeredCauldronBlock.g).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bv.a(Blocks.fI, "_level1", TextureMapping.j(TextureMapping.a(Blocks.J, "_still")), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.bw.a(Blocks.fI, "_level2", TextureMapping.j(TextureMapping.a(Blocks.J, "_still")), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bx.a(Blocks.fI, "_full", TextureMapping.j(TextureMapping.a(Blocks.J, "_still")), this.c)))));
        this.b.accept(MultiVariantGenerator.a(Blocks.fK).a(PropertyDispatch.a(LayeredCauldronBlock.g).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bv.a(Blocks.fK, "_level1", TextureMapping.j(TextureMapping.H(Blocks.rk)), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.bw.a(Blocks.fK, "_level2", TextureMapping.j(TextureMapping.H(Blocks.rk)), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bx.a(Blocks.fK, "_full", TextureMapping.j(TextureMapping.H(Blocks.rk)), this.c)))));
    }

    private void B() {
        TextureMapping textureMapping = TextureMapping.b(Blocks.kQ);
        MinecraftKey resourceLocation = ModelTemplates.aF.a(Blocks.kQ, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.kQ, "_dead", ModelTemplates.aF, (MinecraftKey id) -> textureMapping.c(TextureSlot.b, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(Blocks.kQ).a(BlockModelGenerators.a(BlockProperties.av, 5, resourceLocation2, resourceLocation)));
    }

    private void C() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.tL);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.tL, "_triggered");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.tL, "_crafting");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.tL, "_crafting_triggered");
        this.b.accept(MultiVariantGenerator.a(Blocks.tL).a(PropertyDispatch.a(BlockProperties.U).a((T1 orientation) -> this.a((BlockPropertyJigsawOrientation)orientation, Variant.a()))).a(PropertyDispatch.a(BlockProperties.B, CrafterBlock.b).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private void w(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.cL, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.cL, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.i, TextureMapping.a(Blocks.cL, "_top")).a(TextureSlot.g, TextureMapping.a(block, "_front_vertical"));
        MinecraftKey resourceLocation = ModelTemplates.p.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.r.a(block, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.Q).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void D() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.fM);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.fM, "_filled");
        this.b.accept(MultiVariantGenerator.a(Blocks.fM).a(PropertyDispatch.a(BlockProperties.h).a((Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation2))).a(BlockModelGenerators.c()));
    }

    private void E() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.kP, "_side");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.kP, "_noside");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.kP, "_noside1");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.kP, "_noside2");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.kP, "_noside3");
        this.b.accept(MultiPartGenerator.a(Blocks.kP).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2), Variant.a().a(VariantProperties.c, resourceLocation3), Variant.a().a(VariantProperties.c, resourceLocation4), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    }

    private void F() {
        this.b.accept(MultiPartGenerator.a(Blocks.px).a(Variant.a().a(VariantProperties.c, TextureMapping.H(Blocks.px))).a((Condition)Condition.a().a(BlockProperties.aM, 1), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents1"))).a((Condition)Condition.a().a(BlockProperties.aM, 2), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents2"))).a((Condition)Condition.a().a(BlockProperties.aM, 3), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents3"))).a((Condition)Condition.a().a(BlockProperties.aM, 4), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents4"))).a((Condition)Condition.a().a(BlockProperties.aM, 5), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents5"))).a((Condition)Condition.a().a(BlockProperties.aM, 6), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents6"))).a((Condition)Condition.a().a(BlockProperties.aM, 7), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents7"))).a((Condition)Condition.a().a(BlockProperties.aM, 8), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.px, "_contents_ready"))));
    }

    private void x(Block copperBulbBlock) {
        MinecraftKey resourceLocation = ModelTemplates.c.a(copperBulbBlock, TextureMapping.a(copperBulbBlock), this.c);
        MinecraftKey resourceLocation2 = this.a(copperBulbBlock, "_powered", ModelTemplates.c, TextureMapping::b);
        MinecraftKey resourceLocation3 = this.a(copperBulbBlock, "_lit", ModelTemplates.c, TextureMapping::b);
        MinecraftKey resourceLocation4 = this.a(copperBulbBlock, "_lit_powered", ModelTemplates.c, TextureMapping::b);
        this.b.accept(this.a(copperBulbBlock, resourceLocation, resourceLocation3, resourceLocation2, resourceLocation4));
    }

    private BlockStateGenerator a(Block copperBulbBlock, MinecraftKey modelId, MinecraftKey litModelId, MinecraftKey poweredModelId, MinecraftKey litPoweredModelId) {
        return MultiVariantGenerator.a(copperBulbBlock).a(PropertyDispatch.a(BlockProperties.r, BlockProperties.x).a((T1 lit, T2 powered) -> {
            if (lit.booleanValue()) {
                return Variant.a().a(VariantProperties.c, powered != false ? litPoweredModelId : litModelId);
            }
            return Variant.a().a(VariantProperties.c, powered != false ? poweredModelId : modelId);
        }));
    }

    private void i(Block unwaxedCopperBulbBlock, Block waxedCopperBulbBlock) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(unwaxedCopperBulbBlock);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_powered");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_lit");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(unwaxedCopperBulbBlock, "_lit_powered");
        this.a(waxedCopperBulbBlock, ModelLocationUtils.a(unwaxedCopperBulbBlock.j()));
        this.b.accept(this.a(waxedCopperBulbBlock, resourceLocation, resourceLocation3, resourceLocation2, resourceLocation4));
    }

    private void y(Block block) {
        this.c(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelTemplates.ao.a(block, TextureMapping.c(block), this.c))).a(this.n()));
    }

    private void G() {
        this.y(Blocks.qT);
        this.y(Blocks.qS);
        this.y(Blocks.qR);
        this.y(Blocks.qQ);
    }

    private void H() {
        this.c(Blocks.sO);
        PropertyDispatch.b<EnumDirection, DripstoneThickness> c2 = PropertyDispatch.a(BlockProperties.bn, BlockProperties.bo);
        for (DripstoneThickness dripstoneThickness : DripstoneThickness.values()) {
            c2.a(EnumDirection.b, dripstoneThickness, this.a(EnumDirection.b, dripstoneThickness));
        }
        for (DripstoneThickness dripstoneThickness2 : DripstoneThickness.values()) {
            c2.a(EnumDirection.a, dripstoneThickness2, this.a(EnumDirection.a, dripstoneThickness2));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.sO).a(c2));
    }

    private Variant a(EnumDirection direction, DripstoneThickness thickness) {
        String string = "_" + direction.c() + "_" + thickness.c();
        TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(Blocks.sO, string));
        return Variant.a().a(VariantProperties.c, ModelTemplates.an.a(Blocks.sO, string, textureMapping, this.c));
    }

    private void z(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.H(Blocks.ei)).a(TextureSlot.f, TextureMapping.H(block)).a(TextureSlot.i, TextureMapping.a(block, "_side"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.n.a(block, textureMapping, this.c)));
    }

    private void I() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.hp, "_side");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.hp, "_top")).a(TextureSlot.i, resourceLocation);
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.hp, "_inverted_top")).a(TextureSlot.i, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.hp).a(PropertyDispatch.a(BlockProperties.p).a((Boolean)false, Variant.a().a(VariantProperties.c, ModelTemplates.aG.a(Blocks.hp, textureMapping, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, ModelTemplates.aG.a(ModelLocationUtils.a(Blocks.hp, "_inverted"), textureMapping2, this.c)))));
    }

    private void A(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.n()));
    }

    private void J() {
        Block block = Blocks.sN;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_on");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.n()).a(BlockModelGenerators.a(BlockProperties.x, resourceLocation, resourceLocation2)));
    }

    private void K() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.B, TextureMapping.H(Blocks.j)).a(TextureSlot.f, TextureMapping.H(Blocks.cK));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.B, TextureMapping.H(Blocks.j)).a(TextureSlot.f, TextureMapping.a(Blocks.cK, "_moist"));
        MinecraftKey resourceLocation = ModelTemplates.aX.a(Blocks.cK, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aX.a(TextureMapping.a(Blocks.cK, "_moist"), textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cK).a(BlockModelGenerators.a(BlockProperties.aR, 7, resourceLocation2, resourceLocation)));
    }

    private List<MinecraftKey> B(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_floor0"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_floor1"), TextureMapping.x(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2);
    }

    private List<MinecraftKey> C(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_side0"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_side1"), TextureMapping.x(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ba.a(ModelLocationUtils.a(texture, "_side_alt0"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.ba.a(ModelLocationUtils.a(texture, "_side_alt1"), TextureMapping.x(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private List<MinecraftKey> D(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.bb.a(ModelLocationUtils.a(texture, "_up0"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bb.a(ModelLocationUtils.a(texture, "_up1"), TextureMapping.x(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bc.a(ModelLocationUtils.a(texture, "_up_alt0"), TextureMapping.w(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bc.a(ModelLocationUtils.a(texture, "_up_alt1"), TextureMapping.x(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private static List<Variant> a(List<MinecraftKey> modelIds, UnaryOperator<Variant> processor) {
        return modelIds.stream().map(modelId -> Variant.a().a(VariantProperties.c, modelId)).map(processor).collect(Collectors.toList());
    }

    private void L() {
        Condition.c condition = Condition.a().a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.P, false).a(BlockProperties.K, false);
        List<MinecraftKey> list = this.B(Blocks.cy);
        List<MinecraftKey> list2 = this.C(Blocks.cy);
        List<MinecraftKey> list3 = this.D(Blocks.cy);
        this.b.accept(MultiPartGenerator.a(Blocks.cy).a((Condition)condition, BlockModelGenerators.a(list, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.M, true), condition), BlockModelGenerators.a(list2, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.N, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(Condition.b(Condition.a().a(BlockProperties.O, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(Condition.b(Condition.a().a(BlockProperties.P, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))).a((Condition)Condition.a().a(BlockProperties.K, true), BlockModelGenerators.a(list3, variant -> variant)));
    }

    private void M() {
        List<MinecraftKey> list = this.B(Blocks.cz);
        List<MinecraftKey> list2 = this.C(Blocks.cz);
        this.b.accept(MultiPartGenerator.a(Blocks.cz).a(BlockModelGenerators.a(list, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void E(Block lantern) {
        MinecraftKey resourceLocation = TexturedModel.u.create(lantern, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.v.create(lantern, this.c);
        this.a(lantern.j());
        this.b.accept(MultiVariantGenerator.a(lantern).a(BlockModelGenerators.a(BlockProperties.j, resourceLocation2, resourceLocation)));
    }

    private void N() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.a(Blocks.ah, "_side"), TextureMapping.a(Blocks.ah, "_top"));
        MinecraftKey resourceLocation = ModelTemplates.j.a(Blocks.ah, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(Blocks.ah, resourceLocation));
    }

    private void O() {
        this.a(Items.af);
        Block block = Blocks.H;
        PropertyDispatch.b<Boolean, Integer> c2 = PropertyDispatch.a(MangrovePropaguleBlock.d, MangrovePropaguleBlock.b);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        for (int i2 = 0; i2 <= 4; ++i2) {
            MinecraftKey resourceLocation2 = ModelLocationUtils.a(block, "_hanging_" + i2);
            c2.a((Boolean)true, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation2));
            c2.a((Boolean)false, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.H).a(c2));
    }

    private void P() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ld).a(PropertyDispatch.a(BlockProperties.at).a((Integer)0, Variant.a().a(VariantProperties.c, this.a(Blocks.ld, "_0", ModelTemplates.c, TextureMapping::b))).a((Integer)1, Variant.a().a(VariantProperties.c, this.a(Blocks.ld, "_1", ModelTemplates.c, TextureMapping::b))).a((Integer)2, Variant.a().a(VariantProperties.c, this.a(Blocks.ld, "_2", ModelTemplates.c, TextureMapping::b))).a((Integer)3, Variant.a().a(VariantProperties.c, this.a(Blocks.ld, "_3", ModelTemplates.c, TextureMapping::b)))));
    }

    private void Q() {
        MinecraftKey resourceLocation = TextureMapping.H(Blocks.j);
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).b(TextureSlot.e, TextureSlot.c).a(TextureSlot.f, TextureMapping.a(Blocks.i, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.i, "_snow"));
        Variant variant = Variant.a().a(VariantProperties.c, ModelTemplates.n.a(Blocks.i, "_snow", textureMapping, this.c));
        this.a(Blocks.i, ModelLocationUtils.a(Blocks.i), variant);
        MinecraftKey resourceLocation2 = TexturedModel.f.get(Blocks.fz).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.fz, this.c);
        this.a(Blocks.fz, resourceLocation2, variant);
        MinecraftKey resourceLocation3 = TexturedModel.f.get(Blocks.l).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.l, this.c);
        this.a(Blocks.l, resourceLocation3, variant);
    }

    private void a(Block topSoil, MinecraftKey modelId, Variant snowyVariant) {
        List<Variant> list = Arrays.asList(BlockModelGenerators.a(modelId));
        this.b.accept(MultiVariantGenerator.a(topSoil).a(PropertyDispatch.a(BlockProperties.A).a((Boolean)true, snowyVariant).a((Boolean)false, list)));
    }

    private void R() {
        this.a(Items.rV);
        this.b.accept(MultiVariantGenerator.a(Blocks.fQ).a(PropertyDispatch.a(BlockProperties.as).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fQ, "_stage0"))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fQ, "_stage1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fQ, "_stage2")))).a(BlockModelGenerators.c()));
    }

    private void S() {
        this.b.accept(BlockModelGenerators.b(Blocks.kZ, ModelLocationUtils.a(Blocks.kZ)));
    }

    private void j(Block weightedPressurePlate, Block textureSource) {
        TextureMapping textureMapping = TextureMapping.b(textureSource);
        MinecraftKey resourceLocation = ModelTemplates.Y.a(weightedPressurePlate, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.Z.a(weightedPressurePlate, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(weightedPressurePlate).a(BlockModelGenerators.a(BlockProperties.aU, 1, resourceLocation2, resourceLocation)));
    }

    private void T() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.hs);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.hs, "_side");
        this.a(Items.mf);
        this.b.accept(MultiVariantGenerator.a(Blocks.hs).a(PropertyDispatch.a(BlockProperties.R).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void k(Block modelSource, Block child) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(modelSource);
        this.b.accept(MultiVariantGenerator.a(child, Variant.a().a(VariantProperties.c, resourceLocation)));
        this.a(child, resourceLocation);
    }

    private void U() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.fk, "_post_ends");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.fk, "_post");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.fk, "_cap");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.fk, "_cap_alt");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.fk, "_side");
        MinecraftKey resourceLocation6 = ModelLocationUtils.a(Blocks.fk, "_side_alt");
        this.b.accept(MultiPartGenerator.a(Blocks.fk).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.M, true).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.M, false).a(BlockProperties.N, true).a(BlockProperties.O, false).a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, true).a(BlockProperties.P, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation6)).a((Condition)Condition.a().a(BlockProperties.P, true), Variant.a().a(VariantProperties.c, resourceLocation6).a(VariantProperties.b, VariantProperties.a.b)));
        this.d(Blocks.fk);
    }

    private void F(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(BlockModelGenerators.b()));
    }

    private void V() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.dI);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.dI, "_on");
        this.d(Blocks.dI);
        this.b.accept(MultiVariantGenerator.a(Blocks.dI).a(BlockModelGenerators.a(BlockProperties.x, resourceLocation, resourceLocation2)).a(PropertyDispatch.a(BlockProperties.V, BlockProperties.S).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void W() {
        this.d(Blocks.fA);
        this.b.accept(BlockModelGenerators.b(Blocks.fA, ModelLocationUtils.a(Blocks.fA)));
    }

    private void X() {
        this.d(Blocks.tI);
        this.b.accept(BlockModelGenerators.c(Blocks.tI, ModelLocationUtils.a(Blocks.tI)));
    }

    private void Y() {
        this.b.accept(MultiVariantGenerator.a(Blocks.eq).a(PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eq, "_ns"))).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eq, "_ew")))));
    }

    private void Z() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.ei, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.ei, Variant.a().a(VariantProperties.c, resourceLocation), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.d)));
    }

    private void aa() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.lj);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.lj, "_on");
        this.b.accept(MultiVariantGenerator.a(Blocks.lj).a(BlockModelGenerators.a(BlockProperties.x, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void ab() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.a(Blocks.bF, "_bottom")).a(TextureSlot.i, TextureMapping.a(Blocks.bF, "_side"));
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.bF, "_top_sticky");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.bF, "_top");
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, resourceLocation);
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, resourceLocation2);
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.bF, "_base");
        this.a(Blocks.bF, resourceLocation3, textureMapping3);
        this.a(Blocks.by, resourceLocation3, textureMapping2);
        MinecraftKey resourceLocation4 = ModelTemplates.n.a(Blocks.bF, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation2), this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.n.a(Blocks.by, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation), this.c);
        this.a(Blocks.bF, resourceLocation4);
        this.a(Blocks.by, resourceLocation5);
    }

    private void a(Block piston, MinecraftKey extendedModelId, TextureMapping textures) {
        MinecraftKey resourceLocation = ModelTemplates.bm.a(piston, textures, this.c);
        this.b.accept(MultiVariantGenerator.a(piston).a(BlockModelGenerators.a(BlockProperties.g, extendedModelId, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void ac() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.F, TextureMapping.a(Blocks.bF, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.bF, "_side"));
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bF, "_top_sticky"));
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bF, "_top"));
        this.b.accept(MultiVariantGenerator.a(Blocks.bG).a(PropertyDispatch.a(BlockProperties.y, BlockProperties.bh).a((Boolean)false, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bn.a(Blocks.bF, "_head", textureMapping3, this.c))).a((Boolean)false, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bn.a(Blocks.bF, "_head_sticky", textureMapping2, this.c))).a((Boolean)true, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bo.a(Blocks.bF, "_head_short", textureMapping3, this.c))).a((Boolean)true, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bo.a(Blocks.bF, "_head_short_sticky", textureMapping2, this.c)))).a(BlockModelGenerators.e()));
    }

    private void ad() {
        Block block = Blocks.tM;
        TextureMapping textureMapping = TextureMapping.a(block, "_side_inactive", "_top_inactive");
        TextureMapping textureMapping2 = TextureMapping.a(block, "_side_active", "_top_active");
        TextureMapping textureMapping3 = TextureMapping.a(block, "_side_active", "_top_ejecting_reward");
        TextureMapping textureMapping4 = TextureMapping.a(block, "_side_inactive_ominous", "_top_inactive_ominous");
        TextureMapping textureMapping5 = TextureMapping.a(block, "_side_active_ominous", "_top_active_ominous");
        TextureMapping textureMapping6 = TextureMapping.a(block, "_side_active_ominous", "_top_ejecting_reward_ominous");
        MinecraftKey resourceLocation = ModelTemplates.o.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.o.a(block, "_active", textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.o.a(block, "_ejecting_reward", textureMapping3, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.o.a(block, "_inactive_ominous", textureMapping4, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.o.a(block, "_active_ominous", textureMapping5, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.o.a(block, "_ejecting_reward_ominous", textureMapping6, this.c);
        this.a(block, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.bz, BlockProperties.bC).a((T1 spawnerState, T2 ominous) -> switch (spawnerState) {
            default -> throw new MatchException(null, null);
            case TrialSpawnerState.a, TrialSpawnerState.f -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation4 : resourceLocation);
            case TrialSpawnerState.b, TrialSpawnerState.c, TrialSpawnerState.d -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation5 : resourceLocation2);
            case TrialSpawnerState.e -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation6 : resourceLocation3);
        })));
    }

    private void ae() {
        Block block = Blocks.tN;
        TextureMapping textureMapping = TextureMapping.a(block, "_front_off", "_side_off", "_top", "_bottom");
        TextureMapping textureMapping2 = TextureMapping.a(block, "_front_on", "_side_on", "_top", "_bottom");
        TextureMapping textureMapping3 = TextureMapping.a(block, "_front_ejecting", "_side_on", "_top", "_bottom");
        TextureMapping textureMapping4 = TextureMapping.a(block, "_front_ejecting", "_side_on", "_top_ejecting", "_bottom");
        MinecraftKey resourceLocation = ModelTemplates.bS.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bS.a(block, "_active", textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bS.a(block, "_unlocking", textureMapping3, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bS.a(block, "_ejecting_reward", textureMapping4, this.c);
        TextureMapping textureMapping5 = TextureMapping.a(block, "_front_off_ominous", "_side_off_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping6 = TextureMapping.a(block, "_front_on_ominous", "_side_on_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping7 = TextureMapping.a(block, "_front_ejecting_ominous", "_side_on_ominous", "_top_ominous", "_bottom_ominous");
        TextureMapping textureMapping8 = TextureMapping.a(block, "_front_ejecting_ominous", "_side_on_ominous", "_top_ejecting_ominous", "_bottom_ominous");
        MinecraftKey resourceLocation5 = ModelTemplates.bS.a(block, "_ominous", textureMapping5, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.bS.a(block, "_active_ominous", textureMapping6, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.bS.a(block, "_unlocking_ominous", textureMapping7, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bS.a(block, "_ejecting_reward_ominous", textureMapping8, this.c);
        this.a(block, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.b()).a(PropertyDispatch.a(VaultBlock.b, VaultBlock.d).a((T1 vaultState, T2 ominous) -> switch (vaultState) {
            default -> throw new MatchException(null, null);
            case VaultState.a -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation5 : resourceLocation);
            case VaultState.b -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation6 : resourceLocation2);
            case VaultState.c -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation7 : resourceLocation3);
            case VaultState.d -> Variant.a().a(VariantProperties.c, ominous != false ? resourceLocation8 : resourceLocation4);
        })));
    }

    private void af() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.rl, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.rl, "_active");
        this.a(Blocks.rl, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.rl).a(PropertyDispatch.a(BlockProperties.bp).a((T1 phase) -> Variant.a().a(VariantProperties.c, phase == SculkSensorPhase.b || phase == SculkSensorPhase.c ? resourceLocation2 : resourceLocation))));
    }

    private void ag() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.rm, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.rm, "_active");
        this.a(Blocks.rm, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.rm).a(PropertyDispatch.a(BlockProperties.bp).a((T1 phase) -> Variant.a().a(VariantProperties.c, phase == SculkSensorPhase.b || phase == SculkSensorPhase.c ? resourceLocation2 : resourceLocation))).a(BlockModelGenerators.b()));
    }

    private void ah() {
        MinecraftKey resourceLocation = ModelTemplates.bR.a(Blocks.rq, TextureMapping.a(false), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bR.a(Blocks.rq, "_can_summon", TextureMapping.a(true), this.c);
        this.a(Blocks.rq, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.rq).a(BlockModelGenerators.a(BlockProperties.H, resourceLocation2, resourceLocation)));
    }

    private void ai() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.on, "_stable");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.on, "_unstable");
        this.a(Blocks.on, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.on).a(BlockModelGenerators.a(BlockProperties.b, resourceLocation2, resourceLocation)));
    }

    private void aj() {
        MinecraftKey resourceLocation = this.a(Blocks.sQ, "", ModelTemplates.ao, TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(Blocks.sQ, "_lit", ModelTemplates.ao, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.sQ).a(BlockModelGenerators.a(BlockProperties.E, resourceLocation2, resourceLocation)));
        MinecraftKey resourceLocation3 = this.a(Blocks.sR, "", ModelTemplates.ao, TextureMapping::c);
        MinecraftKey resourceLocation4 = this.a(Blocks.sR, "_lit", ModelTemplates.ao, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.sR).a(BlockModelGenerators.a(BlockProperties.E, resourceLocation4, resourceLocation3)));
    }

    private void ak() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.fP, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.fP, "_on", ModelTemplates.c, TextureMapping::b);
        this.b.accept(MultiVariantGenerator.a(Blocks.fP).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)));
    }

    private void l(Block torch, Block wallTorch) {
        TextureMapping textureMapping = TextureMapping.z(torch);
        this.b.accept(BlockModelGenerators.c(torch, ModelTemplates.bg.a(torch, textureMapping, this.c)));
        this.b.accept(MultiVariantGenerator.a(wallTorch, Variant.a().a(VariantProperties.c, ModelTemplates.bi.a(wallTorch, textureMapping, this.c))).a(BlockModelGenerators.d()));
        this.d(torch);
        this.c(wallTorch);
    }

    private void al() {
        TextureMapping textureMapping = TextureMapping.z(Blocks.dX);
        TextureMapping textureMapping2 = TextureMapping.i(TextureMapping.a(Blocks.dX, "_off"));
        MinecraftKey resourceLocation = ModelTemplates.bk.a(Blocks.dX, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bh.a(Blocks.dX, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dX).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation, resourceLocation2)));
        MinecraftKey resourceLocation3 = ModelTemplates.bl.a(Blocks.dY, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bj.a(Blocks.dY, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dY).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation4)).a(BlockModelGenerators.d()));
        this.d(Blocks.dX);
        this.c(Blocks.dY);
    }

    private void am() {
        this.a(Items.lY);
        this.b.accept(MultiVariantGenerator.a(Blocks.eu).a(PropertyDispatch.a(BlockProperties.aB, BlockProperties.t, BlockProperties.x).a((T1 tick, T2 locked, T3 on) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('_').append(tick).append("tick");
            if (on.booleanValue()) {
                stringBuilder.append("_on");
            }
            if (locked.booleanValue()) {
                stringBuilder.append("_locked");
            }
            return Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.eu, stringBuilder.toString()));
        })).a(BlockModelGenerators.c()));
    }

    private void an() {
        this.a(Items.da);
        this.b.accept(MultiVariantGenerator.a(Blocks.nq).a(PropertyDispatch.a(BlockProperties.aT, BlockProperties.D).a((Integer)1, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("dead_sea_pickle")))).a((Integer)2, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_dead_sea_pickles")))).a((Integer)3, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_dead_sea_pickles")))).a((Integer)4, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_dead_sea_pickles")))).a((Integer)1, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("sea_pickle")))).a((Integer)2, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_sea_pickles")))).a((Integer)3, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_sea_pickles")))).a((Integer)4, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_sea_pickles"))))));
    }

    private void ao() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.ea);
        MinecraftKey resourceLocation = ModelTemplates.c.a(Blocks.ec, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.ea).a(PropertyDispatch.a(BlockProperties.aG).a((T1 height) -> Variant.a().a(VariantProperties.c, height < 8 ? ModelLocationUtils.a(Blocks.ea, "_height" + height * 2) : resourceLocation))));
        this.a(Blocks.ea, ModelLocationUtils.a(Blocks.ea, "_height2"));
        this.b.accept(BlockModelGenerators.c(Blocks.ec, resourceLocation));
    }

    private void ap() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ox, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ox))).a(BlockModelGenerators.b()));
    }

    private void aq() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.pv, this.c);
        this.a(Blocks.pv, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.pv).a(PropertyDispatch.a(BlockProperties.bk).a((T1 mode) -> Variant.a().a(VariantProperties.c, this.a(Blocks.pv, "_" + mode.c(), ModelTemplates.c, TextureMapping::b)))));
    }

    private void ar() {
        this.a(Items.xl);
        this.b.accept(MultiVariantGenerator.a(Blocks.oD).a(PropertyDispatch.a(BlockProperties.at).a((T1 stage) -> Variant.a().a(VariantProperties.c, this.a(Blocks.oD, "_stage" + stage, ModelTemplates.ao, TextureMapping::c)))));
    }

    private void as() {
        this.a(Items.pO);
        this.b.accept(MultiVariantGenerator.a(Blocks.fW).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.N, BlockProperties.M, BlockProperties.O, BlockProperties.P).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_n"))).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ne"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_nse"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_nsew"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ns"))).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_n"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ne"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ns"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_nse"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fW, "_attached_nsew")))));
    }

    private void at() {
        this.d(Blocks.fV);
        this.b.accept(MultiVariantGenerator.a(Blocks.fV).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.x).a((T1 attached, T2 on) -> Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fV, (attached != false ? "_attached" : "") + (on != false ? "_on" : ""))))).a(BlockModelGenerators.b()));
    }

    private MinecraftKey a(int eggs, String prefix, TextureMapping textures) {
        switch (eggs) {
            case 1: {
                return ModelTemplates.bq.a(ModelLocationUtils.a(prefix + "turtle_egg"), textures, this.c);
            }
            case 2: {
                return ModelTemplates.br.a(ModelLocationUtils.a("two_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 3: {
                return ModelTemplates.bs.a(ModelLocationUtils.a("three_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 4: {
                return ModelTemplates.bt.a(ModelLocationUtils.a("four_" + prefix + "turtle_eggs"), textures, this.c);
            }
        }
        throw new UnsupportedOperationException();
    }

    private MinecraftKey a(Integer eggs, Integer hatch) {
        switch (hatch) {
            case 0: {
                return this.a(eggs, "", TextureMapping.b(TextureMapping.H(Blocks.mA)));
            }
            case 1: {
                return this.a(eggs, "slightly_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mA, "_slightly_cracked")));
            }
            case 2: {
                return this.a(eggs, "very_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mA, "_very_cracked")));
            }
        }
        throw new UnsupportedOperationException();
    }

    private void au() {
        this.a(Items.kD);
        this.b.accept(MultiVariantGenerator.a(Blocks.mA).a(PropertyDispatch.a(BlockProperties.aE, BlockProperties.aF).b((T1 eggs, T2 hatch) -> Arrays.asList(BlockModelGenerators.a(this.a((Integer)eggs, (Integer)hatch))))));
    }

    private void av() {
        this.a(Items.kE);
        Function<Integer, MinecraftKey> function = hatch -> {
            String string = switch (hatch) {
                case 1 -> "_slightly_cracked";
                case 2 -> "_very_cracked";
                default -> "_not_cracked";
            };
            TextureMapping textureMapping = TextureMapping.a(string);
            return ModelTemplates.bB.a(Blocks.mB, string, textureMapping, this.c);
        };
        this.b.accept(MultiVariantGenerator.a(Blocks.mB).a(PropertyDispatch.a(SnifferEggBlock.c).a((T1 hatch) -> Variant.a().a(VariantProperties.c, (MinecraftKey)function.apply((Integer)hatch)))));
    }

    private void G(Block block) {
        this.d(block);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Condition.c terminalCondition2 = SystemUtils.a(Condition.a(), (? super T terminalCondition) -> a.stream().map(Pair::getFirst).map(MultifaceBlock::b).forEach(property -> {
            if (block.m().b(property)) {
                terminalCondition.a(property, false);
            }
        }));
        for (Pair<EnumDirection, Function<MinecraftKey, Variant>> pair : a) {
            BlockStateBoolean booleanProperty = MultifaceBlock.b((EnumDirection)pair.getFirst());
            Function function = (Function)pair.getSecond();
            if (!block.m().b(booleanProperty)) continue;
            multiPartGenerator.a((Condition)Condition.a().a(booleanProperty, true), (Variant)function.apply(resourceLocation));
            multiPartGenerator.a((Condition)terminalCondition2, (Variant)function.apply(resourceLocation));
        }
        this.b.accept(multiPartGenerator);
    }

    private void H(Block block) {
        MinecraftKey resourceLocation = TexturedModel.j.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.k.get(block).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.a(block, "_side_tall"))).a(block, "_side_tall", this.c);
        MinecraftKey resourceLocation3 = TexturedModel.k.get(block).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.a(block, "_side_small"))).a(block, "_side_small", this.c);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Condition.c terminalCondition = Condition.a().a(MossyCarpetBlock.b, false);
        multiPartGenerator.a((Condition)Condition.a().a(MossyCarpetBlock.b, true), Variant.a().a(VariantProperties.c, resourceLocation));
        multiPartGenerator.a((Condition)terminalCondition, Variant.a().a(VariantProperties.c, resourceLocation));
        a.stream().map(Pair::getFirst).forEach(direction -> {
            BlockStateEnum<BlockPropertyWallHeight> enumProperty = MossyCarpetBlock.a(direction);
            if (enumProperty != null && block.m().b(enumProperty)) {
                terminalCondition.a(enumProperty, BlockPropertyWallHeight.a);
            }
        });
        for (Pair<EnumDirection, Function<MinecraftKey, Variant>> pair : a) {
            EnumDirection direction2 = (EnumDirection)pair.getFirst();
            BlockStateEnum<BlockPropertyWallHeight> enumProperty = MossyCarpetBlock.a(direction2);
            if (enumProperty == null) continue;
            Function function = (Function)pair.getSecond();
            multiPartGenerator.a((Condition)Condition.a().a(enumProperty, BlockPropertyWallHeight.c), (Variant)function.apply(resourceLocation2));
            multiPartGenerator.a((Condition)Condition.a().a(enumProperty, BlockPropertyWallHeight.b), (Variant)function.apply(resourceLocation3));
            multiPartGenerator.a((Condition)terminalCondition, (Variant)function.apply(resourceLocation2));
        }
        this.b.accept(multiPartGenerator);
    }

    private void I(Block block) {
        PropertyDispatch propertyDispatch = PropertyDispatch.a(HangingMossBlock.b).a((T1 tip) -> {
            String string = tip != false ? "_tip" : "";
            TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(block, string));
            MinecraftKey resourceLocation = net.minecraft.data.models.BlockModelGenerators$e.b.a().a(block, string, textureMapping, this.c);
            return Variant.a().a(VariantProperties.c, resourceLocation);
        });
        this.d(block);
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void aw() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.rp, "_bottom");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.rp, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.rp, "_side"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.rp, "_top_bloom")).a(TextureSlot.i, TextureMapping.a(Blocks.rp, "_side_bloom"));
        MinecraftKey resourceLocation2 = ModelTemplates.n.a(Blocks.rp, "", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.n.a(Blocks.rp, "_bloom", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.rp).a(PropertyDispatch.a(BlockProperties.F).a((T1 bloom) -> Variant.a().a(VariantProperties.c, bloom != false ? resourceLocation3 : resourceLocation2))));
        this.a(Items.gw, resourceLocation2);
    }

    private void ax() {
        Block block = Blocks.ct;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        List.of(Pair.of((Object)EnumDirection.c, (Object)((Object)VariantProperties.a.a)), Pair.of((Object)EnumDirection.f, (Object)((Object)VariantProperties.a.b)), Pair.of((Object)EnumDirection.d, (Object)((Object)VariantProperties.a.c)), Pair.of((Object)EnumDirection.e, (Object)((Object)VariantProperties.a.d))).forEach(pair -> {
            EnumDirection direction = (EnumDirection)pair.getFirst();
            VariantProperties.a rotation = (VariantProperties.a)((Object)((Object)pair.getSecond()));
            Condition.c terminalCondition = Condition.a().a(BlockProperties.S, direction);
            multiPartGenerator.a((Condition)terminalCondition, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation).a(VariantProperties.d, true));
            this.a(multiPartGenerator, terminalCondition, rotation);
        });
        this.b.accept(multiPartGenerator);
        this.a(block, ModelLocationUtils.a(block, "_inventory"));
        i.clear();
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation) {
        List.of(Pair.of((Object)BlockProperties.bq, (Object)ModelTemplates.aN), Pair.of((Object)BlockProperties.br, (Object)ModelTemplates.aO), Pair.of((Object)BlockProperties.bs, (Object)ModelTemplates.aP), Pair.of((Object)BlockProperties.bt, (Object)ModelTemplates.aQ), Pair.of((Object)BlockProperties.bu, (Object)ModelTemplates.aR), Pair.of((Object)BlockProperties.bv, (Object)ModelTemplates.aS)).forEach(pair -> {
            BlockStateBoolean booleanProperty = (BlockStateBoolean)pair.getFirst();
            ModelTemplate modelTemplate = (ModelTemplate)pair.getSecond();
            this.a(blockStateSupplier, facingCondition, rotation, booleanProperty, modelTemplate, true);
            this.a(blockStateSupplier, facingCondition, rotation, booleanProperty, modelTemplate, false);
        });
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation, BlockStateBoolean property, ModelTemplate model, boolean occupied) {
        String string = occupied ? "_occupied" : "_empty";
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.b, TextureMapping.a(Blocks.ct, string));
        d bookSlotModelCacheKey = new d(model, string);
        MinecraftKey resourceLocation = i.computeIfAbsent(bookSlotModelCacheKey, key -> model.a(Blocks.ct, string, textureMapping, this.c));
        blockStateSupplier.a(Condition.a(facingCondition, Condition.a().a(property, occupied)), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation));
    }

    private void ay() {
        this.b.accept(BlockModelGenerators.c(Blocks.le, ModelTemplates.c.a(Blocks.le, TextureMapping.b(ModelLocationUtils.a("magma")), this.c)));
    }

    private void J(Block shulkerBox) {
        this.b(shulkerBox, TexturedModel.r);
        ModelTemplates.bI.a(ModelLocationUtils.a(shulkerBox.j()), TextureMapping.v(shulkerBox), this.c);
    }

    private void b(Block plant, Block plantStem, e tintType) {
        this.b(plant, tintType);
        this.b(plantStem, tintType);
    }

    private void m(Block bed, Block particleSource) {
        ModelTemplates.bJ.a(ModelLocationUtils.a(bed.j()), TextureMapping.v(particleSource), this.c);
    }

    private void az() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.b);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.b, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.fb, resourceLocation, resourceLocation2));
        this.a(Blocks.fb, resourceLocation);
    }

    private void aA() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.te);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.te, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.ty, resourceLocation, resourceLocation2).a(BlockModelGenerators.f()));
        this.a(Blocks.ty, resourceLocation);
    }

    private void n(Block root, Block pottedRoot) {
        this.a(root, net.minecraft.data.models.BlockModelGenerators$e.b);
        TextureMapping textureMapping = TextureMapping.d(TextureMapping.a(root, "_pot"));
        MinecraftKey resourceLocation = net.minecraft.data.models.BlockModelGenerators$e.b.b().a(pottedRoot, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(pottedRoot, resourceLocation));
    }

    private void aB() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.pG, "_bottom");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.pG, "_top_off");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.pG, "_top");
        MinecraftKey[] resourceLocations = new MinecraftKey[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, i2 == 0 ? resourceLocation2 : resourceLocation3).a(TextureSlot.i, TextureMapping.a(Blocks.pG, "_side" + i2));
            resourceLocations[i2] = ModelTemplates.n.a(Blocks.pG, "_" + i2, textureMapping, this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.pG).a(PropertyDispatch.a(BlockProperties.ba).a((T1 charges) -> Variant.a().a(VariantProperties.c, resourceLocations[charges]))));
        this.a(Items.xJ, resourceLocations[0]);
    }

    private Variant a(BlockPropertyJigsawOrientation orientation, Variant variant) {
        switch (orientation) {
            case b: {
                return variant.a(VariantProperties.a, VariantProperties.a.b);
            }
            case c: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c);
            }
            case d: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d);
            }
            case a: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b);
            }
            case f: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.c);
            }
            case g: {
                return variant.a(VariantProperties.a, VariantProperties.a.d);
            }
            case h: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.b);
            }
            case e: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.d);
            }
            case k: {
                return variant;
            }
            case l: {
                return variant.a(VariantProperties.b, VariantProperties.a.c);
            }
            case i: {
                return variant.a(VariantProperties.b, VariantProperties.a.d);
            }
            case j: {
                return variant.a(VariantProperties.b, VariantProperties.a.b);
            }
        }
        throw new UnsupportedOperationException("Rotation " + String.valueOf(orientation) + " can't be expressed with existing x and y values");
    }

    private void aC() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.pw, "_top");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.pw, "_bottom");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.pw, "_side");
        MinecraftKey resourceLocation4 = TextureMapping.a(Blocks.pw, "_lock");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.o, resourceLocation3).a(TextureSlot.m, resourceLocation3).a(TextureSlot.l, resourceLocation3).a(TextureSlot.c, resourceLocation).a(TextureSlot.j, resourceLocation).a(TextureSlot.k, resourceLocation2).a(TextureSlot.n, resourceLocation4);
        MinecraftKey resourceLocation5 = ModelTemplates.b.a(Blocks.pw, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.pw, Variant.a().a(VariantProperties.c, resourceLocation5)).a(PropertyDispatch.a(BlockProperties.U).a((T1 orientation) -> this.a((BlockPropertyJigsawOrientation)orientation, Variant.a()))));
    }

    private void aD() {
        Block block = Blocks.n;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        TexturedModel texturedModel = TexturedModel.a.get(block);
        Block block2 = Blocks.jZ;
        MinecraftKey resourceLocation2 = ModelTemplates.ab.a(block2, texturedModel.b(), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ac.a(block2, texturedModel.b(), this.c);
        this.b.accept(BlockModelGenerators.e(block2, resourceLocation2, resourceLocation3, resourceLocation));
    }

    public void a() {
        BlockFamilies.a().filter(BlockFamily::c).forEach(family -> this.i(family.a()).a((BlockFamily)family));
        this.i(Blocks.rA).a(BlockFamilies.x).a(Blocks.rA, Blocks.rY).a(Blocks.rE, Blocks.rI).a(BlockFamilies.z);
        this.i(Blocks.rz).a(BlockFamilies.B).a(Blocks.rz, Blocks.rX).a(Blocks.rD, Blocks.rH).a(BlockFamilies.D);
        this.i(Blocks.ry).a(BlockFamilies.F).a(Blocks.ry, Blocks.rW).a(Blocks.rC, Blocks.rG).a(BlockFamilies.H);
        this.i(Blocks.rx).a(BlockFamilies.J).a(Blocks.rx, Blocks.rV).a(Blocks.rB, Blocks.rF).a(BlockFamilies.L);
        this.x(Blocks.sF);
        this.x(Blocks.sG);
        this.x(Blocks.sH);
        this.x(Blocks.sI);
        this.i(Blocks.sF, Blocks.sJ);
        this.i(Blocks.sG, Blocks.sK);
        this.i(Blocks.sH, Blocks.sL);
        this.i(Blocks.sI, Blocks.sM);
        this.n(Blocks.a);
        this.c(Blocks.nx, Blocks.a);
        this.c(Blocks.nw, Blocks.a);
        this.n(Blocks.gc);
        this.n(Blocks.ed);
        this.c(Blocks.ny, Blocks.J);
        this.n(Blocks.fO);
        this.n(Blocks.mz);
        this.n(Blocks.fF);
        this.n(Blocks.gf);
        this.a(Items.uU);
        this.n(Blocks.pB);
        this.n(Blocks.J);
        this.n(Blocks.K);
        this.n(Blocks.im);
        this.a(Items.gf);
        this.o(Blocks.qh, Blocks.qy);
        this.o(Blocks.qi, Blocks.qz);
        this.o(Blocks.qj, Blocks.qA);
        this.o(Blocks.qk, Blocks.qB);
        this.o(Blocks.ql, Blocks.qC);
        this.o(Blocks.qm, Blocks.qD);
        this.o(Blocks.qn, Blocks.qE);
        this.o(Blocks.qo, Blocks.qF);
        this.o(Blocks.qp, Blocks.qG);
        this.o(Blocks.qq, Blocks.qH);
        this.o(Blocks.qr, Blocks.qI);
        this.o(Blocks.qs, Blocks.qJ);
        this.o(Blocks.qt, Blocks.qK);
        this.o(Blocks.qu, Blocks.qL);
        this.o(Blocks.qv, Blocks.qM);
        this.o(Blocks.qw, Blocks.qN);
        this.o(Blocks.qg, Blocks.qx);
        this.n(Blocks.nv);
        this.n(Blocks.gH);
        this.n(Blocks.rk);
        this.n(Blocks.sS);
        this.t(Blocks.sT);
        this.t(Blocks.sU);
        this.u(Blocks.tD);
        this.u(Blocks.tE);
        this.aj();
        this.g(Blocks.sX, Blocks.sV);
        this.H(Blocks.tQ);
        this.I(Blocks.tR);
        this.a(Blocks.tP);
        this.q(Blocks.sW);
        this.a(Blocks.in, Items.hP);
        this.a(Items.hP);
        this.aE();
        this.a(Blocks.li, Items.jp);
        this.a(Items.jp);
        this.f(Blocks.bX, TextureMapping.a(Blocks.bF, "_side"));
        this.a(Blocks.U);
        this.a(Blocks.V);
        this.a(Blocks.iS);
        this.a(Blocks.cF);
        this.a(Blocks.cG);
        this.a(Blocks.cH);
        this.a(Blocks.fS);
        this.a(Blocks.fT);
        this.a(Blocks.fX);
        this.a(Blocks.Q);
        this.a(Blocks.W);
        this.a(Blocks.R);
        this.a(Blocks.co);
        this.a(Blocks.S);
        this.a(Blocks.T);
        this.a(Blocks.cp);
        this.b(Blocks.pE, TexturedModel.d);
        this.a(Blocks.pD);
        this.a(Blocks.aY);
        this.a(Blocks.aZ);
        this.a(Blocks.ba);
        this.a(Blocks.hr);
        this.a(Blocks.dV);
        this.a(Blocks.dW);
        this.a(Blocks.hq);
        this.a(Blocks.pX);
        this.a(Blocks.nr);
        this.a(Blocks.ee);
        this.a(Blocks.k);
        this.a(Blocks.pF);
        this.a(Blocks.fN);
        this.a(Blocks.ep);
        this.a(Blocks.O);
        this.a(Blocks.pC);
        this.a(Blocks.eb);
        this.b(Blocks.eg, TexturedModel.g);
        this.b(Blocks.pL, TexturedModel.d);
        this.b(Blocks.fo, TexturedModel.d);
        this.n(Blocks.ag);
        this.n(Blocks.gp);
        this.a(Blocks.lf);
        this.a(Blocks.bf);
        this.a(Blocks.iT);
        this.a(Blocks.cv);
        this.a(Blocks.qf);
        this.a(Blocks.iz);
        this.a(Blocks.oT);
        this.a(Blocks.ej);
        this.a(Blocks.ek);
        this.b(Blocks.cA, TexturedModel.b);
        this.h(Blocks.cB);
        this.a(Blocks.aV);
        this.b(Blocks.bD, TexturedModel.w);
        this.a(Items.cZ);
        this.b(Blocks.cr, TexturedModel.f);
        this.b(Blocks.py, TexturedModel.d);
        this.a(Blocks.oK);
        this.a(Blocks.aW);
        this.a(Blocks.qO);
        this.a(Blocks.qP);
        this.a(Blocks.ri);
        this.a(Blocks.sP);
        this.a(Blocks.tA);
        this.a(Blocks.tB);
        this.a(Blocks.tC);
        this.e(Blocks.rn);
        this.n(Blocks.tO);
        this.aD();
        this.a(Blocks.rv);
        this.a(Blocks.rw);
        this.a(Blocks.rr);
        this.a(Blocks.rs);
        this.a(Blocks.rt);
        this.a(Blocks.ru);
        this.k(Blocks.rr, Blocks.rR);
        this.k(Blocks.rs, Blocks.rT);
        this.k(Blocks.rt, Blocks.rS);
        this.k(Blocks.ru, Blocks.rU);
        this.j(Blocks.sh);
        this.j(Blocks.si);
        this.j(Blocks.sk);
        this.j(Blocks.sj);
        this.a(Blocks.sh, Blocks.sl);
        this.a(Blocks.si, Blocks.sm);
        this.a(Blocks.sk, Blocks.so);
        this.a(Blocks.sj, Blocks.sn);
        this.l(Blocks.sp);
        this.l(Blocks.sq);
        this.l(Blocks.ss);
        this.l(Blocks.sr);
        this.b(Blocks.sp, Blocks.st);
        this.b(Blocks.sq, Blocks.su);
        this.b(Blocks.ss, Blocks.sw);
        this.b(Blocks.sr, Blocks.sv);
        this.a(Blocks.sx);
        this.a(Blocks.sy);
        this.a(Blocks.sz);
        this.a(Blocks.sA);
        this.k(Blocks.sx, Blocks.sB);
        this.k(Blocks.sy, Blocks.sC);
        this.k(Blocks.sz, Blocks.sD);
        this.k(Blocks.sA, Blocks.sE);
        this.j(Blocks.hm, Blocks.co);
        this.j(Blocks.hn, Blocks.cp);
        this.G();
        this.r();
        this.ax();
        this.v();
        this.w();
        this.a(new Block[]{Blocks.oB, Blocks.oC});
        this.x();
        this.A();
        this.B();
        this.E();
        this.F();
        this.I();
        this.D();
        this.A(Blocks.kO);
        this.J();
        this.K();
        this.L();
        this.M();
        this.P();
        this.Q();
        this.R();
        this.S();
        this.q();
        this.T();
        this.U();
        this.V();
        this.W();
        this.Y();
        this.Z();
        this.aa();
        this.ab();
        this.ac();
        this.ai();
        this.al();
        this.ak();
        this.am();
        this.an();
        this.y();
        this.ao();
        this.ap();
        this.aq();
        this.ar();
        this.as();
        this.at();
        this.au();
        this.av();
        this.G(Blocks.ft);
        this.G(Blocks.fu);
        this.G(Blocks.ro);
        this.ay();
        this.aC();
        this.af();
        this.ag();
        this.ah();
        this.X();
        this.O();
        this.N();
        this.ad();
        this.ae();
        this.F(Blocks.cX);
        this.d(Blocks.cX);
        this.F(Blocks.ov);
        this.g();
        this.F(Blocks.sZ);
        this.l(Blocks.cw, Blocks.cx);
        this.l(Blocks.en, Blocks.eo);
        this.a(Blocks.cI, Blocks.n, TextureMapping::c);
        this.a(Blocks.ot, Blocks.p, TextureMapping::d);
        this.z(Blocks.oR);
        this.z(Blocks.oI);
        this.w(Blocks.bb);
        this.w(Blocks.hy);
        this.C();
        this.E(Blocks.oz);
        this.E(Blocks.oA);
        this.e(Blocks.fl, ModelLocationUtils.a(Blocks.fl));
        this.a(Blocks.el, TexturedModel.d);
        this.a(Blocks.em, TexturedModel.d);
        this.a(Blocks.tz);
        this.a(Blocks.lh, TexturedModel.d);
        this.f(Blocks.j);
        this.f(Blocks.tc);
        this.f(Blocks.L);
        this.g(Blocks.M);
        this.g(Blocks.P);
        this.f(Blocks.N);
        this.e(Blocks.I);
        this.b(Blocks.tJ, TexturedModel.f);
        this.a(Blocks.iA, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.kS, TexturedModel.x, TexturedModel.y);
        this.a(Blocks.hv, TexturedModel.x, TexturedModel.y);
        this.a(Blocks.tF, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.tG, TexturedModel.d, TexturedModel.e);
        this.a(Blocks.tH, TexturedModel.d, TexturedModel.e);
        this.c(Blocks.oo, TexturedModel.i);
        this.z();
        this.a(Blocks.pz, TextureMapping::B);
        this.a(Blocks.pA, TextureMapping::D);
        this.a(Blocks.kY, BlockProperties.at, 0, 1, 2, 3);
        this.a(Blocks.gI, BlockProperties.aw, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.fE, BlockProperties.at, 0, 1, 1, 2);
        this.a(Blocks.gJ, BlockProperties.aw, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.cJ, BlockProperties.aw, 0, 1, 2, 3, 4, 5, 6, 7);
        this.a(Blocks.kV, net.minecraft.data.models.BlockModelGenerators$e.b, BlockProperties.ar, 0, 1);
        this.i();
        this.h();
        this.a(ModelLocationUtils.a("decorated_pot"), Blocks.iR).b(Blocks.tK);
        this.a(ModelLocationUtils.a("banner"), Blocks.n).a(ModelTemplates.bK, Blocks.ja, Blocks.jb, Blocks.jc, Blocks.jd, Blocks.je, Blocks.jf, Blocks.jg, Blocks.jh, Blocks.ji, Blocks.jj, Blocks.jk, Blocks.jl, Blocks.jm, Blocks.jn, Blocks.jo, Blocks.jp).b(Blocks.jq, Blocks.jr, Blocks.js, Blocks.jt, Blocks.ju, Blocks.jv, Blocks.jw, Blocks.jx, Blocks.jy, Blocks.jz, Blocks.jA, Blocks.jB, Blocks.jC, Blocks.jD, Blocks.jE, Blocks.jF);
        this.a(ModelLocationUtils.a("bed"), Blocks.n).b(Blocks.bg, Blocks.bh, Blocks.bi, Blocks.bj, Blocks.bk, Blocks.bl, Blocks.bm, Blocks.bn, Blocks.bo, Blocks.bp, Blocks.bq, Blocks.br, Blocks.bs, Blocks.bt, Blocks.bu, Blocks.bv);
        this.m(Blocks.bg, Blocks.bH);
        this.m(Blocks.bh, Blocks.bI);
        this.m(Blocks.bi, Blocks.bJ);
        this.m(Blocks.bj, Blocks.bK);
        this.m(Blocks.bk, Blocks.bL);
        this.m(Blocks.bl, Blocks.bM);
        this.m(Blocks.bm, Blocks.bN);
        this.m(Blocks.bn, Blocks.bO);
        this.m(Blocks.bo, Blocks.bP);
        this.m(Blocks.bp, Blocks.bQ);
        this.m(Blocks.bq, Blocks.bR);
        this.m(Blocks.br, Blocks.bS);
        this.m(Blocks.bs, Blocks.bT);
        this.m(Blocks.bt, Blocks.bU);
        this.m(Blocks.bu, Blocks.bV);
        this.m(Blocks.bv, Blocks.bW);
        this.a(ModelLocationUtils.a("skull"), Blocks.ej).a(ModelTemplates.bL, Blocks.hc, Blocks.ha, Blocks.gY, Blocks.gU, Blocks.gW, Blocks.hg).a(Blocks.he).b(Blocks.hd, Blocks.hf, Blocks.hb, Blocks.gZ, Blocks.gV, Blocks.gX, Blocks.hh);
        this.J(Blocks.lk);
        this.J(Blocks.ll);
        this.J(Blocks.lm);
        this.J(Blocks.ln);
        this.J(Blocks.lo);
        this.J(Blocks.lp);
        this.J(Blocks.lq);
        this.J(Blocks.lr);
        this.J(Blocks.ls);
        this.J(Blocks.lt);
        this.J(Blocks.lu);
        this.J(Blocks.lv);
        this.J(Blocks.lw);
        this.J(Blocks.lx);
        this.J(Blocks.ly);
        this.J(Blocks.lz);
        this.J(Blocks.lA);
        this.b(Blocks.ns, TexturedModel.r);
        this.c(Blocks.ns);
        this.a(ModelLocationUtils.a("chest"), Blocks.n).b(Blocks.cD, Blocks.hl);
        this.a(ModelLocationUtils.a("ender_chest"), Blocks.cv).b(Blocks.fU);
        this.f(Blocks.fL, Blocks.cv).a(Blocks.fL, Blocks.la);
        this.a(Blocks.aT);
        this.a(Blocks.aU);
        this.a(Blocks.lR);
        this.a(Blocks.lS);
        this.a(Blocks.lT);
        this.a(Blocks.lU);
        this.a(Blocks.lV);
        this.a(Blocks.lW);
        this.a(Blocks.lX);
        this.a(Blocks.lY);
        this.a(Blocks.lZ);
        this.a(Blocks.ma);
        this.a(Blocks.mb);
        this.a(Blocks.mc);
        this.a(Blocks.md);
        this.a(Blocks.me);
        this.a(Blocks.mf);
        this.a(Blocks.mg);
        this.a(TexturedModel.a, Blocks.mh, Blocks.mi, Blocks.mj, Blocks.mk, Blocks.ml, Blocks.mm, Blocks.mn, Blocks.mo, Blocks.mp, Blocks.mq, Blocks.mr, Blocks.ms, Blocks.mt, Blocks.mu, Blocks.mv, Blocks.mw);
        this.a(Blocks.iR);
        this.a(Blocks.hz);
        this.a(Blocks.hA);
        this.a(Blocks.hB);
        this.a(Blocks.hC);
        this.a(Blocks.hD);
        this.a(Blocks.hE);
        this.a(Blocks.hF);
        this.a(Blocks.hG);
        this.a(Blocks.hH);
        this.a(Blocks.hI);
        this.a(Blocks.hJ);
        this.a(Blocks.hK);
        this.a(Blocks.hL);
        this.a(Blocks.hM);
        this.a(Blocks.hN);
        this.a(Blocks.hO);
        this.a(Blocks.rj);
        this.h(Blocks.aX, Blocks.fm);
        this.h(Blocks.ev, Blocks.hP);
        this.h(Blocks.ew, Blocks.hQ);
        this.h(Blocks.ex, Blocks.hR);
        this.h(Blocks.ey, Blocks.hS);
        this.h(Blocks.ez, Blocks.hT);
        this.h(Blocks.eA, Blocks.hU);
        this.h(Blocks.eB, Blocks.hV);
        this.h(Blocks.eC, Blocks.hW);
        this.h(Blocks.eD, Blocks.hX);
        this.h(Blocks.eE, Blocks.hY);
        this.h(Blocks.eF, Blocks.hZ);
        this.h(Blocks.eG, Blocks.ia);
        this.h(Blocks.eH, Blocks.ib);
        this.h(Blocks.eI, Blocks.ic);
        this.h(Blocks.eJ, Blocks.id);
        this.h(Blocks.eK, Blocks.ie);
        this.b(TexturedModel.p, Blocks.lB, Blocks.lC, Blocks.lD, Blocks.lE, Blocks.lF, Blocks.lG, Blocks.lH, Blocks.lI, Blocks.lJ, Blocks.lK, Blocks.lL, Blocks.lM, Blocks.lN, Blocks.lO, Blocks.lP, Blocks.lQ);
        this.g(Blocks.bH, Blocks.iB);
        this.g(Blocks.bI, Blocks.iC);
        this.g(Blocks.bJ, Blocks.iD);
        this.g(Blocks.bK, Blocks.iE);
        this.g(Blocks.bL, Blocks.iF);
        this.g(Blocks.bM, Blocks.iG);
        this.g(Blocks.bN, Blocks.iH);
        this.g(Blocks.bO, Blocks.iI);
        this.g(Blocks.bP, Blocks.iJ);
        this.g(Blocks.bQ, Blocks.iK);
        this.g(Blocks.bR, Blocks.iL);
        this.g(Blocks.bS, Blocks.iM);
        this.g(Blocks.bT, Blocks.iN);
        this.g(Blocks.bU, Blocks.iO);
        this.g(Blocks.bV, Blocks.iP);
        this.g(Blocks.bW, Blocks.iQ);
        this.a(Blocks.td);
        this.a(Blocks.eZ);
        this.a(Blocks.bB, Blocks.gq, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Blocks.bY, Blocks.gr, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ca, Blocks.gs, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cb, Blocks.gt, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cc, Blocks.gu, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cd, Blocks.gv, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ce, Blocks.gw, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cf, Blocks.gx, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cg, Blocks.gy, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ch, Blocks.gz, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ci, Blocks.gA, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cj, Blocks.gB, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cl, Blocks.gC, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ck, Blocks.gD, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cn, Blocks.gE, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cm, Blocks.gF, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bC, Blocks.gG, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bZ, Blocks.gg, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.H();
        this.v(Blocks.fh);
        this.v(Blocks.fi);
        this.v(Blocks.fj);
        this.a(Blocks.bA, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.b(Blocks.ef, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Items.dQ);
        this.b(Blocks.mx, Blocks.my, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Items.dR);
        this.c(Blocks.my);
        this.b(Blocks.tb, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.tb);
        this.c(Blocks.sR);
        this.b(Blocks.oU, Blocks.oV, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.oW, Blocks.oX, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.oU, "_plant");
        this.c(Blocks.oV);
        this.a(Blocks.oW, "_plant");
        this.c(Blocks.oX);
        this.a(Blocks.nt, net.minecraft.data.models.BlockModelGenerators$e.a, TextureMapping.c(TextureMapping.a(Blocks.nu, "_stage0")));
        this.m();
        this.a(Blocks.bz, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iV, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iW, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iX, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iY, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.c(Blocks.iZ, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.j();
        this.k();
        this.l();
        this.a(Blocks.mR, Blocks.mM, Blocks.mH, Blocks.mC, Blocks.nb, Blocks.mW, Blocks.nl, Blocks.ng);
        this.a(Blocks.mS, Blocks.mN, Blocks.mI, Blocks.mD, Blocks.nc, Blocks.mX, Blocks.nm, Blocks.nh);
        this.a(Blocks.mT, Blocks.mO, Blocks.mJ, Blocks.mE, Blocks.nd, Blocks.mY, Blocks.nn, Blocks.ni);
        this.a(Blocks.mU, Blocks.mP, Blocks.mK, Blocks.mF, Blocks.ne, Blocks.mZ, Blocks.no, Blocks.nj);
        this.a(Blocks.mV, Blocks.mQ, Blocks.mL, Blocks.mG, Blocks.nf, Blocks.na, Blocks.np, Blocks.nk);
        this.e(Blocks.fs, Blocks.fq);
        this.e(Blocks.fr, Blocks.fp);
        this.m(Blocks.af).c(Blocks.af).a(Blocks.aA);
        this.m(Blocks.ar).c(Blocks.ar).a(Blocks.aJ);
        this.a(Blocks.ar, Blocks.du, Blocks.dE);
        this.b(Blocks.aS, TexturedModel.t);
        this.m(Blocks.ab).c(Blocks.ab).a(Blocks.ax);
        this.m(Blocks.am).c(Blocks.am).a(Blocks.aF);
        this.a(Blocks.am, Blocks.dn, Blocks.dz);
        this.a(Blocks.D, Blocks.gl, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aO, TexturedModel.t);
        this.m(Blocks.ac).d(Blocks.ac).a(Blocks.ay);
        this.m(Blocks.an).d(Blocks.an).a(Blocks.aG);
        this.a(Blocks.an, Blocks.do, Blocks.dA);
        this.a(Blocks.E, Blocks.gm, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aP, TexturedModel.t);
        this.m(Blocks.Z).c(Blocks.Z).a(Blocks.av);
        this.m(Blocks.ak).c(Blocks.ak).a(Blocks.aD);
        this.a(Blocks.ak, Blocks.dm, Blocks.dy);
        this.a(Blocks.B, Blocks.gj, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aM, TexturedModel.t);
        this.m(Blocks.X).c(Blocks.X).a(Blocks.at);
        this.m(Blocks.aq).c(Blocks.aq).a(Blocks.aB);
        this.a(Blocks.aq, Blocks.dk, Blocks.dw);
        this.a(Blocks.z, Blocks.gh, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aK, TexturedModel.t);
        this.m(Blocks.Y).c(Blocks.Y).a(Blocks.au);
        this.m(Blocks.aj).c(Blocks.aj).a(Blocks.aC);
        this.a(Blocks.aj, Blocks.dl, Blocks.dx);
        this.a(Blocks.A, Blocks.gi, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aL, TexturedModel.t);
        this.m(Blocks.ad).c(Blocks.ad).a(Blocks.az);
        this.m(Blocks.ao).c(Blocks.ao).a(Blocks.aH);
        this.a(Blocks.ao, Blocks.dq, Blocks.dC);
        this.a(Blocks.F, Blocks.gn, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aQ, TexturedModel.t);
        this.m(Blocks.ae).c(Blocks.ae).a(Blocks.u);
        this.m(Blocks.ap).c(Blocks.ap).a(Blocks.aI);
        this.a(Blocks.ap, Blocks.dr, Blocks.dD);
        this.a(Blocks.G, Blocks.go, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aR, TexturedModel.t);
        this.m(Blocks.aa).c(Blocks.aa).a(Blocks.aw);
        this.m(Blocks.al).c(Blocks.al).a(Blocks.aE);
        this.a(Blocks.al, Blocks.dp, Blocks.dB);
        this.a(Blocks.C, Blocks.gk, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.aN, TexturedModel.t);
        this.m(Blocks.oN).b(Blocks.oN).a(Blocks.oP);
        this.m(Blocks.oO).b(Blocks.oO).a(Blocks.oQ);
        this.a(Blocks.oO, Blocks.ds, Blocks.dF);
        this.a(Blocks.oS, Blocks.pH, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.n(Blocks.oY, Blocks.pJ);
        this.m(Blocks.oE).b(Blocks.oE).a(Blocks.oG);
        this.m(Blocks.oF).b(Blocks.oF).a(Blocks.oH);
        this.a(Blocks.oF, Blocks.dt, Blocks.dG);
        this.a(Blocks.oJ, Blocks.pI, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.n(Blocks.oL, Blocks.pK);
        this.m(Blocks.ai).d(Blocks.ai);
        this.m(Blocks.as).d(Blocks.as);
        this.a(Blocks.x, Blocks.dv, Blocks.dH);
        this.b(Blocks.oM, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Items.dN);
        this.j(Blocks.dK);
        this.l(Blocks.ip);
        this.u();
        this.o(Blocks.cY);
        this.p(Blocks.bw);
        this.p(Blocks.bx);
        this.p(Blocks.hx);
        this.t();
        this.r(Blocks.gb);
        this.r(Blocks.lb);
        this.r(Blocks.lc);
        this.s(Blocks.hi);
        this.s(Blocks.hj);
        this.s(Blocks.hk);
        this.o();
        this.p();
        this.d(Blocks.cL, TexturedModel.h);
        this.d(Blocks.or, TexturedModel.h);
        this.d(Blocks.oq, TexturedModel.i);
        this.s();
        this.aB();
        this.aw();
        this.k(Blocks.eY, Blocks.fg);
        this.k(Blocks.m, Blocks.fc);
        this.k(Blocks.eX, Blocks.ff);
        this.k(Blocks.eW, Blocks.fe);
        this.az();
        this.k(Blocks.eV, Blocks.fd);
        this.aA();
        ItemMonsterEgg.b().forEach(item -> this.a((Item)item, ModelLocationUtils.b("template_spawn_egg")));
    }

    private void aE() {
        this.c(Blocks.io);
        PropertyDispatch.a<Integer> c1 = PropertyDispatch.a(BlockProperties.aQ);
        for (int i2 = 0; i2 < 16; ++i2) {
            String string = String.format(Locale.ROOT, "_%02d", i2);
            MinecraftKey resourceLocation = TextureMapping.a(Items.hQ, string);
            c1.a((Integer)i2, Variant.a().a(VariantProperties.c, ModelTemplates.aa.a(Blocks.io, string, TextureMapping.h(resourceLocation), this.c)));
            ModelTemplates.bC.a(ModelLocationUtils.a(Items.hQ, string), TextureMapping.k(resourceLocation), this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.io).a(c1));
    }

    private void o(Block candle, Block cake) {
        this.a(candle.j());
        TextureMapping textureMapping = TextureMapping.b(TextureMapping.H(candle));
        TextureMapping textureMapping2 = TextureMapping.b(TextureMapping.a(candle, "_lit"));
        MinecraftKey resourceLocation = ModelTemplates.bM.a(candle, "_one_candle", textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bN.a(candle, "_two_candles", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bO.a(candle, "_three_candles", textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bP.a(candle, "_four_candles", textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.bM.a(candle, "_one_candle_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.bN.a(candle, "_two_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.bO.a(candle, "_three_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bP.a(candle, "_four_candles_lit", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(candle).a(PropertyDispatch.a(BlockProperties.aA, BlockProperties.r).a((Integer)1, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Integer)2, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Integer)3, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation3)).a((Integer)4, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Integer)1, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation5)).a((Integer)2, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation6)).a((Integer)3, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation7)).a((Integer)4, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation8))));
        MinecraftKey resourceLocation9 = ModelTemplates.bQ.a(cake, TextureMapping.a(candle, false), this.c);
        MinecraftKey resourceLocation10 = ModelTemplates.bQ.a(cake, "_lit", TextureMapping.a(candle, true), this.c);
        this.b.accept(MultiVariantGenerator.a(cake).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation10, resourceLocation9)));
    }

    private /* synthetic */ Variant a(int[] age, Int2ObjectMap int2ObjectMap, Block block, Integer integer) {
        int i2 = age[integer];
        MinecraftKey resourceLocation = (MinecraftKey)int2ObjectMap.computeIfAbsent(i2, j2 -> this.a(block, "_stage" + i2, ModelTemplates.aW, TextureMapping::g));
        return Variant.a().a(VariantProperties.c, resourceLocation);
    }

    @FunctionalInterface
    static interface c {
        public BlockStateGenerator create(Block var1, MinecraftKey var2, TextureMapping var3, BiConsumer<MinecraftKey, Supplier<JsonElement>> var4);
    }

    class b {
        private final TextureMapping b;
        private final Map<ModelTemplate, MinecraftKey> c = Maps.newHashMap();
        @Nullable
        private BlockFamily d;
        @Nullable
        private MinecraftKey e;
        private final Set<Block> f = new HashSet<Block>();

        public b(TextureMapping textures) {
            this.b = textures;
        }

        public b a(Block block, ModelTemplate model) {
            this.e = model.a(block, this.b, BlockModelGenerators.this.c);
            if (BlockModelGenerators.this.f.containsKey(block)) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.this.f.get(block).create(block, this.e, this.b, BlockModelGenerators.this.c));
            } else {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
            }
            return this;
        }

        public b a(Block parent, Block child) {
            MinecraftKey resourceLocation = ModelLocationUtils.a(parent);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(child, resourceLocation));
            BlockModelGenerators.this.a(child, resourceLocation);
            this.f.add(child);
            return this;
        }

        public b a(Block buttonBlock) {
            MinecraftKey resourceLocation = ModelTemplates.s.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.t.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(buttonBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.u.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(buttonBlock, resourceLocation3);
            return this;
        }

        public b b(Block wallBlock) {
            MinecraftKey resourceLocation = ModelTemplates.M.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.N.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.O.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            MinecraftKey resourceLocation4 = ModelTemplates.P.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(wallBlock, resourceLocation4);
            return this;
        }

        public b c(Block customFenceBlock) {
            TextureMapping textureMapping = TextureMapping.q(customFenceBlock);
            MinecraftKey resourceLocation = ModelTemplates.D.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.E.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.F.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.G.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation5 = ModelTemplates.H.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5));
            MinecraftKey resourceLocation6 = ModelTemplates.I.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(customFenceBlock, resourceLocation6);
            return this;
        }

        public b d(Block fenceBlock) {
            MinecraftKey resourceLocation = ModelTemplates.J.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.K.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(fenceBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.L.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(fenceBlock, resourceLocation3);
            return this;
        }

        public b e(Block customFenceGateBlock) {
            TextureMapping textureMapping = TextureMapping.q(customFenceGateBlock);
            MinecraftKey resourceLocation = ModelTemplates.R.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.Q.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.T.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.S.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, false));
            return this;
        }

        public b f(Block fenceGateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.V.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.U.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.X.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.W.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, true));
            return this;
        }

        public b g(Block pressurePlateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.Y.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.Z.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public b h(Block signBlock) {
            if (this.d == null) {
                throw new IllegalStateException("Family not defined");
            }
            Block block = this.d.b().get((Object)BlockFamily.b.r);
            MinecraftKey resourceLocation = ModelTemplates.aa.a(signBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(signBlock, resourceLocation));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            BlockModelGenerators.this.a(signBlock.j());
            BlockModelGenerators.this.c(block);
            return this;
        }

        public b i(Block block) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            MinecraftKey resourceLocation = this.a(ModelTemplates.ab, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.ac, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(block, resourceLocation, resourceLocation2, this.e));
            BlockModelGenerators.this.a(block, resourceLocation);
            return this;
        }

        public b j(Block block) {
            MinecraftKey resourceLocation = this.a(ModelTemplates.af, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.ae, block);
            MinecraftKey resourceLocation3 = this.a(ModelTemplates.ag, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(block, resourceLocation, resourceLocation2, resourceLocation3));
            BlockModelGenerators.this.a(block, resourceLocation2);
            return this;
        }

        private b k(Block block) {
            TexturedModel texturedModel = BlockModelGenerators.this.g.getOrDefault(block, TexturedModel.a.get(block));
            MinecraftKey resourceLocation = texturedModel.a(block, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            return this;
        }

        private b l(Block block) {
            BlockModelGenerators.this.j(block);
            return this;
        }

        private void m(Block block) {
            if (BlockModelGenerators.this.e.contains(block)) {
                BlockModelGenerators.this.l(block);
            } else {
                BlockModelGenerators.this.k(block);
            }
        }

        private MinecraftKey a(ModelTemplate model, Block block) {
            return this.c.computeIfAbsent(model, newModel -> newModel.a(block, this.b, BlockModelGenerators.this.c));
        }

        public b a(BlockFamily family) {
            this.d = family;
            family.b().forEach((variant, block) -> {
                if (this.f.contains(block)) {
                    return;
                }
                BiConsumer<b, Block> biConsumer = h.get(variant);
                if (biConsumer != null) {
                    biConsumer.accept(this, (Block)block);
                }
            });
            return this;
        }
    }

    class f {
        private final TextureMapping b;

        public f(TextureMapping textures) {
            this.b = textures;
        }

        public f a(Block woodBlock) {
            TextureMapping textureMapping = this.b.c(TextureSlot.d, this.b.a(TextureSlot.i));
            MinecraftKey resourceLocation = ModelTemplates.j.a(woodBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(woodBlock, resourceLocation));
            return this;
        }

        public f b(Block stemBlock) {
            MinecraftKey resourceLocation = ModelTemplates.j.a(stemBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(stemBlock, resourceLocation));
            return this;
        }

        public f c(Block logBlock) {
            MinecraftKey resourceLocation = ModelTemplates.j.a(logBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.k.a(logBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(logBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public f d(Block logBlock) {
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(logBlock, this.b, BlockModelGenerators.this.c));
            return this;
        }
    }

    static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        private static final /* synthetic */ e[] c;

        public static e[] values() {
            return (e[])c.clone();
        }

        public static e valueOf(String string) {
            return Enum.valueOf(e.class, string);
        }

        public ModelTemplate a() {
            return this == a ? ModelTemplates.ap : ModelTemplates.ao;
        }

        public ModelTemplate b() {
            return this == a ? ModelTemplates.ar : ModelTemplates.aq;
        }

        private static /* synthetic */ e[] c() {
            return new e[]{a, b};
        }

        static {
            c = net.minecraft.data.models.BlockModelGenerators$e.c();
        }
    }

    class a {
        private final MinecraftKey b;

        public a(MinecraftKey modelId, Block block) {
            this.b = ModelTemplates.aa.a(modelId, TextureMapping.v(block), BlockModelGenerators.this.c);
        }

        public a a(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.b));
            }
            return this;
        }

        public a b(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.c(block);
            }
            return this.a(blocks);
        }

        public a a(ModelTemplate model, Block ... blocks) {
            for (Block block : blocks) {
                model.a(ModelLocationUtils.a(block.j()), TextureMapping.v(block), BlockModelGenerators.this.c);
            }
            return this.a(blocks);
        }
    }

    record d(ModelTemplate a, String b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this, object);
        }
    }
}

