/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.EquipmentModels;
import net.minecraft.world.item.equipment.Equippable;

public class ItemModelGenerators {
    public static final MinecraftKey a = MinecraftKey.b("trim_type");
    private static final List<a> b = List.of(new a("quartz", 0.1f, Map.of()), new a("iron", 0.2f, Map.of(EquipmentModels.c, "iron_darker")), new a("netherite", 0.3f, Map.of(EquipmentModels.g, "netherite_darker")), new a("redstone", 0.4f, Map.of()), new a("copper", 0.5f, Map.of()), new a("gold", 0.6f, Map.of(EquipmentModels.d, "gold_darker")), new a("emerald", 0.7f, Map.of()), new a("diamond", 0.8f, Map.of(EquipmentModels.e, "diamond_darker")), new a("lapis", 0.9f, Map.of()), new a("amethyst", 1.0f, Map.of()));
    private final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;

    public ItemModelGenerators(BiConsumer<MinecraftKey, Supplier<JsonElement>> writer) {
        this.c = writer;
    }

    private void a(Item item, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void a(Item item, String suffix, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item, suffix), TextureMapping.k(TextureMapping.a(item, suffix)), this.c);
    }

    private void a(Item item, Item texture, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(texture), this.c);
    }

    private void a(Item armor) {
        this.a(ModelLocationUtils.a(armor), TextureMapping.c(armor), TextureMapping.a(armor, "_overlay"));
    }

    private void b(Item compass) {
        for (int i2 = 0; i2 < 32; ++i2) {
            if (i2 == 16) continue;
            this.a(compass, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bC);
        }
    }

    private void c(Item clock) {
        for (int i2 = 1; i2 < 64; ++i2) {
            this.a(clock, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bC);
        }
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1) {
        ModelTemplates.bG.a(id, TextureMapping.c(layer0, layer1), this.c);
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1, MinecraftKey layer2) {
        ModelTemplates.bH.a(id, TextureMapping.a(layer0, layer1, layer2), this.c);
    }

    private MinecraftKey a(MinecraftKey id, String trimMaterialName) {
        return id.g("_" + trimMaterialName + "_trim");
    }

    private JsonObject a(MinecraftKey id, Map<TextureSlot, MinecraftKey> textures, MinecraftKey modelId) {
        JsonObject jsonObject = ModelTemplates.bG.a(id, textures);
        JsonArray jsonArray = new JsonArray();
        for (a trimModelData : b) {
            JsonObject jsonObject2 = new JsonObject();
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty(a.a(), (Number)Float.valueOf(trimModelData.b()));
            jsonObject2.add("predicate", (JsonElement)jsonObject3);
            jsonObject2.addProperty("model", this.a(id, trimModelData.a(modelId)).toString());
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("overrides", (JsonElement)jsonArray);
        return jsonObject;
    }

    private void a(Item item, MinecraftKey modelId, EquipmentModel model, EnumItemSlot slot) {
        List<EquipmentModel.c> list = model.a(EquipmentModel.d.a);
        if (list.isEmpty()) {
            return;
        }
        boolean bl = list.size() == 2 && list.getFirst().b().isPresent();
        MinecraftKey resourceLocation = ModelLocationUtils.a(item);
        MinecraftKey resourceLocation2 = TextureMapping.c(item);
        MinecraftKey resourceLocation3 = TextureMapping.a(item, "_overlay");
        if (bl) {
            ModelTemplates.bG.a(resourceLocation, TextureMapping.c(resourceLocation2, resourceLocation3), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, modelId));
        } else {
            ModelTemplates.bC.a(resourceLocation, TextureMapping.k(resourceLocation2), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, modelId));
        }
        String string = switch (slot) {
            case EnumItemSlot.f -> "helmet";
            case EnumItemSlot.e -> "chestplate";
            case EnumItemSlot.d -> "leggings";
            case EnumItemSlot.c -> "boots";
            default -> throw new UnsupportedOperationException();
        };
        for (a trimModelData : b) {
            String string2 = trimModelData.a(modelId);
            MinecraftKey resourceLocation4 = this.a(resourceLocation, string2);
            String string3 = string + "_trim_" + string2;
            MinecraftKey resourceLocation5 = MinecraftKey.b(string3).f("trims/items/");
            if (bl) {
                this.a(resourceLocation4, resourceLocation2, resourceLocation3, resourceLocation5);
                continue;
            }
            this.a(resourceLocation4, resourceLocation2, resourceLocation5);
        }
    }

    public void a() {
        this.a(Items.ow, ModelTemplates.bC);
        this.a(Items.oy, ModelTemplates.bC);
        this.a(Items.ox, ModelTemplates.bC);
        this.a(Items.oz, ModelTemplates.bC);
        this.a(Items.oZ, ModelTemplates.bC);
        this.a(Items.oQ, ModelTemplates.bC);
        this.a(Items.oM, ModelTemplates.bC);
        this.a(Items.vv, ModelTemplates.bC);
        this.a(Items.oS, ModelTemplates.bC);
        this.a(Items.uX, ModelTemplates.bC);
        this.a(Items.eb, ModelTemplates.bE);
        this.a(Items.sO, ModelTemplates.bC);
        this.a(Items.wa, ModelTemplates.bC);
        this.a(Items.wc, ModelTemplates.bC);
        this.a(Items.os, ModelTemplates.bC);
        this.a(Items.ot, ModelTemplates.bC);
        this.a(Items.sl, ModelTemplates.bC);
        this.a(Items.tc, ModelTemplates.bC);
        this.a(Items.sU, ModelTemplates.bE);
        this.a(Items.sh, ModelTemplates.bC);
        this.a(Items.sm, ModelTemplates.bC);
        this.a(Items.wX, ModelTemplates.bC);
        this.a(Items.rn, ModelTemplates.bC);
        this.a(Items.oP, ModelTemplates.bC);
        this.a(Items.pT, ModelTemplates.bC);
        this.a(Items.rj, ModelTemplates.bC);
        this.a(Items.uQ, ModelTemplates.bE);
        this.a(Items.si, ModelTemplates.bC);
        this.a(Items.qW, ModelTemplates.bC);
        this.a(Items.ok, ModelTemplates.bF);
        this.a(Items.ol, ModelTemplates.bF);
        this.a(Items.oU, ModelTemplates.bC);
        this.a(Items.og, ModelTemplates.bC);
        this.a(Items.sQ, ModelTemplates.bC);
        this.a(Items.vW, ModelTemplates.bC);
        this.a(Items.rk, ModelTemplates.bC);
        this.c(Items.rK);
        this.a(Items.oT, ModelTemplates.bC);
        this.a(Items.rf, ModelTemplates.bC);
        this.a(Items.vC, ModelTemplates.bC);
        this.b(Items.rq);
        this.b(Items.rr);
        this.a(Items.sP, ModelTemplates.bC);
        this.a(Items.sR, ModelTemplates.bC);
        this.a(Items.rR, ModelTemplates.bC);
        this.a(Items.vE, ModelTemplates.bC);
        this.a(Items.qu, ModelTemplates.bC);
        this.a(Items.vr, ModelTemplates.bC);
        this.a(Items.rS, ModelTemplates.bC);
        this.a(Items.sG, ModelTemplates.bC);
        this.a(Items.pc, ModelTemplates.bC);
        this.a(Items.pd, ModelTemplates.bC);
        this.a(Items.wP, ModelTemplates.bC);
        this.a(Items.sf, ModelTemplates.bC);
        this.a(Items.oA, ModelTemplates.bC);
        this.a(Items.oB, ModelTemplates.bC);
        this.a(Items.oV, ModelTemplates.bC);
        this.a(Items.pF, ModelTemplates.bE);
        this.a(Items.pG, ModelTemplates.bE);
        this.a(Items.vy, ModelTemplates.bC);
        this.a(Items.pE, ModelTemplates.bE);
        this.a(Items.pD, ModelTemplates.bE);
        this.a(Items.pC, ModelTemplates.bE);
        this.a(Items.wd, ModelTemplates.bC);
        this.a(Items.sL, ModelTemplates.bC);
        this.a(Items.rp, ModelTemplates.bC);
        this.a(Items.oW, ModelTemplates.bC);
        this.a(Items.vm, ModelTemplates.bC);
        this.a(Items.tg, ModelTemplates.bC);
        this.a(Items.sT, ModelTemplates.bC);
        this.a(Items.vV, ModelTemplates.bC);
        this.a(Items.uL, ModelTemplates.bC);
        this.a(Items.tb, ModelTemplates.bC);
        this.a(Items.wW, ModelTemplates.bC);
        this.a(Items.vk, ModelTemplates.bC);
        this.a(Items.uM, ModelTemplates.bC);
        this.a(Items.qs, ModelTemplates.bC);
        this.a(Items.oO, ModelTemplates.bC);
        this.a(Items.wU, ModelTemplates.bC);
        this.a(Items.wO, ModelTemplates.bC);
        this.a(Items.oh, ModelTemplates.bC);
        this.a(Items.sV, ModelTemplates.bC);
        this.a(Items.sY, ModelTemplates.bC);
        this.a(Items.th, ModelTemplates.bC);
        this.a(Items.wS, ModelTemplates.bC);
        this.a(Items.xm, ModelTemplates.bC);
        this.a(Items.rM, ModelTemplates.bC);
        this.a(Items.rU, ModelTemplates.bC);
        this.a(Items.uT, ModelTemplates.bC);
        this.a(Items.pe, ModelTemplates.bC);
        this.a(Items.qw, ModelTemplates.bC);
        this.a(Items.pv, ModelTemplates.bE);
        this.a(Items.va, ModelTemplates.bC);
        this.a(Items.pw, ModelTemplates.bE);
        this.a(Items.vx, ModelTemplates.bC);
        this.a(Items.pu, ModelTemplates.bE);
        this.a(Items.pt, ModelTemplates.bE);
        this.a(Items.ps, ModelTemplates.bE);
        this.a(Items.pf, ModelTemplates.bC);
        this.a(Items.sW, ModelTemplates.bC);
        this.a(Items.sd, ModelTemplates.bC);
        this.a(Items.sj, ModelTemplates.bC);
        this.a(Items.pQ, ModelTemplates.bC);
        this.a(Items.wV, ModelTemplates.bC);
        this.a(Items.wK, ModelTemplates.bC);
        this.a(Items.xq, ModelTemplates.bC);
        this.a(Items.xt, ModelTemplates.bC);
        this.a(Items.oj, ModelTemplates.bC);
        this.a(Items.rT, ModelTemplates.bC);
        this.a(Items.pa, ModelTemplates.bC);
        this.a(Items.pA, ModelTemplates.bE);
        this.a(Items.pB, ModelTemplates.bE);
        this.a(Items.vw, ModelTemplates.bC);
        this.a(Items.pb, ModelTemplates.bC);
        this.a(Items.wl, ModelTemplates.bC);
        this.a(Items.pz, ModelTemplates.bE);
        this.a(Items.py, ModelTemplates.bE);
        this.a(Items.px, ModelTemplates.bE);
        this.a(Items.uS, ModelTemplates.bC);
        this.a(Items.ou, ModelTemplates.bC);
        this.a(Items.ov, ModelTemplates.bC);
        this.a(Items.wm, ModelTemplates.bC);
        this.a(Items.oX, ModelTemplates.bC);
        this.a(Items.qY, ModelTemplates.bC);
        this.a(Items.rb, ModelTemplates.bC);
        this.a(Items.vz, ModelTemplates.bC);
        this.a(Items.rZ, ModelTemplates.bC);
        this.a(Items.se, ModelTemplates.bC);
        this.a(Items.sb, ModelTemplates.bC);
        this.a(Items.rY, ModelTemplates.bC);
        this.a(Items.td, ModelTemplates.bC);
        this.a(Items.oE, ModelTemplates.bC);
        this.a(Items.oF, ModelTemplates.bC);
        this.a(Items.oG, ModelTemplates.bC);
        this.a(Items.oH, ModelTemplates.bC);
        this.a(Items.uZ, ModelTemplates.bC);
        this.a(Items.sK, ModelTemplates.bC);
        this.a(Items.rc, ModelTemplates.bC);
        this.a(Items.of, ModelTemplates.bC);
        this.a(Items.wR, ModelTemplates.bC);
        this.a(Items.pN, ModelTemplates.bC);
        this.a(Items.wH, ModelTemplates.bC);
        this.a(Items.wA, ModelTemplates.bD);
        this.a(Items.wo, ModelTemplates.bD);
        this.a(Items.wq, ModelTemplates.bD);
        this.a(Items.wp, ModelTemplates.bD);
        this.a(Items.wr, ModelTemplates.bD);
        this.a(Items.ws, ModelTemplates.bD);
        this.a(Items.wt, ModelTemplates.bD);
        this.a(Items.wu, ModelTemplates.bD);
        this.a(Items.wv, ModelTemplates.bD);
        this.a(Items.ww, ModelTemplates.bD);
        this.a(Items.wF, ModelTemplates.bD);
        this.a(Items.wG, ModelTemplates.bD);
        this.a(Items.wx, ModelTemplates.bD);
        this.a(Items.wy, ModelTemplates.bD);
        this.a(Items.wB, ModelTemplates.bD);
        this.a(Items.wz, ModelTemplates.bD);
        this.a(Items.wC, ModelTemplates.bD);
        this.a(Items.wD, ModelTemplates.bD);
        this.a(Items.wE, ModelTemplates.bD);
        this.a(Items.vD, ModelTemplates.bC);
        this.a(Items.vB, ModelTemplates.bC);
        this.a(Items.wJ, ModelTemplates.bC);
        this.a(Items.pK, ModelTemplates.bE);
        this.a(Items.pL, ModelTemplates.bE);
        this.a(Items.pg, ModelTemplates.bC);
        this.a(Items.pJ, ModelTemplates.bE);
        this.a(Items.ph, ModelTemplates.bC);
        this.a(Items.pI, ModelTemplates.bE);
        this.a(Items.pH, ModelTemplates.bE);
        this.a(Items.vn, ModelTemplates.bC);
        this.a(Items.vi, ModelTemplates.bC);
        this.a(Items.oo, ModelTemplates.bC);
        this.a(Items.op, ModelTemplates.bC);
        this.a(Items.rX, ModelTemplates.bC);
        this.a(Items.qv, ModelTemplates.bC);
        this.a(Items.oC, ModelTemplates.bC);
        this.a(Items.oD, ModelTemplates.bC);
        this.a(Items.rm, ModelTemplates.bC);
        this.a(Items.om, ModelTemplates.bC);
        this.a(Items.wT, ModelTemplates.bC);
        this.a(Items.sc, ModelTemplates.bC);
        this.a(Items.uY, ModelTemplates.bC);
        this.a(Items.vX, ModelTemplates.bC);
        this.a(Items.qt, ModelTemplates.bC);
        this.a(Items.qZ, ModelTemplates.bC);
        this.a(Items.vp, ModelTemplates.bC);
        this.a(Items.vo, ModelTemplates.bC);
        this.a(Items.rQ, ModelTemplates.bC);
        this.a(Items.rd, ModelTemplates.bC);
        this.a(Items.vj, ModelTemplates.bC);
        this.a(Items.sg, ModelTemplates.bC);
        this.a(Items.oY, ModelTemplates.bC);
        this.a(Items.vq, ModelTemplates.bC);
        this.a(Items.vt, ModelTemplates.bC);
        this.a(Items.vu, ModelTemplates.bC);
        this.a(Items.vs, ModelTemplates.bC);
        this.a(Items.sk, ModelTemplates.bC);
        this.a(Items.sS, ModelTemplates.bC);
        this.a(Items.oe, ModelTemplates.bC);
        this.a(Items.rO, ModelTemplates.bC);
        this.a(Items.re, ModelTemplates.bC);
        this.a(Items.oL, ModelTemplates.bC);
        this.a(Items.sJ, ModelTemplates.bC);
        this.a(Items.wk, ModelTemplates.bC);
        this.a(Items.wQ, ModelTemplates.bC);
        this.a(Items.ro, ModelTemplates.bC);
        this.a(Items.ra, ModelTemplates.bC);
        this.a(Items.yk, ModelTemplates.bC);
        this.a(Items.wf, ModelTemplates.bC);
        this.a(Items.ta, ModelTemplates.bC);
        this.a(Items.oq, ModelTemplates.bC);
        this.a(Items.or, ModelTemplates.bC);
        this.a(Items.rL, ModelTemplates.bC);
        this.a(Items.pM, ModelTemplates.bE);
        this.a(Items.pq, ModelTemplates.bE);
        this.a(Items.pr, ModelTemplates.bE);
        this.a(Items.pp, ModelTemplates.bE);
        this.a(Items.po, ModelTemplates.bE);
        this.a(Items.pn, ModelTemplates.bE);
        this.a(Items.so, ModelTemplates.bC);
        this.a(Items.wM, ModelTemplates.bC);
        this.a(Items.oi, ModelTemplates.bC);
        this.a(Items.wj, ModelTemplates.bC);
        this.a(Items.wI, ModelTemplates.bC);
        this.a(Items.rP, ModelTemplates.bC);
        this.a(Items.rg, ModelTemplates.bC);
        this.a(Items.rh, ModelTemplates.bC);
        this.a(Items.ri, ModelTemplates.bC);
        this.a(Items.qX, ModelTemplates.bC);
        this.a(Items.pS, ModelTemplates.bC);
        this.a(Items.rW, ModelTemplates.bC);
        this.a(Items.uN, ModelTemplates.bC);
        this.a(Items.uR, ModelTemplates.bT);
        this.a(Items.oN);
        this.a(Items.pl, ModelTemplates.bE);
        this.a(Items.pm, ModelTemplates.bE);
        this.a(Items.pk, ModelTemplates.bE);
        this.a(Items.pj, ModelTemplates.bE);
        this.a(Items.pi, ModelTemplates.bE);
        this.a(Items.uO, ModelTemplates.bC);
        this.a(Items.uP, ModelTemplates.bC);
        this.a(Items.sa, ModelTemplates.bC);
        this.a(Items.ym, ModelTemplates.bC);
        this.a(Items.yn, ModelTemplates.bC);
        this.a(Items.yo, ModelTemplates.bC);
        this.a(Items.yp, ModelTemplates.bC);
        this.a(Items.yq, ModelTemplates.bC);
        this.a(Items.yr, ModelTemplates.bC);
        this.a(Items.ys, ModelTemplates.bC);
        this.a(Items.yt, ModelTemplates.bC);
        this.a(Items.yu, ModelTemplates.bC);
        this.a(Items.yv, ModelTemplates.bC);
        this.a(Items.yw, ModelTemplates.bC);
        this.a(Items.yx, ModelTemplates.bC);
        this.a(Items.yy, ModelTemplates.bC);
        this.a(Items.yz, ModelTemplates.bC);
        this.a(Items.yA, ModelTemplates.bC);
        this.a(Items.yB, ModelTemplates.bC);
        this.a(Items.yC, ModelTemplates.bC);
        this.a(Items.yD, ModelTemplates.bC);
        this.a(Items.yE, ModelTemplates.bC);
        this.a(Items.wn, Items.pM, ModelTemplates.bE);
        this.a(Items.qx, Items.qw, ModelTemplates.bC);
        HashMap map = new HashMap();
        EquipmentModels.a(map::put);
        for (Item item : BuiltInRegistries.g) {
            Equippable equippable = item.g().a(DataComponents.D);
            if (equippable == null || equippable.a().a() != EnumItemSlot.Function.b || !equippable.c().isPresent()) continue;
            MinecraftKey resourceLocation = equippable.c().get();
            EquipmentModel equipmentModel = (EquipmentModel)map.get(resourceLocation);
            if (equipmentModel == null) {
                throw new IllegalStateException("Referenced equipment model does not exist: " + String.valueOf(resourceLocation));
            }
            this.a(item, resourceLocation, equipmentModel, equippable.a());
        }
        this.a(Items.yF, ModelTemplates.bC);
        this.a(Items.yG, ModelTemplates.bC);
        this.a(Items.yH, ModelTemplates.bC);
        this.a(Items.yI, ModelTemplates.bC);
        this.a(Items.yJ, ModelTemplates.bC);
        this.a(Items.yK, ModelTemplates.bC);
        this.a(Items.yL, ModelTemplates.bC);
        this.a(Items.yM, ModelTemplates.bC);
        this.a(Items.yN, ModelTemplates.bC);
        this.a(Items.yO, ModelTemplates.bC);
        this.a(Items.yP, ModelTemplates.bC);
        this.a(Items.yQ, ModelTemplates.bC);
        this.a(Items.yR, ModelTemplates.bC);
        this.a(Items.yS, ModelTemplates.bC);
        this.a(Items.yT, ModelTemplates.bC);
        this.a(Items.yU, ModelTemplates.bC);
        this.a(Items.yV, ModelTemplates.bC);
        this.a(Items.yW, ModelTemplates.bC);
        this.a(Items.yX, ModelTemplates.bC);
        this.a(Items.yY, ModelTemplates.bC);
        this.a(Items.yZ, ModelTemplates.bC);
        this.a(Items.za, ModelTemplates.bC);
        this.a(Items.zb, ModelTemplates.bC);
        this.a(Items.zt, ModelTemplates.bC);
        this.a(Items.zu, ModelTemplates.bC);
        this.a(Items.zw, ModelTemplates.bC);
        this.a(Items.rs, ModelTemplates.bC);
        this.a(Items.rI, ModelTemplates.bC);
        this.a(Items.rt, ModelTemplates.bC);
        this.a(Items.rA, ModelTemplates.bC);
        this.a(Items.rB, ModelTemplates.bC);
        this.a(Items.rw, ModelTemplates.bC);
        this.a(Items.rE, ModelTemplates.bC);
        this.a(Items.rC, ModelTemplates.bC);
        this.a(Items.rx, ModelTemplates.bC);
        this.a(Items.rH, ModelTemplates.bC);
        this.a(Items.rD, ModelTemplates.bC);
        this.a(Items.rv, ModelTemplates.bC);
        this.a(Items.rz, ModelTemplates.bC);
        this.a(Items.rG, ModelTemplates.bC);
        this.a(Items.ry, ModelTemplates.bC);
        this.a(Items.rF, ModelTemplates.bC);
        this.a(Items.ru, ModelTemplates.bC);
    }

    record a(String a, float b, Map<MinecraftKey, String> c) {
        public String a(MinecraftKey modelId) {
            return this.c.getOrDefault(modelId, this.a);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this, object);
        }
    }
}

